/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.chunkio;

import com.android.tools.chunkio.ChunkException;
import com.android.tools.chunkio.RangedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.stream.Collectors;

public final class ChunkUtils {
    private ChunkUtils() {
    }

    public static void checkState(boolean condition, String format, Object ... args) {
        if (!condition) {
            throw new ChunkException(String.format(format, args));
        }
    }

    public static <T> String join(Collection<T> list, String delimiter) {
        return list.stream().map(Object::toString).collect(Collectors.joining(delimiter));
    }

    public static boolean readBoolean(RangedInputStream in, long byteCount) throws IOException {
        boolean b;
        switch ((int)byteCount) {
            case -1: 
            case 1: {
                b = in.readByte() != 0;
                break;
            }
            case 2: {
                b = in.readShort() != 0;
                break;
            }
            case 4: {
                b = in.readInt() != 0;
                break;
            }
            case 8: {
                b = in.readLong() != 0L;
                break;
            }
            default: {
                b = in.readByte() != 0;
                ChunkUtils.skip(in, byteCount - 1L);
            }
        }
        return b;
    }

    public static byte readByte(RangedInputStream in, long byteCount) throws IOException {
        byte b;
        switch ((int)byteCount) {
            case -1: 
            case 1: {
                b = in.readByte();
                break;
            }
            default: {
                b = in.readByte();
                ChunkUtils.skip(in, byteCount - 1L);
            }
        }
        return b;
    }

    public static char readChar(RangedInputStream in, long byteCount) throws IOException {
        char c;
        switch ((int)byteCount) {
            case 1: {
                c = (char)(in.readByte() & 0xFF);
                break;
            }
            case -1: 
            case 2: {
                c = in.readChar();
                break;
            }
            default: {
                c = in.readChar();
                ChunkUtils.skip(in, byteCount - 2L);
            }
        }
        return c;
    }

    public static double readDouble(RangedInputStream in, long byteCount) throws IOException {
        double d;
        switch ((int)byteCount) {
            case 4: {
                d = in.readFloat();
                break;
            }
            case -1: 
            case 8: {
                d = in.readDouble();
                break;
            }
            default: {
                d = in.readDouble();
                ChunkUtils.skip(in, byteCount - 8L);
            }
        }
        return d;
    }

    public static float readFloat(RangedInputStream in, long byteCount) throws IOException {
        float f;
        switch ((int)byteCount) {
            case -1: 
            case 4: {
                f = in.readFloat();
                break;
            }
            default: {
                f = in.readFloat();
                ChunkUtils.skip(in, byteCount - 4L);
            }
        }
        return f;
    }

    public static int readInt(RangedInputStream in, long byteCount) throws IOException {
        int i;
        switch ((int)byteCount) {
            case 1: {
                i = in.readUnsignedByte();
                break;
            }
            case 2: {
                i = in.readUnsignedShort();
                break;
            }
            case -1: 
            case 4: {
                i = in.readInt();
                break;
            }
            default: {
                i = in.readInt();
                ChunkUtils.skip(in, byteCount - 4L);
            }
        }
        return i;
    }

    public static long readLong(RangedInputStream in, long byteCount) throws IOException {
        long l;
        switch ((int)byteCount) {
            case 1: {
                l = in.readUnsignedByte();
                break;
            }
            case 2: {
                l = in.readUnsignedShort();
                break;
            }
            case 4: {
                l = (long)in.readInt() & 0xFFFFFFFFL;
                break;
            }
            case -1: 
            case 8: {
                l = in.readLong();
                break;
            }
            default: {
                l = in.readLong();
                ChunkUtils.skip(in, byteCount - 8L);
            }
        }
        return l;
    }

    public static short readShort(RangedInputStream in, long byteCount) throws IOException {
        short s;
        switch ((int)byteCount) {
            case 1: {
                s = (short)(in.readByte() & 0xFF);
                break;
            }
            case -1: 
            case 2: {
                s = in.readShort();
                break;
            }
            default: {
                s = in.readShort();
                ChunkUtils.skip(in, byteCount - 2L);
            }
        }
        return s;
    }

    public static void skip(RangedInputStream in, long byteCount) throws IOException {
        if (byteCount > 0L) {
            long s;
            long skipped = 0L;
            long toSkip = byteCount;
            while (skipped < byteCount && (s = in.skip(toSkip)) >= 0L) {
                skipped += s;
                toSkip -= s;
            }
        }
    }

    static long copy(InputStream from, OutputStream to, int bufferSize) throws IOException {
        int read;
        byte[] buf = new byte[bufferSize];
        long total = 0L;
        while ((read = from.read(buf)) >= 0) {
            to.write(buf, 0, read);
            total += (long)read;
        }
        return total;
    }

    public static byte[] readUnboundedByteArray(RangedInputStream in, int bufferSize) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ChunkUtils.copy(in, out, bufferSize);
        return out.toByteArray();
    }

    public static byte[] readByteArray(RangedInputStream in, long byteCount) throws IOException {
        byte[] data = new byte[(int)byteCount];
        in.readFully(data);
        return data;
    }

    public static String readString(RangedInputStream in, long byteCount, Charset charset) throws IOException {
        return new String(ChunkUtils.readByteArray(in, byteCount), charset);
    }

    public static byte[] readByteArray(RangedInputStream in, long byteCount, int bufferSize) throws IOException {
        if (byteCount >= 0L) {
            return ChunkUtils.readByteArray(in, byteCount);
        }
        return ChunkUtils.readUnboundedByteArray(in, bufferSize);
    }
}

