/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.model.MergedManifestManager;
import com.android.tools.idea.res.ResourceHelper;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UastContext;

public class AndroidPsiUtils {
    @Nullable
    public static PsiFile getPsiFileSafely(@NotNull Project project, @NotNull VirtualFile file) {
        return (PsiFile)ApplicationManager.getApplication().runReadAction(() -> {
            if (project.isDisposed()) {
                return null;
            }
            return file.isValid() ? PsiManager.getInstance((Project)project).findFile(file) : null;
        });
    }

    @Nullable
    public static Module getModuleSafely(@NotNull PsiElement element) {
        return (Module)ApplicationManager.getApplication().runReadAction(() -> ModuleUtilCore.findModuleForPsiElement((PsiElement)element));
    }

    @Nullable
    public static Module getModuleSafely(@NotNull Project project, @NotNull VirtualFile file) {
        return (Module)ApplicationManager.getApplication().runReadAction(() -> {
            if (project.isDisposed()) {
                return null;
            }
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            return psiFile == null ? null : ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile);
        });
    }

    @Nullable
    public static XmlTag getRootTagSafely(@NotNull XmlFile file) {
        if (file.getProject().isDisposed()) {
            return null;
        }
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            return file.getRootTag();
        }
        return (XmlTag)ApplicationManager.getApplication().runReadAction(() -> ((XmlFile)file).getRootTag());
    }

    @Nullable
    public static String getRootTagAttributeSafely(@NotNull XmlFile file, @NotNull String attribute, @Nullable String namespace) {
        Application application = ApplicationManager.getApplication();
        if (!application.isReadAccessAllowed()) {
            return (String)application.runReadAction(() -> AndroidPsiUtils.getRootTagAttributeSafely(file, attribute, namespace));
        }
        XmlTag tag = file.getRootTag();
        if (tag != null) {
            XmlAttribute attr;
            XmlAttribute xmlAttribute = attr = namespace != null ? tag.getAttribute(attribute, namespace) : tag.getAttribute(attribute);
            if (attr != null) {
                return attr.getValue();
            }
        }
        return null;
    }

    @Nullable
    public static PsiDirectory getPsiDirectorySafely(@NotNull Project project, @NotNull VirtualFile dir) {
        return (PsiDirectory)ApplicationManager.getApplication().runReadAction(() -> {
            if (project.isDisposed()) {
                return null;
            }
            return PsiManager.getInstance((Project)project).findDirectory(dir);
        });
    }

    @Nullable
    public static String getRootTagName(@NotNull PsiFile file) {
        ResourceFolderType folderType = ResourceHelper.getFolderType(file);
        if ((folderType == ResourceFolderType.XML || folderType == ResourceFolderType.MENU || folderType == ResourceFolderType.DRAWABLE) && file instanceof XmlFile) {
            XmlTag rootTag = AndroidPsiUtils.getRootTagSafely((XmlFile)file);
            return rootTag == null ? null : rootTag.getName();
        }
        return null;
    }

    @Nullable
    public static PsiElement getPsiParentSafely(@NotNull PsiElement element) {
        return (PsiElement)ApplicationManager.getApplication().runReadAction(() -> ((PsiElement)element).getParent());
    }

    @Nullable
    @Contract(value="null, _, _ -> null")
    public static <T extends PsiElement> T getPsiParentOfType(@Nullable PsiElement element, @NotNull Class<T> parentClass, boolean strict) {
        if (element == null) {
            return null;
        }
        PsiElement parentElement = PsiTreeUtil.getParentOfType((PsiElement)element, parentClass, (boolean)strict);
        if (parentElement != null) {
            return (T)parentElement;
        }
        for (PsiElement psiElement = element; psiElement != null; psiElement = psiElement.getParent()) {
            T parentPsiElement;
            UElement uElement = ((UastContext)ServiceManager.getService((Project)element.getProject(), UastContext.class)).convertElementWithParent(psiElement, UElement.class);
            if (uElement == null || (parentPsiElement = AndroidPsiUtils.getPsiParentOfType(uElement, parentClass, strict && psiElement == element)) == null) continue;
            return parentPsiElement;
        }
        return null;
    }

    @Nullable
    @Contract(value="null, _, _ -> null")
    public static <T extends PsiElement> T getPsiParentOfType(@Nullable UElement element, @NotNull Class<T> parentClass, boolean strict) {
        if (element == null) {
            return null;
        }
        if (strict) {
            element = element.getUastParent();
        }
        while (element != null) {
            PsiElement psiElement = UElementKt.getAsJavaPsiElement((UElement)element, parentClass);
            if (psiElement != null) {
                return (T)((PsiElement)parentClass.cast(psiElement));
            }
            element = element.getUastParent();
        }
        return null;
    }

    public static boolean isResourceReference(@NotNull PsiElement element) {
        return AndroidPsiUtils.getResourceReferenceType(element) != ResourceReferenceType.NONE;
    }

    @NotNull
    public static ResourceReferenceType getResourceReferenceType(@NotNull PsiElement element) {
        if (element instanceof PsiReferenceExpression) {
            return AndroidPsiUtils.getResourceReferenceType((PsiReferenceExpression)element);
        }
        if (element instanceof PsiIdentifier && element.getParent() instanceof PsiReferenceExpression) {
            return AndroidPsiUtils.getResourceReferenceType((PsiReferenceExpression)element.getParent());
        }
        return ResourceReferenceType.NONE;
    }

    @NotNull
    public static String getResourceName(@NotNull PsiElement element) {
        PsiReferenceExpression refExp;
        String name;
        assert (AndroidPsiUtils.isResourceReference(element));
        if (element instanceof PsiReferenceExpression && (name = (refExp = (PsiReferenceExpression)element).getReferenceName()) != null) {
            return name;
        }
        return element.getText();
    }

    @NotNull
    public static ResourceReferenceType getResourceReferenceType(PsiReferenceExpression element) {
        PsiElement resolvedElement = element.resolve();
        if (resolvedElement == null) {
            return ResourceReferenceType.NONE;
        }
        PsiElement elementType = resolvedElement.getParent();
        if (!(elementType instanceof PsiClass)) {
            return ResourceReferenceType.NONE;
        }
        PsiElement elementPackage = elementType.getParent();
        if (!(elementPackage instanceof PsiClass)) {
            return ResourceReferenceType.NONE;
        }
        if ("R".equals(((PsiClass)elementPackage).getName())) {
            PsiElement elemParent3 = elementPackage.getParent();
            if (elemParent3 instanceof PsiClassOwner && "android".equals(((PsiClassOwner)elemParent3).getPackageName())) {
                return ResourceReferenceType.FRAMEWORK;
            }
            return ResourceReferenceType.APP;
        }
        return ResourceReferenceType.NONE;
    }

    @Nullable
    public static ResourceType getResourceType(PsiElement resourceRefElement) {
        if (!AndroidPsiUtils.isResourceReference(resourceRefElement)) {
            return null;
        }
        PsiReferenceExpression exp = resourceRefElement instanceof PsiReferenceExpression ? (PsiReferenceExpression)resourceRefElement : (PsiReferenceExpression)resourceRefElement.getParent();
        PsiElement resolvedElement = exp.resolve();
        if (resolvedElement == null) {
            return null;
        }
        PsiElement elemParent = resolvedElement.getParent();
        if (!(elemParent instanceof PsiClass)) {
            return null;
        }
        return ResourceType.fromClassName((String)((PsiClass)elemParent).getName());
    }

    @Nullable
    public static String getDeclaredContextFqcn(@NotNull Module module, @NotNull XmlFile xmlFile) {
        String context = AndroidPsiUtils.getRootTagAttributeSafely(xmlFile, "context", "http://schemas.android.com/tools");
        if (context != null && !context.isEmpty()) {
            boolean startsWithDot;
            boolean bl = startsWithDot = context.charAt(0) == '.';
            if (startsWithDot || context.indexOf(46) == -1) {
                String pkg = MergedManifestManager.getSnapshot(module).getPackage();
                return startsWithDot ? pkg + context : pkg + '.' + context;
            }
            return context;
        }
        return null;
    }

    @Nullable
    public static PsiClass getContextClass(@NotNull Module module, @NotNull XmlFile xmlFile) {
        String fqn = AndroidPsiUtils.getDeclaredContextFqcn(module, xmlFile);
        if (fqn != null) {
            Project project = module.getProject();
            return JavaPsiFacade.getInstance((Project)project).findClass(fqn, GlobalSearchScope.allScope((Project)project));
        }
        return null;
    }

    @Nullable
    public static String getQualifiedNameSafely(@NotNull PsiClass psiClass) {
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            return psiClass.getQualifiedName();
        }
        return (String)ApplicationManager.getApplication().runReadAction(() -> ((PsiClass)psiClass).getQualifiedName());
    }

    @Nullable
    public static String getAttributeSafely(@NotNull XmlTag tag, @Nullable String namespace, @NotNull String name) {
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            return tag.getAttributeValue(name, namespace);
        }
        return (String)ApplicationManager.getApplication().runReadAction(() -> tag.getAttributeValue(name, namespace));
    }

    public static boolean isValid(@NotNull XmlTag tag) {
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            return tag.isValid();
        }
        return (Boolean)ApplicationManager.getApplication().runReadAction(() -> ((XmlTag)tag).isValid());
    }

    public static enum ResourceReferenceType {
        NONE,
        APP,
        FRAMEWORK;

    }
}

