/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.idea.projectsystem.AndroidModuleTemplate;
import com.android.tools.idea.projectsystem.NamedModuleTemplate;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.ui.wizard.StudioWizardDialogBuilder;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.intellij.ide.IdeView;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import icons.AndroidIcons;
import java.awt.Dimension;
import java.net.URL;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AndroidAssetStudioAction
extends AnAction {
    protected AndroidAssetStudioAction(@Nullable String text, @Nullable String description) {
        super(text, description, AndroidIcons.Android);
    }

    protected static boolean isAvailable(@NotNull DataContext dataContext) {
        Module module = (Module)LangDataKeys.MODULE.getData(dataContext);
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        VirtualFile location = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        return module != null && view != null && location != null && view.getDirectories().length > 0 && AndroidFacet.getInstance(module) != null && ProjectSystemUtil.getProjectSystem(module.getProject()).allowsFileCreation() && AndroidAssetStudioAction.getModuleTemplate(module, location) != null;
    }

    @Nullable
    private static AndroidModuleTemplate getModuleTemplate(@NotNull Module module, @NotNull VirtualFile location) {
        for (NamedModuleTemplate namedTemplate : ProjectSystemUtil.getModuleSystem(module).getModuleTemplates(location)) {
            AndroidModuleTemplate template = namedTemplate.getPaths();
            if (template.getResDirectories().isEmpty()) continue;
            return template;
        }
        return null;
    }

    public final void update(@NotNull AnActionEvent e) {
        e.getPresentation().setVisible(AndroidAssetStudioAction.isAvailable(e.getDataContext()));
    }

    public final void actionPerformed(@NotNull AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (view == null) {
            return;
        }
        Module module = (Module)LangDataKeys.MODULE.getData(dataContext);
        if (module == null) {
            return;
        }
        VirtualFile location = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        if (location == null) {
            return;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            return;
        }
        AndroidModuleTemplate template = AndroidAssetStudioAction.getModuleTemplate(module, location);
        if (template == null) {
            return;
        }
        ModelWizard wizard = this.createWizard(facet, template);
        if (wizard != null) {
            StudioWizardDialogBuilder dialogBuilder = new StudioWizardDialogBuilder(wizard, "Asset Studio");
            dialogBuilder.setProject(facet.getModule().getProject()).setMinimumSize(this.getWizardMinimumSize()).setPreferredSize(this.getWizardPreferredSize()).setHelpUrl(this.getHelpUrl());
            dialogBuilder.build().show();
        }
    }

    @Nullable
    protected abstract ModelWizard createWizard(@NotNull AndroidFacet var1, @NotNull AndroidModuleTemplate var2);

    @NotNull
    protected abstract Dimension getWizardMinimumSize();

    @NotNull
    protected abstract Dimension getWizardPreferredSize();

    @Nullable
    protected URL getHelpUrl() {
        return null;
    }
}

