/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.idea.npw.model.NewProjectModel;
import com.android.tools.idea.npw.project.ChooseAndroidProjectStep;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.ui.wizard.StudioWizardDialogBuilder;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.wm.impl.welcomeScreen.NewWelcomeScreen;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;

public class AndroidNewProjectAction
extends AnAction
implements DumbAware {
    public AndroidNewProjectAction() {
        this(ActionsBundle.actionText((String)"NewDirectoryProject"));
    }

    public AndroidNewProjectAction(@NotNull String text) {
        super(text);
    }

    public void update(@NotNull AnActionEvent e) {
        if (NewWelcomeScreen.isNewWelcomeScreen((AnActionEvent)e)) {
            e.getPresentation().setIcon(AllIcons.Welcome.CreateNewProject);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (!AndroidSdkUtils.isAndroidSdkAvailable()) {
            SdkQuickfixUtils.showSdkMissingDialog();
            return;
        }
        final NewProjectModel projectModel = new NewProjectModel();
        ModelWizard wizard = new ModelWizard.Builder(new ModelWizardStep[0]).addStep(new ChooseAndroidProjectStep(projectModel)).build();
        wizard.addResultListener(new ModelWizard.WizardListener(){

            @Override
            public void onWizardFinished(@NotNull ModelWizard.WizardResult result2) {
                projectModel.onWizardFinished(result2);
            }
        });
        new StudioWizardDialogBuilder(wizard, ActionsBundle.actionText((String)"WelcomeScreen.CreateNewProject")).setUxStyle(StudioWizardDialogBuilder.UxStyle.DYNAMIC_APP).build().show();
    }
}

