/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.flags.StudioFlags;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import icons.StudioIcons;
import org.jetbrains.annotations.NotNull;

public class AndroidShowThemeEditor
extends AnAction {
    public AndroidShowThemeEditor() {
        super("Theme Editor", null, StudioIcons.Shell.Menu.THEME_EDITOR);
    }

    public void update(@NotNull AnActionEvent e) {
        if (!((Boolean)StudioFlags.THEME_EDITOR_ENABLED.get()).booleanValue()) {
            e.getPresentation().setVisible(false);
            return;
        }
        Project project = e.getProject();
        e.getPresentation().setEnabled(project != null && ThemeEditorUtils.findAndroidModules(project).findAny().isPresent());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        ThemeEditorUtils.openThemeEditor(project);
    }
}

