/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.databinding.DataBindingProjectComponent;
import com.android.tools.idea.res.ResourceHelper;
import com.intellij.codeInsight.intention.AbstractIntentionAction;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public final class ConvertLayoutToDataBindingAction
extends AbstractIntentionAction
implements HighPriorityAction {
    @NotNull
    public String getText() {
        return "Convert to data binding layout";
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor2, PsiFile file) {
        if (ResourceHelper.getFolderType(file) != ResourceFolderType.LAYOUT) {
            return false;
        }
        if (!(file instanceof XmlFile)) {
            return false;
        }
        XmlFile xmlFile = (XmlFile)file;
        XmlTag tag = xmlFile.getRootTag();
        if (tag == null) {
            return false;
        }
        int offset = editor2.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        if (element == null) {
            return false;
        }
        if (!tag.equals(element.getParent()) && offset >= tag.getTextOffset()) {
            return false;
        }
        if (tag.getName().equals("layout")) {
            return false;
        }
        DataBindingProjectComponent component = (DataBindingProjectComponent)project.getComponent(DataBindingProjectComponent.class);
        return component != null && component.hasAnyDataBindingEnabledFacet();
    }

    public boolean startInWriteAction() {
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor2, PsiFile file) throws IncorrectOperationException {
        XmlFile xmlFile = (XmlFile)file;
        XmlTag root = xmlFile.getRootTag();
        assert (root != null);
        XmlElementFactory factory = XmlElementFactory.getInstance((Project)project);
        XmlTag newRoot = factory.createTagFromText((CharSequence)"<layout>\n<data>\n\n</data></layout>");
        String rootText = root.getText();
        newRoot = (XmlTag)root.replace((PsiElement)newRoot);
        root = factory.createTagFromText((CharSequence)rootText);
        for (XmlAttribute attribute : root.getAttributes()) {
            String name = attribute.getName();
            if (!name.startsWith("xmlns:")) continue;
            newRoot.setAttribute(name, attribute.getValue());
            attribute.delete();
        }
        XmlAttribute context = root.getAttribute("context", "http://schemas.android.com/tools");
        if (context != null) {
            root.setAttribute("context", "http://schemas.android.com/tools", context.getValue());
            context.delete();
        }
        newRoot.addSubTag(root, false);
    }
}

