/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.idea.actions.CreateFileFromTemplateDialog;
import com.google.common.base.Splitter;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeView;
import com.intellij.ide.actions.CreateFromTemplateAction;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.util.IncorrectOperationException;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public final class CreateClassAction
extends AnAction {
    private final JavaDirectoryService myJavaDirectoryService = JavaDirectoryService.getInstance();

    public CreateClassAction() {
        super("Java Class");
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        DataContext context = event.getDataContext();
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(context);
        if (view == null) {
            return;
        }
        Module module = (Module)LangDataKeys.MODULE.getData(context);
        if (module == null) {
            return;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(context);
        if (project == null) {
            return;
        }
        final PsiDirectory directory = CreateClassAction.getDestinationDirectory(view, module);
        if (directory == null) {
            return;
        }
        CreateFileFromTemplateDialog dialog2 = new CreateFileFromTemplateDialog(project, directory);
        try {
            PsiClass createdElement = dialog2.show(new CreateFileFromTemplateDialog.FileCreator(){

                @Override
                public PsiClass createFile(@NotNull String name, @NotNull Map<String, String> creationOptions, @NotNull String templateName) {
                    String enteredPackageName = creationOptions.get("PACKAGE_NAME");
                    PsiDirectory packageSubdirectory = (PsiDirectory)ApplicationManager.getApplication().runWriteAction(() -> CreateClassAction.createPackageSubdirectory(directory, enteredPackageName));
                    return CreateClassAction.this.checkOrCreate(name, packageSubdirectory, templateName, creationOptions);
                }

                @Override
                @NotNull
                public String getActionName(@NotNull String name, @NotNull String templateName) {
                    PsiPackage p = CreateClassAction.this.myJavaDirectoryService.getPackage(directory);
                    assert (p != null);
                    String packageDirectoryQualifiedName = p.getQualifiedName();
                    return IdeBundle.message((String)"progress.creating.class", (Object[])new Object[]{StringUtil.getQualifiedName((String)packageDirectoryQualifiedName, (String)name)});
                }
            });
            view.selectElement((PsiElement)createdElement);
            CreateFromTemplateAction.moveCaretAfterNameIdentifier((PsiNameIdentifierOwner)createdElement);
            if (dialog2.isShowSelectOverridesDialogCheckBoxSelected()) {
                CreateClassAction.showOverridesDialog(event);
            }
        }
        catch (CreateFileFromTemplateDialog.FailedToCreateFileException failedToCreateFileException) {
            // empty catch block
        }
    }

    @Nullable
    static PsiDirectory getDestinationDirectory(@NotNull IdeView ide, @NotNull Module module) {
        PsiDirectory[] directories = ide.getDirectories();
        if (directories.length == 1) {
            return directories[0];
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            return ide.getOrChooseDirectory();
        }
        Collection files2 = facet.getMainSourceProvider().getJavaDirectories();
        if (files2.size() != 1) {
            return ide.getOrChooseDirectory();
        }
        VirtualFile file = LocalFileSystem.getInstance().findFileByIoFile((File)files2.iterator().next());
        if (file == null) {
            return ide.getOrChooseDirectory();
        }
        return PsiManager.getInstance((Project)module.getProject()).findDirectory(file);
    }

    public void update(@NotNull AnActionEvent e) {
        boolean enabled = CreateClassAction.isAvailable(e.getDataContext());
        Presentation presentation = e.getPresentation();
        presentation.setVisible(enabled);
        presentation.setEnabled(enabled);
    }

    private static boolean isAvailable(@NotNull DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (project == null || view == null || view.getDirectories().length == 0) {
            return false;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        for (PsiDirectory dir : view.getDirectories()) {
            if (!projectFileIndex.isUnderSourceRootOfType(dir.getVirtualFile(), JavaModuleSourceRootTypes.SOURCES) || !CreateClassAction.checkPackageExists(dir)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkPackageExists(PsiDirectory directory) {
        PsiPackage psiPackage = JavaDirectoryService.getInstance().getPackage(directory);
        if (psiPackage == null) {
            return false;
        }
        String name = psiPackage.getQualifiedName();
        return StringUtil.isEmpty((String)name) || PsiNameHelper.getInstance((Project)directory.getProject()).isQualifiedName(name);
    }

    @NotNull
    private static PsiDirectory createPackageSubdirectory(@NotNull PsiDirectory directory, @NotNull String packageName) {
        String startPackagePath;
        PsiPackage psiPackage = JavaDirectoryService.getInstance().getPackage(directory);
        String string = startPackagePath = psiPackage != null ? psiPackage.getQualifiedName() : null;
        if (startPackagePath == null || startPackagePath.equals(packageName)) {
            return directory;
        }
        PsiPackage baseName = JavaDirectoryService.getInstance().getPackage(directory);
        assert (baseName != null);
        PsiDirectory dir = directory;
        if (!packageName.startsWith(baseName.getQualifiedName())) {
            while (baseName.getParentPackage() != null) {
                if (packageName.equals(baseName.getQualifiedName())) {
                    assert (dir != null);
                    return dir;
                }
                if (packageName.startsWith(baseName.getQualifiedName())) break;
                baseName = baseName.getParentPackage();
                assert (baseName != null);
                assert (dir != null);
                dir = dir.getParentDirectory();
            }
        }
        String newPackageName = baseName.getQualifiedName().isEmpty() ? packageName : packageName.substring(baseName.getQualifiedName().length() + 1);
        for (String component : Splitter.on((char)'.').split((CharSequence)newPackageName)) {
            assert (dir != null);
            PsiDirectory d = dir.findSubdirectory(component);
            dir = d == null ? dir.createSubdirectory(component) : d;
        }
        assert (dir != null);
        return dir;
    }

    private static void showOverridesDialog(@NotNull AnActionEvent event) {
        Project project = event.getProject();
        assert (project != null);
        Editor editor2 = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        if (editor2 instanceof EditorEx) {
            EditorEx editorEx = (EditorEx)editor2;
            AnActionEvent newEvent = new AnActionEvent(event.getInputEvent(), editorEx.getDataContext(), "unknown", event.getPresentation(), event.getActionManager(), 0);
            ActionManager.getInstance().getAction("OverrideMethods").actionPerformed(newEvent);
        }
    }

    @Nullable
    private PsiClass checkOrCreate(String newName2, PsiDirectory directory, String templateName, Map<String, String> creationOptions) throws IncorrectOperationException {
        PsiDirectory dir = directory;
        if ((newName2 = StringUtil.trimEnd((String)newName2, (String)".java")).contains(".")) {
            List names = Splitter.on((String)".").splitToList((CharSequence)newName2);
            for (String name : names.subList(0, names.size() - 1)) {
                PsiDirectory subDir = dir.findSubdirectory(name);
                if (subDir == null) {
                    subDir = dir.createSubdirectory(name);
                }
                dir = subDir;
            }
            newName2 = (String)names.get(names.size() - 1);
        }
        return this.myJavaDirectoryService.createClass(dir, newName2, templateName, true, creationOptions);
    }
}

