/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.idea.actions.CreateNewClassDialogValidatorEx;
import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.intellij.lang.java.lexer.JavaLexer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiNameHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateNewClassDialogValidatorExImpl
implements CreateNewClassDialogValidatorEx {
    public static final String INVALID_PACKAGE_MESSAGE = "This is not a valid Java package name";
    public static final String INVALID_QUALIFIED_NAME_FOR_NEW_NAME = "New class name is not a valid Java qualified name";
    public static final String INVALID_QUALIFIED_NAME_FOR_INTERFACE = "Interface is not a valid Java qualified name";
    public static final String INVALID_QUALIFIED_NAME_FOR_SUPERCLASS = "Superclass is not a valid Java qualified name";
    public static final String INVALID_QUALIFIED_NAME = "This is not a valid Java qualified name";
    public static final String NOT_A_VALID_INTERFACE = "Not a valid interface: ";
    public static final String NOT_A_VALID_CLASS = "Not a valid class: ";
    private Project myProject;

    public CreateNewClassDialogValidatorExImpl(Project project) {
        this.myProject = project;
    }

    public static boolean isValidJavaIdentifier(String identifier) {
        return StringUtil.isJavaIdentifier((String)identifier) && !JavaLexer.isKeyword((String)identifier, (LanguageLevel)LanguageLevel.HIGHEST);
    }

    @Override
    public boolean checkSuperclass(@NotNull String inputString) {
        return CreateNewClassDialogValidatorExImpl.checkQualifiedName(inputString);
    }

    @Override
    public boolean checkInterface(@NotNull String inputString) {
        return CreateNewClassDialogValidatorExImpl.checkQualifiedName(inputString);
    }

    @Override
    public boolean checkPackage(@NotNull String inputString) {
        return CharMatcher.WHITESPACE.matchesAllOf((CharSequence)inputString) || CreateNewClassDialogValidatorExImpl.checkList(inputString, ".");
    }

    @Nullable
    public String getErrorText(String inputString) {
        if (!inputString.isEmpty() && !PsiNameHelper.getInstance((Project)this.myProject).isQualifiedName(inputString)) {
            return INVALID_QUALIFIED_NAME;
        }
        return null;
    }

    @Override
    @NotNull
    public String getNameErrorText(@Nullable String inputString) {
        return INVALID_QUALIFIED_NAME_FOR_NEW_NAME;
    }

    @Override
    @NotNull
    public String getSuperclassErrorText(@Nullable String inputString) {
        return INVALID_QUALIFIED_NAME_FOR_SUPERCLASS;
    }

    @Override
    @NotNull
    public String getInterfacesErrorText(@Nullable String inputString) {
        return INVALID_QUALIFIED_NAME_FOR_INTERFACE;
    }

    @Override
    @NotNull
    public String getNotAClassErrorText(@Nullable String inputString) {
        return NOT_A_VALID_CLASS + inputString;
    }

    @Override
    @NotNull
    public String getNotAnInterfaceErrorText(@Nullable String inputString) {
        return NOT_A_VALID_INTERFACE + inputString;
    }

    @Override
    @NotNull
    public String getPackageErrorText(@Nullable String inputString) {
        return INVALID_PACKAGE_MESSAGE;
    }

    public boolean checkInput(String inputString) {
        String name = inputString.trim();
        return !CharMatcher.WHITESPACE.matchesAllOf((CharSequence)name) && this.getErrorText(name) == null;
    }

    public boolean canClose(String inputString) {
        return !CharMatcher.WHITESPACE.matchesAllOf((CharSequence)inputString) && this.getErrorText(inputString) == null;
    }

    private static boolean checkQualifiedName(@NotNull String qualifiedName) {
        return CharMatcher.WHITESPACE.matchesAllOf((CharSequence)qualifiedName) || CreateNewClassDialogValidatorExImpl.checkList(qualifiedName, ".");
    }

    private static boolean checkList(@NotNull String inputString, @NotNull String delimiter) {
        for (String identifier : Splitter.on((String)delimiter).trimResults().split((CharSequence)inputString)) {
            if (CreateNewClassDialogValidatorExImpl.isValidJavaIdentifier(identifier)) continue;
            return false;
        }
        return true;
    }
}

