/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.ide.common.util.PathString;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.util.FileExtensions;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformIcons;
import java.io.IOException;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateSampleDataDirectory
extends AnAction {
    private static final Logger LOG = Logger.getInstance(CreateSampleDataDirectory.class);

    public CreateSampleDataDirectory() {
        super(AndroidBundle.message("new.sampledata.dir.action.title", new Object[0]), AndroidBundle.message("new.sampledata.dir.action.description", new Object[0]), PlatformIcons.FOLDER_ICON);
    }

    @Nullable
    private static Module getModuleFromSelection(@NotNull DataContext dataContext) {
        Module[] modules = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(dataContext);
        if (modules != null && modules.length > 0) {
            return modules[0];
        }
        return (Module)LangDataKeys.MODULE.getData(dataContext);
    }

    private static boolean isActionVisibleForModule(@Nullable Module module) {
        if (module == null) {
            return false;
        }
        PathString sampleDataDirPath = ProjectSystemUtil.getModuleSystem(module).getSampleDataDirectory();
        if (sampleDataDirPath == null) {
            return false;
        }
        VirtualFile sampleDataDir = FileExtensions.toVirtualFile(sampleDataDirPath);
        return sampleDataDir == null || !sampleDataDir.exists();
    }

    public void update(@NotNull AnActionEvent e) {
        Module module = CreateSampleDataDirectory.getModuleFromSelection(e.getDataContext());
        e.getPresentation().setEnabledAndVisible(CreateSampleDataDirectory.isActionVisibleForModule(module));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Module module = CreateSampleDataDirectory.getModuleFromSelection(e.getDataContext());
        assert (module != null);
        try {
            WriteAction.run(() -> ProjectSystemUtil.getModuleSystem(module).getOrCreateSampleDataDirectory());
        }
        catch (IOException ex) {
            LOG.warn("Unable to create sample data directory for module " + module.getName(), (Throwable)ex);
        }
    }
}

