/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiClassNavigation
implements NavigationItem {
    @NotNull
    private PsiFile myPsiFile;
    private int myOffset;
    private int myLine;

    private PsiClassNavigation(@NotNull PsiFile file, int offset, int line) {
        this.myPsiFile = file;
        this.myOffset = offset;
        this.myLine = line;
    }

    @Nullable
    public static PsiClassNavigation[] getNavigationForClass(@NotNull Project project, @Nullable String className) {
        if (className == null || className.isEmpty()) {
            return null;
        }
        PsiClass[] resolvedClasses = PsiClassNavigation.resolveClasses(project, className);
        PsiClassNavigation[] navigatables = new PsiClassNavigation[resolvedClasses.length];
        for (int i2 = 0; i2 < resolvedClasses.length; ++i2) {
            PsiClass c = resolvedClasses[i2];
            navigatables[i2] = new PsiClassNavigation(c.getContainingFile(), c.getTextOffset(), -1);
        }
        return navigatables;
    }

    @Nullable
    public static PsiClassNavigation[] getNavigationForClass(@NotNull Project project, @Nullable String className, int line) {
        if (className == null || className.isEmpty()) {
            return null;
        }
        PsiClass[] psiClasses = PsiClassNavigation.getPsiClassesForOuterClass(project, className);
        PsiClassNavigation[] navigatables = new PsiClassNavigation[psiClasses.length];
        for (int i2 = 0; i2 < psiClasses.length; ++i2) {
            PsiClass c = psiClasses[i2];
            navigatables[i2] = new PsiClassNavigation(c.getContainingFile(), -1, line);
        }
        return navigatables;
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(PsiClassNavigation.class);
    }

    @NotNull
    private static PsiClass[] resolveClasses(@NotNull Project project, @NotNull String className) {
        PsiClass[] psiClasses = PsiClassNavigation.getPsiClassesForOuterClass(project, className);
        if (psiClasses.length == 0) {
            return psiClasses;
        }
        String[] classNameComponents = className.split("\\$");
        if (classNameComponents.length == 1) {
            return psiClasses;
        }
        block0: for (int psiClassIndex = 0; psiClassIndex < psiClasses.length; ++psiClassIndex) {
            for (int i2 = 1; i2 < classNameComponents.length; ++i2) {
                String innerClassName = classNameComponents[i2];
                if (PsiClassNavigation.startsWithInteger(innerClassName)) {
                    int innerClassIndex = PsiClassNavigation.convertToClassIndex(innerClassName);
                    if (innerClassIndex < 0) {
                        PsiClassNavigation.getLog().info("Attempted to resolve mismatched class name in hprof file: " + className);
                        continue block0;
                    }
                    CountDownAnonymousClassVisitor visitor = new CountDownAnonymousClassVisitor(innerClassIndex);
                    psiClasses[psiClassIndex].accept((PsiElementVisitor)visitor);
                    PsiAnonymousClass anonymousClass = visitor.getAnonymousClass();
                    if (anonymousClass == null) continue block0;
                    psiClasses[psiClassIndex] = anonymousClass;
                    continue;
                }
                PsiClass innerClass = psiClasses[psiClassIndex].findInnerClassByName(innerClassName, false);
                if (innerClass == null) continue block0;
                psiClasses[psiClassIndex] = innerClass;
            }
        }
        return psiClasses;
    }

    @NotNull
    private static PsiClass[] getPsiClassesForOuterClass(@NotNull Project project, @NotNull String className) {
        String outerClassName = PsiClassNavigation.getOuterClassName(className);
        if (outerClassName == null) {
            return PsiClass.EMPTY_ARRAY;
        }
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiClass[] psiClasses = javaPsiFacade.findClasses(outerClassName, GlobalSearchScope.projectScope((Project)project));
        if (psiClasses.length == 0) {
            psiClasses = javaPsiFacade.findClasses(outerClassName, GlobalSearchScope.allScope((Project)project));
        }
        block0: for (int i2 = 0; i2 < psiClasses.length; ++i2) {
            PsiClass[] sourcePsiClasses;
            PsiElement fileElement;
            PsiClass psiClass = psiClasses[i2];
            if (psiClass.getQualifiedName() == null || !(psiClass instanceof PsiCompiledElement) || (fileElement = psiClass.getContainingFile().getNavigationElement()) instanceof PsiCompiledElement || !(fileElement instanceof PsiJavaFile)) continue;
            for (PsiClass sourcePsiClass : sourcePsiClasses = ((PsiJavaFile)fileElement).getClasses()) {
                if (!psiClass.getQualifiedName().equals(sourcePsiClass.getQualifiedName())) continue;
                psiClasses[i2] = sourcePsiClass;
                continue block0;
            }
        }
        return psiClasses;
    }

    @Nullable
    private static String getOuterClassName(@NotNull String className) {
        int innerClassSymbolIndex = className.indexOf(36);
        if (innerClassSymbolIndex > 0) {
            return className.substring(0, innerClassSymbolIndex);
        }
        if (innerClassSymbolIndex == 0) {
            PsiClassNavigation.getLog().warn("Invalid class name: starts with '$'");
            return null;
        }
        return className;
    }

    private static int convertToClassIndex(@NotNull String innerClassNameString) {
        try {
            return Integer.parseInt(innerClassNameString) - 1;
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static boolean startsWithInteger(@NotNull String target) {
        return !target.isEmpty() && Character.isDigit(target.charAt(0));
    }

    @NotNull
    public PsiFile getPsiFile() {
        return this.myPsiFile;
    }

    @Nullable
    public String getName() {
        return this.myPsiFile.getName();
    }

    @Nullable
    public ItemPresentation getPresentation() {
        return this.myPsiFile.getPresentation();
    }

    public void navigate(boolean requestFocus) {
        OpenFileDescriptor fileDescriptor = this.myOffset >= 0 ? new OpenFileDescriptor(this.myPsiFile.getProject(), this.myPsiFile.getVirtualFile(), this.myOffset) : new OpenFileDescriptor(this.myPsiFile.getProject(), this.myPsiFile.getVirtualFile(), this.myLine, 0);
        fileDescriptor.navigate(requestFocus);
    }

    public boolean canNavigate() {
        return this.myPsiFile.canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.myPsiFile.canNavigateToSource();
    }

    private static class CountDownAnonymousClassVisitor
    extends JavaRecursiveElementVisitor {
        @Nullable
        private PsiAnonymousClass myAnonymousClass;
        private int myAnonymousClassIndex;

        public CountDownAnonymousClassVisitor(int anonymousClassIndex) {
            this.myAnonymousClassIndex = anonymousClassIndex;
        }

        public void visitAnonymousClass(PsiAnonymousClass aClass) {
            super.visitAnonymousClass(aClass);
            if (this.myAnonymousClassIndex == 0) {
                this.myAnonymousClass = aClass;
            }
            --this.myAnonymousClassIndex;
        }

        @Nullable
        public PsiAnonymousClass getAnonymousClass() {
            return this.myAnonymousClass;
        }
    }
}

