/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.annotations.concurrency.Slow;
import com.android.ide.common.repository.GradleVersion;
import com.android.repository.Revision;
import com.android.repository.api.LocalPackage;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.gradle.util.GradleVersions;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.utils.FileUtils;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingAnsiEscapesAwareProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EnvironmentUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SendFeedbackAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(SendFeedbackAction.class);
    private static final Pattern CMAKE_VERSION_PATTERN = Pattern.compile("cmake version\\s+(.*)");

    public void actionPerformed(@NotNull AnActionEvent e) {
        SendFeedbackAction.doPerformAction(e.getProject());
    }

    public static void doPerformAction(@Nullable Project project) {
        SendFeedbackAction.doPerformAction(project, "");
    }

    public static void doPerformAction(final @Nullable Project project, final @Nullable String extraDescriptionDetails) {
        new Task.Modal(project, "Collecting Data", false){

            public void run(@NotNull ProgressIndicator indicator) {
                indicator.setText("Collecting feedback information");
                indicator.setIndeterminate(true);
                String description = SendFeedbackAction.getDescription(project);
                com.intellij.ide.actions.SendFeedbackAction.doPerformAction((Project)project, (String)(description + extraDescriptionDetails));
            }
        }.setCancelText("Cancel").queue();
    }

    @Slow
    public static String getDescription(@Nullable Project project) {
        return SendFeedbackAction.safeCall(() -> {
            StringBuilder sb = new StringBuilder(com.intellij.ide.actions.SendFeedbackAction.getDescription());
            StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(SendFeedbackAction.class);
            AndroidSdkHandler sdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
            sb.append("\n\n");
            sb.append(String.format("AS: %1$s; ", ApplicationInfoEx.getInstanceEx().getFullVersion()));
            if (project != null) {
                sb.append(String.format("Android Gradle Plugin: %1$s; ", SendFeedbackAction.safeCall(() -> SendFeedbackAction.getGradlePluginDetails(project))));
                sb.append(String.format("Gradle: %1$s; ", SendFeedbackAction.safeCall(() -> SendFeedbackAction.getGradleDetails(project))));
            }
            sb.append(String.format("NDK: %1$s; ", SendFeedbackAction.safeCall(() -> SendFeedbackAction.lambda$null$2(project, sdkHandler, (com.android.repository.api.ProgressIndicator)progress))));
            sb.append(String.format("LLDB: %1$s; ", SendFeedbackAction.safeCall(() -> SendFeedbackAction.lambda$null$3(sdkHandler, (com.android.repository.api.ProgressIndicator)progress))));
            sb.append(String.format("CMake: %1$s", SendFeedbackAction.safeCall(() -> SendFeedbackAction.lambda$null$4(project, sdkHandler, (com.android.repository.api.ProgressIndicator)progress))));
            return sb.toString();
        });
    }

    private static String safeCall(@NotNull Supplier<String> runnable) {
        try {
            return runnable.get();
        }
        catch (Throwable e) {
            LOG.info("Unable to prepopulate additional version information - proceeding with sending feedback anyway. ", e);
            return "(unable to retrieve additional version information)";
        }
    }

    @Slow
    private static String getGradlePluginDetails(@NotNull Project project) {
        GradleVersion androidPluginVersion;
        AndroidPluginInfo androidPluginInfo = AndroidPluginInfo.find(project);
        if (androidPluginInfo != null && (androidPluginVersion = androidPluginInfo.getPluginVersion()) != null) {
            return androidPluginVersion.toString();
        }
        return "(plugin information not found)";
    }

    private static String getGradleDetails(@NotNull Project project) {
        GradleVersion gradleVersion2 = GradleVersions.getInstance().getGradleVersion(project);
        if (gradleVersion2 != null) {
            return gradleVersion2.toString();
        }
        return "(gradle version information not found)";
    }

    private static String getNdkDetails(@Nullable Project project, @NotNull AndroidSdkHandler sdkHandler, @NotNull com.android.repository.api.ProgressIndicator progress) {
        StringBuilder sb = new StringBuilder();
        if (project != null) {
            try {
                String ndkDir = new LocalProperties(project).getProperty("ndk.dir");
                sb.append(String.format("from local.properties: %1$s, ", ndkDir == null ? "(not specified)" : SendFeedbackAction.getNdkVersion(ndkDir)));
            }
            catch (IOException e) {
                LOG.info(String.format("Unable to read local.properties file of Project '%1$s'", project.getName()), (Throwable)e);
            }
        }
        LocalPackage p = sdkHandler.getLatestLocalPackageForPrefix("ndk-bundle", null, false, progress);
        sb.append(String.format("latest from SDK: %1$s", p == null ? "(not found)" : SendFeedbackAction.getNdkVersion(p.getLocation().getAbsolutePath())));
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getNdkVersion(@NotNull String ndkDir) {
        File sourcePropertiesFile = new File(ndkDir, "source.properties");
        if (sourcePropertiesFile.exists()) {
            FileInputStream fileInput = null;
            try {
                fileInput = new FileInputStream(sourcePropertiesFile);
                Properties props = new Properties();
                props.load(fileInput);
                String string = props.getProperty("Pkg.Revision");
                return string;
            }
            catch (Exception e) {
                LOG.info("Could not read NDK version", (Throwable)e);
                String string = "(unable to read)";
                return string;
            }
            finally {
                if (fileInput != null) {
                    try {
                        ((InputStream)fileInput).close();
                    }
                    catch (IOException e) {
                        LOG.warn("Failed to close '" + sourcePropertiesFile.getPath() + "'", (Throwable)e);
                    }
                }
            }
        }
        File releaseTxtFile = new File(ndkDir, "RELEASE.TXT");
        if (releaseTxtFile.exists()) {
            try {
                byte[] content = Files.readAllBytes(releaseTxtFile.toPath());
                return new String(content).trim();
            }
            catch (IOException e) {
                LOG.info("Could not read NDK version", (Throwable)e);
                return "(unable to read)";
            }
        }
        return "UNKNOWN";
    }

    private static String getLldbDetails(@NotNull AndroidSdkHandler sdkHandler, @NotNull com.android.repository.api.ProgressIndicator progress) {
        String path = DetailsTypes.getLldbPath((Revision)Revision.parseRevision((String)"3.1"));
        LocalPackage p = sdkHandler.getLocalPackage(path, progress);
        if (p == null) {
            p = sdkHandler.getLatestLocalPackageForPrefix("lldb", null, false, progress);
            return String.format("pinned revision %1$s not found, latest from SDK: %2$s", "3.1", SendFeedbackAction.getLocalPackageDisplayInfo(p));
        }
        return SendFeedbackAction.getLocalPackageDisplayInfo(p);
    }

    private static String getCMakeDetails(@Nullable Project project, @NotNull AndroidSdkHandler sdkHandler, @NotNull com.android.repository.api.ProgressIndicator progress) {
        StringBuilder sb = new StringBuilder();
        if (project != null) {
            try {
                String cmakeDir = new LocalProperties(project).getProperty("cmake.dir");
                sb.append(String.format("from local.properties: %1$s, ", cmakeDir == null ? "(not specified)" : SendFeedbackAction.runAndGetCMakeVersion(SendFeedbackAction.getCMakeExecutablePath(cmakeDir))));
            }
            catch (IOException e) {
                LOG.info(String.format("Unable to read local.properties file of Project '%1$s'", project.getName()), (Throwable)e);
            }
        }
        LocalPackage p = sdkHandler.getLatestLocalPackageForPrefix("cmake", null, false, progress);
        sb.append(String.format("latest from SDK: %1$s, ", p == null ? "(not found)" : SendFeedbackAction.runAndGetCMakeVersion(SendFeedbackAction.getCMakeExecutablePath(p.getLocation().getAbsolutePath()))));
        String cmakeBinFromPath = SendFeedbackAction.findOnPath("cmake");
        sb.append(String.format("from PATH: %1$s", cmakeBinFromPath == null ? "(not found)" : SendFeedbackAction.runAndGetCMakeVersion(cmakeBinFromPath)));
        return sb.toString();
    }

    @Nullable
    private static String findOnPath(@NotNull String executableName) {
        String path = EnvironmentUtil.getValue((String)"PATH");
        if (path != null) {
            for (String dir : StringUtil.tokenize((String)path, (String)File.pathSeparator)) {
                File candidate = new File(dir, executableName);
                if (!candidate.canExecute()) continue;
                return candidate.getAbsolutePath();
            }
        }
        return null;
    }

    private static String getCMakeExecutableName() {
        String cmakeExecutableName = "cmake";
        if (SystemInfo.isWindows) {
            cmakeExecutableName = cmakeExecutableName + ".exe";
        }
        return cmakeExecutableName;
    }

    private static String getCMakeExecutablePath(@NotNull String cmakeDir) {
        String cmakeExecutableName;
        String cmakeBinDirectory = FileUtils.join((String[])new String[]{cmakeDir, "bin"});
        File cmakeExecutableFile = new File(FileUtils.join((String[])new String[]{cmakeBinDirectory, cmakeExecutableName = SendFeedbackAction.getCMakeExecutableName()}));
        if (!cmakeExecutableFile.exists() || !cmakeExecutableFile.canExecute()) {
            return "(binary doesn't exist or is not executable)";
        }
        return cmakeExecutableFile.getAbsolutePath();
    }

    private static String runAndGetCMakeVersion(@NotNull String cmakeExecutableFile) {
        LOG.info("CMake binary: " + cmakeExecutableFile);
        GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{cmakeExecutableFile});
        commandLine.addParameter("-version");
        try {
            Matcher m;
            CapturingAnsiEscapesAwareProcessHandler process = new CapturingAnsiEscapesAwareProcessHandler(commandLine);
            final StringBuffer output = new StringBuffer();
            process.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    output.append(event.getText());
                    super.onTextAvailable(event, outputType);
                }
            });
            int exitCode = process.runProcess().getExitCode();
            if (exitCode == 0 && (m = CMAKE_VERSION_PATTERN.matcher(output.toString())).find()) {
                return m.group(1);
            }
            return output.length() > 0 ? output.toString() : "(empty output)";
        }
        catch (ExecutionException e) {
            LOG.info("Could not invoke 'cmake -version'", (Throwable)e);
            return "(unable to invoke cmake)";
        }
    }

    private static String getLocalPackageDisplayInfo(@Nullable LocalPackage p) {
        if (p == null) {
            return "(package not found)";
        }
        return String.format("%1$s (revision: %2$s)", p.getDisplayName(), p.getVersion());
    }

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        if (e.getPresentation().isEnabled()) {
            e.getPresentation().setEnabled(SystemInfo.isMac || SystemInfo.isLinux || SystemInfo.isWindows);
        }
    }

    private static /* synthetic */ String lambda$null$4(Project project, AndroidSdkHandler sdkHandler, com.android.repository.api.ProgressIndicator progress) {
        return SendFeedbackAction.getCMakeDetails(project, sdkHandler, progress);
    }

    private static /* synthetic */ String lambda$null$3(AndroidSdkHandler sdkHandler, com.android.repository.api.ProgressIndicator progress) {
        return SendFeedbackAction.getLldbDetails(sdkHandler, progress);
    }

    private static /* synthetic */ String lambda$null$2(Project project, AndroidSdkHandler sdkHandler, com.android.repository.api.ProgressIndicator progress) {
        return SendFeedbackAction.getNdkDetails(project, sdkHandler, progress);
    }
}

