/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.adb;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.tools.idea.adb.AdbLogOutput;
import com.android.tools.idea.adb.AdbOptionsService;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdbService
implements Disposable,
AdbOptionsService.AdbOptionsListener {
    private static final Logger LOG = Logger.getInstance(AdbService.class);
    public static final int TIMEOUT = 3000000;
    @Nullable
    private ListenableFuture<AndroidDebugBridge> myFuture;
    private final AtomicReference<File> myAdb = new AtomicReference();
    private static final Object ADB_INIT_LOCK = new Object();

    public static AdbService getInstance() {
        return (AdbService)ServiceManager.getService(AdbService.class);
    }

    private AdbService() {
        String defaultLogLevel = AdbLogOutput.SystemLogRedirecter.getLogger().isTraceEnabled() ? Log.LogLevel.VERBOSE.getStringValue() : (AdbLogOutput.SystemLogRedirecter.getLogger().isDebugEnabled() ? Log.LogLevel.DEBUG.getStringValue() : Log.LogLevel.INFO.getStringValue());
        DdmPreferences.setLogLevel((String)defaultLogLevel);
        DdmPreferences.setTimeOut((int)3000000);
        Log.addLogger((Log.ILogOutput)new AdbLogOutput.SystemLogRedirecter());
        AdbOptionsService.getInstance().addListener(this);
    }

    public void dispose() {
        this.terminateDdmlib();
        AdbOptionsService.getInstance().removeListener(this);
    }

    public synchronized ListenableFuture<AndroidDebugBridge> getDebugBridge(@NotNull File adb) {
        this.myAdb.set(adb);
        if (this.myFuture != null && this.myFuture.isDone() && !AdbService.wasSuccessful(this.myFuture)) {
            this.terminateDdmlib();
        }
        if (this.myFuture == null) {
            Future future2 = ApplicationManager.getApplication().executeOnPooledThread((Callable)new CreateBridgeTask(adb));
            this.myFuture = AdbService.makeTimedFuture(future2, 20L, TimeUnit.SECONDS);
        }
        return this.myFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void terminateDdmlib() {
        if (this.myFuture != null) {
            this.myFuture.cancel(true);
            this.myFuture = null;
        }
        Object object = ADB_INIT_LOCK;
        synchronized (object) {
            AndroidDebugBridge.disconnectBridge();
            AndroidDebugBridge.terminate();
        }
    }

    public static boolean isDdmsCorrupted(@NotNull AndroidDebugBridge bridge) {
        IDevice[] devices = bridge.getDevices();
        if (devices.length > 0) {
            for (IDevice device : devices) {
                Client[] clients = device.getClients();
                if (clients.length <= 0) continue;
                ClientData clientData = clients[0].getClientData();
                return clientData.getVmIdentifier() == null;
            }
        }
        return false;
    }

    @NotNull
    public synchronized ListenableFuture<AndroidDebugBridge> restartDdmlib(@NotNull File adb) {
        this.terminateDdmlib();
        return this.getDebugBridge(adb);
    }

    private static boolean wasSuccessful(Future<AndroidDebugBridge> future2) {
        if (!future2.isDone()) {
            return false;
        }
        try {
            AndroidDebugBridge bridge = future2.get();
            return bridge != null && bridge.isConnected();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void optionsChanged() {
        File adb = this.myAdb.get();
        if (adb != null) {
            LOG.info("Terminating adb server");
            this.terminateDdmlib();
            LOG.info("Restart adb server");
            this.getDebugBridge(adb);
        }
    }

    private static ListenableFuture<AndroidDebugBridge> makeTimedFuture(@NotNull Future<BridgeConnectionResult> delegate, long timeout, @NotNull TimeUnit unit) {
        SettableFuture future2 = SettableFuture.create();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                BridgeConnectionResult value2 = (BridgeConnectionResult)delegate.get(timeout, unit);
                if (value2.error != null) {
                    future2.setException((Throwable)new RuntimeException("Unable to create Debug Bridge: " + value2.error));
                } else {
                    future2.set((Object)value2.bridge);
                }
            }
            catch (ExecutionException e) {
                future2.setException(e.getCause());
            }
            catch (InterruptedException | TimeoutException e) {
                delegate.cancel(true);
                future2.setException((Throwable)e);
            }
        });
        return future2;
    }

    public static String getDebugBridgeDiagnosticErrorMessage(@NotNull Throwable t, @NotNull File adb) {
        String msg = t.getMessage() != null ? t.getMessage() : String.format("Unable to establish a connection to adb.\n\nCheck the Event Log for possible issues.\nThis can happen if you have an incompatible version of adb running already,\nor if localhost is pointing to the wrong address.\nTry re-opening %1$s after killing any existing adb daemons and verifying that your\nlocalhost entry is pointing to 127.0.0.1 or ::1 for IPv4 or IPv6, respectively.\n\nIf this happens repeatedly, please file a bug at http://b.android.com including the following:\n  1. Output of the command: '%2$s devices'\n  2. Your idea.log file (Help | Show Log in Explorer)\n", ApplicationNamesInfo.getInstance().getProductName(), adb.getAbsolutePath());
        return msg;
    }

    private static class BridgeConnectionResult {
        @Nullable
        public final AndroidDebugBridge bridge;
        @Nullable
        public final String error;

        private BridgeConnectionResult(@Nullable AndroidDebugBridge bridge, @Nullable String error) {
            this.bridge = bridge;
            this.error = error;
        }

        public static BridgeConnectionResult make(@NotNull AndroidDebugBridge bridge) {
            return new BridgeConnectionResult(bridge, null);
        }

        public static BridgeConnectionResult make(@NotNull String error) {
            return new BridgeConnectionResult(null, error);
        }
    }

    private static class CreateBridgeTask
    implements Callable<BridgeConnectionResult> {
        private final File myAdb;

        public CreateBridgeTask(@NotNull File adb) {
            this.myAdb = adb;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BridgeConnectionResult call() throws Exception {
            LOG.info("Initializing adb using: " + this.myAdb.getAbsolutePath());
            ImmutableMap env = ApplicationManager.getApplication() == null || ApplicationManager.getApplication().isUnitTestMode() ? ImmutableMap.of((Object)"HOME", (Object)Files.createTempDir().getAbsolutePath()) : ImmutableMap.of();
            AdbLogOutput.ToStringLogger toStringLogger = new AdbLogOutput.ToStringLogger();
            Log.addLogger((Log.ILogOutput)toStringLogger);
            try {
                AndroidDebugBridge bridge;
                Object object = ADB_INIT_LOCK;
                synchronized (object) {
                    AndroidDebugBridge.init((boolean)true, (boolean)AdbOptionsService.getInstance().shouldUseLibusb(), (Map)env);
                    bridge = AndroidDebugBridge.createBridge((String)this.myAdb.getPath(), (boolean)false);
                }
                if (bridge == null) {
                    object = BridgeConnectionResult.make("Unable to start adb server: " + toStringLogger.getOutput());
                    return object;
                }
                while (!bridge.isConnected()) {
                    try {
                        TimeUnit.MILLISECONDS.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        BridgeConnectionResult bridgeConnectionResult = BridgeConnectionResult.make("Timed out attempting to connect to adb: " + toStringLogger.getOutput());
                        Log.removeLogger((Log.ILogOutput)toStringLogger);
                        return bridgeConnectionResult;
                    }
                }
                LOG.info("Successfully connected to adb");
                object = BridgeConnectionResult.make(bridge);
                return object;
            }
            finally {
                Log.removeLogger((Log.ILogOutput)toStringLogger);
            }
        }
    }
}

