/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer;

import com.android.tools.apk.analyzer.ApkSizeCalculator;
import com.android.tools.apk.analyzer.Archive;
import com.android.tools.apk.analyzer.ArchiveContext;
import com.android.tools.apk.analyzer.Archives;
import com.android.tools.apk.analyzer.BinaryXmlParser;
import com.android.tools.apk.analyzer.internal.ArchiveTreeNode;
import com.android.tools.idea.FileEditorUtil;
import com.android.tools.idea.apk.viewer.ApkFileEditorComponent;
import com.android.tools.idea.apk.viewer.ApkFileSystem;
import com.android.tools.idea.apk.viewer.ApkParser;
import com.android.tools.idea.apk.viewer.ApkViewPanel;
import com.android.tools.idea.apk.viewer.ApkVirtualFile;
import com.android.tools.idea.apk.viewer.EmptyPanel;
import com.android.tools.idea.apk.viewer.ProtoXmlPrettyPrinterImpl;
import com.android.tools.idea.apk.viewer.arsc.ArscViewer;
import com.android.tools.idea.apk.viewer.dex.DexFileViewer;
import com.android.tools.idea.apk.viewer.diff.ApkDiffPanel;
import com.google.common.base.Charsets;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.FocusTraversalPolicy;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.LayoutFocusTraversalPolicy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApkEditor
extends UserDataHolderBase
implements FileEditor,
ApkViewPanel.Listener {
    private final Project myProject;
    private final VirtualFile myBaseFile;
    private final VirtualFile myRoot;
    private ApkViewPanel myApkViewPanel;
    private ArchiveContext myArchiveContext;
    private JBSplitter mySplitter;
    private ApkFileEditorComponent myCurrentEditor;

    public ApkEditor(@NotNull Project project, final @NotNull VirtualFile baseFile, @NotNull VirtualFile root) {
        this.myProject = project;
        this.myBaseFile = baseFile;
        this.myRoot = root;
        FileEditorUtil.DISABLE_GENERATED_FILE_NOTIFICATION_KEY.set((UserDataHolder)this, (Object)true);
        this.mySplitter = new JBSplitter(true, "android.apk.viewer", 0.62f);
        this.mySplitter.setName("apkViwerContainer");
        this.mySplitter.setFocusCycleRoot(true);
        this.mySplitter.setFocusTraversalPolicy((FocusTraversalPolicy)new LayoutFocusTraversalPolicy());
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)this);
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                for (VFileEvent vFileEvent : events) {
                    if (!ApkEditor.this.myBaseFile.equals(vFileEvent.getFile()) || !ApkEditor.this.myBaseFile.isValid()) continue;
                    ApkEditor.this.refreshApk(baseFile);
                }
            }
        });
        this.refreshApk(this.myBaseFile);
        this.mySplitter.setSecondComponent((JComponent)new JPanel());
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(ApkEditor.class);
    }

    private void refreshApk(@NotNull VirtualFile apkVirtualFile) {
        this.disposeArchive();
        try {
            Path copyOfApk = Files.createTempFile(apkVirtualFile.getNameWithoutExtension(), "." + apkVirtualFile.getExtension(), new FileAttribute[0]);
            Files.copy(VfsUtilCore.virtualToIoFile((VirtualFile)apkVirtualFile).toPath(), copyOfApk, StandardCopyOption.REPLACE_EXISTING);
            this.myArchiveContext = Archives.open((Path)copyOfApk);
            this.myApkViewPanel = new ApkViewPanel(this.myProject, new ApkParser(this.myArchiveContext, ApkSizeCalculator.getDefault()));
            this.myApkViewPanel.setListener(this);
            this.mySplitter.setFirstComponent(this.myApkViewPanel.getContainer());
            this.selectionChanged(null);
        }
        catch (IOException e) {
            ApkEditor.getLog().error((Throwable)e);
            this.disposeArchive();
            this.mySplitter.setFirstComponent((JComponent)new JBLabel(e.toString()));
        }
    }

    @Override
    public void selectionChanged(@Nullable ArchiveTreeNode[] entries) {
        if (this.myCurrentEditor != null) {
            Disposer.dispose((Disposable)this.myCurrentEditor);
            this.myCurrentEditor = null;
        }
        this.myCurrentEditor = this.getEditor(entries);
        this.mySplitter.setSecondComponent(this.myCurrentEditor.getComponent());
    }

    @Override
    public void selectApkAndCompare() {
        FileChooserDescriptor desc = new FileChooserDescriptor(true, false, false, false, false, false);
        desc.withFileFilter(file -> ApkFileSystem.EXTENSIONS.contains(file.getExtension()));
        VirtualFile file2 = FileChooser.chooseFile((FileChooserDescriptor)desc, (Project)this.myProject, null);
        if (file2 == null) {
            return;
        }
        VirtualFile oldApk = ApkFileSystem.getInstance().getRootByLocal(file2);
        assert (oldApk != null);
        DialogBuilder builder = new DialogBuilder(this.myProject);
        builder.setTitle(oldApk.getName() + " (old) vs " + this.myRoot.getName() + " (new)");
        ApkDiffPanel panel2 = new ApkDiffPanel(oldApk, this.myRoot);
        builder.setCenterPanel(panel2.getContainer());
        builder.setPreferredFocusComponent(panel2.getPreferredFocusedComponent());
        builder.show();
    }

    @NotNull
    public JComponent getComponent() {
        return this.mySplitter;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myApkViewPanel.getPreferredFocusedComponent();
    }

    @NotNull
    public String getName() {
        return this.myBaseFile.getName();
    }

    public void setState(@NotNull FileEditorState state) {
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return this.myBaseFile.isValid();
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
        if (this.myCurrentEditor != null) {
            Disposer.dispose((Disposable)this.myCurrentEditor);
            this.myCurrentEditor = null;
        }
        ApkEditor.getLog().info("Disposing ApkEditor with ApkViewPanel: " + this.myApkViewPanel);
        this.disposeArchive();
    }

    private void disposeArchive() {
        if (this.myApkViewPanel != null) {
            this.myApkViewPanel.clearArchive();
        }
        if (this.myArchiveContext != null) {
            try {
                this.myArchiveContext.close();
                Files.deleteIfExists(this.myArchiveContext.getArchive().getPath());
            }
            catch (IOException e) {
                ApkEditor.getLog().warn((Throwable)e);
            }
            this.myArchiveContext = null;
        }
    }

    @NotNull
    private ApkFileEditorComponent getEditor(@Nullable ArchiveTreeNode[] nodes) {
        if (nodes == null || nodes.length == 0) {
            return new EmptyPanel();
        }
        boolean allDex = true;
        for (ArchiveTreeNode path : nodes) {
            if (path.getData().getPath().getFileName().toString().endsWith("dex")) continue;
            allDex = false;
            break;
        }
        if (allDex) {
            Path[] paths2 = new Path[nodes.length];
            for (int i2 = 0; i2 < nodes.length; ++i2) {
                paths2[i2] = nodes[i2].getData().getPath();
            }
            return new DexFileViewer(this.myProject, paths2, this.myBaseFile.getParent());
        }
        ArchiveTreeNode n = nodes[0];
        Path p = n.getData().getPath();
        Path fileName = p.getFileName();
        if ("resources.arsc".equals(fileName.toString())) {
            byte[] arscContent;
            try {
                arscContent = Files.readAllBytes(p);
            }
            catch (IOException e) {
                return new EmptyPanel();
            }
            return new ArscViewer(arscContent);
        }
        if (p.toString().endsWith("dex")) {
            return new DexFileViewer(this.myProject, new Path[]{p}, this.myBaseFile.getParent());
        }
        if (p.toString().endsWith("kotlin_builtins") || p.toString().endsWith("kotlin_metadata")) {
            return new EmptyPanel();
        }
        VirtualFile file = this.createVirtualFile(n.getData().getArchive(), p);
        Optional<FileEditorProvider> providers = this.getFileEditorProviders(file);
        if (!providers.isPresent()) {
            return new EmptyPanel();
        }
        if (file != null) {
            final FileEditor editor2 = providers.get().createEditor(this.myProject, file);
            return new ApkFileEditorComponent(){

                @Override
                @NotNull
                public JComponent getComponent() {
                    return editor2.getComponent();
                }

                public void dispose() {
                    Disposer.dispose((Disposable)editor2);
                }
            };
        }
        return new EmptyPanel();
    }

    @Nullable
    private VirtualFile createVirtualFile(@NotNull Archive archive, @NotNull Path p) {
        byte[] content;
        Path name = p.getFileName();
        if (name == null) {
            return null;
        }
        if (Files.isDirectory(p, new LinkOption[0])) {
            return null;
        }
        try {
            content = Files.readAllBytes(p);
        }
        catch (IOException e) {
            ApkEditor.getLog().warn(String.format("Error loading entry \"%s\" from archive", p.toString()), (Throwable)e);
            return null;
        }
        if (archive.isBinaryXml(p, content)) {
            content = BinaryXmlParser.decodeXml((String)name.toString(), (byte[])content);
            return ApkVirtualFile.create(p, content);
        }
        if (archive.isProtoXml(p, content)) {
            try {
                ProtoXmlPrettyPrinterImpl prettyPrinter = new ProtoXmlPrettyPrinterImpl();
                content = prettyPrinter.prettyPrint(content).getBytes(Charsets.UTF_8);
            }
            catch (IOException e) {
                ApkEditor.getLog().warn(String.format("Error decoding XML entry \"%s\" from archive", p.toString()), (Throwable)e);
            }
            return ApkVirtualFile.create(p, content);
        }
        VirtualFile file = JarFileSystem.getInstance().findLocalVirtualFileByPath(archive.getPath().toString());
        if (file != null) {
            return file.findFileByRelativePath(p.toString());
        }
        return ApkVirtualFile.create(p, content);
    }

    @NotNull
    private Optional<FileEditorProvider> getFileEditorProviders(@Nullable VirtualFile file) {
        if (file == null || file.isDirectory()) {
            return Optional.empty();
        }
        FileEditorProvider[] providers = FileEditorProviderManager.getInstance().getProviders(this.myProject, file);
        return Arrays.stream(providers).filter(fileEditorProvider -> !fileEditorProvider.getClass().getName().equals("com.android.tools.idea.editors.NinePatchEditorProvider")).findFirst();
    }
}

