/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer.dex;

import com.android.tools.apk.analyzer.dex.DexReferences;
import com.android.tools.apk.analyzer.dex.PackageTreeCreator;
import com.android.tools.apk.analyzer.dex.ProguardMappings;
import com.android.tools.apk.analyzer.dex.tree.DexClassNode;
import com.android.tools.apk.analyzer.dex.tree.DexElementNode;
import com.android.tools.apk.analyzer.dex.tree.DexFieldNode;
import com.android.tools.apk.analyzer.dex.tree.DexMethodNode;
import com.android.tools.idea.apk.viewer.dex.DexFileViewer;
import com.android.tools.idea.apk.viewer.dex.DexNodeIcons;
import com.android.tools.idea.concurrent.EdtExecutor;
import com.android.tools.proguard.ProguardMap;
import com.android.tools.proguard.ProguardSeedsMap;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import java.awt.Component;
import java.awt.Dimension;
import java.util.concurrent.Executor;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jf.dexlib2.iface.reference.FieldReference;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.iface.reference.Reference;
import org.jf.dexlib2.iface.reference.TypeReference;

public class ShowReferencesAction
extends AnAction {
    @NotNull
    private final Tree myTree;
    @NotNull
    private final DexFileViewer myDexFileViewer;

    public ShowReferencesAction(@NotNull Tree tree, @NotNull DexFileViewer viewer) {
        super(ProjectBundle.message((String)"find.usages.action.text", (Object[])new Object[0]), ProjectBundle.message((String)"find.usages.action.text", (Object[])new Object[0]), AllIcons.Actions.Find);
        this.registerCustomShortcutSet(ActionManager.getInstance().getAction("FindUsages").getShortcutSet(), (JComponent)tree);
        this.myTree = tree;
        this.myDexFileViewer = viewer;
    }

    public void update(@NotNull AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        DexElementNode node = this.getSelectedNode();
        if (!ShowReferencesAction.canShowReferences(node)) {
            presentation.setEnabled(false);
            return;
        }
        presentation.setEnabled(true);
    }

    public void actionPerformed(final @NotNull AnActionEvent e) {
        final DexElementNode node = this.getSelectedNode();
        assert (node != null);
        final Project project = ShowReferencesAction.getEventProject((AnActionEvent)e);
        ListenableFuture<DexReferences> references = this.myDexFileViewer.getDexReferences();
        assert (references != null);
        Futures.addCallback(references, (FutureCallback)new FutureCallback<DexReferences>(){

            public void onSuccess(@Nullable DexReferences result2) {
                ShowReferencesAction.this.showReferenceTree(e, node, project, result2);
            }

            public void onFailure(Throwable t) {
            }
        }, (Executor)EdtExecutor.INSTANCE);
    }

    private void showReferenceTree(AnActionEvent e, DexElementNode node, Project project, final DexReferences references) {
        ProguardMappings proguardMappings = this.myDexFileViewer.getProguardMappings();
        final ProguardMap proguardMap = proguardMappings != null ? proguardMappings.map : null;
        final ProguardSeedsMap seedsMap = proguardMappings != null ? proguardMappings.seeds : null;
        final boolean deobfuscate = this.myDexFileViewer.isDeobfuscateNames();
        assert (node.getReference() != null);
        Tree tree = new Tree((TreeModel)new DefaultTreeModel((TreeNode)references.getReferenceTreeFor(node.getReference(), true)));
        tree.setShowsRootHandles(true);
        tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                DexElementNode node;
                TreePath path = event.getPath();
                if (path.getLastPathComponent() instanceof DexElementNode && !DexReferences.isAlreadyLoaded((DexElementNode)(node = (DexElementNode)path.getLastPathComponent()))) {
                    node.removeAllChildren();
                    assert (node.getReference() != null);
                    references.addReferencesForNode(node, true);
                    node.sort(DexReferences.NODE_COMPARATOR);
                }
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }
        });
        tree.setCellRenderer((TreeCellRenderer)new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                ProguardMap usedProguardMap;
                DexElementNode node = (DexElementNode)value2;
                Reference ref = node.getReference();
                boolean isSeed = node.isSeed(seedsMap, proguardMap, false);
                SimpleTextAttributes attr2 = new SimpleTextAttributes(isSeed ? 1 : 0, null);
                ProguardMap proguardMap2 = usedProguardMap = deobfuscate ? proguardMap : null;
                if (ref instanceof TypeReference) {
                    TypeReference typeRef = (TypeReference)ref;
                    this.append(PackageTreeCreator.decodeClassName((String)typeRef.getType(), (ProguardMap)usedProguardMap), attr2);
                } else if (ref instanceof MethodReference) {
                    MethodReference methodRef = (MethodReference)ref;
                    this.append(PackageTreeCreator.decodeClassName((String)methodRef.getDefiningClass(), (ProguardMap)usedProguardMap), attr2);
                    this.append(": ", attr2);
                    this.append(PackageTreeCreator.decodeClassName((String)methodRef.getReturnType(), (ProguardMap)usedProguardMap), attr2);
                    this.append(" ", attr2);
                    this.append(PackageTreeCreator.decodeMethodName((MethodReference)methodRef, (ProguardMap)usedProguardMap), attr2);
                    this.append(PackageTreeCreator.decodeMethodParams((MethodReference)methodRef, (ProguardMap)usedProguardMap), attr2);
                } else if (ref instanceof FieldReference) {
                    FieldReference fieldRef = (FieldReference)ref;
                    this.append(PackageTreeCreator.decodeClassName((String)fieldRef.getDefiningClass(), (ProguardMap)usedProguardMap), attr2);
                    this.append(": ", attr2);
                    this.append(PackageTreeCreator.decodeClassName((String)fieldRef.getType(), (ProguardMap)usedProguardMap), attr2);
                    this.append(" ", attr2);
                    this.append(PackageTreeCreator.decodeFieldName((FieldReference)fieldRef, (ProguardMap)usedProguardMap), attr2);
                }
                this.setIcon(DexNodeIcons.forNode(node));
            }
        });
        JBScrollPane pane = new JBScrollPane((Component)tree);
        pane.setPreferredSize(new Dimension(600, 400));
        JBPopup popup2 = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)pane, null).setProject(project).setDimensionServiceKey(project, ShowReferencesAction.class.getName(), false).setResizable(true).setMovable(true).setTitle("References to " + node.getName()).createPopup();
        popup2.showInBestPositionFor(e.getDataContext());
    }

    @Nullable
    private DexElementNode getSelectedNode() {
        TreePath path = this.myTree.getSelectionPath();
        Object component = path.getLastPathComponent();
        return component instanceof DexElementNode ? (DexElementNode)component : null;
    }

    static boolean canShowReferences(@Nullable DexElementNode node) {
        if (node == null || node.getReference() == null) {
            return false;
        }
        return node instanceof DexClassNode || node instanceof DexMethodNode || node instanceof DexFieldNode;
    }
}

