/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.assistant;

import com.android.tools.idea.assistant.datamodel.ActionData;
import com.android.tools.idea.assistant.datamodel.FeatureData;
import com.android.tools.idea.assistant.datamodel.StepData;
import com.android.tools.idea.assistant.datamodel.StepElementData;
import com.android.tools.idea.assistant.datamodel.StepElementType;
import com.android.tools.idea.assistant.datamodel.TutorialBundleData;
import com.android.tools.idea.assistant.datamodel.TutorialData;
import com.android.tools.idea.templates.recipe.Recipe;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.IconLoader;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;

@XmlRootElement(name="tutorialBundle")
public class DefaultTutorialBundle
implements TutorialBundleData {
    @XmlAttribute(name="name")
    private String myName;
    @XmlAttribute(name="icon")
    @Nullable
    private String myIconName;
    @XmlAttribute(name="logo")
    @Nullable
    private String myLogoName;
    @XmlAttribute(name="id")
    private String myId;
    @XmlAttribute(name="delete")
    private int myDeleteme;
    @XmlAttribute(name="contentRoot")
    private String myContentRoot;
    @XmlAttribute(name="resourceRoot")
    private String myResourceRoot;
    @XmlElement(name="welcome")
    private String myWelcome;
    @XmlElement(name="learnMoreLink")
    private String myLearnMoreLink;
    @XmlAttribute(name="stepByStep")
    private boolean myStepByStep;
    @XmlAttribute(name="hideStepIndex")
    private boolean myHideStepIndex;
    private Icon myIcon;
    private Icon myLogo;
    private Class myResourceClass;
    @XmlElements(value={@XmlElement(name="feature", type=Feature.class)})
    private List<Feature> myFeatures = Lists.newArrayList();

    public static TutorialBundleData parse(@NotNull InputStream stream) throws JAXBException {
        return DefaultTutorialBundle.parse(stream, DefaultTutorialBundle.class);
    }

    public static <T> T parse(@NotNull InputStream stream, Class<T> clazz) throws JAXBException {
        Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])new Class[]{clazz}).createUnmarshaller();
        unmarshaller.setEventHandler(event -> {
            DefaultTutorialBundle.getLog().info("Found unhandled xml", event.getLinkedException());
            return true;
        });
        return (T)unmarshaller.unmarshal((Source)new StreamSource(stream), clazz).getValue();
    }

    private static Logger getLog() {
        return Logger.getInstance(TutorialBundleData.class);
    }

    @Override
    public void setResourceClass(@NotNull Class clazz) {
        this.myResourceClass = clazz;
        this.myFeatures.forEach(feature -> feature.getTutorials().forEach(tutorial -> tutorial.setResourceClass(clazz)));
    }

    @Nullable
    private Icon getIconResource(@NotNull String path) {
        return IconLoader.findIcon((String)path, (Class)this.myResourceClass);
    }

    @NotNull
    public static String getIconResourcePath(@NotNull String resourceRoot, @NotNull String iconPath) {
        return FileUtils.toSystemIndependentPath((String)new File(resourceRoot, iconPath).toString());
    }

    @Override
    @NotNull
    public String getName() {
        return this.myName;
    }

    @Override
    public boolean isStepByStep() {
        return this.myStepByStep;
    }

    @Override
    public boolean hideStepIndex() {
        return this.myHideStepIndex;
    }

    @Override
    @Nullable
    public Icon getIcon() {
        if (this.myIcon != null) {
            return this.myIcon;
        }
        if (this.myIconName == null || this.myResourceRoot == null) {
            return null;
        }
        this.myIcon = this.getIconResource(DefaultTutorialBundle.getIconResourcePath(this.myResourceRoot, this.myIconName));
        return this.myIcon;
    }

    @Override
    @Nullable
    public Icon getLogo() {
        if (this.myLogo != null) {
            return this.myLogo;
        }
        if (this.myLogoName == null || this.myResourceRoot == null) {
            return null;
        }
        this.myLogo = this.getIconResource(DefaultTutorialBundle.getIconResourcePath(this.myResourceRoot, this.myLogoName));
        return this.myLogo;
    }

    @NotNull
    public List<Feature> getFeatures() {
        return ImmutableList.copyOf(this.myFeatures);
    }

    @Override
    @NotNull
    public String getWelcome() {
        return this.myWelcome;
    }

    private void afterUnmarshal(Unmarshaller u, Object parent) {
        this.myFeatures.forEach(feature -> feature.getTutorials().forEach(tutorial -> {
            tutorial.myResourceRoot = this.myResourceRoot;
        }));
    }

    public String toString() {
        return "TutorialBundle{myName='" + this.myName + '\'' + ", myIcon='" + this.myIcon + '\'' + ", myLogo='" + this.myLogo + '\'' + ", myId='" + this.myId + '\'' + ", myContentRoot='" + this.myContentRoot + '\'' + ", myResourceRoot='" + this.myResourceRoot + '\'' + ", myWelcome='" + this.myWelcome + '\'' + ", myLearnMoreLink='" + this.myLearnMoreLink + '\'' + ", myFeatures=" + this.myFeatures + '}';
    }

    public static final class Action
    implements ActionData {
        @XmlAttribute(name="label")
        private String myLabel;
        @XmlAttribute(name="key")
        private String myKey;
        @XmlAttribute(name="actionArgument")
        private String myActionArgument;
        @XmlAttribute(name="successMessage")
        private String mySuccessMessage;
        @XmlAttribute(name="editAction")
        private String myEditAction;
        @XmlElement(name="recipe", type=Recipe.class)
        private Recipe myRecipe;

        @Override
        @NotNull
        public String getLabel() {
            return this.myLabel;
        }

        @Override
        @NotNull
        public String getKey() {
            return this.myKey;
        }

        @Override
        public String getActionArgument() {
            return this.myActionArgument;
        }

        @Override
        public String getSuccessMessage() {
            return this.mySuccessMessage;
        }

        @Override
        public Recipe getRecipe() {
            return this.myRecipe;
        }

        public String toString() {
            return "Action{myLabel='" + this.myLabel + "', myKey='" + this.myKey + "', myActionArgument='" + this.myActionArgument + "', mySuccessMessage='" + this.mySuccessMessage + "', myEditAction='" + this.myEditAction + "', myRecipe='" + this.myRecipe + "'" + '}';
        }

        private void afterUnmarshal(Unmarshaller u, Object parent) {
            if (this.myRecipe != null) {
                this.myRecipe.addUpdateAndSyncGradleInstruction();
            }
        }

        public boolean equals(@Nullable Object that) {
            if (this == that) {
                return true;
            }
            if (!(that instanceof Action)) {
                return false;
            }
            Action otherAction = (Action)that;
            return this.toString().equals(otherAction.toString());
        }
    }

    public static final class Image {
        @XmlAttribute(name="src")
        private String mySource;
        @XmlAttribute(name="height")
        private int myHeight;
        @XmlAttribute(name="width")
        private int myWidth;
        @XmlAttribute(name="description")
        private String myDescription;

        @Nullable
        public String getSource() {
            return this.mySource;
        }

        public int getHeight() {
            return this.myHeight;
        }

        public int getWidth() {
            return this.myWidth;
        }

        @Nullable
        public String getDescription() {
            return this.myDescription;
        }
    }

    public static final class Code {
        @XmlValue
        private String myCode;
        @XmlAttribute(name="fileType")
        private String myCodeType;

        public String getCode() {
            return this.myCode;
        }

        public FileType getCodeType() {
            if (this.myCodeType == null) {
                return null;
            }
            String type = this.myCodeType.trim().toUpperCase(Locale.ENGLISH);
            if (type.equals("JAVA")) {
                return StdFileTypes.JAVA;
            }
            if (type.equals("XML")) {
                return StdFileTypes.XML;
            }
            if (type.equals("GROOVY")) {
                return GroovyFileType.GROOVY_FILE_TYPE;
            }
            if (type.equals("PLAIN_TEXT")) {
                return FileTypes.PLAIN_TEXT;
            }
            return null;
        }
    }

    public static final class StepElement
    implements StepElementData {
        private StepElementType myType;
        @XmlElement(name="code", type=Code.class)
        private Code myCode;
        @XmlElement(name="section")
        private String mySection;
        @XmlElement(name="action", type=Action.class)
        private Action myAction;
        @XmlElement(name="image", type=Image.class)
        private Image myImage;

        @Override
        @NotNull
        public StepElementType getType() {
            if (this.myType != null) {
                return this.myType;
            }
            if (this.myAction != null) {
                this.myType = StepElementType.ACTION;
            } else if (this.mySection != null) {
                this.myType = StepElementType.SECTION;
            } else if (this.myCode != null) {
                this.myType = StepElementType.CODE;
            } else if (this.myImage != null) {
                this.myType = StepElementType.IMAGE;
            }
            if (this.myType == null) {
                throw new RuntimeException("Unsupported StepElement.");
            }
            return this.myType;
        }

        @Override
        public String getCode() {
            return this.myCode.getCode();
        }

        @Override
        public FileType getCodeType() {
            return this.myCode == null ? null : this.myCode.getCodeType();
        }

        @Override
        public String getSection() {
            return this.mySection;
        }

        @Override
        public Action getAction() {
            return this.myAction;
        }

        @Override
        @Nullable
        public Image getImage() {
            return this.myImage;
        }

        public String toString() {
            return "StepElement{myType='" + (Object)((Object)this.getType()) + "'" + '}';
        }
    }

    public static final class Step
    implements StepData {
        @XmlElements(value={@XmlElement(name="stepElement", type=StepElement.class)})
        private List<StepElement> myStepElements = Lists.newArrayList();
        @XmlAttribute(name="label")
        private String myLabel;

        @NotNull
        public List<StepElement> getStepElements() {
            return ImmutableList.copyOf(this.myStepElements);
        }

        @Override
        @NotNull
        public String getLabel() {
            return this.myLabel;
        }

        public String toString() {
            return "Step{myLabel='" + this.myLabel + "'" + '}';
        }
    }

    public static class Tutorial
    implements TutorialData {
        @XmlAttribute(name="label")
        private String myLabel;
        @XmlElement(name="description")
        private String myDescription;
        @XmlAttribute(name="remoteLink")
        private String myRemoteLink;
        @XmlAttribute(name="remoteLinkLabel")
        private String myRemoteLinkLabel;
        @XmlAttribute(name="key")
        private String myKey;
        @XmlAttribute(name="icon")
        @Nullable
        private String myIconName;
        protected String myResourceRoot;
        @XmlElements(value={@XmlElement(name="step", type=Step.class)})
        private List<Step> mySteps = Lists.newArrayList();
        private Icon myIcon;
        private Class myResourceClass;

        public void setResourceClass(@NotNull Class clazz) {
            this.myResourceClass = clazz;
        }

        @Override
        @NotNull
        public String getLabel() {
            return this.myLabel;
        }

        @Override
        @Nullable
        public String getDescription() {
            return this.myDescription;
        }

        @Override
        @NotNull
        public String getRemoteLink() {
            return this.myRemoteLink;
        }

        @Override
        @NotNull
        public String getRemoteLinkLabel() {
            return this.myRemoteLinkLabel;
        }

        @Override
        @NotNull
        public String getKey() {
            return this.myKey;
        }

        @Override
        @Nullable
        public Icon getIcon() {
            if (this.myIcon != null) {
                return this.myIcon;
            }
            if (this.myIconName == null || this.myResourceRoot == null) {
                return null;
            }
            this.myIcon = IconLoader.findIcon((String)DefaultTutorialBundle.getIconResourcePath(this.myResourceRoot, this.myIconName), (Class)this.myResourceClass);
            return this.myIcon;
        }

        @NotNull
        public List<Step> getSteps() {
            return ImmutableList.copyOf(this.mySteps);
        }

        public String toString() {
            return "Tutorial{myLabel='" + this.myLabel + '\'' + ", myDescription='" + this.myDescription + '\'' + ", myRemoteLink='" + this.myRemoteLink + '\'' + ", myRemoteLinkLabel='" + this.myRemoteLinkLabel + '\'' + ", myKey='" + this.myKey + '\'' + ", mySteps=" + this.mySteps + '}';
        }
    }

    public static final class Feature
    implements FeatureData {
        @XmlAttribute(name="name")
        @NotNull
        private String myName;
        @XmlAttribute(name="icon")
        @Nullable
        private String myIcon;
        @Nullable
        private Icon myIconInstance;
        @XmlAttribute(name="resourceRoot")
        @NotNull
        private String myResourceRoot;
        @XmlElements(value={@XmlElement(name="resource", type=String.class)})
        private List<String> myResources = Lists.newArrayList();
        @XmlElement(name="description")
        private String myDescription;
        @XmlElements(value={@XmlElement(name="tutorial", type=Tutorial.class)})
        private List<Tutorial> myTutorials = Lists.newArrayList();
        private Class myResourceClass;

        @Override
        public void setResourceClass(@NotNull Class clazz) {
            this.myResourceClass = clazz;
        }

        @Override
        @NotNull
        public String getName() {
            return this.myName;
        }

        @Nullable
        private Icon getIconResource(@NotNull String path) {
            return IconLoader.findIcon((String)path, (Class)this.myResourceClass);
        }

        @Override
        @Nullable
        public Icon getIcon() {
            if (this.myIconInstance != null) {
                return this.myIconInstance;
            }
            if (this.myIcon == null) {
                return null;
            }
            this.myIconInstance = this.getIconResource(DefaultTutorialBundle.getIconResourcePath(this.myResourceRoot, this.myIcon));
            return this.myIconInstance;
        }

        @Override
        @NotNull
        public String getDescription() {
            return this.myDescription;
        }

        @NotNull
        public List<Tutorial> getTutorials() {
            return ImmutableList.copyOf(this.myTutorials);
        }

        public String toString() {
            return "Feature{myName='" + this.myName + "', myResourceRoot='" + this.myResourceRoot + "', myResources=" + this.myResources + '}';
        }
    }
}

