/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.assistant;

import com.android.tools.idea.templates.recipe.Recipe;
import com.google.common.collect.Lists;
import com.intellij.openapi.module.Module;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RecipeMetadata {
    @NotNull
    private final List<String> myDependencies = Lists.newArrayList();
    @NotNull
    private final List<String> myClasspathEntries = Lists.newArrayList();
    @NotNull
    private final List<String> myPlugins = Lists.newArrayList();
    @NotNull
    private final List<String> myPermissions = Lists.newArrayList();
    @NotNull
    private final List<String> myModifiedFiles = Lists.newArrayList();
    @NotNull
    private final Module myModule;
    @NotNull
    private final Recipe myRecipe;

    public RecipeMetadata(@NotNull Recipe recipe, @NotNull Module module) {
        this.myRecipe = recipe;
        this.myModule = module;
    }

    public void addDependency(@NotNull String dependency) {
        this.myDependencies.add(dependency);
    }

    public void addClasspathEntry(@NotNull String classpathEntry) {
        this.myClasspathEntries.add(classpathEntry);
    }

    public void addPlugin(@NotNull String plugin) {
        this.myPlugins.add(plugin);
    }

    public void addPermission(@NotNull String permission) {
        this.myPermissions.add(permission);
    }

    public void addModifiedFile(@NotNull File file) {
        this.myModifiedFiles.add(file.getName());
    }

    @NotNull
    public List<String> getDependencies() {
        return this.myDependencies;
    }

    @NotNull
    public List<String> getClasspathEntries() {
        return this.myClasspathEntries;
    }

    @NotNull
    public List<String> getPlugins() {
        return this.myPlugins;
    }

    @NotNull
    public List<String> getModifiedFiles() {
        return this.myModifiedFiles;
    }

    @NotNull
    public List<String> getPermissions() {
        return this.myPermissions;
    }

    @NotNull
    public Module getModule() {
        return this.myModule;
    }

    @NotNull
    public Recipe getRecipe() {
        return this.myRecipe;
    }
}

