/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.assistant.view;

import com.android.tools.idea.assistant.AssistActionStateManager;
import com.android.tools.idea.assistant.datamodel.ActionData;
import com.android.tools.idea.assistant.datamodel.StepData;
import com.android.tools.idea.assistant.datamodel.StepElementData;
import com.android.tools.idea.assistant.view.StatefulButton;
import com.android.tools.idea.assistant.view.UIUtils;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.EditorMouseAdapter;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.jetbrains.annotations.NotNull;

public class TutorialStep
extends JPanel {
    public final JBColor NUMBER_COLOR = new JBColor(5399451, 5807606);
    private static final int IMAGE_PADDING = 10;
    private final int myIndex;
    private final StepData myStep;
    private final JPanel myContents;
    private final Project myProject;

    private static Logger getLog() {
        return Logger.getInstance(TutorialStep.class);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    TutorialStep(@NotNull StepData step, int index, @NotNull ActionListener listener, @NotNull Project project, boolean hideStepIndex) {
        super(new GridBagLayout());
        this.myIndex = index;
        this.myStep = step;
        this.myProject = project;
        this.myContents = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, true));
        this.setOpaque(false);
        if (!hideStepIndex) {
            this.initStepNumber();
        }
        this.initLabel();
        this.initStepContentsContainer();
        block19: for (StepElementData element : step.getStepElements()) {
            switch (1.$SwitchMap$com$android$tools$idea$assistant$datamodel$StepElementType[element.getType().ordinal()]) {
                case 1: {
                    section = new JEditorPane();
                    section.setOpaque(false);
                    section.setBorder(BorderFactory.createEmptyBorder());
                    section.setDragEnabled(false);
                    UIUtils.setHtml(section, element.getSection(), ".as-shim { margin-top: 1px; }");
                    this.myContents.add(section);
                    break;
                }
                case 2: {
                    if (element.getAction() != null) {
                        action = element.getAction();
                        stateManager = Arrays.stream(AssistActionStateManager.EP_NAME.getExtensions()).filter((Predicate<AssistActionStateManager>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$new$0(com.android.tools.idea.assistant.datamodel.ActionData com.android.tools.idea.assistant.AssistActionStateManager ), (Lcom/android/tools/idea/assistant/AssistActionStateManager;)Z)((ActionData)action)).findFirst();
                        this.myContents.add(new StatefulButton(element.getAction(), listener, stateManager.orElse(null), project));
                        break;
                    }
                    TutorialStep.getLog().warn("Found action element with no action definition: " + element.toString());
                    break;
                }
                case 3: {
                    this.myContents.add((Component)new CodePane(element));
                    break;
                }
                case 4: {
                    imageElement = element.getImage();
                    if (imageElement == null) {
                        TutorialStep.getLog().error("Image element has no image.");
                        continue block19;
                    }
                    try {
                        imageStream = this.getClass().getResourceAsStream(imageElement.getSource());
                        var11_12 = null;
                        if (imageStream != null) ** GOTO lbl58
                        TutorialStep.getLog().error("Cannot load image: " + imageElement.getSource());
                        if (imageStream == null) continue block19;
                        if (var11_12 == null) ** GOTO lbl55
                        try {
                            imageStream.close();
                        }
                        catch (Throwable var12_14) {
                            var11_12.addSuppressed(var12_14);
                        }
                        continue block19;
lbl55:
                        // 1 sources

                        imageStream.close();
                        continue block19;
lbl58:
                        // 2 sources

                        imageIcon = new ImageIcon(ImageIO.read(imageStream));
                        image = imageIcon.getImage();
                        scaledImage = image.getScaledInstance(imageElement.getWidth(), imageElement.getHeight(), 4);
                        imageIcon = new ImageIcon(scaledImage, imageElement.getDescription());
                        containerPanel = new JPanel((LayoutManager)new HorizontalLayout(0));
                        containerPanel.setBackground(UIUtils.getBackgroundColor());
                        containerPanel.setBorder((Border)new JBEmptyBorder(10, 0, 10, 0));
                        containerPanel.add(new JLabel(imageIcon));
                        this.myContents.add(containerPanel);
                        if (imageStream == null) break;
                        if (var11_12 == null) ** GOTO lbl77
                        try {
                            imageStream.close();
                        }
                        catch (Throwable var12_15) {
                            var11_12.addSuppressed(var12_15);
                        }
                        break;
lbl77:
                        // 1 sources

                        imageStream.close();
                        ** break;
                        catch (Throwable var12_16) {
                            try {
                                var11_12 = var12_16;
                                throw var12_16;
                            }
                            catch (Throwable var16_20) {
                                if (imageStream != null) {
                                    if (var11_12 != null) {
                                        try {
                                            imageStream.close();
                                        }
                                        catch (Throwable var17_21) {
                                            var11_12.addSuppressed(var17_21);
                                        }
                                    } else {
                                        imageStream.close();
                                    }
                                }
                                throw var16_20;
lbl94:
                                // 1 sources

                            }
                        }
                    }
                    catch (IOException e) {
                        TutorialStep.getLog().error("Cannot load image: " + imageElement.getSource(), (Throwable)e);
                    }
                    break;
                }
                default: {
                    TutorialStep.getLog().error("Found a StepElement of unknown type. " + element.toString());
                }
            }
            this.myContents.add(Box.createRigidArea(new Dimension(0, 5)));
        }
    }

    private void initLabel() {
        JLabel label = new JLabel(this.myStep.getLabel());
        Font font = label.getFont();
        Font plainFont = new Font(font.getFontName(), 0, 18);
        label.setFont(plainFont);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 18;
        c.insets = JBUI.insets((int)8, (int)10, (int)10, (int)5);
        this.add((Component)label, c);
    }

    private void initStepContentsContainer() {
        this.myContents.setOpaque(false);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 18;
        c.insets = JBUI.insets((int)0, (int)10, (int)0, (int)10);
        this.add((Component)this.myContents, c);
    }

    private void initStepNumber() {
        Font font = new JLabel().getFont();
        JTextPane stepNumber = new JTextPane();
        stepNumber.setEditable(false);
        stepNumber.setText(String.valueOf(this.myIndex + 1));
        Font boldFont = new Font(font.getFontName(), 1, 11);
        stepNumber.setFont(boldFont);
        stepNumber.setOpaque(false);
        stepNumber.setForeground((Color)this.NUMBER_COLOR);
        stepNumber.setBorder(new NumberBorder());
        Dimension size = new Dimension(21, 21);
        stepNumber.setSize(size);
        stepNumber.setPreferredSize(size);
        stepNumber.setMinimumSize(size);
        stepNumber.setMaximumSize(size);
        StyledDocument doc = stepNumber.getStyledDocument();
        SimpleAttributeSet center = new SimpleAttributeSet();
        StyleConstants.setAlignment(center, 1);
        doc.setParagraphAttributes(0, doc.getLength(), center, false);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 10;
        c.insets = JBUI.insets((int)5, (int)5, (int)5, (int)0);
        this.add((Component)stepNumber, c);
    }

    private static /* synthetic */ boolean lambda$new$0(ActionData action2, AssistActionStateManager s) {
        return s.getId().equals(action2.getKey());
    }

    private class CodePane
    extends EditorTextField {
        private static final int PAD = 5;
        private static final int MAX_HEIGHT = 500;
        private int myScrollBarHeight;

        public CodePane(StepElementData element) {
            super(element.getCode() != null ? element.getCode() : "", TutorialStep.this.myProject, (FileType)(element.getCodeType() != null ? element.getCodeType() : StdFileTypes.JAVA));
            this.myScrollBarHeight = 0;
            this.setOneLineMode(false);
            this.setFont(new Font("Monospaced", 0, 11));
            this.ensureWillComputePreferredSize();
            this.getDocument().setReadOnly(true);
            this.getPreferredSize();
            int height = Math.min(500, this.getActualPreferredHeight());
            this.setMinimumSize(new Dimension(1, height));
            this.setPreferredSize(new Dimension(this.getActualPreferredWidth(), height));
        }

        private int getActualPreferredWidth() {
            return (int)this.getPreferredSize().getWidth() + 10;
        }

        private int getActualPreferredHeight() {
            return this.getFontMetrics(this.getFont()).getHeight() * this.getDocument().getLineCount() + 10 + this.myScrollBarHeight;
        }

        protected EditorEx createEditor() {
            final EditorEx editor2 = super.createEditor();
            editor2.setBackgroundColor(UIUtils.getBackgroundColor());
            editor2.addEditorMouseListener((EditorMouseListener)new AutoTextSelectionListener(editor2));
            editor2.getContentComponent().setFocusTraversalKeysEnabled(false);
            editor2.getContentComponent().addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getKeyChar() != '\t') {
                        return;
                    }
                    if (e.getModifiers() == 1) {
                        editor2.getContentComponent().transferFocusBackward();
                        return;
                    }
                    editor2.getContentComponent().transferFocus();
                }
            });
            JScrollPane scroll = editor2.getScrollPane();
            scroll.getViewport().setBackground(UIUtils.getBackgroundColor());
            if (scroll.getViewport().getView() != null) {
                scroll.getViewport().getView().setBackground(UIUtils.getBackgroundColor());
            }
            scroll.addMouseWheelListener(new CodeMouseWheelListener(scroll));
            scroll.setViewportBorder(BorderFactory.createMatteBorder(5, 5, 5, 5, UIUtils.getBackgroundColor()));
            this.myScrollBarHeight = scroll.getHorizontalScrollBar().getPreferredSize().height + 2;
            scroll.setHorizontalScrollBarPolicy(30);
            scroll.setVerticalScrollBarPolicy(20);
            JScrollBar verticalScrollBar = scroll.getVerticalScrollBar();
            JScrollBar horizontalScrollBar = scroll.getHorizontalScrollBar();
            verticalScrollBar.setValue(verticalScrollBar.getMinimum());
            horizontalScrollBar.setValue(horizontalScrollBar.getMinimum());
            return editor2;
        }

        class CodeMouseWheelListener
        implements MouseWheelListener {
            private JScrollBar myScrollBar;
            private int myLastScrollOffset = 0;
            private JScrollPane myParentScrollPane;
            private JScrollPane currentScrollPane;

            public CodeMouseWheelListener(JScrollPane scroll) {
                this.currentScrollPane = scroll;
                this.myScrollBar = this.currentScrollPane.getVerticalScrollBar();
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                int terminalValue;
                JScrollPane parent = this.getParentScrollPane();
                if (parent == null) {
                    this.currentScrollPane.removeMouseWheelListener(this);
                    return;
                }
                int n = terminalValue = e.getWheelRotation() < 0 ? 0 : this.getMax();
                if (this.myScrollBar.getValue() == terminalValue && this.myLastScrollOffset == terminalValue) {
                    parent.dispatchEvent(this.cloneEvent(e));
                }
                this.myLastScrollOffset = this.myScrollBar.getValue();
            }

            private JScrollPane getParentScrollPane() {
                if (this.myParentScrollPane == null) {
                    Container parent;
                    for (parent = CodePane.this.getParent(); !(parent instanceof JScrollPane) && parent != null; parent = parent.getParent()) {
                    }
                    this.myParentScrollPane = (JScrollPane)parent;
                }
                return this.myParentScrollPane;
            }

            private int getMax() {
                return this.myScrollBar.getMaximum() - this.myScrollBar.getVisibleAmount();
            }

            private MouseWheelEvent cloneEvent(MouseWheelEvent e) {
                return new MouseWheelEvent((Component)this.getParentScrollPane(), e.getID(), e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger(), e.getScrollType(), e.getScrollAmount(), e.getWheelRotation());
            }
        }
    }

    class NumberBorder
    extends AbstractBorder {
        private static final int INSET = 3;

        NumberBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int d = height - 1;
            g2.setColor((Color)TutorialStep.this.NUMBER_COLOR);
            g2.drawOval(x, y, d, d);
            g2.dispose();
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return JBUI.insets((int)3);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.bottom = 3;
            insets.top = 3;
            insets.right = 3;
            insets.left = 3;
            return insets;
        }
    }

    private static class AutoTextSelectionListener
    extends EditorMouseAdapter {
        private final EditorEx myEditor;
        private boolean myIsTextSelectedOnMousePressed = false;

        AutoTextSelectionListener(@NotNull EditorEx editor2) {
            this.myEditor = editor2;
        }

        private boolean isNothingSelected() {
            return Strings.isNullOrEmpty((String)this.myEditor.getSelectionModel().getSelectedText(true));
        }

        private boolean isAnythingSelected() {
            return !Strings.isNullOrEmpty((String)this.myEditor.getSelectionModel().getSelectedText(true));
        }

        public void mouseClicked(EditorMouseEvent e) {
            if (!this.myIsTextSelectedOnMousePressed && this.isNothingSelected()) {
                this.selectAllText();
                e.consume();
            }
        }

        public void mousePressed(EditorMouseEvent e) {
            this.myIsTextSelectedOnMousePressed = this.isAnythingSelected();
            if (this.myIsTextSelectedOnMousePressed) {
                this.selectNothing();
            }
        }

        private void selectNothing() {
            LogicalPosition docStart = this.myEditor.visualToLogicalPosition(new VisualPosition(0, 0));
            this.myEditor.getCaretModel().setCaretsAndSelections((List)Lists.newArrayList((Object[])new CaretState[]{new CaretState(docStart, docStart, docStart)}));
        }

        private void selectAllText() {
            int lineCount = this.myEditor.getDocument().getLineCount() - 1;
            if (lineCount < 0) {
                return;
            }
            int lastLineEndOffset = this.myEditor.getDocument().getLineEndOffset(lineCount);
            LogicalPosition docStart = this.myEditor.visualToLogicalPosition(new VisualPosition(0, 0));
            LogicalPosition docEnd = this.myEditor.visualToLogicalPosition(new VisualPosition(lineCount, lastLineEndOffset));
            this.myEditor.getCaretModel().setCaretsAndSelections((List)Lists.newArrayList((Object[])new CaretState[]{new CaretState(docStart, docStart, docEnd)}));
        }
    }
}

