/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.tools.idea.avdmanager.AccelerationErrorSolution;
import com.intellij.openapi.util.SystemInfo;

public enum AccelerationErrorCode {
    ALREADY_INSTALLED(0, "", AccelerationErrorSolution.SolutionCode.NONE, ""),
    NESTED_NOT_SUPPORTED(1, "HAXM doesn't support nested virtual machines.", AccelerationErrorSolution.SolutionCode.NONE, "Unfortunately, the Android Emulator can't support virtual machine acceleration from within a virtual machine.\nHere are some of your options:\n 1) Use a physical device for testing\n 2) Start the emulator on a non-virtualized operating system\n 3) Use an Android Virtual Device based on an ARM system image (This is 10x slower than hardware accelerated virtualization)\n"),
    INTEL_REQUIRED(2, "HAXM requires a Genuine Intel processor.", AccelerationErrorSolution.SolutionCode.NONE, "Unfortunately, your computer does not support hardware accelerated virtualization.\nHere are some of your options:\n 1) Use a physical device for testing\n 2) Develop on a Windows/OSX computer with an Intel processor that supports VT-x and NX\n 3) Develop on a Linux computer that supports VT-x or SVM\n 4) Use an Android Virtual Device based on an ARM system image\n   (This is 10x slower than hardware accelerated virtualization)\n"),
    NO_CPU_SUPPORT(3, "Your CPU does not support required features (VT-x or SVM).", AccelerationErrorSolution.SolutionCode.NONE, "Unfortunately, your computer does not support hardware accelerated virtualization.\nHere are some of your options:\n 1) Use a physical device for testing\n 2) Develop on a Windows/OSX computer with an Intel processor that supports VT-x and NX\n 3) Develop on a Linux computer that supports VT-x or SVM\n 4) Use an Android Virtual Device based on an ARM system image\n   (This is 10x slower than hardware accelerated virtualization)\n"),
    NO_CPU_VTX_SUPPORT(4, "Your CPU does not support VT-x.", AccelerationErrorSolution.SolutionCode.NONE, "Unfortunately, your computer does not support hardware accelerated virtualization.\nHere are some of your options:\n 1) Use a physical device for testing\n 2) Develop on a Windows/OSX computer with an Intel processor that supports VT-x and NX\n 3) Develop on a Linux computer that supports VT-x or SVM\n 4) Use an Android Virtual Device based on an ARM system image\n   (This is 10x slower than hardware accelerated virtualization)\n"),
    NO_CPU_NX_SUPPORT(5, "Your CPU does not support NX.", AccelerationErrorSolution.SolutionCode.NONE, "Unfortunately, your computer does not support hardware accelerated virtualization.\nHere are some of your options:\n 1) Use a physical device for testing\n 2) Develop on a Windows/OSX computer with an Intel processor that supports VT-x and NX\n 3) Develop on a Linux computer that supports VT-x or SVM\n 4) Use an Android Virtual Device based on an ARM system image\n   (This is 10x slower than hardware accelerated virtualization)\n"),
    ACCELERATION_NOT_INSTALLED_LINUX(6, "KVM is not installed.", AccelerationErrorSolution.SolutionCode.INSTALL_KVM, "Enable Linux KVM for better emulation performance."),
    ACCELERATION_NOT_INSTALLED_WIN_MAC(6, "HAXM is not installed.", AccelerationErrorSolution.SolutionCode.INSTALL_HAXM, "Install Intel HAXM for better emulation performance."),
    ACCELERATION_OBSOLETE(7, "Virtual machine acceleration driver is out-of-date.", AccelerationErrorSolution.SolutionCode.REINSTALL_HAXM, "A newer HAXM Version is required. Please update."),
    DEV_NOT_FOUND_LINUX(8, "/dev/kvm is not found.", AccelerationErrorSolution.SolutionCode.NONE, "Enable VT-x in your BIOS security settings, ensure that your Linux distro has working KVM module."),
    DEV_NOT_FOUND_WIN_MAC(8, "HAXM device is not found.", AccelerationErrorSolution.SolutionCode.NONE, "Enable VT-x in your BIOS security settings, ensure that HAXM is installed properly. Try disabling 3rd party security software if the problem still occurs."),
    VT_DISABLED(9, "VT-x is disabled in BIOS.", AccelerationErrorSolution.SolutionCode.NONE, "Enable VT-x in your BIOS security settings (refer to documentation for your computer)."),
    NX_DISABLED(10, "NX is disabled in BIOS.", AccelerationErrorSolution.SolutionCode.NONE, "Enable NX in your BIOS settings (refer to documentation for your computer)."),
    DEV_PERMISSION_LINUX(11, "/dev/kvm device: permission denied.", AccelerationErrorSolution.SolutionCode.NONE, "Grant current user access to /dev/kvm"),
    DEV_PERMISSION_WIN_MAC(11, "HAXM device: permission denied.", AccelerationErrorSolution.SolutionCode.REINSTALL_HAXM, "Reinstall HAXM."),
    DEV_OPEN_FAILED_LINUX(12, "/dev/kvm device: open failed.", AccelerationErrorSolution.SolutionCode.NONE, "Grant current user access to /dev/kvm"),
    DEV_OPEN_FAILED_WIN_MAC(12, "HAXM device: open failed.", AccelerationErrorSolution.SolutionCode.REINSTALL_HAXM, "Reinstall HAXM."),
    DEV_IOCTL_FAILED_LINUX(13, "/dev/kvm device: ioctl denied.", AccelerationErrorSolution.SolutionCode.NONE, "Upgrade your kernel."),
    DEV_IOCTL_FAILED_WIN_MAC(13, "HAXM device: ioctl denied.", AccelerationErrorSolution.SolutionCode.REINSTALL_HAXM, "Reinstall HAXM."),
    DEV_OBSOLETE_LINUX(14, "KVM module is too old.", AccelerationErrorSolution.SolutionCode.NONE, "Upgrade your kernel."),
    DEV_OBSOLETE_WIN_MAC(14, "Virtual machine acceleration driver out-of-date.", AccelerationErrorSolution.SolutionCode.REINSTALL_HAXM, "Reinstall HAXM."),
    HYPER_V_ENABLED(15, "Android Emulator is incompatible with Hyper-V.", AccelerationErrorSolution.SolutionCode.TURNOFF_HYPER_V, "Unfortunately, you cannot have Hyper-V running and use the emulator.\nHere is what you can do:\n  1) Start a command prompt as Administrator\n  2) Run the following command: C:\\Windows\\system32> bcdedit /set hypervisorlaunchtype off\n  3) Reboot your machine.\n"),
    EMULATOR_ERROR(138, "Accelerator Detection Problem.", AccelerationErrorSolution.SolutionCode.NONE, "Please file a bug against Android Studio."),
    UNKNOWN_ERROR(-1, "Unknown Error", AccelerationErrorSolution.SolutionCode.NONE, "Please file a bug against Android Studio."),
    NO_EMULATOR_INSTALLED(-2, "No emulator installed", AccelerationErrorSolution.SolutionCode.DOWNLOAD_EMULATOR, "Please download the emulator"),
    TOOLS_UPDATE_REQUIRED(-3, "Emulator is outdated", AccelerationErrorSolution.SolutionCode.UPDATE_EMULATOR, "Please download the newest tools"),
    NOT_ENOUGH_MEMORY(-4, "Not enough memory to run HAXM", AccelerationErrorSolution.SolutionCode.NONE, "Get more available memory for HAXM"),
    CANNOT_INSTALL_ON_THIS_OS(-5, "HAXM can only be installed on Windows or Mac.", AccelerationErrorSolution.SolutionCode.NONE, "Please file a bug against Android Studio."),
    PLATFORM_TOOLS_UPDATE_ADVISED(-6, "Platform tools update is available", AccelerationErrorSolution.SolutionCode.UPDATE_PLATFORM_TOOLS, "Please download platform tools"),
    SYSTEM_IMAGE_UPDATE_ADVISED(-7, "System image update is available", AccelerationErrorSolution.SolutionCode.UPDATE_SYSTEM_IMAGES, "Please update system images");

    private int myErrorCode;
    private String myProblem;
    private AccelerationErrorSolution.SolutionCode mySolution;
    private String mySolutionMessage;

    private AccelerationErrorCode(int code, String problem, AccelerationErrorSolution.SolutionCode solution, String solutionMessage) {
        this.myErrorCode = code;
        this.myProblem = problem;
        this.mySolution = solution;
        this.mySolutionMessage = solutionMessage;
    }

    public int getErrorCode() {
        return this.myErrorCode;
    }

    public String getProblem() {
        return this.myProblem;
    }

    void setProblem(String problem) {
        this.myProblem = problem;
    }

    public AccelerationErrorSolution.SolutionCode getSolution() {
        return this.mySolution;
    }

    public String getSolutionMessage() {
        return this.mySolutionMessage;
    }

    public static AccelerationErrorCode fromExitCode(int code) {
        switch (code) {
            case 0: {
                return ALREADY_INSTALLED;
            }
            case 1: {
                return NESTED_NOT_SUPPORTED;
            }
            case 2: {
                return INTEL_REQUIRED;
            }
            case 3: {
                return NO_CPU_SUPPORT;
            }
            case 4: {
                return NO_CPU_VTX_SUPPORT;
            }
            case 5: {
                return NO_CPU_NX_SUPPORT;
            }
            case 6: {
                return SystemInfo.isLinux ? ACCELERATION_NOT_INSTALLED_LINUX : ACCELERATION_NOT_INSTALLED_WIN_MAC;
            }
            case 7: {
                return ACCELERATION_OBSOLETE;
            }
            case 8: {
                return SystemInfo.isLinux ? DEV_NOT_FOUND_LINUX : DEV_NOT_FOUND_WIN_MAC;
            }
            case 9: {
                return VT_DISABLED;
            }
            case 10: {
                return NX_DISABLED;
            }
            case 11: {
                return SystemInfo.isLinux ? DEV_PERMISSION_LINUX : DEV_PERMISSION_WIN_MAC;
            }
            case 12: {
                return SystemInfo.isLinux ? DEV_OPEN_FAILED_LINUX : DEV_OPEN_FAILED_WIN_MAC;
            }
            case 13: {
                return SystemInfo.isLinux ? DEV_IOCTL_FAILED_LINUX : DEV_IOCTL_FAILED_WIN_MAC;
            }
            case 14: {
                return SystemInfo.isLinux ? DEV_OBSOLETE_LINUX : DEV_OBSOLETE_WIN_MAC;
            }
            case 15: {
                return HYPER_V_ENABLED;
            }
        }
        return UNKNOWN_ERROR;
    }
}

