/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.repository.Revision;
import com.android.tools.idea.avdmanager.AccelerationErrorCode;
import com.android.tools.idea.avdmanager.AccelerationErrorNotificationPanel;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.avdmanager.ElevatedCommandLine;
import com.android.tools.idea.sdk.wizard.HaxmWizard;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.google.common.collect.ImmutableList;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingAnsiEscapesAwareProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtilRt;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AccelerationErrorSolution {
    private static final Logger LOG = Logger.getInstance(AccelerationErrorNotificationPanel.class);
    private static final Revision KARMIC_KERNEL = Revision.parseRevision((String)"2.6.31");
    private static final String KVM_INSTRUCTIONS = "https://help.ubuntu.com/community/KVM/Installation";
    static final String SOLUTION_NESTED_VIRTUAL_MACHINE = "Unfortunately, the Android Emulator can't support virtual machine acceleration from within a virtual machine.\nHere are some of your options:\n 1) Use a physical device for testing\n 2) Start the emulator on a non-virtualized operating system\n 3) Use an Android Virtual Device based on an ARM system image (This is 10x slower than hardware accelerated virtualization)\n";
    static final String SOLUTION_ACCELERATION_NOT_SUPPORTED = "Unfortunately, your computer does not support hardware accelerated virtualization.\nHere are some of your options:\n 1) Use a physical device for testing\n 2) Develop on a Windows/OSX computer with an Intel processor that supports VT-x and NX\n 3) Develop on a Linux computer that supports VT-x or SVM\n 4) Use an Android Virtual Device based on an ARM system image\n   (This is 10x slower than hardware accelerated virtualization)\n";
    static final String SOLUTION_TURN_OFF_HYPER_V = "Unfortunately, you cannot have Hyper-V running and use the emulator.\nHere is what you can do:\n  1) Start a command prompt as Administrator\n  2) Run the following command: C:\\Windows\\system32> bcdedit /set hypervisorlaunchtype off\n  3) Reboot your machine.\n";
    static final String SOLUTION_REBOOT_AFTER_TURNING_HYPER_V_OFF = "Hyper-V was successfully turned off. However a system restart is required for this to take effect.\n\nDo you want to reboot now?\n";
    private static final AtomicBoolean ourRebootRequestedAsync = new AtomicBoolean(false);
    private final AccelerationErrorCode myError;
    private final Project myProject;
    private final Runnable myRefresh;
    private final Runnable myCancel;
    private boolean myChangesMade;

    public static Runnable getActionForFix(@NotNull AccelerationErrorCode error, @Nullable Project project, @Nullable Runnable refresh2, @Nullable Runnable cancel) {
        return new AccelerationErrorSolution(error, project, refresh2, cancel).getAction();
    }

    private AccelerationErrorSolution(@NotNull AccelerationErrorCode error, @Nullable Project project, @Nullable Runnable refresh2, @Nullable Runnable cancel) {
        assert (error != AccelerationErrorCode.ALREADY_INSTALLED);
        this.myError = error;
        this.myProject = project;
        this.myRefresh = refresh2;
        this.myCancel = cancel;
    }

    private Runnable getAction() {
        switch (this.myError.getSolution()) {
            case DOWNLOAD_EMULATOR: 
            case UPDATE_EMULATOR: {
                return () -> {
                    try {
                        this.showQuickFix((List<String>)ImmutableList.of((Object)"emulator"));
                    }
                    finally {
                        this.reportBack();
                    }
                };
            }
            case UPDATE_PLATFORM_TOOLS: {
                return () -> {
                    try {
                        this.showQuickFix((List<String>)ImmutableList.of((Object)"platform-tools"));
                    }
                    finally {
                        this.reportBack();
                    }
                };
            }
            case UPDATE_SYSTEM_IMAGES: {
                return () -> {
                    try {
                        AvdManagerConnection avdManager = AvdManagerConnection.getDefaultAvdManagerConnection();
                        this.showQuickFix(avdManager.getSystemImageUpdates());
                    }
                    finally {
                        this.reportBack();
                    }
                };
            }
            case INSTALL_KVM: {
                return () -> {
                    try {
                        GeneralCommandLine install = AccelerationErrorSolution.createKvmInstallCommand();
                        if (install == null) {
                            BrowserUtil.browse((String)KVM_INSTRUCTIONS, (Project)this.myProject);
                        } else {
                            String text = String.format("Linux systems vary a great deal; the installation steps we will attempt may not work in your particular scenario.\n\nThe steps are:\n\n  %1$s\n\nIf you prefer, you can skip this step and perform the KVM installation steps on your own.\n\nThere might be more details at: %2$s\n", install.getCommandLineString(), KVM_INSTRUCTIONS);
                            int response = Messages.showDialog((String)text, (String)this.myError.getSolution().getDescription(), (String[])new String[]{"Skip", "Proceed"}, (int)1, (Icon)Messages.getQuestionIcon());
                            if (response == 1) {
                                try {
                                    AccelerationErrorSolution.execute(install);
                                    this.myChangesMade = true;
                                }
                                catch (ExecutionException ex) {
                                    LOG.error((Throwable)ex);
                                    BrowserUtil.browse((String)KVM_INSTRUCTIONS, (Project)this.myProject);
                                    Messages.showWarningDialog((Project)this.myProject, (String)"Automatic KVM installation failed, please retry manually.\n\nFor more details on the automatic installation failure, please consult the IDE log (Help | Show Log)", (String)"Installation Failed");
                                }
                            } else {
                                BrowserUtil.browse((String)KVM_INSTRUCTIONS, (Project)this.myProject);
                            }
                        }
                    }
                    finally {
                        this.reportBack();
                    }
                };
            }
            case INSTALL_HAXM: 
            case REINSTALL_HAXM: {
                return () -> {
                    try {
                        HaxmWizard wizard = new HaxmWizard(false);
                        wizard.init();
                        this.myChangesMade = wizard.showAndGet();
                    }
                    finally {
                        this.reportBack();
                    }
                };
            }
            case TURNOFF_HYPER_V: {
                return () -> {
                    try {
                        ElevatedCommandLine turnHyperVOff = new ElevatedCommandLine(new String[0]).withTempFilePrefix("turn_hypervisor_off");
                        turnHyperVOff.setExePath("bcdedit");
                        turnHyperVOff.addParameters(new String[]{"/set", "hypervisorlaunchtype", "off"});
                        turnHyperVOff.setWorkDirectory(FileUtilRt.getTempDirectory());
                        try {
                            AccelerationErrorSolution.execute(turnHyperVOff);
                            AccelerationErrorSolution.promptAndReboot(SOLUTION_REBOOT_AFTER_TURNING_HYPER_V_OFF);
                        }
                        catch (ExecutionException ex) {
                            LOG.error((Throwable)ex);
                            Messages.showWarningDialog((Project)this.myProject, (String)SOLUTION_TURN_OFF_HYPER_V, (String)"Operation Failed");
                        }
                    }
                    finally {
                        this.reportBack();
                    }
                };
            }
        }
        return () -> {
            try {
                Messages.showWarningDialog((Project)this.myProject, (String)this.myError.getSolutionMessage(), (String)this.myError.getSolution().getDescription());
            }
            finally {
                this.reportBack();
            }
        };
    }

    public static void promptAndReboot(@NotNull String prompt) throws ExecutionException {
        int response = Messages.showOkCancelDialog((Project)null, (String)prompt, (String)"Reboot Now", (Icon)Messages.getQuestionIcon());
        if (response == 0) {
            ElevatedCommandLine reboot = new ElevatedCommandLine(new String[0]);
            reboot.setExePath("shutdown");
            reboot.addParameters(new String[]{"/g", "/t", "10"});
            reboot.setWorkDirectory(FileUtilRt.getTempDirectory());
            AccelerationErrorSolution.execute(reboot);
        }
    }

    public static void promptAndRebootAsync(@NotNull String prompt, @NotNull ModalityState modality) {
        if (ourRebootRequestedAsync.compareAndSet(false, true)) {
            ApplicationManager.getApplication().invokeLater(() -> {
                try {
                    AccelerationErrorSolution.promptAndReboot(prompt);
                }
                catch (ExecutionException e) {
                    LOG.warn("Automatic reboot attempt failed due to an exception", (Throwable)e);
                    Messages.showErrorDialog((String)"Reboot attempt failed. Please reboot manually", (String)"Automatic Reboot");
                }
                ourRebootRequestedAsync.set(false);
            }, modality);
        }
    }

    private static String execute(@NotNull String command, String ... parameters2) throws ExecutionException {
        return AccelerationErrorSolution.execute(AccelerationErrorSolution.generateCommand(command, parameters2));
    }

    private static GeneralCommandLine generateCommand(@NotNull String command, String ... parameters2) {
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setExePath(command);
        commandLine.addParameters(parameters2);
        return commandLine;
    }

    private static String execute(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        CapturingAnsiEscapesAwareProcessHandler process = new CapturingAnsiEscapesAwareProcessHandler(commandLine);
        ProcessOutput output = process.runProcess();
        int exitValue = output.getExitCode();
        if (exitValue == 0) {
            return output.getStdout();
        }
        throw new ExecutionException(String.format("Error running: %1$s", process.getCommandLine()));
    }

    @Nullable
    private static GeneralCommandLine createKvmInstallCommand() {
        try {
            String version2 = AccelerationErrorSolution.execute("uname", "-r");
            Revision revision = AccelerationErrorSolution.toRevision(version2);
            if (revision.compareTo(KARMIC_KERNEL) <= 0) {
                return AccelerationErrorSolution.generateCommand("gksudo", "aptitude -y", "install", "kvm", "libvirt-bin", "ubuntu-vm-builder", "bridge-utils");
            }
            return AccelerationErrorSolution.generateCommand("gksudo", "apt-get --assume-yes", "install", "qemu-kvm", "libvirt-bin", "ubuntu-vm-builder", "bridge-utils");
        }
        catch (ExecutionException | NumberFormatException ex) {
            LOG.error(ex);
            return null;
        }
    }

    private static Revision toRevision(@NotNull String version2) {
        int index = version2.indexOf(45);
        if (index > 0) {
            version2 = version2.substring(0, index);
        }
        return Revision.parseRevision((String)version2);
    }

    private void showQuickFix(@NotNull List<String> requested) {
        ModelWizardDialog sdkQuickfixWizard = SdkQuickfixUtils.createDialogForPaths(this.myProject, requested);
        if (sdkQuickfixWizard != null) {
            sdkQuickfixWizard.show();
            if (sdkQuickfixWizard.getExitCode() == 0) {
                this.myChangesMade = true;
            }
        }
    }

    private void reportBack() {
        Runnable reporter;
        Runnable runnable = reporter = this.myChangesMade ? this.myRefresh : this.myCancel;
        if (reporter != null) {
            ApplicationManager.getApplication().invokeLater(reporter);
        }
    }

    public static enum SolutionCode {
        NONE("Troubleshoot"),
        DOWNLOAD_EMULATOR("Install Emulator"),
        UPDATE_EMULATOR("Update Emulator"),
        UPDATE_PLATFORM_TOOLS("Update Platform Tools"),
        UPDATE_SYSTEM_IMAGES("Update System Images"),
        INSTALL_KVM("Install KVM"),
        INSTALL_HAXM("Install Haxm"),
        REINSTALL_HAXM("Reinstall Haxm"),
        TURNOFF_HYPER_V("Turn off Hyper-V");

        private final String myDescription;

        public String getDescription() {
            return this.myDescription;
        }

        private SolutionCode(String shortDescription) {
            this.myDescription = shortDescription;
        }
    }
}

