/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.repository.io.FileUtilKt;
import com.android.resources.Density;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.targets.SystemImage;
import com.android.tools.adtui.common.ColoredIconGenerator;
import com.android.tools.idea.avdmanager.AccelerationErrorCode;
import com.android.tools.idea.avdmanager.AccelerationErrorNotificationPanel;
import com.android.tools.idea.avdmanager.ApiLevelComparator;
import com.android.tools.idea.avdmanager.AvdActionPanel;
import com.android.tools.idea.avdmanager.AvdListDialog;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.avdmanager.AvdUiAction;
import com.android.tools.idea.avdmanager.CreateAvdAction;
import com.android.tools.idea.avdmanager.DeleteAvdAction;
import com.android.tools.idea.avdmanager.DeviceManagerConnection;
import com.android.tools.idea.avdmanager.EditAvdAction;
import com.android.tools.idea.avdmanager.EmptyAvdListPanel;
import com.android.tools.idea.avdmanager.RunAvdAction;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AvdDisplayList
extends JPanel
implements ListSelectionListener,
AvdActionPanel.AvdRefreshProvider,
AvdUiAction.AvdInfoProvider {
    public static final String NONEMPTY = "nonempty";
    public static final String EMPTY = "empty";
    private static final String MOBILE_TAG_STRING = "mobile-device";
    @Nullable
    private final Project myProject;
    private final JPanel myCenterCardPanel;
    private final JPanel myNotificationPanel;
    private final AvdListDialog myDialog;
    private TableView<AvdInfo> myTable;
    private ListTableModel<AvdInfo> myModel = new ListTableModel(new ColumnInfo[0]);
    private Set<AvdSelectionListener> myListeners = Sets.newHashSet();
    private final AvdActionsColumnInfo myActionsColumnRenderer = new AvdActionsColumnInfo("Actions", 2);
    private static final HashMap<String, HighlightableIconPair> myDeviceClassIcons = new HashMap(8);
    private final MouseAdapter myEditingListener = new MouseAdapter(){

        @Override
        public void mouseMoved(MouseEvent e) {
            AvdDisplayList.this.possiblySwitchEditors(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            AvdDisplayList.this.possiblySwitchEditors(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            AvdDisplayList.this.possiblySwitchEditors(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            AvdDisplayList.this.possiblySwitchEditors(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            AvdDisplayList.this.possiblyShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            AvdDisplayList.this.possiblyShowPopup(e);
        }
    };
    private final ColumnInfo[] myColumnInfos = new ColumnInfo[]{new AvdIconColumnInfo("Type"){

        @NotNull
        public HighlightableIconPair valueOf(AvdInfo avdInfo) {
            return AvdDisplayList.getDeviceClassIconPair(avdInfo);
        }
    }, new AvdColumnInfo("Name"){

        @Nullable
        public String valueOf(AvdInfo info) {
            return AvdManagerConnection.getAvdDisplayName(info);
        }
    }, new AvdIconColumnInfo("Play Store", JBUI.scale((int)75)){
        private final HighlightableIconPair emptyIconPair;
        private final HighlightableIconPair playStoreIconPair;
        {
            this.emptyIconPair = new HighlightableIconPair(null);
            this.playStoreIconPair = new HighlightableIconPair(StudioIcons.Avd.DEVICE_PLAY_STORE);
        }

        @NotNull
        public HighlightableIconPair valueOf(AvdInfo avdInfo) {
            return avdInfo.hasPlayStore() ? this.playStoreIconPair : this.emptyIconPair;
        }

        @NotNull
        public Comparator<AvdInfo> getComparator() {
            return (avd1, avd2) -> Boolean.compare(avd2.hasPlayStore(), avd1.hasPlayStore());
        }
    }, new AvdColumnInfo("Resolution"){

        @Nullable
        public String valueOf(AvdInfo avdInfo) {
            return AvdDisplayList.getResolution(avdInfo);
        }

        @Override
        @NotNull
        public Comparator<AvdInfo> getComparator() {
            return new Comparator<AvdInfo>(){

                @Override
                public int compare(AvdInfo o1, AvdInfo o2) {
                    Dimension d2;
                    Dimension d1 = AvdDisplayList.getScreenSize(o1);
                    if (d1 == (d2 = AvdDisplayList.getScreenSize(o2))) {
                        return 0;
                    }
                    if (d1 == null) {
                        return -1;
                    }
                    if (d2 == null) {
                        return 1;
                    }
                    return d1.width * d1.height - d2.width * d2.height;
                }
            };
        }
    }, new AvdColumnInfo("API", JBUI.scale((int)50)){

        @NotNull
        public String valueOf(AvdInfo avdInfo) {
            return avdInfo.getAndroidVersion().getApiString();
        }

        @Override
        @NotNull
        public Comparator<AvdInfo> getComparator() {
            final ApiLevelComparator comparator2 = new ApiLevelComparator();
            return new Comparator<AvdInfo>(){

                @Override
                public int compare(AvdInfo o1, AvdInfo o2) {
                    return comparator2.compare(this.valueOf(o1), this.valueOf(o2));
                }
            };
        }
    }, new AvdColumnInfo("Target"){

        @NotNull
        public String valueOf(AvdInfo info) {
            return AvdDisplayList.targetString(info.getAndroidVersion(), info.getTag());
        }
    }, new AvdColumnInfo("CPU/ABI"){

        @NotNull
        public String valueOf(AvdInfo avdInfo) {
            return avdInfo.getCpuArch();
        }
    }, new AvdSizeColumnInfo("Size on Disk"), this.myActionsColumnRenderer};

    @NotNull
    public static String storageSizeDisplayString(@NotNull Storage size) {
        String unitString = "MB";
        double value2 = size.getPreciseSizeAsUnit(Storage.Unit.MiB);
        if (value2 >= 1024.0) {
            unitString = "GB";
            value2 = size.getPreciseSizeAsUnit(Storage.Unit.GiB);
        }
        if (value2 > 9.94) {
            return String.format(Locale.getDefault(), "%1$.0f %2$s", value2, unitString);
        }
        return String.format(Locale.getDefault(), "%1$.1f %2$s", value2, unitString);
    }

    public AvdDisplayList(@NotNull AvdListDialog dialog2, @Nullable Project project) {
        this.myDialog = dialog2;
        this.myProject = project;
        this.myModel.setColumnInfos(this.myColumnInfos);
        this.myModel.setSortable(true);
        this.myTable = new TableView();
        this.myTable.setModelAndUpdateColumns(this.myModel);
        this.myTable.setDefaultRenderer(Object.class, (TableCellRenderer)new MyRenderer(this.myTable.getDefaultRenderer(Object.class)));
        this.setLayout(new BorderLayout());
        this.myCenterCardPanel = new JPanel(new CardLayout());
        this.myNotificationPanel = new JPanel();
        this.myNotificationPanel.setLayout(new BoxLayout(this.myNotificationPanel, 1));
        JPanel nonemptyPanel = new JPanel(new BorderLayout());
        this.myCenterCardPanel.add((Component)nonemptyPanel, NONEMPTY);
        nonemptyPanel.add((Component)ScrollPaneFactory.createScrollPane(this.myTable), "Center");
        nonemptyPanel.add((Component)this.myNotificationPanel, "North");
        this.myCenterCardPanel.add((Component)new EmptyAvdListPanel(this), EMPTY);
        this.add((Component)this.myCenterCardPanel, "Center");
        JPanel southPanel = new JPanel(new BorderLayout());
        JButton helpButton = new JButton(AllIcons.Actions.Help);
        helpButton.putClientProperty("JButton.buttonType", "segmented-only");
        helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserUtil.browse((String)"http://developer.android.com/r/studio-ui/virtualdeviceconfig.html");
            }
        });
        JButton refreshButton = new JButton(AllIcons.Actions.Refresh);
        refreshButton.putClientProperty("JButton.buttonType", "segmented-only");
        refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AvdDisplayList.this.refreshAvds();
            }
        });
        JButton newButton = new JButton(new CreateAvdAction(this));
        newButton.putClientProperty("JButton.buttonType", "segmented-only");
        JPanel southEastPanel = new JPanel(new FlowLayout());
        JPanel southWestPanel = new JPanel(new FlowLayout());
        southEastPanel.add(refreshButton);
        if (UIUtil.isUnderAquaBasedLookAndFeel()) {
            southWestPanel.add(helpButton);
        } else {
            southEastPanel.add(helpButton);
        }
        southWestPanel.add(newButton);
        southPanel.add((Component)southEastPanel, "East");
        southPanel.add((Component)southWestPanel, "West");
        nonemptyPanel.add((Component)southPanel, "South");
        this.myTable.getSelectionModel().setSelectionMode(0);
        this.myTable.getSelectionModel().addListSelectionListener(this);
        this.myTable.addMouseListener((MouseListener)this.myEditingListener);
        this.myTable.addMouseMotionListener((MouseMotionListener)this.myEditingListener);
        LaunchListener launchListener = new LaunchListener();
        this.myTable.addMouseListener((MouseListener)launchListener);
        ActionMap am = this.myTable.getActionMap();
        am.put("selectPreviousColumnCell", new CycleAction(true));
        am.put("selectNextColumnCell", new CycleAction(false));
        am.put("deleteAvd", new DeleteAvdAction(this));
        this.myTable.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "enter");
        this.myTable.getInputMap(1).put(KeyStroke.getKeyStroke(32, 0), "enter");
        this.myTable.getInputMap(1).put(KeyStroke.getKeyStroke(127, 0), "deleteAvd");
        this.myTable.getInputMap(1).put(KeyStroke.getKeyStroke(8, 0), "deleteAvd");
        am.put("enter", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AvdDisplayList.this.doAction();
            }
        });
        this.refreshAvds();
    }

    public void addSelectionListener(AvdSelectionListener listener2) {
        this.myListeners.add(listener2);
    }

    public void removeSelectionListener(AvdSelectionListener listener2) {
        this.myListeners.remove(listener2);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.myTable.editCellAt(this.myTable.getSelectedRow(), this.myTable.getSelectedColumn());
        AvdInfo selected = (AvdInfo)this.myTable.getSelectedObject();
        for (AvdSelectionListener listener2 : this.myListeners) {
            listener2.onAvdSelected(selected);
        }
    }

    @Override
    @Nullable
    public AvdInfo getAvdInfo() {
        return (AvdInfo)this.myTable.getSelectedObject();
    }

    @Override
    public void refreshAvds() {
        List<AvdInfo> avds = AvdManagerConnection.getDefaultAvdManagerConnection().getAvds(true);
        this.myModel.setItems(avds);
        if (avds.isEmpty()) {
            ((CardLayout)this.myCenterCardPanel.getLayout()).show(this.myCenterCardPanel, EMPTY);
        } else {
            ((CardLayout)this.myCenterCardPanel.getLayout()).show(this.myCenterCardPanel, NONEMPTY);
        }
        this.refreshErrorCheck();
    }

    @Override
    public void refreshAvdsAndSelect(@Nullable AvdInfo avdToSelect) {
        this.refreshAvds();
        if (avdToSelect != null) {
            for (AvdInfo listItem : this.myTable.getItems()) {
                if (!listItem.getName().equals(avdToSelect.getName())) continue;
                ArrayList<AvdInfo> selectedAvds = new ArrayList<AvdInfo>();
                selectedAvds.add(listItem);
                this.myTable.setSelection(selectedAvds);
                break;
            }
        }
    }

    @Override
    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return this;
    }

    private void possiblySwitchEditors(MouseEvent e) {
        Point p = e.getPoint();
        int row = this.myTable.rowAtPoint(p);
        int col = this.myTable.columnAtPoint(p);
        if ((row != this.myTable.getEditingRow() || col != this.myTable.getEditingColumn()) && row != -1 && col != -1 && this.myTable.isCellEditable(row, col)) {
            this.myTable.editCellAt(row, col);
        }
    }

    private void possiblyShowPopup(MouseEvent e) {
        int lastColumn;
        Component maybeActionPanel;
        if (!e.isPopupTrigger()) {
            return;
        }
        Point p = e.getPoint();
        int row = this.myTable.rowAtPoint(p);
        int col = this.myTable.columnAtPoint(p);
        if (row != -1 && col != -1 && (maybeActionPanel = this.myTable.getCellRenderer(row, lastColumn = this.myTable.getColumnCount() - 1).getTableCellRendererComponent((JTable)this.myTable, this.myTable.getValueAt(row, lastColumn), false, true, row, lastColumn)) instanceof AvdActionPanel) {
            ((AvdActionPanel)maybeActionPanel).showPopup((Component)this.myTable, e);
        }
    }

    static Dimension getScreenSize(@NotNull AvdInfo info) {
        DeviceManagerConnection deviceManager = DeviceManagerConnection.getDefaultDeviceManagerConnection();
        Device device = deviceManager.getDevice(info.getDeviceName(), info.getDeviceManufacturer());
        if (device == null) {
            return null;
        }
        return device.getScreenSize(device.getDefaultState().getOrientation());
    }

    static String getResolution(@NotNull AvdInfo info) {
        DeviceManagerConnection deviceManager = DeviceManagerConnection.getDefaultDeviceManagerConnection();
        Device device = deviceManager.getDevice(info.getDeviceName(), info.getDeviceManufacturer());
        Dimension res = null;
        Density density = null;
        if (device != null) {
            res = device.getScreenSize(device.getDefaultState().getOrientation());
            density = device.getDefaultHardware().getScreen().getPixelDensity();
        }
        String densityString = density == null ? "Unknown Density" : density.getResourceValue();
        String resolution = res != null ? String.format(Locale.getDefault(), "%1$d \u00d7 %2$d: %3$s", res.width, res.height, densityString) : "Unknown Resolution";
        return resolution;
    }

    static HighlightableIconPair getDeviceClassIconPair(@NotNull AvdInfo info) {
        HighlightableIconPair thisClassPair;
        String id = info.getTag().getId();
        if (id.contains("android-")) {
            String path = String.format("/studio/icons/avd/device-%s-large.svg", id.substring("android-".length()));
            thisClassPair = myDeviceClassIcons.get(path);
            if (thisClassPair == null) {
                thisClassPair = new HighlightableIconPair(IconLoader.getIcon((String)path, AvdDisplayList.class));
                myDeviceClassIcons.put(path, thisClassPair);
            }
        } else {
            thisClassPair = myDeviceClassIcons.get(MOBILE_TAG_STRING);
            if (thisClassPair == null) {
                thisClassPair = new HighlightableIconPair(StudioIcons.Avd.DEVICE_MOBILE_LARGE);
                myDeviceClassIcons.put(MOBILE_TAG_STRING, thisClassPair);
            }
        }
        return thisClassPair;
    }

    static String targetString(@NotNull AndroidVersion version2, @NotNull IdDisplay tag) {
        StringBuilder resultBuilder = new StringBuilder(32);
        resultBuilder.append("Android ");
        resultBuilder.append(SdkVersionInfo.getVersionStringSanitized((int)version2.getFeatureLevel()));
        if (!tag.equals((Object)SystemImage.DEFAULT_TAG)) {
            resultBuilder.append(" (").append(tag.getDisplay()).append(")");
        }
        return resultBuilder.toString();
    }

    private void refreshErrorCheck() {
        boolean refreshUI = this.myNotificationPanel.getComponentCount() > 0;
        this.myNotificationPanel.removeAll();
        AccelerationErrorCode error = AvdManagerConnection.getDefaultAvdManagerConnection().checkAcceleration();
        if (error != AccelerationErrorCode.ALREADY_INSTALLED) {
            refreshUI = true;
            this.myNotificationPanel.add((Component)((Object)new AccelerationErrorNotificationPanel(error, this.myProject, new Runnable(){

                @Override
                public void run() {
                    AvdDisplayList.this.refreshErrorCheck();
                }
            })));
        }
        if (refreshUI) {
            this.myNotificationPanel.revalidate();
            this.myNotificationPanel.repaint();
        }
    }

    private void doAction() {
        AvdInfo info = this.getAvdInfo();
        if (info != null) {
            if (info.getStatus() == AvdInfo.AvdStatus.OK) {
                new RunAvdAction(this).actionPerformed(null);
            } else {
                new EditAvdAction(this).actionPerformed(null);
            }
        }
    }

    private static class MyRenderer
    implements TableCellRenderer {
        private static final Border myBorder = JBUI.Borders.empty((int)10);
        TableCellRenderer myDefaultRenderer;

        MyRenderer(TableCellRenderer defaultRenderer) {
            this.myDefaultRenderer = defaultRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table2, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
            JComponent result2 = (JComponent)this.myDefaultRenderer.getTableCellRendererComponent(table2, value2, isSelected, hasFocus, row, column);
            result2.setBorder(myBorder);
            return result2;
        }
    }

    private class CycleAction
    extends AbstractAction {
        boolean myBackward;

        CycleAction(boolean backward) {
            this.myBackward = backward;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            int selectedRow = AvdDisplayList.this.myTable.getSelectedRow();
            int selectedColumn = AvdDisplayList.this.myTable.getSelectedColumn();
            int actionsColumn = AvdDisplayList.this.myModel.findColumn(AvdDisplayList.this.myActionsColumnRenderer.getName());
            if (this.myBackward) {
                this.cycleBackward(selectedRow, selectedColumn, actionsColumn);
            } else {
                this.cycleForward(selectedRow, selectedColumn, actionsColumn);
            }
            selectedRow = AvdDisplayList.this.myTable.getSelectedRow();
            if (selectedRow != -1) {
                AvdDisplayList.this.myTable.editCellAt(selectedRow, AvdDisplayList.this.myTable.getSelectedColumn());
            }
            AvdDisplayList.this.repaint();
        }

        private void cycleForward(int selectedRow, int selectedColumn, int actionsColumn) {
            if (selectedColumn == actionsColumn && selectedRow == AvdDisplayList.this.myTable.getRowCount() - 1) {
                if (!AvdDisplayList.this.myActionsColumnRenderer.cycleFocus((AvdInfo)AvdDisplayList.this.myTable.getSelectedObject(), false)) {
                    TableCellEditor cellEditor = AvdDisplayList.this.myActionsColumnRenderer.getEditor(AvdDisplayList.this.getAvdInfo());
                    if (cellEditor != null) {
                        cellEditor.stopCellEditing();
                    }
                    AvdDisplayList.this.myTable.removeRowSelectionInterval(selectedRow, selectedRow);
                    KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                    manager.focusNextComponent((Component)AvdDisplayList.this.myTable);
                }
            } else if (selectedColumn != actionsColumn && selectedRow != -1) {
                AvdDisplayList.this.myTable.setColumnSelectionInterval(actionsColumn, actionsColumn);
                AvdDisplayList.this.myActionsColumnRenderer.cycleFocus((AvdInfo)AvdDisplayList.this.myTable.getSelectedObject(), false);
            } else if (selectedRow == -1 || !AvdDisplayList.this.myActionsColumnRenderer.cycleFocus((AvdInfo)AvdDisplayList.this.myTable.getSelectedObject(), false)) {
                AvdDisplayList.this.myTable.setColumnSelectionInterval(0, 0);
                AvdDisplayList.this.myTable.setRowSelectionInterval(selectedRow + 1, selectedRow + 1);
            }
        }

        private void cycleBackward(int selectedRow, int selectedColumn, int actionsColumn) {
            if (selectedColumn == 0 && selectedRow == 0) {
                AvdDisplayList.this.myTable.removeRowSelectionInterval(selectedRow, selectedRow);
                KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                manager.focusPreviousComponent();
            } else if (selectedColumn == actionsColumn && selectedRow != -1 && !AvdDisplayList.this.myActionsColumnRenderer.cycleFocus((AvdInfo)AvdDisplayList.this.myTable.getSelectedObject(), true)) {
                AvdDisplayList.this.myTable.setColumnSelectionInterval(0, 0);
            } else if (selectedRow == -1 || selectedColumn != actionsColumn) {
                if (selectedRow == -1) {
                    selectedRow = AvdDisplayList.this.myTable.getRowCount();
                }
                AvdDisplayList.this.myTable.setRowSelectionInterval(selectedRow - 1, selectedRow - 1);
                AvdDisplayList.this.myTable.setColumnSelectionInterval(actionsColumn, actionsColumn);
                AvdDisplayList.this.myActionsColumnRenderer.cycleFocus((AvdInfo)AvdDisplayList.this.myTable.getSelectedObject(), true);
            }
        }
    }

    private class LaunchListener
    extends MouseAdapter {
        private LaunchListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                AvdDisplayList.this.doAction();
            }
        }
    }

    private class AvdSizeColumnInfo
    extends AvdColumnInfo {
        public AvdSizeColumnInfo(String name) {
            super(name);
        }

        @NotNull
        private Storage getSize(AvdInfo avdInfo) {
            long sizeInBytes = 0L;
            if (avdInfo != null) {
                File avdDir = new File(avdInfo.getDataFolderPath());
                try {
                    sizeInBytes = FileUtilKt.recursiveSize((Path)avdDir.toPath());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return new Storage(sizeInBytes);
        }

        @Nullable
        public String valueOf(AvdInfo avdInfo) {
            Storage size = this.getSize(avdInfo);
            return AvdDisplayList.storageSizeDisplayString(size);
        }

        @Override
        @Nullable
        public Comparator<AvdInfo> getComparator() {
            return new Comparator<AvdInfo>(){

                @Override
                public int compare(AvdInfo o1, AvdInfo o2) {
                    Storage s1 = AvdSizeColumnInfo.this.getSize(o1);
                    Storage s2 = AvdSizeColumnInfo.this.getSize(o2);
                    return Comparing.compare((long)s1.getSize(), (long)s2.getSize());
                }
            };
        }
    }

    private class AvdActionsColumnInfo
    extends ColumnInfo<AvdInfo, AvdInfo> {
        private int myWidth;
        private int myNumVisibleActions;
        private final Map<AvdInfo, ActionRenderer> ourActionPanelRendererEditor;

        public AvdActionsColumnInfo(String name, int numVisibleActions) {
            super(name);
            this.ourActionPanelRendererEditor = Maps.newHashMap();
            this.myNumVisibleActions = numVisibleActions;
            this.myWidth = numVisibleActions == -1 ? -1 : JBUI.scale((int)45) * numVisibleActions + JBUI.scale((int)75);
        }

        public AvdActionsColumnInfo(String name) {
            this(name, -1);
        }

        @Nullable
        public AvdInfo valueOf(AvdInfo avdInfo) {
            return avdInfo;
        }

        @Nullable
        public Comparator<AvdInfo> getComparator() {
            return new Comparator<AvdInfo>(){

                @Override
                public int compare(AvdInfo o1, AvdInfo o2) {
                    return o1.getStatus().compareTo((Enum)o2.getStatus());
                }
            };
        }

        @Nullable
        public TableCellRenderer getRenderer(AvdInfo avdInfo) {
            return this.getComponent(avdInfo);
        }

        public ActionRenderer getComponent(AvdInfo avdInfo) {
            ActionRenderer renderer = this.ourActionPanelRendererEditor.get(avdInfo);
            if (renderer == null) {
                renderer = new ActionRenderer(this.myNumVisibleActions, avdInfo);
                this.ourActionPanelRendererEditor.put(avdInfo, renderer);
            }
            return renderer;
        }

        @Nullable
        public TableCellEditor getEditor(AvdInfo avdInfo) {
            return this.getComponent(avdInfo);
        }

        public boolean isCellEditable(AvdInfo avdInfo) {
            return true;
        }

        public int getWidth(JTable table2) {
            return this.myWidth;
        }

        public boolean cycleFocus(AvdInfo info, boolean backward) {
            return this.getComponent(info).cycleFocus(backward);
        }
    }

    private class ActionRenderer
    extends AbstractTableCellEditor
    implements TableCellRenderer {
        AvdActionPanel myComponent;
        private int myNumVisibleActions = -1;

        ActionRenderer(int numVisibleActions, AvdInfo info) {
            this.myNumVisibleActions = numVisibleActions;
            this.myComponent = new AvdActionPanel(info, this.myNumVisibleActions, AvdDisplayList.this);
        }

        private Component getComponent(JTable table2, int row, int column) {
            if (table2.getSelectedRow() == row) {
                this.myComponent.setBackground(table2.getSelectionBackground());
                this.myComponent.setForeground(table2.getSelectionForeground());
                this.myComponent.setHighlighted(true);
            } else {
                this.myComponent.setBackground(table2.getBackground());
                this.myComponent.setForeground(table2.getForeground());
                this.myComponent.setHighlighted(false);
            }
            this.myComponent.setFocused(table2.getSelectedRow() == row && table2.getSelectedColumn() == column);
            return this.myComponent;
        }

        public boolean cycleFocus(boolean backward) {
            return this.myComponent.cycleFocus(backward);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table2, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
            return this.getComponent(table2, row, column);
        }

        public Component getTableCellEditorComponent(JTable table2, Object value2, boolean isSelected, int row, int column) {
            return this.getComponent(table2, row, column);
        }

        public Object getCellEditorValue() {
            return null;
        }
    }

    public static abstract class AvdColumnInfo
    extends ColumnInfo<AvdInfo, String> {
        private final int myWidth;

        public AvdColumnInfo(@NotNull String name, int width) {
            super(name);
            this.myWidth = width;
        }

        public AvdColumnInfo(@NotNull String name) {
            this(name, -1);
        }

        @Nullable
        public Comparator<AvdInfo> getComparator() {
            return new Comparator<AvdInfo>(){

                @Override
                public int compare(AvdInfo o1, AvdInfo o2) {
                    String s1 = (String)this.valueOf(o1);
                    String s2 = (String)this.valueOf(o2);
                    return Comparing.compare((Comparable)((Object)s1), (Comparable)((Object)s2));
                }
            };
        }

        public int getWidth(JTable table2) {
            return this.myWidth;
        }
    }

    private static abstract class AvdIconColumnInfo
    extends ColumnInfo<AvdInfo, HighlightableIconPair> {
        private final int myWidth;
        private static final TableCellRenderer ourIconRenderer = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table2, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
                HighlightableIconPair iconPair = (HighlightableIconPair)value2;
                JBLabel label = new JBLabel(iconPair.getBaseIcon());
                if (value2 == StudioIcons.Avd.DEVICE_PLAY_STORE) {
                    AccessibleContextUtil.setName((Component)label, (String)"Play Store");
                }
                if (table2.getSelectedRow() == row) {
                    Icon highlightedIcon;
                    label.setBackground(table2.getSelectionBackground());
                    label.setForeground(table2.getSelectionForeground());
                    label.setOpaque(true);
                    Icon theIcon = label.getIcon();
                    if (theIcon != null && (highlightedIcon = iconPair.getHighlightedIcon()) != null) {
                        label.setIcon(highlightedIcon);
                    }
                }
                return label;
            }
        };

        public AvdIconColumnInfo(@NotNull String name, int width) {
            super(name);
            this.myWidth = width;
        }

        public AvdIconColumnInfo(@NotNull String name) {
            this(name, JBUI.scale((int)50));
        }

        @Nullable
        public TableCellRenderer getRenderer(AvdInfo o) {
            return ourIconRenderer;
        }

        public int getWidth(JTable table2) {
            return this.myWidth;
        }
    }

    static class HighlightableIconPair {
        private Icon baseIcon;
        private Icon highlightedIcon;

        public HighlightableIconPair(@Nullable Icon theBaseIcon) {
            this.baseIcon = theBaseIcon;
            if (theBaseIcon != null) {
                this.highlightedIcon = ColoredIconGenerator.INSTANCE.generateWhiteIcon(theBaseIcon);
            }
        }

        @Nullable
        public Icon getBaseIcon() {
            return this.baseIcon;
        }

        @Nullable
        public Icon getHighlightedIcon() {
            return this.highlightedIcon;
        }
    }

    public static interface AvdSelectionListener {
        public void onAvdSelected(@Nullable AvdInfo var1);
    }
}

