/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.SdkConstants;
import com.android.ddmlib.IDevice;
import com.android.prefs.AndroidLocation;
import com.android.repository.Revision;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.android.resources.ScreenOrientation;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.devices.Abi;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.targets.SystemImage;
import com.android.tools.idea.avdmanager.AccelerationErrorCode;
import com.android.tools.idea.avdmanager.AccelerationErrorSolution;
import com.android.tools.idea.avdmanager.AvdWizardUtils;
import com.android.tools.idea.avdmanager.EmulatorAdvFeatures;
import com.android.tools.idea.avdmanager.EmulatorConnectionListener;
import com.android.tools.idea.avdmanager.EmulatorRunner;
import com.android.tools.idea.avdmanager.SystemImageDescription;
import com.android.tools.idea.log.LogWrapper;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.utils.ILogger;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingAnsiEscapesAwareProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.HttpConfigurable;
import java.awt.Dimension;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AvdManagerConnection {
    private static final Logger IJ_LOG = Logger.getInstance(AvdManagerConnection.class);
    private static final ILogger SDK_LOG = new LogWrapper(IJ_LOG);
    private static final ProgressIndicator REPO_LOG = new StudioLoggerProgressIndicator(AvdManagerConnection.class);
    private static final AvdManagerConnection NULL_CONNECTION = new AvdManagerConnection(null);
    private static final int MNC_API_LEVEL_23 = 23;
    private static final int LMP_MR1_API_LEVEL_22 = 22;
    public static final String AVD_INI_HW_LCD_DENSITY = "hw.lcd.density";
    public static final Revision TOOLS_REVISION_WITH_FIRST_QEMU2 = Revision.parseRevision((String)"25.0.0 rc1");
    public static final Revision TOOLS_REVISION_25_0_2_RC3 = Revision.parseRevision((String)"25.0.2 rc3");
    public static final Revision PLATFORM_TOOLS_REVISION_WITH_FIRST_QEMU2 = Revision.parseRevision((String)"23.1.0");
    protected static Revision EMULATOR_REVISION_SUPPORTS_STUDIO_PARAMS = Revision.parseRevision((String)"26.1.0");
    private static final SystemImageUpdateDependency[] SYSTEM_IMAGE_DEPENCENCY_WITH_FIRST_QEMU2 = new SystemImageUpdateDependency[]{new SystemImageUpdateDependency(22, SystemImage.DEFAULT_TAG, 2), new SystemImageUpdateDependency(22, SystemImage.GOOGLE_APIS_TAG, 2), new SystemImageUpdateDependency(23, SystemImage.DEFAULT_TAG, 6), new SystemImageUpdateDependency(23, SystemImage.GOOGLE_APIS_TAG, 10)};
    private static final SystemImageUpdateDependency[] SYSTEM_IMAGE_DEPENCENCY_WITH_25_0_2_RC3 = new SystemImageUpdateDependency[]{new SystemImageUpdateDependency(22, SystemImage.DEFAULT_TAG, 4), new SystemImageUpdateDependency(22, SystemImage.GOOGLE_APIS_TAG, 4), new SystemImageUpdateDependency(23, SystemImage.DEFAULT_TAG, 8), new SystemImageUpdateDependency(23, SystemImage.GOOGLE_APIS_TAG, 12)};
    private AvdManager myAvdManager;
    private static Map<File, AvdManagerConnection> ourCache = ContainerUtil.createWeakMap();
    private static long ourMemorySize = -1L;
    private final FileOp myFileOp;
    private static Function<AndroidSdkHandler, AvdManagerConnection> ourConnectionFactory = AvdManagerConnection::new;
    @Nullable
    private final AndroidSdkHandler mySdkHandler;
    private static final AsyncFunction<ListenableFuture<Object>, Object> DEREFERENCER = new AsyncFunction<ListenableFuture<Object>, Object>(){

        public ListenableFuture<Object> apply(ListenableFuture<Object> input) {
            return input;
        }
    };

    @NotNull
    public static AvdManagerConnection getDefaultAvdManagerConnection() {
        AndroidSdkHandler handler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        if (handler.getLocation() == null) {
            return NULL_CONNECTION;
        }
        return AvdManagerConnection.getAvdManagerConnection(handler);
    }

    @NotNull
    public static synchronized AvdManagerConnection getAvdManagerConnection(@NotNull AndroidSdkHandler handler) {
        File sdkPath = handler.getLocation();
        if (!ourCache.containsKey(sdkPath)) {
            ourCache.put(sdkPath, ourConnectionFactory.apply(handler));
        }
        return ourCache.get(sdkPath);
    }

    public AvdManagerConnection(@Nullable AndroidSdkHandler handler) {
        this.mySdkHandler = handler;
        this.myFileOp = handler == null ? FileOpUtils.create() : handler.getFileOp();
    }

    protected static synchronized void setConnectionFactory(Function<AndroidSdkHandler, AvdManagerConnection> factory) {
        ourCache.clear();
        ourConnectionFactory = factory;
    }

    private boolean initIfNecessary() {
        if (this.myAvdManager == null) {
            if (this.mySdkHandler == null) {
                IJ_LOG.warn("No Android SDK Found");
                return false;
            }
            try {
                this.myAvdManager = AvdManager.getInstance((AndroidSdkHandler)this.mySdkHandler, (File)new File(AndroidLocation.getAvdFolder()), (ILogger)SDK_LOG);
            }
            catch (AndroidLocation.AndroidLocationException e) {
                IJ_LOG.error("Could not instantiate AVD Manager from SDK", (Throwable)e);
                return false;
            }
            if (this.myAvdManager == null) {
                return false;
            }
        }
        return true;
    }

    public String getSdCardSizeFromHardwareProperties() {
        assert (this.mySdkHandler != null);
        return AvdWizardUtils.getHardwarePropertyDefaultValue("sdcard.size", this.mySdkHandler);
    }

    public String getInternalStorageSizeFromHardwareProperties() {
        assert (this.mySdkHandler != null);
        return AvdWizardUtils.getHardwarePropertyDefaultValue("disk.dataPartition.size", this.mySdkHandler);
    }

    @Nullable
    private File getBinaryLocation(String filename) {
        assert (this.mySdkHandler != null);
        LocalPackage sdkPackage = this.mySdkHandler.getLocalPackage("emulator", REPO_LOG);
        if (sdkPackage == null) {
            return null;
        }
        File binaryFile = new File(sdkPackage.getLocation(), filename);
        if (!this.myFileOp.exists(binaryFile)) {
            return null;
        }
        return binaryFile;
    }

    @Nullable
    public File getEmulatorBinary() {
        return this.getBinaryLocation(SdkConstants.FN_EMULATOR);
    }

    @Nullable
    public File getEmulatorCheckBinary() {
        return this.getBinaryLocation(SdkConstants.FN_EMULATOR_CHECK);
    }

    @Nullable
    private SystemImageUpdateDependency[] getSystemImageUpdateDependencies() {
        assert (this.mySdkHandler != null);
        LocalPackage info = (LocalPackage)this.mySdkHandler.getSdkManager(REPO_LOG).getPackages().getLocalPackages().get("tools");
        if (info == null) {
            return null;
        }
        if (info.getVersion().compareTo(TOOLS_REVISION_25_0_2_RC3) >= 0) {
            return SYSTEM_IMAGE_DEPENCENCY_WITH_25_0_2_RC3;
        }
        if (info.getVersion().compareTo(TOOLS_REVISION_WITH_FIRST_QEMU2) >= 0) {
            return SYSTEM_IMAGE_DEPENCENCY_WITH_FIRST_QEMU2;
        }
        return null;
    }

    private boolean hasQEMU2Installed() {
        return this.getSystemImageUpdateDependencies() != null;
    }

    private boolean hasPlatformToolsForQEMU2Installed() {
        assert (this.mySdkHandler != null);
        LocalPackage info = (LocalPackage)this.mySdkHandler.getSdkManager(REPO_LOG).getPackages().getLocalPackages().get("platform-tools");
        if (info == null) {
            return false;
        }
        return info.getVersion().compareTo(PLATFORM_TOOLS_REVISION_WITH_FIRST_QEMU2) >= 0;
    }

    private boolean hasSystemImagesForQEMU2Installed() {
        return this.getSystemImageUpdates().isEmpty();
    }

    @NotNull
    public List<String> getSystemImageUpdates() {
        ArrayList requested = Lists.newArrayList();
        SystemImageUpdateDependency[] dependencies = this.getSystemImageUpdateDependencies();
        if (dependencies == null) {
            return requested;
        }
        assert (this.mySdkHandler != null);
        block0: for (SystemImage systemImage : this.mySdkHandler.getSystemImageManager(REPO_LOG).getImages()) {
            for (SystemImageUpdateDependency dependency : dependencies) {
                if (!dependency.updateRequired(systemImage)) continue;
                requested.add(systemImage.getPackage().getPath());
                continue block0;
            }
        }
        return requested;
    }

    @NotNull
    public List<AvdInfo> getAvds(boolean forceRefresh) {
        if (!this.initIfNecessary()) {
            return ImmutableList.of();
        }
        if (forceRefresh) {
            try {
                this.myAvdManager.reloadAvds(SDK_LOG);
            }
            catch (AndroidLocation.AndroidLocationException e) {
                IJ_LOG.error("Could not find Android SDK!", (Throwable)e);
            }
        }
        ArrayList avdInfos = Lists.newArrayList((Object[])this.myAvdManager.getAllAvds());
        boolean needsRefresh = false;
        for (AvdInfo info : avdInfos) {
            if (info.getStatus() != AvdInfo.AvdStatus.ERROR_DEVICE_CHANGED) continue;
            this.updateDeviceChanged(info);
            needsRefresh = true;
        }
        if (needsRefresh) {
            return this.getAvds(true);
        }
        return avdInfos;
    }

    public boolean deleteAvd(@NotNull String avdName) {
        if (!this.initIfNecessary()) {
            return false;
        }
        AvdInfo info = this.myAvdManager.getAvd(avdName, false);
        if (info == null) {
            return false;
        }
        return this.deleteAvd(info);
    }

    public boolean deleteAvd(@NotNull AvdInfo info) {
        if (!this.initIfNecessary()) {
            return false;
        }
        return this.myAvdManager.deleteAvd(info, SDK_LOG);
    }

    public boolean isAvdRunning(@NotNull AvdInfo info) {
        return this.myAvdManager.isAvdRunning(info, SDK_LOG);
    }

    public void stopAvd(@NotNull AvdInfo info) {
        this.myAvdManager.stopAvd(info);
    }

    @NotNull
    public ListenableFuture<IDevice> startAvd(@Nullable Project project, @NotNull AvdInfo info) {
        return this.startAvd(project, info, null);
    }

    @NotNull
    public ListenableFuture<IDevice> startAvd(@Nullable Project project, @NotNull AvdInfo info, @Nullable String snapshot) {
        ProcessHandler processHandler;
        AccelerationErrorCode error;
        ListenableFuture<IDevice> errorResult;
        if (!this.initIfNecessary()) {
            return Futures.immediateFailedFuture((Throwable)new RuntimeException("No Android SDK Found"));
        }
        String avdName = info.getName();
        String skinPath = (String)info.getProperties().get("skin.path");
        if (skinPath != null) {
            File skinFile = new File(skinPath);
            File baseSkinFile = new File(skinFile.getName());
            AvdWizardUtils.pathToUpdatedSkins(baseSkinFile, null, this.myFileOp);
        }
        if ((errorResult = this.handleAccelerationError(project, info, error = this.checkAcceleration())) != null) {
            return errorResult;
        }
        File emulatorBinary = this.getEmulatorBinary();
        if (emulatorBinary == null) {
            IJ_LOG.error("No emulator binary found!");
            return Futures.immediateFailedFuture((Throwable)new RuntimeException("No emulator binary found"));
        }
        if (this.myAvdManager.isAvdRunning(info, SDK_LOG)) {
            String baseFolder;
            this.myAvdManager.logRunningAvdInfo(info, SDK_LOG);
            try {
                baseFolder = this.myAvdManager.getBaseAvdFolder().getAbsolutePath();
            }
            catch (AndroidLocation.AndroidLocationException e) {
                baseFolder = "$HOME";
            }
            String message2 = String.format("AVD %1$s is already running.\nIf that is not the case, delete the files at\n   %2$s/%1$s.avd/*.lock\nand try again.", avdName, baseFolder);
            Messages.showErrorDialog((Project)project, (String)message2, (String)"AVD Manager");
            return Futures.immediateFailedFuture((Throwable)new RuntimeException(message2));
        }
        EmulatorRunner runner = new EmulatorRunner(this.newEmulatorCommand(emulatorBinary, info, snapshot), info);
        this.addListeners(runner);
        try {
            processHandler = runner.start();
        }
        catch (ExecutionException e) {
            IJ_LOG.error("Error launching emulator", (Throwable)e);
            return Futures.immediateFailedFuture((Throwable)new RuntimeException(String.format("Error launching emulator %1$s ", avdName), e));
        }
        BackgroundableProcessIndicator p = this.hasQEMU2Installed() ? new BackgroundableProcessIndicator(project, "Launching Emulator", PerformInBackgroundOption.ALWAYS_BACKGROUND, "", "", false) : new ProgressWindow(false, true, project);
        p.setIndeterminate(false);
        p.setDelayInMillis(0);
        ApplicationManager.getApplication().executeOnPooledThread(() -> AvdManagerConnection.lambda$startAvd$0((ProgressWindow)p, processHandler));
        return EmulatorConnectionListener.getDeviceForEmulator(project, info.getName(), processHandler, 5L, TimeUnit.MINUTES);
    }

    @NotNull
    private GeneralCommandLine newEmulatorCommand(@NotNull File emulator, @NotNull AvdInfo device, @Nullable String snapshot) {
        GeneralCommandLine command = new GeneralCommandLine();
        command.setExePath(emulator.getPath());
        this.addParameters(device, command);
        String arguments = System.getenv("studio.emu.params");
        if (arguments != null) {
            command.addParameters(Splitter.on((char)',').splitToList((CharSequence)arguments));
        }
        if (snapshot != null) {
            command.addParameters(new String[]{"-snapshot", snapshot});
        }
        return command;
    }

    protected void addListeners(EmulatorRunner runner) {
    }

    protected void addParameters(@NotNull AvdInfo info, @NotNull GeneralCommandLine commandLine) {
        Map properties = info.getProperties();
        String netDelay = (String)properties.get("runtime.network.latency");
        String netSpeed = (String)properties.get("runtime.network.speed");
        if (netDelay != null) {
            commandLine.addParameters(new String[]{"-netdelay", netDelay});
        }
        if (netSpeed != null) {
            commandLine.addParameters(new String[]{"-netspeed", netSpeed});
        }
        if (EmulatorAdvFeatures.emulatorSupportsFastBoot(this.mySdkHandler, (ProgressIndicator)new StudioLoggerProgressIndicator(AvdManagerConnection.class), (ILogger)new LogWrapper(Logger.getInstance(AvdManagerConnection.class)))) {
            if ("yes".equals(properties.get("fastboot.forceColdBoot"))) {
                commandLine.addParameter("-no-snapstorage");
            } else if ("once".equals(properties.get("fastboot.forceColdBoot"))) {
                commandLine.addParameter("-no-snapshot-load");
            } else if ("yes".equals(properties.get("fastboot.forceChosenSnapshotBoot"))) {
                commandLine.addParameters(new String[]{"-snapshot", StringUtil.notNullize((String)((String)properties.get("fastboot.chosenSnapshotFile")))});
                commandLine.addParameter("-no-snapshot-save");
            }
        }
        this.writeParameterFile(commandLine);
        commandLine.addParameters(new String[]{"-avd", info.getName()});
    }

    public boolean emulatorVersionIsAtLeast(@NotNull Revision desired) {
        if (this.mySdkHandler == null) {
            return false;
        }
        StudioLoggerProgressIndicator log = new StudioLoggerProgressIndicator(AvdWizardUtils.class);
        LocalPackage sdkPackage = this.mySdkHandler.getLocalPackage("emulator", (ProgressIndicator)log);
        if (sdkPackage == null) {
            sdkPackage = this.mySdkHandler.getLocalPackage("tools", (ProgressIndicator)log);
        }
        if (sdkPackage == null) {
            return false;
        }
        return sdkPackage.getVersion().compareTo(desired) >= 0;
    }

    protected void writeParameterFile(@NotNull GeneralCommandLine commandLine) {
        if (!this.emulatorVersionIsAtLeast(EMULATOR_REVISION_SUPPORTS_STUDIO_PARAMS)) {
            return;
        }
        HttpConfigurable httpInstance = HttpConfigurable.getInstance();
        if (httpInstance == null) {
            return;
        }
        ArrayList<String> proxyParameters = new ArrayList<String>();
        List myPropList = httpInstance.getJvmProperties(false, null);
        for (Pair kv : myPropList) {
            switch ((String)kv.getFirst()) {
                case "http.proxyHost": 
                case "http.proxyPort": 
                case "https.proxyHost": 
                case "https.proxyPort": 
                case "proxy.authentication.username": 
                case "proxy.authentication.password": {
                    proxyParameters.add((String)kv.getFirst() + "=" + (String)kv.getSecond() + "\n");
                    break;
                }
            }
        }
        if (proxyParameters.isEmpty()) {
            return;
        }
        File tempFile = AvdManagerConnection.writeTempFile(proxyParameters);
        if (tempFile != null) {
            commandLine.addParameters(new String[]{"-studio-params", tempFile.getAbsolutePath()});
        }
    }

    @Nullable
    public static File tempFileDirectory() {
        String androidHomeValue = System.getenv("ANDROID_HOME");
        if (androidHomeValue == null) {
            androidHomeValue = System.getProperty("user.home");
        }
        File tempDir = new File(androidHomeValue, "temp");
        tempDir.mkdirs();
        if (!tempDir.exists()) {
            return null;
        }
        return tempDir;
    }

    @Nullable
    public static File writeTempFile(List<String> fileContents) {
        File tempFile;
        block16: {
            tempFile = null;
            try {
                File tempDir = AvdManagerConnection.tempFileDirectory();
                if (tempDir == null) {
                    return null;
                }
                tempFile = File.createTempFile("emu", ".tmp", tempDir);
                tempFile.deleteOnExit();
                tempFile.setReadable(false, false);
                tempFile.setReadable(true, true);
                FileWriter fileWriter = new FileWriter(tempFile);
                try (BufferedWriter tempFileWriter = new BufferedWriter(fileWriter);){
                    for (String fileLine : fileContents) {
                        tempFileWriter.write(fileLine);
                    }
                }
            }
            catch (IOException ex) {
                if (tempFile == null) break block16;
                tempFile.delete();
                tempFile = null;
            }
        }
        return tempFile;
    }

    @Nullable
    private ListenableFuture<IDevice> handleAccelerationError(@Nullable Project project, @NotNull AvdInfo info, @NotNull AccelerationErrorCode error) {
        switch (error) {
            case ALREADY_INSTALLED: {
                return null;
            }
            case TOOLS_UPDATE_REQUIRED: 
            case PLATFORM_TOOLS_UPDATE_ADVISED: 
            case SYSTEM_IMAGE_UPDATE_ADVISED: {
                return null;
            }
            case NO_EMULATOR_INSTALLED: {
                break;
            }
            default: {
                boolean isAvdIntel;
                Abi abi = Abi.getEnum((String)info.getAbiType());
                boolean bl = isAvdIntel = abi == Abi.X86 || abi == Abi.X86_64;
                if (isAvdIntel) break;
                return null;
            }
        }
        String accelerator = SystemInfo.isLinux ? "KVM" : "Intel HAXM";
        int result2 = Messages.showOkCancelDialog((Project)project, (String)String.format("%1$s is required to run this AVD.\n%2$s\n\n%3$s\n", accelerator, error.getProblem(), error.getSolutionMessage()), (String)error.getSolution().getDescription(), (Icon)AllIcons.General.WarningDialog);
        if (result2 != 0 || error.getSolution() == AccelerationErrorSolution.SolutionCode.NONE) {
            return Futures.immediateFailedFuture((Throwable)new RuntimeException("Could not start AVD"));
        }
        SettableFuture future2 = SettableFuture.create();
        Runnable retry = () -> future2.set(this.startAvd(project, info));
        Runnable cancel = () -> future2.setException((Throwable)new RuntimeException("Retry after fixing problem by hand"));
        Runnable action2 = AccelerationErrorSolution.getActionForFix(error, project, retry, cancel);
        ApplicationManager.getApplication().invokeLater(action2);
        return AvdManagerConnection.dereference(future2);
    }

    private static <V> ListenableFuture<V> dereference(ListenableFuture<? extends ListenableFuture<? extends V>> nested) {
        return Futures.transformAsync(nested, DEREFERENCER, (Executor)MoreExecutors.directExecutor());
    }

    public AccelerationErrorCode checkAcceleration() {
        int exitValue;
        if (!this.initIfNecessary()) {
            return AccelerationErrorCode.UNKNOWN_ERROR;
        }
        File emulatorBinary = this.getEmulatorBinary();
        if (emulatorBinary == null) {
            return AccelerationErrorCode.NO_EMULATOR_INSTALLED;
        }
        if (AvdManagerConnection.getMemorySize() < Storage.Unit.GiB.getNumberOfBytes()) {
            return AccelerationErrorCode.NOT_ENOUGH_MEMORY;
        }
        if (!this.hasQEMU2Installed()) {
            return AccelerationErrorCode.TOOLS_UPDATE_REQUIRED;
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        File checkBinary = this.getEmulatorCheckBinary();
        if (checkBinary != null) {
            commandLine.setExePath(checkBinary.getPath());
            commandLine.addParameter("accel");
        } else {
            commandLine.setExePath(emulatorBinary.getPath());
            commandLine.addParameter("-accel-check");
        }
        try {
            CapturingAnsiEscapesAwareProcessHandler process = new CapturingAnsiEscapesAwareProcessHandler(commandLine);
            ProcessOutput output = process.runProcess();
            exitValue = output.getExitCode();
        }
        catch (ExecutionException e) {
            exitValue = AccelerationErrorCode.UNKNOWN_ERROR.getErrorCode();
        }
        if (exitValue != 0) {
            return AccelerationErrorCode.fromExitCode(exitValue);
        }
        if (!this.hasPlatformToolsForQEMU2Installed()) {
            return AccelerationErrorCode.PLATFORM_TOOLS_UPDATE_ADVISED;
        }
        if (!this.hasSystemImagesForQEMU2Installed()) {
            return AccelerationErrorCode.SYSTEM_IMAGE_UPDATE_ADVISED;
        }
        return AccelerationErrorCode.ALREADY_INSTALLED;
    }

    @Nullable
    public AvdInfo createOrUpdateAvd(@Nullable AvdInfo currentInfo, @NotNull String avdName, @NotNull Device device, @NotNull SystemImageDescription systemImageDescription, @NotNull ScreenOrientation orientation, boolean isCircular, @Nullable String sdCard, @Nullable File skinFolder, @NotNull Map<String, String> hardwareProperties, boolean createSnapshot, boolean removePrevious) {
        boolean success;
        File avdFolder;
        if (!this.initIfNecessary()) {
            return null;
        }
        try {
            avdFolder = currentInfo != null ? new File(currentInfo.getDataFolderPath()) : AvdInfo.getDefaultAvdFolder((AvdManager)this.myAvdManager, (String)avdName, (FileOp)this.myFileOp, (boolean)true);
        }
        catch (AndroidLocation.AndroidLocationException e) {
            IJ_LOG.error("Could not create AVD " + avdName, (Throwable)e);
            return null;
        }
        Dimension resolution = device.getScreenSize(orientation);
        assert (resolution != null);
        String skinName = null;
        if (skinFolder == null && isCircular) {
            skinFolder = AvdManagerConnection.getRoundSkin(systemImageDescription);
        }
        if (FileUtil.filesEqual((File)skinFolder, (File)AvdWizardUtils.NO_SKIN)) {
            skinFolder = null;
        }
        if (skinFolder == null) {
            skinName = String.format(Locale.US, "%dx%d", Math.round(resolution.getWidth()), Math.round(resolution.getHeight()));
        }
        if (orientation == ScreenOrientation.LANDSCAPE) {
            hardwareProperties.put("hw.initialOrientation", ScreenOrientation.LANDSCAPE.getShortDisplayValue().toLowerCase(Locale.ROOT));
        }
        if (currentInfo != null && !avdName.equals(currentInfo.getName()) && removePrevious && !(success = this.myAvdManager.moveAvd(currentInfo, avdName, currentInfo.getDataFolderPath(), SDK_LOG))) {
            return null;
        }
        return this.myAvdManager.createAvd(avdFolder, avdName, systemImageDescription.getSystemImage(), skinFolder, skinName, sdCard, hardwareProperties, device.getBootProps(), device.hasPlayStore(), createSnapshot, false, removePrevious, SDK_LOG);
    }

    @Nullable
    private static File getRoundSkin(SystemImageDescription systemImageDescription) {
        File[] skins;
        for (File skin : skins = systemImageDescription.getSkins()) {
            if (!skin.getName().contains("Round")) continue;
            return skin;
        }
        return null;
    }

    public static boolean doesSystemImageSupportQemu2(@Nullable SystemImageDescription description, @NotNull FileOp fileOp) {
        if (description == null) {
            return false;
        }
        ISystemImage systemImage = description.getSystemImage();
        if (systemImage == null) {
            return false;
        }
        File location = systemImage.getLocation();
        if (!fileOp.isDirectory(location)) {
            return false;
        }
        String[] files2 = fileOp.list(location, null);
        if (files2 != null) {
            for (String filename : files2) {
                if (!filename.startsWith("kernel-ranchu")) continue;
                return true;
            }
        }
        return false;
    }

    public boolean avdExists(String candidate) {
        if (!this.initIfNecessary()) {
            return false;
        }
        return this.myAvdManager.getAvd(candidate, false) != null;
    }

    static boolean isAvdRepairable(@NotNull AvdInfo.AvdStatus avdStatus) {
        return avdStatus == AvdInfo.AvdStatus.ERROR_IMAGE_DIR || avdStatus == AvdInfo.AvdStatus.ERROR_DEVICE_CHANGED || avdStatus == AvdInfo.AvdStatus.ERROR_DEVICE_MISSING || avdStatus == AvdInfo.AvdStatus.ERROR_IMAGE_MISSING;
    }

    public static boolean isSystemImageDownloadProblem(@NotNull AvdInfo.AvdStatus status) {
        switch (status) {
            case ERROR_IMAGE_DIR: 
            case ERROR_IMAGE_MISSING: {
                return true;
            }
        }
        return false;
    }

    public AvdInfo reloadAvd(@NotNull AvdInfo avdInfo) throws AndroidLocation.AndroidLocationException {
        return this.myAvdManager.reloadAvd(avdInfo, SDK_LOG);
    }

    @Nullable
    public static String getRequiredSystemImagePath(@NotNull AvdInfo avdInfo) {
        String imageSystemDir = (String)avdInfo.getProperties().get("image.sysdir.1");
        if (imageSystemDir == null) {
            return null;
        }
        return StringUtil.trimEnd((String)imageSystemDir.replace(File.separatorChar, ';'), (char)';');
    }

    public boolean updateDeviceChanged(@NotNull AvdInfo avdInfo) {
        if (this.initIfNecessary()) {
            try {
                return this.myAvdManager.updateDeviceChanged(avdInfo, SDK_LOG) != null;
            }
            catch (IOException e) {
                IJ_LOG.warn("Could not update AVD Device " + avdInfo.getName(), (Throwable)e);
            }
        }
        return false;
    }

    public boolean wipeUserData(@NotNull AvdInfo avdInfo) {
        if (!this.initIfNecessary()) {
            return false;
        }
        File userdataImage = new File(avdInfo.getDataFolderPath(), "userdata-qemu.img");
        if (this.myFileOp.exists(userdataImage) && !this.myFileOp.delete(userdataImage)) {
            return false;
        }
        File snapshotDirectory = new File(avdInfo.getDataFolderPath(), "snapshots");
        this.myFileOp.deleteFileOrFolder(snapshotDirectory);
        return true;
    }

    public static String getAvdDisplayName(@NotNull AvdInfo avdInfo) {
        String displayName = (String)avdInfo.getProperties().get("avd.ini.displayname");
        if (displayName == null) {
            displayName = avdInfo.getName().replaceAll("[_-]+", " ");
        }
        return displayName;
    }

    public String uniquifyDisplayName(String name) {
        int suffix = 1;
        String result2 = name;
        while (this.findAvdWithName(result2)) {
            result2 = String.format(Locale.US, "%1$s %2$d", name, ++suffix);
        }
        return result2;
    }

    public boolean findAvdWithName(String name) {
        for (AvdInfo avd : this.getAvds(false)) {
            if (!AvdManagerConnection.getAvdDisplayName(avd).equals(name)) continue;
            return true;
        }
        return false;
    }

    public static long getMemorySize() {
        if (ourMemorySize < 0L) {
            ourMemorySize = AvdManagerConnection.checkMemorySize();
        }
        return ourMemorySize;
    }

    private static long checkMemorySize() {
        OperatingSystemMXBean osMXBean = ManagementFactory.getOperatingSystemMXBean();
        try {
            Class<?> oracleSpecificMXBean = Class.forName("com.sun.management.OperatingSystemMXBean");
            Method getPhysicalMemorySizeMethod = oracleSpecificMXBean.getMethod("getTotalPhysicalMemorySize", new Class[0]);
            Object result2 = getPhysicalMemorySizeMethod.invoke((Object)osMXBean, new Object[0]);
            if (result2 instanceof Number) {
                return ((Number)result2).longValue();
            }
        }
        catch (ClassNotFoundException | NoSuchMethodException oracleSpecificMXBean) {
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            IJ_LOG.error((Throwable)e);
        }
        return 32L * Storage.Unit.GiB.getNumberOfBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ void lambda$startAvd$0(ProgressWindow p, ProcessHandler processHandler) {
        try {
            p.start();
            p.setText("Starting AVD...");
            for (double d = 0.0; d < 1.0; d += 0.0125) {
                p.setFraction(d);
                Thread.sleep(100L);
                if (!processHandler.isProcessTerminated()) continue;
                break;
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            p.stop();
            p.processFinish();
        }
    }

    private static class SystemImageUpdateDependency {
        private final int myFeatureLevel;
        private final IdDisplay myTag;
        private final int myRequiredMajorRevision;

        public SystemImageUpdateDependency(int featureLevel, @NotNull IdDisplay tag, int requiredMajorRevision) {
            this.myFeatureLevel = featureLevel;
            this.myTag = tag;
            this.myRequiredMajorRevision = requiredMajorRevision;
        }

        public boolean updateRequired(@NotNull SystemImage image) {
            return this.updateRequired(image.getAbiType(), image.getAndroidVersion().getFeatureLevel(), image.getTag(), image.getRevision());
        }

        public boolean updateRequired(@NotNull String abiType, int featureLevel, @NotNull IdDisplay tag, @NotNull Revision revision) {
            Abi abi = Abi.getEnum((String)abiType);
            boolean isAvdIntel = abi == Abi.X86 || abi == Abi.X86_64;
            return isAvdIntel && featureLevel == this.myFeatureLevel && this.myTag.equals((Object)tag) && revision.getMajor() < this.myRequiredMajorRevision;
        }
    }
}

