/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.prefs.AndroidLocation;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.utils.ILogger;
import com.intellij.CommonBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AvdManagerLog;
import org.jetbrains.android.sdk.MessageBuildingSdkLog;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AvdManagerUtils {
    public static boolean reloadAvds(@NotNull AvdManager manager, @NotNull Project project) {
        try {
            MessageBuildingSdkLog log = new MessageBuildingSdkLog();
            manager.reloadAvds((ILogger)log);
            if (!log.getErrorMessage().isEmpty()) {
                String message2 = AndroidBundle.message("cant.load.avds.error.prefix", new Object[0]) + ' ' + log.getErrorMessage();
                Messages.showErrorDialog((Project)project, (String)message2, (String)CommonBundle.getErrorTitle());
            }
            return true;
        }
        catch (AndroidLocation.AndroidLocationException e) {
            Messages.showErrorDialog((Project)project, (String)AndroidBundle.message("cant.load.avds.error", new Object[0]), (String)CommonBundle.getErrorTitle());
            return false;
        }
    }

    @Nullable
    public static AvdManager getAvdManagerSilently(@NotNull AndroidFacet facet) {
        try {
            return AvdManager.getInstance((AndroidSdkHandler)AndroidSdkData.getSdkHolder(facet), (ILogger)new AvdManagerLog());
        }
        catch (AndroidLocation.AndroidLocationException androidLocationException) {
            return null;
        }
    }
}

