/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.sdklib.devices.Device;
import com.android.tools.adtui.common.ColoredIconGenerator;
import com.android.tools.idea.avdmanager.CloneDeviceAction;
import com.android.tools.idea.avdmanager.CreateDeviceAction;
import com.android.tools.idea.avdmanager.DeleteDeviceAction;
import com.android.tools.idea.avdmanager.DeviceManagerConnection;
import com.android.tools.idea.avdmanager.DeviceUiAction;
import com.android.tools.idea.avdmanager.EditDeviceAction;
import com.android.tools.idea.avdmanager.ExportDeviceAction;
import com.android.tools.idea.avdmanager.ImportDevicesAction;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.npw.FormFactor;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.JBMenuItem;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.TableView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceDefinitionList
extends JPanel
implements ListSelectionListener,
DocumentListener,
DeviceUiAction.DeviceProvider {
    private static final String SEARCH_RESULTS = "Search Results";
    private static final String PHONE_TYPE = "Phone";
    private static final String TABLET_TYPE = "Tablet";
    private static final String DEFAULT_PHONE = "Pixel 2";
    private static final String DEFAULT_TABLET = "Pixel C";
    private static final String DEFAULT_WEAR = "Android Wear Square";
    private static final String DEFAULT_TV = "Android TV (1080p)";
    private static final String DEFAULT_AUTOMOTIVE = "Automotive (1024p landscape)";
    private Map<String, List<Device>> myDeviceCategoryMap;
    private static final Map<String, Device> myDefaultCategoryDeviceMap = Maps.newHashMap();
    private static final DecimalFormat ourDecimalFormat = new DecimalFormat(".##");
    private final ListTableModel<Device> myModel;
    private TableView<Device> myTable;
    private final ListTableModel<String> myCategoryModel;
    private TableView<String> myCategoryList;
    private JButton myCreateProfileButton;
    private JButton myImportProfileButton;
    private JButton myRefreshButton;
    private JPanel myPanel;
    private SearchTextField mySearchTextField;
    private List<DeviceDefinitionSelectionListener> myListeners;
    private List<DeviceCategorySelectionListener> myCategoryListeners;
    private List<Device> myDevices;
    private Device myDefaultDevice;
    private final Border myBorder;
    private final TableCellRenderer myRenderer;

    public DeviceDefinitionList() {
        super(new BorderLayout());
        this.$$$setupUI$$$();
        this.myDeviceCategoryMap = Maps.newHashMap();
        this.myModel = new ListTableModel(new ColumnInfo[0]);
        this.myCategoryModel = new ListTableModel(new ColumnInfo[0]);
        this.myListeners = Lists.newArrayList();
        this.myCategoryListeners = Lists.newArrayList();
        this.myBorder = JBUI.Borders.empty((int)10);
        this.myRenderer = new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table2, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
                JBLabel label = new JBLabel((String)value2);
                label.setBorder(DeviceDefinitionList.this.myBorder);
                if (table2.getSelectedRow() == row) {
                    label.setBackground(table2.getSelectionBackground());
                    label.setForeground(table2.getSelectionForeground());
                    label.setOpaque(true);
                }
                return label;
            }
        };
        ColumnInfo[] columnInfos = new ColumnInfo[]{new DeviceColumnInfo("Name"){

            public String valueOf(Device device) {
                return device.getDisplayName();
            }

            public String getPreferredStringValue() {
                return "4.65\" 720 (Galaxy Nexus)";
            }

            @Override
            public Comparator<Device> getComparator() {
                return (o1, o2) -> {
                    String name2;
                    String name1 = this.valueOf((Device)o1);
                    if (name1 == (name2 = this.valueOf((Device)o2))) {
                        return 0;
                    }
                    if (name1.isEmpty() || name2.isEmpty()) {
                        return -1;
                    }
                    char firstChar1 = name1.charAt(0);
                    char firstChar2 = name2.charAt(0);
                    if (Character.isLetter(firstChar1) && !Character.isLetter(firstChar2)) {
                        return 1;
                    }
                    if (Character.isLetter(firstChar2) && !Character.isLetter(firstChar1)) {
                        return -1;
                    }
                    return name1.compareTo(name2);
                };
            }
        }, new PlayStoreColumnInfo("Play Store"){}, new DeviceColumnInfo("Size"){

            public String valueOf(Device device) {
                return DeviceDefinitionList.getDiagonalSize(device);
            }

            @Override
            public Comparator<Device> getComparator() {
                return (o1, o2) -> {
                    if (o1 == null) {
                        return -1;
                    }
                    if (o2 == null) {
                        return 1;
                    }
                    return Double.compare(o1.getDefaultHardware().getScreen().getDiagonalLength(), o2.getDefaultHardware().getScreen().getDiagonalLength());
                };
            }
        }, new DeviceColumnInfo("Resolution"){

            public String valueOf(Device device) {
                return DeviceDefinitionList.getDimensionString(device);
            }

            @Override
            public Comparator<Device> getComparator() {
                return (o1, o2) -> {
                    if (o1 == null) {
                        return -1;
                    }
                    if (o2 == null) {
                        return 1;
                    }
                    Dimension d1 = o1.getScreenSize(o1.getDefaultState().getOrientation());
                    Dimension d2 = o2.getScreenSize(o2.getDefaultState().getOrientation());
                    if (d1 == null) {
                        return -1;
                    }
                    if (d2 == null) {
                        return 1;
                    }
                    return Integer.compare(d1.width * d1.height, d2.width * d2.height);
                };
            }
        }, new DeviceColumnInfo("Density"){

            public String valueOf(Device device) {
                return DeviceDefinitionList.getDensityString(device);
            }
        }};
        this.myModel.setColumnInfos(columnInfos);
        this.myModel.setSortable(true);
        this.refreshDeviceProfiles();
        this.setDefaultDevices();
        this.myTable.setModelAndUpdateColumns(this.myModel);
        this.myTable.getRowSorter().toggleSortOrder(0);
        this.myTable.getRowSorter().toggleSortOrder(0);
        this.myTable.setSelectionMode(0);
        this.myTable.setRowSelectionAllowed(true);
        this.myRefreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeviceDefinitionList.this.refreshDeviceProfiles();
            }
        });
        this.myTable.getSelectionModel().addListSelectionListener(this);
        ColumnInfo[] categoryInfo = new ColumnInfo[]{new ColumnInfo<String, String>("Category"){

            @Nullable
            public String valueOf(String category) {
                return category;
            }

            public TableCellRenderer getRenderer(String s) {
                return DeviceDefinitionList.this.myRenderer;
            }
        }};
        this.myCategoryModel.setColumnInfos(categoryInfo);
        this.myCategoryList.setModelAndUpdateColumns(this.myCategoryModel);
        this.myCategoryList.getSelectionModel().addListSelectionListener(this);
        this.mySearchTextField.addDocumentListener((DocumentListener)this);
        this.add((Component)this.myPanel, "Center");
        this.myCreateProfileButton.setAction(new CreateDeviceAction(this));
        this.myCreateProfileButton.setText("New Hardware Profile");
        this.myImportProfileButton.setAction(new ImportDevicesAction(this));
        this.myImportProfileButton.setText("Import Hardware Profiles");
        this.myTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DeviceDefinitionList.this.possiblyShowPopup(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                DeviceDefinitionList.this.possiblyShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                DeviceDefinitionList.this.possiblyShowPopup(e);
            }
        });
    }

    private void setDefaultDevices() {
        this.myDefaultDevice = this.updateDefaultDevice(PHONE_TYPE, DEFAULT_PHONE);
        this.updateDefaultDevice(TABLET_TYPE, DEFAULT_TABLET);
        this.updateDefaultDevice(FormFactor.TV.toString(), DEFAULT_TV);
        this.updateDefaultDevice(FormFactor.WEAR.toString(), DEFAULT_WEAR);
        this.updateDefaultDevice(FormFactor.AUTOMOTIVE.toString(), DEFAULT_AUTOMOTIVE);
    }

    private Device updateDefaultDevice(String type, String deviceDisplayName) {
        List<Device> devices = this.myDeviceCategoryMap.get(type);
        if (devices != null) {
            for (Device d : devices) {
                if (!d.getDisplayName().equals(deviceDisplayName)) continue;
                myDefaultCategoryDeviceMap.put(type, d);
                return d;
            }
        }
        return null;
    }

    @NotNull
    private static JBMenuItem createMenuItem(@NotNull DeviceUiAction action2) {
        JBMenuItem item = new JBMenuItem((Action)action2);
        item.setText(action2.getText());
        return item;
    }

    private void possiblyShowPopup(MouseEvent e) {
        if (!e.isPopupTrigger()) {
            return;
        }
        Point p = e.getPoint();
        int row = this.myTable.rowAtPoint(p);
        int col = this.myTable.columnAtPoint(p);
        if (row != -1 && col != -1) {
            JBPopupMenu menu = new JBPopupMenu();
            menu.add((JMenuItem)DeviceDefinitionList.createMenuItem(new CloneDeviceAction(this)));
            menu.add((JMenuItem)DeviceDefinitionList.createMenuItem(new EditDeviceAction(this)));
            menu.add((JMenuItem)DeviceDefinitionList.createMenuItem(new ExportDeviceAction(this)));
            menu.add((JMenuItem)DeviceDefinitionList.createMenuItem(new DeleteDeviceAction(this)));
            menu.show(this.myTable, p.x, p.y);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource().equals(this.myCategoryList.getSelectionModel())) {
            this.setCategory((String)this.myCategoryList.getSelectedObject());
        } else if (e.getSource().equals(this.myTable.getSelectionModel())) {
            this.onSelectionSet((Device)this.myTable.getSelectedObject());
        }
    }

    public void addSelectionListener(@NotNull DeviceDefinitionSelectionListener listener2) {
        this.myListeners.add(listener2);
    }

    public void addCategoryListener(@NotNull DeviceCategorySelectionListener listener2) {
        this.myCategoryListeners.add(listener2);
    }

    public void removeSelectionListener(@NotNull DeviceDefinitionSelectionListener listener2) {
        this.myListeners.remove(listener2);
    }

    @Override
    public void selectDefaultDevice() {
        this.setSelectedDevice(this.myDefaultDevice);
    }

    @Override
    @Nullable
    public Project getProject() {
        return null;
    }

    public void setSelectedDevice(@Nullable Device device) {
        if (Objects.equals(device, this.myTable.getSelectedObject())) {
            return;
        }
        this.onSelectionSet(device);
        if (device != null) {
            String category = DeviceDefinitionList.getCategory(device);
            for (Device listItem : this.myModel.getItems()) {
                if (!listItem.getId().equals(device.getId())) continue;
                this.myTable.setSelection((Collection)ImmutableSet.of((Object)listItem));
            }
            this.myCategoryList.setSelection((Collection)ImmutableSet.of((Object)category));
            this.setCategory(category);
        }
    }

    private void onSelectionSet(@Nullable Device selectedObject) {
        if (selectedObject != null) {
            myDefaultCategoryDeviceMap.put(DeviceDefinitionList.getCategory(selectedObject), selectedObject);
        }
        for (DeviceDefinitionSelectionListener listener2 : this.myListeners) {
            listener2.onDeviceSelectionChanged(selectedObject);
        }
    }

    public void setCategory(@Nullable String selectedCategory) {
        if (this.myDeviceCategoryMap.containsKey(selectedCategory)) {
            List<Device> newItems = this.myDeviceCategoryMap.get(selectedCategory);
            if (!this.myModel.getItems().equals(newItems)) {
                this.myModel.setItems(newItems);
                this.setSelectedDevice(myDefaultCategoryDeviceMap.get(selectedCategory));
                this.notifyCategoryListeners(selectedCategory, newItems);
            }
        }
    }

    private void notifyCategoryListeners(@Nullable String selectedCategory, @Nullable List<Device> items2) {
        for (DeviceCategorySelectionListener listener2 : this.myCategoryListeners) {
            listener2.onCategorySelectionChanged(selectedCategory, items2);
        }
    }

    private void refreshDeviceProfiles() {
        this.myDevices = DeviceManagerConnection.getDefaultDeviceManagerConnection().getDevices().stream().filter(d -> !HardwareConfigHelper.isAutomotive((Device)d) || (Boolean)StudioFlags.NPW_TEMPLATES_AUTOMOTIVE.get() != false).collect(Collectors.toList());
        this.myDeviceCategoryMap.clear();
        for (Device d2 : this.myDevices) {
            String category = DeviceDefinitionList.getCategory(d2);
            if (!this.myDeviceCategoryMap.containsKey(category)) {
                this.myDeviceCategoryMap.put(category, new ArrayList(1));
            }
            this.myDeviceCategoryMap.get(category).add(d2);
        }
        Set<String> categories = this.myDeviceCategoryMap.keySet();
        Object[] categoryArray = ArrayUtil.toStringArray(categories);
        this.myCategoryModel.setItems((List)Lists.newArrayList((Object[])categoryArray));
    }

    public static String getCategory(@NotNull Device d) {
        if (HardwareConfigHelper.isAutomotive((Device)d)) {
            return FormFactor.AUTOMOTIVE.toString();
        }
        if (HardwareConfigHelper.isTv((Device)d) || DeviceDefinitionList.hasTvSizedScreen(d)) {
            return FormFactor.TV.toString();
        }
        if (HardwareConfigHelper.isWear((Device)d)) {
            return FormFactor.WEAR.toString();
        }
        if (DeviceDefinitionList.isTablet(d)) {
            return TABLET_TYPE;
        }
        return PHONE_TYPE;
    }

    public static boolean isTablet(@NotNull Device d) {
        return d.getDefaultHardware().getScreen().getDiagonalLength() >= 7.0 && !d.getDefaultHardware().getScreen().isFoldable();
    }

    private static boolean hasTvSizedScreen(@NotNull Device d) {
        return d.getDefaultHardware().getScreen().getDiagonalLength() >= 15.0;
    }

    public static String getDiagonalSize(@NotNull Device device) {
        return ourDecimalFormat.format(device.getDefaultHardware().getScreen().getDiagonalLength()) + '\"';
    }

    public static String getDimensionString(@NotNull Device device) {
        Dimension size = device.getScreenSize(device.getDefaultState().getOrientation());
        return size == null ? "Unknown Resolution" : String.format(Locale.getDefault(), "%dx%d", size.width, size.height);
    }

    public static String getDensityString(@NotNull Device device) {
        return device.getDefaultHardware().getScreen().getPixelDensity().getResourceValue();
    }

    private void createUIComponents() {
        this.myCategoryList = new TableView();
        this.myTable = new TableView();
        this.myRefreshButton = new JButton(AllIcons.Actions.Refresh);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateSearchResults(DeviceDefinitionList.getText(e.getDocument()));
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateSearchResults(DeviceDefinitionList.getText(e.getDocument()));
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateSearchResults(DeviceDefinitionList.getText(e.getDocument()));
    }

    private static String getText(Document d) {
        try {
            return d.getText(0, d.getLength());
        }
        catch (BadLocationException e) {
            return "";
        }
    }

    private void updateSearchResults(@NotNull String searchString) {
        if (searchString.isEmpty()) {
            if (((String)this.myCategoryModel.getItem(this.myCategoryModel.getRowCount() - 1)).equals(SEARCH_RESULTS)) {
                this.myCategoryModel.removeRow(this.myCategoryModel.getRowCount() - 1);
                this.setCategory((String)this.myCategoryList.getRow(0));
            }
            return;
        }
        if (!((String)this.myCategoryModel.getItem(this.myCategoryModel.getRowCount() - 1)).equals(SEARCH_RESULTS)) {
            this.myCategoryModel.addRow((Object)SEARCH_RESULTS);
            this.myCategoryList.setSelection((Collection)ImmutableSet.of((Object)SEARCH_RESULTS));
        }
        ArrayList items2 = Lists.newArrayList((Iterable)Iterables.filter(this.myDevices, input -> input.getDisplayName().toLowerCase(Locale.getDefault()).contains(searchString.toLowerCase(Locale.getDefault()))));
        this.myModel.setItems((List)items2);
        this.notifyCategoryListeners(null, items2);
    }

    @Override
    @Nullable
    public Device getDevice() {
        return (Device)this.myTable.getSelectedObject();
    }

    @Override
    public void setDevice(@Nullable Device device) {
        this.setSelectedDevice(device);
    }

    @Override
    public void refreshDevices() {
        this.refreshDeviceProfiles();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        SearchTextField searchTextField;
        JButton jButton;
        JButton jButton2;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 8, 2, 1, 7, null, new Dimension(100, -1), new Dimension(100, -1)));
        TableView<String> tableView = this.myCategoryList;
        jBScrollPane.setViewportView((Component)tableView);
        JBScrollPane jBScrollPane2 = new JBScrollPane();
        jPanel.add((Component)jBScrollPane2, new GridConstraints(1, 1, 1, 1, 0, 3, 7, 7, null, null, null));
        TableView<Device> tableView2 = this.myTable;
        jBScrollPane2.setViewportView((Component)tableView2);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myCreateProfileButton = jButton2 = new JButton();
        jButton2.setText("New Hardware Profile");
        jPanel2.add((Component)jButton2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myImportProfileButton = jButton = new JButton();
        jButton.setText("Import Hardware Profiles");
        ((Component)jButton).setVisible(true);
        jPanel2.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JButton jButton3 = this.myRefreshButton;
        jButton3.setText("");
        jPanel2.add((Component)jButton3, new GridConstraints(0, 3, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.mySearchTextField = searchTextField = new SearchTextField();
        jPanel.add((Component)searchTextField, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    public static interface DeviceCategorySelectionListener {
        public void onCategorySelectionChanged(@Nullable String var1, @Nullable List<Device> var2);
    }

    public static interface DeviceDefinitionSelectionListener {
        public void onDeviceSelectionChanged(@Nullable Device var1);
    }

    private static class PlayStoreColumnInfo
    extends ColumnInfo<Device, Icon> {
        public static final Icon highlightedPlayStoreIcon = ColoredIconGenerator.INSTANCE.generateWhiteIcon(StudioIcons.Avd.DEVICE_PLAY_STORE);
        private static final TableCellRenderer ourIconRenderer = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table2, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
                Icon theIcon = (Icon)value2;
                JBLabel label = new JBLabel(theIcon);
                if (theIcon != null) {
                    AccessibleContextUtil.setName((Component)label, (String)"Play Store");
                }
                if (table2.getSelectedRow() == row) {
                    label.setBackground(table2.getSelectionBackground());
                    label.setForeground(table2.getSelectionForeground());
                    label.setOpaque(true);
                    if (theIcon != null) {
                        label.setIcon(highlightedPlayStoreIcon);
                    }
                }
                return label;
            }
        };

        PlayStoreColumnInfo(String name) {
            super(name);
        }

        @NotNull
        public TableCellRenderer getRenderer(Device device) {
            return ourIconRenderer;
        }

        public int getWidth(JTable table2) {
            return -1;
        }

        @Nullable
        public Icon valueOf(Device device) {
            return device.hasPlayStore() ? StudioIcons.Avd.DEVICE_PLAY_STORE : null;
        }

        @NotNull
        public Comparator<Device> getComparator() {
            return (o1, o2) -> Boolean.compare(o2.hasPlayStore(), o1.hasPlayStore());
        }
    }

    private abstract class DeviceColumnInfo
    extends ColumnInfo<Device, String> {
        private final int myWidth;

        @Nullable
        public Comparator<Device> getComparator() {
            return (o1, o2) -> {
                if (o1 == null || this.valueOf(o1) == null) {
                    return -1;
                }
                if (o2 == null || this.valueOf(o2) == null) {
                    return 1;
                }
                return ((String)this.valueOf(o1)).compareTo((String)this.valueOf(o2));
            };
        }

        DeviceColumnInfo(String name, int width) {
            super(name);
            this.myWidth = width;
        }

        DeviceColumnInfo(String name) {
            this(name, -1);
        }

        @Nullable
        public TableCellRenderer getRenderer(Device device) {
            return DeviceDefinitionList.this.myRenderer;
        }

        public int getWidth(JTable table2) {
            return this.myWidth;
        }
    }
}

