/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.ShellAPI;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.platform.win32.WinReg;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.StdCallLibrary;
import com.sun.jna.win32.W32APIOptions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ElevatedCommandLine
extends GeneralCommandLine {
    private static final int INFINITE = -1;
    private String myTempFilePrefix = "temp";

    public ElevatedCommandLine(String ... command) {
        super(command);
    }

    public ElevatedCommandLine withTempFilePrefix(@NotNull String tempFilePrefix) {
        this.myTempFilePrefix = tempFilePrefix;
        return this;
    }

    @NotNull
    protected Process startProcess(@NotNull List<String> commands2) throws IOException {
        if (SystemInfo.isWin7OrNewer) {
            return this.executeAsShellCommand();
        }
        return super.startProcess(commands2);
    }

    private Process executeAsShellCommand() throws IOException {
        String exeName = new File(this.getExePath()).getName();
        File wrapper = FileUtil.createTempFile((String)(FileUtil.getNameWithoutExtension((String)exeName) + "_wrapper"), (String)".bat", (boolean)true);
        String exePath = new File(this.getExePath()).getParent();
        FileUtil.writeToFile((File)wrapper, (String)String.format("@echo off\nsetlocal enableextensions\n\ncd /d \"%1$s\"\n\n%2$s %%*", exePath, exeName));
        this.setExePath(wrapper.getPath());
        File outFile = FileUtil.createTempFile((String)(this.myTempFilePrefix + "_out"), (String)".txt", (boolean)true);
        File errFile = FileUtil.createTempFile((String)(this.myTempFilePrefix + "_err"), (String)".txt", (boolean)true);
        this.addParameters(new String[]{">", outFile.getPath(), "2>", errFile.getPath()});
        ShellExecuteInfo info = new ShellExecuteInfo(this);
        WinDef.BOOL returnValue = Shell32Ex.INSTANCE.ShellExecuteEx(info);
        int errorCode = returnValue.booleanValue() ? 0 : Kernel32.INSTANCE.GetLastError();
        return new ProcessWrapper(info.hProcess, errorCode, outFile, errFile);
    }

    private static interface Shell32Ex
    extends ShellAPI,
    StdCallLibrary {
        public static final Shell32Ex INSTANCE = (Shell32Ex)Native.loadLibrary((String)"shell32", Shell32Ex.class, (Map)W32APIOptions.UNICODE_OPTIONS);

        public WinDef.BOOL ShellExecuteEx(ShellExecuteInfo var1);
    }

    public static class ShellExecuteInfo
    extends Structure {
        public WinDef.DWORD cbSize = new WinDef.DWORD((long)this.size());
        public WinDef.ULONG fMask;
        public WinDef.HWND hwnd;
        public WString lpVerb;
        public WString lpFile;
        public WString lpParameters;
        public WString lpDirectory;
        public int nShow;
        public WinDef.HINSTANCE hInstApp;
        public Pointer lpIDList;
        public WString lpClass;
        public WinReg.HKEY hKeyClass;
        public WinDef.DWORD dwHotKey;
        public WinNT.HANDLE hMonitor;
        public WinNT.HANDLE hProcess;
        private static final int SW_HIDE = 0;
        private static final int SEE_MASK_NO_CLOSE_PROCESS = 64;

        public ShellExecuteInfo(@NotNull GeneralCommandLine commandLine) {
            this.lpFile = new WString(commandLine.getExePath());
            this.lpVerb = new WString("runas");
            this.lpParameters = new WString(commandLine.getParametersList().getParametersString());
            this.lpDirectory = new WString(commandLine.getWorkDirectory().getPath());
            this.nShow = 0;
            this.fMask = new WinDef.ULONG(64L);
        }

        protected List getFieldOrder() {
            return Arrays.asList("cbSize", "fMask", "hwnd", "lpVerb", "lpFile", "lpParameters", "lpDirectory", "nShow", "hInstApp", "lpIDList", "lpClass", "hKeyClass", "dwHotKey", "hMonitor", "hProcess");
        }
    }

    private static class ProcessWrapper
    extends Process {
        private WinNT.HANDLE myProcess;
        private final IntByReference myExitCode;
        private final File myOutFile;
        private final File myErrFile;

        private ProcessWrapper(@NotNull WinNT.HANDLE hProcess, int errorCode, @NotNull File outFile, @NotNull File errFile) {
            this.myProcess = hProcess;
            this.myExitCode = new IntByReference(errorCode);
            this.myOutFile = outFile;
            this.myErrFile = errFile;
        }

        @Override
        public OutputStream getOutputStream() {
            throw new RuntimeException("Unexpected behaviour");
        }

        @Override
        public InputStream getInputStream() {
            return this.toInputStream(this.myOutFile);
        }

        @Override
        public InputStream getErrorStream() {
            return this.toInputStream(this.myErrFile);
        }

        @Override
        public int waitFor() {
            if (this.myProcess != null) {
                Kernel32.INSTANCE.WaitForSingleObject(this.myProcess, -1);
                Kernel32.INSTANCE.GetExitCodeProcess(this.myProcess, this.myExitCode);
                Kernel32.INSTANCE.CloseHandle(this.myProcess);
                this.myProcess = null;
            }
            return this.myExitCode.getValue();
        }

        @Override
        public int exitValue() {
            return this.waitFor();
        }

        @Override
        public void destroy() {
            this.waitFor();
        }

        private InputStream toInputStream(@NotNull File file) {
            try {
                this.waitFor();
                return new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

