/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.devices.Abi;
import com.android.tools.idea.avdmanager.AccelerationErrorCode;
import com.android.tools.idea.avdmanager.AccelerationErrorSolution;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.avdmanager.AvdWizardUtils;
import com.android.tools.idea.avdmanager.SystemImageDescription;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.View;
import org.jetbrains.annotations.NotNull;

public class HaxmAlert
extends JPanel {
    private JBLabel myWarningMessage;
    private HyperlinkLabel myErrorInstructionsLink = new HyperlinkLabel();
    private HyperlinkListener myErrorLinkListener;
    private SystemImageDescription myImageDescription;
    private AccelerationErrorCode myAccelerationErrorCode;

    public HaxmAlert() {
        this.myWarningMessage = new JBLabel(){

            public Dimension getPreferredSize() {
                View view = (View)this.getClientProperty("html");
                Container parent = this.getParent();
                if (view != null && parent != null && parent.getWidth() > 0 && parent.getWidth() != (int)view.getPreferredSpan(0)) {
                    view.setSize(parent.getWidth(), 0.0f);
                    return new Dimension((int)view.getPreferredSpan(0), (int)view.getPreferredSpan(1));
                }
                return super.getPreferredSize();
            }
        };
        this.setLayout((LayoutManager)new GridLayoutManager(2, 1));
        GridConstraints constraints = new GridConstraints();
        constraints.setAnchor(8);
        this.add((Component)this.myWarningMessage, constraints);
        constraints.setRow(1);
        this.add((Component)this.myErrorInstructionsLink, constraints);
        this.myErrorInstructionsLink.setOpaque(false);
        this.myWarningMessage.setForeground((Color)JBColor.RED);
        this.myWarningMessage.setHorizontalAlignment(2);
        this.setOpaque(false);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Recommendation"), BorderFactory.createEmptyBorder(0, 5, 3, 5)));
    }

    public void setSystemImageDescription(SystemImageDescription description) {
        this.myImageDescription = description;
        this.refresh();
    }

    private void refresh() {
        String warningText;
        Abi abi;
        if (this.myImageDescription == null) {
            this.setVisible(false);
            return;
        }
        boolean hasLink = false;
        StringBuilder warningTextBuilder = new StringBuilder();
        AccelerationErrorCode accelerationError = this.getAccelerationState(false);
        if (accelerationError != AccelerationErrorCode.ALREADY_INSTALLED) {
            hasLink = true;
            warningTextBuilder.append(accelerationError.getProblem());
            warningTextBuilder.append("<br>");
            this.myErrorInstructionsLink.setHyperlinkText(accelerationError.getSolution().getDescription());
            if (this.myErrorLinkListener != null) {
                this.myErrorInstructionsLink.removeHyperlinkListener(this.myErrorLinkListener);
            }
            Runnable refresh2 = new Runnable(){

                @Override
                public void run() {
                    HaxmAlert.this.refresh();
                }
            };
            final Runnable action2 = AccelerationErrorSolution.getActionForFix(accelerationError, null, refresh2, null);
            this.myErrorLinkListener = new HyperlinkAdapter(){

                protected void hyperlinkActivated(HyperlinkEvent e) {
                    action2.run();
                }
            };
            this.myErrorInstructionsLink.addHyperlinkListener(this.myErrorLinkListener);
            this.myErrorInstructionsLink.setToolTipText(accelerationError.getSolution() != AccelerationErrorSolution.SolutionCode.NONE ? accelerationError.getSolutionMessage() : null);
        }
        if (this.myImageDescription.getVersion().getApiLevel() < 14) {
            if (warningTextBuilder.length() > 0) {
                warningTextBuilder.append("<br>");
            }
            warningTextBuilder.append("This API Level is Deprecated<br>");
        }
        if ((abi = Abi.getEnum((String)this.myImageDescription.getAbiType())) != Abi.X86 && abi != Abi.X86_64) {
            if (warningTextBuilder.length() > 0) {
                warningTextBuilder.append("<br>");
            }
            warningTextBuilder.append("Consider using an x86 system image on an x86 host for better emulation performance.<br>");
        }
        if (!AvdWizardUtils.TAGS_WITH_GOOGLE_API.contains(this.myImageDescription.getTag())) {
            if (warningTextBuilder.length() > 0) {
                warningTextBuilder.append("<br>");
            }
            warningTextBuilder.append("Consider using a system image with Google APIs to enable testing with Google Play Services.");
        }
        if (!(warningText = warningTextBuilder.toString()).isEmpty()) {
            warningTextBuilder.insert(0, "<html>");
            warningTextBuilder.append("</html>");
            this.myWarningMessage.setText(warningTextBuilder.toString().replaceAll("\n", "<br>"));
            this.setVisible(true);
            this.myErrorInstructionsLink.setVisible(hasLink);
        } else {
            this.setVisible(false);
        }
    }

    @NotNull
    public AccelerationErrorCode getAccelerationState(boolean forceRefresh) {
        if (this.myAccelerationErrorCode == null || forceRefresh) {
            this.myAccelerationErrorCode = HaxmAlert.computeAccelerationState();
        }
        return this.myAccelerationErrorCode;
    }

    private static AccelerationErrorCode computeAccelerationState() {
        AvdManagerConnection manager = AvdManagerConnection.getDefaultAvdManagerConnection();
        return manager.checkAcceleration();
    }
}

