/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.actions;

import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import org.jetbrains.annotations.NotNull;

public class GotoComponentAction
extends DumbAwareAction {
    private final DesignSurface mySurface;

    public GotoComponentAction(DesignSurface surface) {
        super("Go to XML");
        this.mySurface = surface;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        ImmutableList<NlComponent> components;
        InputEvent inputEvent = e.getInputEvent();
        if (inputEvent instanceof MouseEvent && (this.mySurface.getInteractionManager().interceptPanInteraction((MouseEvent)inputEvent) || AdtUiUtils.isActionKeyDown((InputEvent)inputEvent))) {
            return;
        }
        SelectionModel selectionModel = this.mySurface.getSelectionModel();
        NlComponent primary = selectionModel.getPrimary();
        NlModel model2 = this.mySurface.getModel();
        NlComponent componentToNavigate = null;
        if (primary != null) {
            componentToNavigate = primary;
        } else if (model2 != null && !(components = model2.getComponents()).isEmpty()) {
            componentToNavigate = (NlComponent)components.get(0);
        }
        this.mySurface.deactivate();
        if (componentToNavigate == null || !NlComponentHelperKt.navigateTo(componentToNavigate)) {
            this.switchTab(model2);
        }
    }

    private void switchTab(@NotNull NlModel model2) {
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)this.mySurface.getProject());
        editorManager.openTextEditor(new OpenFileDescriptor(model2.getProject(), model2.getVirtualFile(), 0), true);
    }
}

