/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.actions;

import com.android.tools.idea.common.error.IssueModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.uibuilder.analytics.NlUsageTracker;
import com.google.wireless.android.sdk.stats.LayoutEditorEvent;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.util.IconUtil;
import icons.StudioIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class IssueNotificationAction
extends ToggleAction {
    public static final String NO_ISSUE = "No Issue";
    public static final String SHOW_ISSUE = "Show Warnings and Errors";
    private static final Icon DISABLED_ICON = IconUtil.desaturate((Icon)StudioIcons.Common.ERROR);
    private final DesignSurface mySurface;

    public IssueNotificationAction(@NotNull DesignSurface surface) {
        super(NO_ISSUE, NO_ISSUE, null);
        this.mySurface = surface;
    }

    public void update(@NotNull AnActionEvent event) {
        super.update(event);
        Presentation presentation = event.getPresentation();
        IssueModel issueModel = this.mySurface.getIssueModel();
        int markerCount = issueModel.getIssueCount();
        presentation.setText(markerCount == 0 ? NO_ISSUE : SHOW_ISSUE);
        presentation.setDescription(markerCount == 0 ? NO_ISSUE : SHOW_ISSUE);
        presentation.setIcon(IssueNotificationAction.getIssueTypeIcon(issueModel));
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        return !this.mySurface.getIssuePanel().isMinimized();
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        NlUsageTracker.getInstance(this.mySurface).logAction(LayoutEditorEvent.LayoutEditorEventType.SHOW_LINT_MESSAGES);
        this.mySurface.setShowIssuePanel(state);
    }

    @NotNull
    private static Icon getIssueTypeIcon(@NotNull IssueModel issueModel) {
        Icon icon2 = issueModel.getErrorCount() > 0 ? StudioIcons.Common.ERROR : (issueModel.getWarningCount() > 0 ? StudioIcons.Common.WARNING : (issueModel.getIssueCount() > 0 ? StudioIcons.Common.INFO : DISABLED_ICON));
        return icon2;
    }
}

