/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.analytics;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.uibuilder.property2.NelePropertyItem;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidAttribute;
import com.google.wireless.android.sdk.stats.AndroidView;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.FrameworkResourceManager;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UsageTrackerUtil {
    @VisibleForTesting
    public static final String CUSTOM_NAME = "CUSTOM";

    private UsageTrackerUtil() {
    }

    @NotNull
    public static AndroidAttribute convertAttribute(@NotNull NlProperty property2) {
        AndroidFacet facet = property2.getModel().getFacet();
        AttributeDefinition definition = property2.getDefinition();
        String libraryName = definition != null ? definition.getLibraryName() : null;
        AndroidAttribute.AttributeNamespace namespace = UsageTrackerUtil.convertNamespace(property2.getNamespace());
        return AndroidAttribute.newBuilder().setAttributeName(UsageTrackerUtil.convertAttributeName(property2.getName(), namespace, libraryName, facet)).setAttributeNamespace(namespace).build();
    }

    @NotNull
    public static AndroidAttribute convertAttribute(@NotNull NelePropertyItem property2) {
        AndroidFacet facet = property2.getModel().getFacet();
        AndroidAttribute.AttributeNamespace namespace = UsageTrackerUtil.convertNamespace(property2.getNamespace());
        return AndroidAttribute.newBuilder().setAttributeName(UsageTrackerUtil.convertAttributeName(property2.getName(), namespace, property2.getLibraryName(), facet)).setAttributeNamespace(namespace).build();
    }

    @NotNull
    public static AndroidAttribute convertAttribute(@NotNull String attributeName, @NotNull AndroidFacet facet) {
        AndroidAttribute.AttributeNamespace namespace = null;
        if (attributeName.startsWith("tools:")) {
            namespace = AndroidAttribute.AttributeNamespace.TOOLS;
            attributeName = StringUtil.trimStart((String)attributeName, (String)"tools:");
        }
        NamespaceAndLibraryNamePair lookup = UsageTrackerUtil.lookupAttributeResource(facet, attributeName);
        if (namespace == null) {
            namespace = lookup.getNamespace();
        }
        return AndroidAttribute.newBuilder().setAttributeName(UsageTrackerUtil.convertAttributeName(attributeName, lookup.getNamespace(), lookup.getLibraryName(), facet)).setAttributeNamespace(namespace).build();
    }

    @NotNull
    @VisibleForTesting
    static AndroidAttribute.AttributeNamespace convertNamespace(@Nullable String namespace) {
        if (StringUtil.isEmpty((String)namespace)) {
            return AndroidAttribute.AttributeNamespace.ANDROID;
        }
        switch (namespace) {
            case "http://schemas.android.com/tools": {
                return AndroidAttribute.AttributeNamespace.TOOLS;
            }
            case "http://schemas.android.com/apk/res/android": {
                return AndroidAttribute.AttributeNamespace.ANDROID;
            }
        }
        return AndroidAttribute.AttributeNamespace.APPLICATION;
    }

    @NotNull
    @VisibleForTesting
    static String convertAttributeName(@NotNull String attributeName, @NotNull AndroidAttribute.AttributeNamespace namespace, @Nullable String libraryName, @NotNull AndroidFacet facet) {
        switch (namespace) {
            case ANDROID: {
                return attributeName;
            }
            case APPLICATION: {
                return libraryName != null && UsageTrackerUtil.acceptedGoogleLibraryNamespace(libraryName) ? attributeName : CUSTOM_NAME;
            }
            case TOOLS: {
                NamespaceAndLibraryNamePair lookup = UsageTrackerUtil.lookupAttributeResource(facet, attributeName);
                assert (lookup.getNamespace() != AndroidAttribute.AttributeNamespace.TOOLS);
                return UsageTrackerUtil.convertAttributeName(attributeName, lookup.getNamespace(), lookup.getLibraryName(), facet);
            }
        }
        return CUSTOM_NAME;
    }

    @NotNull
    public static AndroidView convertTagName(@NotNull String tagName) {
        tagName = UsageTrackerUtil.acceptedGoogleTagNamespace(tagName) ? StringUtil.getShortName((String)tagName, (char)'.') : CUSTOM_NAME;
        return AndroidView.newBuilder().setTagName(tagName).build();
    }

    @VisibleForTesting
    static boolean acceptedGoogleLibraryNamespace(@NotNull String libraryName) {
        return libraryName.startsWith("com.android.") || libraryName.startsWith("com.google.") || libraryName.startsWith("constraint-layout") || libraryName.startsWith("flexbox") || libraryName.startsWith("design-") || libraryName.startsWith("appcompat-v7-") || libraryName.startsWith("cardview-v7-") || libraryName.startsWith("gridlayout-v7") || libraryName.startsWith("recyclerview-v7") || libraryName.startsWith("coordinatorlayout-v7") || libraryName.startsWith("play-services-maps-") || libraryName.startsWith("play-services-ads-") || libraryName.startsWith("leanback-v17-");
    }

    @VisibleForTesting
    static boolean acceptedGoogleTagNamespace(@NotNull String fullyQualifiedTagName) {
        return fullyQualifiedTagName.indexOf(46) < 0 || fullyQualifiedTagName.startsWith("com.android.") || fullyQualifiedTagName.startsWith("com.google.") || fullyQualifiedTagName.startsWith("android.support.") || fullyQualifiedTagName.startsWith("android.databinding.");
    }

    @NotNull
    @VisibleForTesting
    static NamespaceAndLibraryNamePair lookupAttributeResource(@NotNull AndroidFacet facet, @NotNull String attributeName) {
        ModuleResourceManagers resourceManagers = ModuleResourceManagers.getInstance(facet);
        FrameworkResourceManager frameworkResourceManager = resourceManagers.getFrameworkResourceManager();
        if (frameworkResourceManager == null) {
            return new NamespaceAndLibraryNamePair(AndroidAttribute.AttributeNamespace.APPLICATION);
        }
        LocalResourceManager localResourceManager = resourceManagers.getLocalResourceManager();
        AttributeDefinitions localAttributeDefinitions = ((ResourceManager)localResourceManager).getAttributeDefinitions();
        AttributeDefinitions systemAttributeDefinitions = ((ResourceManager)frameworkResourceManager).getAttributeDefinitions();
        if (systemAttributeDefinitions != null && systemAttributeDefinitions.getAttrs().contains(ResourceReference.attr((ResourceNamespace)ResourceNamespace.ANDROID, (String)attributeName))) {
            return new NamespaceAndLibraryNamePair(AndroidAttribute.AttributeNamespace.ANDROID);
        }
        if (localAttributeDefinitions == null) {
            return new NamespaceAndLibraryNamePair(AndroidAttribute.AttributeNamespace.APPLICATION);
        }
        AttributeDefinition definition = localAttributeDefinitions.getAttrDefinition(ResourceReference.attr((ResourceNamespace)ResourceNamespace.TODO(), (String)attributeName));
        if (definition == null) {
            return new NamespaceAndLibraryNamePair(AndroidAttribute.AttributeNamespace.APPLICATION);
        }
        return new NamespaceAndLibraryNamePair(AndroidAttribute.AttributeNamespace.APPLICATION, definition.getLibraryName());
    }

    @VisibleForTesting
    static class NamespaceAndLibraryNamePair {
        private final AndroidAttribute.AttributeNamespace myNamespace;
        private final String myLibraryName;

        @VisibleForTesting
        NamespaceAndLibraryNamePair(@NotNull AndroidAttribute.AttributeNamespace namespace) {
            this(namespace, null);
        }

        @VisibleForTesting
        NamespaceAndLibraryNamePair(@NotNull AndroidAttribute.AttributeNamespace namespace, @Nullable String libraryName) {
            this.myNamespace = namespace;
            this.myLibraryName = libraryName;
        }

        @NotNull
        public AndroidAttribute.AttributeNamespace getNamespace() {
            return this.myNamespace;
        }

        @Nullable
        public String getLibraryName() {
            return this.myLibraryName;
        }
    }
}

