/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.diagnostics;

import com.intellij.openapi.diagnostic.Logger;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\tJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\tJ\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\tH\u0002J\u0006\u0010\u0015\u001a\u00020\u0012J\u000e\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\tJ\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\tH\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R9\u0010\u0007\u001a*\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bj\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n`\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/common/diagnostics/PerfDebugHelper;", "", "()V", "DEBUG", "", "getDEBUG", "()Z", "myStats", "Ljava/util/HashMap;", "", "Ljava/util/LinkedList;", "", "Lkotlin/collections/HashMap;", "getMyStats", "()Ljava/util/HashMap;", "avg", "name", "end", "", "log", "msg", "print", "start", "uneven", "intellij.android.designer"})
public final class PerfDebugHelper {
    private final boolean DEBUG = false;
    @NotNull
    private final HashMap<String, LinkedList<Long>> myStats = new HashMap();

    public final boolean getDEBUG() {
        return this.DEBUG;
    }

    @NotNull
    public final HashMap<String, LinkedList<Long>> getMyStats() {
        return this.myStats;
    }

    public final void start(@NotNull String name) {
        if (!this.DEBUG) {
            return;
        }
        long current = System.currentTimeMillis();
        LinkedList<Long> elapsedList = this.myStats.get(name);
        if (elapsedList == null) {
            elapsedList = new LinkedList();
            Map map2 = this.myStats;
            LinkedList<Long> linkedList = elapsedList;
            boolean bl = false;
            map2.put(name, linkedList);
        }
        if (elapsedList.size() % 2 != 0) {
            this.uneven(name);
            return;
        }
        elapsedList.add(current);
    }

    public final void end(@NotNull String name) {
        if (!this.DEBUG) {
            return;
        }
        long current = System.currentTimeMillis();
        LinkedList<Long> list = this.myStats.get(name);
        if (list == null || list.size() % 2 != 1) {
            this.uneven(name);
            return;
        }
        list.add(current);
    }

    private final void uneven(String name) {
        this.log(name + " has uneven start/end callsites. Unable to proceed.");
    }

    private final void log(String msg) {
        Logger.getInstance(PerfDebugHelper.class).warn(msg);
    }

    /*
     * WARNING - void declaration
     */
    public final long avg(@NotNull String name) {
        if (!this.DEBUG) {
            return -1L;
        }
        LinkedList<Long> list = this.myStats.get(name);
        if (list == null || list.isEmpty() || list.size() % 2 != 0) {
            this.uneven(name);
            return -1L;
        }
        int halfSize = list.size() / 2;
        long sum = 0L;
        int n = 0;
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)new IntRange(n, halfSize - 1)), (int)1);
        int n2 = intProgression.getFirst();
        int n3 = intProgression.getLast();
        int n4 = intProgression.getStep();
        int n5 = n2;
        int n6 = n3;
        if (n4 > 0 ? n5 <= n6 : n5 >= n6) {
            while (true) {
                void i2;
                long start = ((Number)list.get((int)(i2 * 2))).longValue();
                long end = ((Number)list.get((int)(i2 * 2 + true))).longValue();
                sum += end - start;
                if (i2 == n3) break;
                i2 += n4;
            }
        }
        return sum / (long)halfSize;
    }

    public final void print() {
        if (!this.DEBUG) {
            return;
        }
        this.log("------");
        Map map2 = this.myStats;
        boolean bl = false;
        for (Map.Entry entry : map2.entrySet()) {
            this.log((String)entry.getKey() + " : " + this.avg((String)entry.getKey()));
        }
        this.log("------");
    }
}

