/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.editor;

import com.android.tools.idea.common.editor.ActionsToolbar;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.surface.DesignSurface;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ActionManager<S extends DesignSurface> {
    protected final S mySurface;

    protected ActionManager(@NotNull S surface) {
        this.mySurface = surface;
    }

    private void registerAction(@NotNull AnAction action2, @NotNull ShortcutSet shortcutSet2, @NotNull JComponent component, @Nullable Disposable parentDisposable) {
        Object disposable = parentDisposable != null ? parentDisposable : (component instanceof Disposable ? (Disposable)component : this.mySurface);
        action2.registerCustomShortcutSet(shortcutSet2, component, disposable);
    }

    protected final void registerAction(@NotNull AnAction action2, @NonNls String actionId, @NotNull JComponent component, @Nullable Disposable parentDisposable) {
        this.registerAction(action2, com.intellij.openapi.actionSystem.ActionManager.getInstance().getAction(actionId).getShortcutSet(), component, parentDisposable);
    }

    protected final void registerAction(@NotNull AnAction action2, @NotNull KeyStroke keyStroke, @NotNull JComponent component, @Nullable Disposable parentDisposable) {
        this.registerAction(action2, (ShortcutSet)new CustomShortcutSet(keyStroke), component, parentDisposable);
    }

    @NotNull
    public JComponent createToolbar() {
        return new ActionsToolbar((Disposable)this.mySurface, (DesignSurface)((Object)this.mySurface)).getToolbarComponent();
    }

    public final void showPopup(@NotNull MouseEvent event, @Nullable NlComponent leafComponent) {
        DefaultActionGroup group = this.getPopupMenuActions(leafComponent);
        if (group.getChildrenCount() == 0) {
            return;
        }
        com.intellij.openapi.actionSystem.ActionManager actionManager = com.intellij.openapi.actionSystem.ActionManager.getInstance();
        ActionPopupMenu popupMenu = actionManager.createActionPopupMenu("LayoutEditor", (ActionGroup)group);
        Object invoker = event.getSource() instanceof Component ? (Component)event.getSource() : this.mySurface;
        popupMenu.getComponent().show((Component)invoker, event.getX(), event.getY());
    }

    @Nullable
    protected static AnAction getRegisteredActionByName(@NotNull String actionName) {
        return com.intellij.openapi.actionSystem.ActionManager.getInstance().getAction(actionName);
    }

    public abstract void registerActionsShortcuts(@NotNull JComponent var1, @Nullable Disposable var2);

    @NotNull
    public abstract DefaultActionGroup getPopupMenuActions(@Nullable NlComponent var1);

    @NotNull
    public abstract DefaultActionGroup getToolbarActions(@Nullable NlComponent var1, @NotNull List<NlComponent> var2);
}

