/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.editor;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.adtui.common.AdtPrimaryPanel;
import com.android.tools.adtui.workbench.ToolWindowDefinition;
import com.android.tools.adtui.workbench.WorkBench;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.common.editor.DesignerEditor;
import com.android.tools.idea.common.error.IssuePanelSplitter;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.concurrent.EdtExecutor;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.startup.ClearResourceCacheAfterFirstBuild;
import com.android.tools.idea.util.SyncUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DesignerEditorPanel
extends JPanel
implements Disposable {
    private static final String DESIGN_UNAVAILABLE_MESSAGE = "Design editor is unavailable until after a successful project sync";
    @NotNull
    private final DesignerEditor myEditor;
    @NotNull
    private final Project myProject;
    @NotNull
    private final VirtualFile myFile;
    @NotNull
    private final DesignSurface mySurface;
    @NotNull
    private final JPanel myContentPanel;
    @NotNull
    private final WorkBench<DesignSurface> myWorkBench;
    private JBSplitter mySplitter;
    @Nullable
    private final JPanel myAccessoryPanel;
    @NotNull
    private final Function<AndroidFacet, List<ToolWindowDefinition<DesignSurface>>> myToolWindowDefinitions;

    public DesignerEditorPanel(@NotNull DesignerEditor editor2, @NotNull Project project, @NotNull VirtualFile file, @NotNull WorkBench<DesignSurface> workBench, @NotNull Function<DesignerEditorPanel, DesignSurface> surface, @NotNull Function<AndroidFacet, List<ToolWindowDefinition<DesignSurface>>> toolWindowDefinitions) {
        super(new BorderLayout());
        this.myEditor = editor2;
        this.myProject = project;
        this.myFile = file;
        this.myWorkBench = workBench;
        this.myWorkBench.setOpaque(true);
        this.myContentPanel = new AdtPrimaryPanel((LayoutManager)new BorderLayout());
        this.mySurface = surface.apply(this);
        Disposer.register((Disposable)this, (Disposable)this.mySurface);
        this.myAccessoryPanel = this.mySurface.getAccessoryPanel();
        this.myContentPanel.add((Component)DesignerEditorPanel.createSurfaceToolbar(this.mySurface), "North");
        this.myWorkBench.setLoadingText("Loading...");
        this.mySplitter = new IssuePanelSplitter(this.mySurface, (JComponent)this.myWorkBench);
        this.add((Component)this.mySplitter);
        Disposer.register((Disposable)editor2, this.myWorkBench);
        this.myToolWindowDefinitions = toolWindowDefinitions;
        ClearResourceCacheAfterFirstBuild.getInstance(project).runWhenResourceCacheClean(this::initNeleModel, this::buildError);
    }

    @NotNull
    private static JComponent createSurfaceToolbar(@NotNull DesignSurface surface) {
        return surface.getActionManager().createToolbar();
    }

    private void buildError() {
        this.myWorkBench.loadingStopped(DESIGN_UNAVAILABLE_MESSAGE);
    }

    public void initNeleModel() {
        SyncUtil.runWhenSmartAndSynced(this.myProject, this, result2 -> {
            if (result2.isSuccessful()) {
                this.initNeleModelWhenSmart();
            } else {
                this.buildError();
                SyncUtil.listenUntilNextSync(this.myProject, this, ignore -> this.initNeleModel());
            }
        });
    }

    private void initNeleModelWhenSmart() {
        if (Disposer.isDisposed((Disposable)this.myEditor)) {
            return;
        }
        CompletableFuture.supplyAsync(() -> {
            XmlFile file = (XmlFile)ReadAction.compute(() -> this.getFile());
            AndroidFacet facet = AndroidFacet.getInstance((PsiElement)file);
            assert (facet != null);
            return NlModel.create((Disposable)this.myEditor, facet, this.myFile, this.mySurface.getConfigurationManager(facet), this.mySurface.getComponentRegistrar());
        }, AppExecutorUtil.getAppExecutorService()).whenComplete((model2, exception) -> {
            this.mySurface.goingToSetModel((NlModel)model2).join();
            if (exception == null) {
                this.myWorkBench.setLoadingText("Waiting for build to finish...");
                SyncUtil.runWhenSmartAndSyncedOnEdt(this.myProject, this, result2 -> {
                    if (result2.isSuccessful()) {
                        this.initNeleModelOnEventDispatchThread((NlModel)model2);
                    } else {
                        this.buildError();
                        SyncUtil.listenUntilNextSync(this.myProject, this, ignore -> this.initNeleModel());
                    }
                });
            } else {
                this.myWorkBench.loadingStopped("Failed to initialize editor");
                Logger.getInstance(DesignerEditorPanel.class).warn("Failed to initialize DesignerEditorPanel", exception);
            }
        });
    }

    @UiThread
    private void initNeleModelOnEventDispatchThread(@NotNull NlModel model2) {
        if (Disposer.isDisposed((Disposable)model2)) {
            return;
        }
        CompletableFuture<Void> modelSetFuture = this.mySurface.setModel(model2);
        if (this.myAccessoryPanel != null) {
            boolean verticalSplitter = (Boolean)StudioFlags.NELE_MOTION_HORIZONTAL.get();
            OnePixelSplitter splitter = new OnePixelSplitter(verticalSplitter, 1.0f, 0.5f, 1.0f);
            splitter.setHonorComponentsMinimumSize(true);
            splitter.setFirstComponent((JComponent)((Object)this.mySurface));
            splitter.setSecondComponent((JComponent)this.myAccessoryPanel);
            this.myContentPanel.add((Component)splitter, "Center");
        } else {
            this.myContentPanel.add((Component)((Object)this.mySurface), "Center");
        }
        modelSetFuture.whenCompleteAsync((result2, ex) -> this.myWorkBench.init((JComponent)this.myContentPanel, (Object)this.mySurface, this.myToolWindowDefinitions.apply(model2.getFacet())), (Executor)EdtExecutor.INSTANCE);
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.mySurface.getPreferredFocusedComponent();
    }

    public void activate() {
        this.mySurface.activate();
    }

    public void deactivate() {
        this.mySurface.deactivate();
    }

    @NotNull
    public DesignSurface getSurface() {
        return this.mySurface;
    }

    @NotNull
    private XmlFile getFile() {
        XmlFile file = (XmlFile)AndroidPsiUtils.getPsiFileSafely(this.myProject, this.myFile);
        assert (file != null);
        return file;
    }

    public void setIssuePanelProportion(float proportion) {
        this.mySplitter.setProportion(proportion);
    }

    public void dispose() {
    }

    @NotNull
    public WorkBench<DesignSurface> getWorkBench() {
        return this.myWorkBench;
    }
}

