/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.editor;

import com.android.tools.idea.AndroidPsiUtils;
import com.intellij.codeInsight.hint.ImplementationViewComponent;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import java.util.Arrays;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.uipreview.AndroidEditorSettings;
import org.jetbrains.annotations.NotNull;

public abstract class DesignerEditorProvider
implements FileEditorProvider,
DumbAware {
    private static final String CALLER_NAME_OF_QUICK_DEFINITION = ImplementationViewComponent.class.getName();

    public boolean accept(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        PsiFile psiFile = AndroidPsiUtils.getPsiFileSafely(project, virtualFile);
        if (psiFile instanceof XmlFile) {
            XmlFile xmlFile = (XmlFile)psiFile;
            AndroidFacet facet = AndroidFacet.getInstance((PsiElement)xmlFile);
            return facet != null && this.acceptAndroidFacetXml(xmlFile);
        }
        return false;
    }

    @NotNull
    public abstract FileEditor createEditor(@NotNull Project var1, @NotNull VirtualFile var2);

    @NotNull
    public abstract String getEditorTypeId();

    protected abstract boolean acceptAndroidFacetXml(@NotNull XmlFile var1);

    @NotNull
    public FileEditorPolicy getPolicy() {
        if (AndroidEditorSettings.getInstance().getGlobalState().isPreferXmlEditor()) {
            return FileEditorPolicy.PLACE_AFTER_DEFAULT_EDITOR;
        }
        if (Arrays.stream(Thread.currentThread().getStackTrace()).anyMatch(element -> CALLER_NAME_OF_QUICK_DEFINITION.equals(element.getClassName()))) {
            return FileEditorPolicy.PLACE_AFTER_DEFAULT_EDITOR;
        }
        return FileEditorPolicy.PLACE_BEFORE_DEFAULT_EDITOR;
    }
}

