/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.error;

import com.android.tools.idea.common.model.NlComponent;
import com.intellij.lang.annotation.HighlightSeverity;
import java.util.stream.Stream;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Issue {
    public static final String EXECUTE_FIX = "Execute Fix: ";

    @NotNull
    public abstract String getSummary();

    @NotNull
    public abstract String getDescription();

    @NotNull
    public abstract HighlightSeverity getSeverity();

    @Nullable
    public abstract NlComponent getSource();

    @NotNull
    public abstract String getCategory();

    @Nullable
    public HyperlinkListener getHyperlinkListener() {
        return null;
    }

    @NotNull
    public Stream<Fix> getFixes() {
        return Stream.empty();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Issue)) {
            return false;
        }
        Issue issue2 = (Issue)object;
        return issue2.getSeverity().equals((Object)this.getSeverity()) && issue2.getSummary().equals(this.getSummary()) && issue2.getDescription().equals(this.getDescription()) && issue2.getCategory().equals(this.getCategory()) && issue2.getSource() == this.getSource();
    }

    public int hashCode() {
        int result2 = 13;
        result2 += 17 * this.getSeverity().hashCode();
        result2 += 19 * this.getSummary().hashCode();
        result2 += 23 * this.getDescription().hashCode();
        result2 += 29 * this.getCategory().hashCode();
        NlComponent source = this.getSource();
        if (source != null) {
            result2 += 31 * source.hashCode();
        }
        return result2;
    }

    public static class Fix {
        String myDescription;
        Runnable myRunnable;

        public Fix(@NotNull String description, @NotNull Runnable runnable) {
            this.myDescription = description;
            this.myRunnable = runnable;
        }

        @NotNull
        public String getDescription() {
            return this.myDescription;
        }

        @NotNull
        public Runnable getRunnable() {
            return this.myRunnable;
        }
    }
}

