/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.error;

import com.android.tools.idea.common.error.Issue;
import com.android.tools.idea.common.error.IssueProvider;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.util.ListenerCollection;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ModalityState;
import com.intellij.ui.GuiUtils;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IssueModel {
    private ImmutableList<Issue> myIssues = ImmutableList.of();
    private final ListenerCollection<IssueModelListener> myListeners = ListenerCollection.createWithExecutor(command -> GuiUtils.invokeLaterIfNeeded((Runnable)command, (ModalityState)ModalityState.defaultModalityState()));
    protected int myWarningCount;
    protected int myErrorCount;
    public final Runnable myUpdateCallback = () -> this.updateErrorsList();
    private List<IssueProvider> myIssueProviders = new ArrayList<IssueProvider>();

    public void updateErrorsList() {
        this.myWarningCount = 0;
        this.myErrorCount = 0;
        ImmutableList.Builder issueListBuilder = ImmutableList.builder();
        for (IssueProvider provider : ImmutableList.copyOf(this.myIssueProviders)) {
            provider.collectIssues((ImmutableCollection.Builder<Issue>)issueListBuilder);
        }
        this.myIssues = issueListBuilder.build();
        this.myIssues.forEach(issue2 -> this.updateIssuesCounts((Issue)issue2));
        this.myListeners.forEach(IssueModelListener::errorModelChanged);
    }

    private void updateIssuesCounts(@NotNull Issue issue2) {
        if (issue2.getSeverity().equals((Object)HighlightSeverity.WARNING)) {
            ++this.myWarningCount;
        } else if (issue2.getSeverity().equals((Object)HighlightSeverity.ERROR)) {
            ++this.myErrorCount;
        }
    }

    public void addIssueProvider(@NotNull IssueProvider issueProvider) {
        this.myIssueProviders.add(issueProvider);
        issueProvider.addListener(this.myUpdateCallback);
        this.updateErrorsList();
    }

    public void removeIssueProvider(@NotNull IssueProvider issueProvider) {
        this.myIssueProviders.remove(issueProvider);
        issueProvider.removeListener(this.myUpdateCallback);
        this.updateErrorsList();
    }

    @NotNull
    public ImmutableList<Issue> getIssues() {
        return this.myIssues;
    }

    public int getIssueCount() {
        return this.myIssues.size();
    }

    public void addErrorModelListener(@NotNull IssueModelListener listener2) {
        this.myListeners.add(listener2);
    }

    public void removeErrorModelListener(@NotNull IssueModelListener listener2) {
        this.myListeners.remove(listener2);
    }

    public int getWarningCount() {
        return this.myWarningCount;
    }

    public int getErrorCount() {
        return this.myErrorCount;
    }

    public boolean hasIssues() {
        return !this.myIssues.isEmpty();
    }

    @Nullable
    public Issue findIssue(@NotNull NlComponent component) {
        for (Issue issue2 : this.myIssues) {
            if (!component.equals(issue2.getSource())) continue;
            return issue2;
        }
        return null;
    }

    public static interface IssueModelListener {
        public void errorModelChanged();
    }
}

