/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.lint;

import com.android.ide.common.rendering.api.ResourceReference;
import com.android.tools.idea.common.lint.AttributeKey;
import com.android.tools.idea.common.lint.LintAnnotationsModel;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.lint.detector.api.Issue;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeHighlighting.HighlightingPass;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import java.lang.ref.WeakReference;
import org.jetbrains.android.inspections.lint.AndroidLintExternalAnnotator;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintUtil;
import org.jetbrains.android.inspections.lint.ProblemData;
import org.jetbrains.android.inspections.lint.State;
import org.jetbrains.annotations.NotNull;

public class LintHighlightingPass
implements HighlightingPass {
    private final WeakReference<DesignSurface> mySurfaceRef;
    private LintAnnotationsModel myLintAnnotationsModel;

    public LintHighlightingPass(@NotNull DesignSurface surface) {
        this.mySurfaceRef = new WeakReference<DesignSurface>(surface);
    }

    public void collectInformation(@NotNull ProgressIndicator progress) {
        this.myLintAnnotationsModel = null;
        DesignSurface surface = (DesignSurface)((Object)this.mySurfaceRef.get());
        if (surface == null) {
            return;
        }
        SceneView sceneView = surface.getCurrentSceneView();
        if (sceneView == null) {
            return;
        }
        this.myLintAnnotationsModel = LintHighlightingPass.getAnnotations(sceneView.getModel(), progress);
    }

    public void applyInformationToEditor() {
        DesignSurface surface = (DesignSurface)((Object)this.mySurfaceRef.get());
        if (surface == null) {
            return;
        }
        SceneView sceneView = surface.getCurrentSceneView();
        if (sceneView == null || this.myLintAnnotationsModel == null) {
            return;
        }
        sceneView.getModel().setLintAnnotationsModel(this.myLintAnnotationsModel);
        surface.setLintAnnotationsModel(this.myLintAnnotationsModel);
        sceneView.getSurface().repaint();
    }

    @NotNull
    private static LintAnnotationsModel getAnnotations(@NotNull NlModel model2, @NotNull ProgressIndicator progress) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        LintAnnotationsModel lintModel = new LintAnnotationsModel();
        XmlFile xmlFile = model2.getFile();
        AndroidLintExternalAnnotator annotator = new AndroidLintExternalAnnotator();
        State state = annotator.collectInformation((PsiFile)xmlFile);
        if (state != null) {
            state = annotator.doAnnotate(state);
        }
        if (state == null) {
            return lintModel;
        }
        for (ProblemData problemData : state.getProblems()) {
            AndroidLintInspectionBase inspection;
            NlComponent component;
            if (progress.isCanceled()) break;
            TextRange range = problemData.getTextRange();
            PsiElement startElement = xmlFile.findElementAt(range.getStartOffset());
            PsiElement endElement = xmlFile.findElementAt(range.getEndOffset());
            if (startElement == null || endElement == null || (component = model2.findViewByPsi(startElement)) == null) continue;
            ResourceReference attribute = model2.findAttributeByPsi(startElement);
            AttributeKey attributeKey = attribute != null ? new AttributeKey(component, attribute.getNamespace().getXmlNamespaceUri(), attribute.getName()) : null;
            Issue issue2 = problemData.getIssue();
            Pair<AndroidLintInspectionBase, HighlightDisplayLevel> pair = AndroidLintUtil.getHighlightLevelAndInspection(xmlFile.getProject(), issue2, (PsiElement)xmlFile);
            if (pair == null || (inspection = (AndroidLintInspectionBase)((Object)pair.getFirst())) == null) continue;
            HighlightDisplayLevel level = (HighlightDisplayLevel)pair.getSecond();
            HighlightDisplayKey key = HighlightDisplayKey.find((String)inspection.getShortName());
            if (key == null) continue;
            lintModel.addIssue(component, attributeKey, issue2, problemData.getMessage(), inspection, level, startElement, endElement, problemData.getQuickfixData());
        }
        return lintModel;
    }
}

