/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.model;

import com.android.resources.Density;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.configurations.Configuration;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Coordinates {
    public static final float DEFAULT_DENSITY = Density.DEFAULT_DENSITY;

    public static int getSwingX(@NotNull SceneView view, int androidX) {
        return view.getX() + view.getContentTranslationX() + (int)Math.round(view.getScale() * (double)androidX);
    }

    public static float getSwingX(@NotNull SceneView view, float androidX) {
        return (float)(view.getX() + view.getContentTranslationX()) + (float)view.getScale() * androidX;
    }

    public static int getSwingY(@NotNull SceneView view, int androidY) {
        return view.getY() + view.getContentTranslationY() + (int)Math.round(view.getScale() * (double)androidY);
    }

    public static float getSwingY(@NotNull SceneView view, float androidY) {
        return (float)(view.getY() + view.getContentTranslationY()) + (float)view.getScale() * androidY;
    }

    public static int getSwingDimension(@NotNull SceneView view, int androidDimension) {
        return (int)Math.round(view.getScale() * (double)androidDimension);
    }

    public static int getSwingDimension(@NotNull DesignSurface surface, int androidDimension) {
        return (int)Math.round(surface.getScale() * (double)androidDimension);
    }

    public static int getSwingDimension(@NotNull SceneContext sceneContext, int androidDimension) {
        return (int)Math.round(sceneContext.getScale() * (double)androidDimension);
    }

    public static float getSwingDimension(@NotNull SceneView view, float androidDimension) {
        return (float)view.getScale() * androidDimension;
    }

    public static int dpToPx(@NotNull SceneView view, int androidDp) {
        return Coordinates.dpToPx(view.getSurface(), (float)androidDp);
    }

    @Deprecated
    public static int pxToDp(@NotNull NlModel model2, int androidPx) {
        Configuration configuration = model2.getConfiguration();
        int dpiValue = configuration.getDensity().getDpiValue();
        return Math.round((float)androidPx * (DEFAULT_DENSITY / (float)dpiValue));
    }

    public static int dpToPx(@NotNull SceneView view, float androidDp) {
        return Coordinates.dpToPx(view.getSurface(), androidDp);
    }

    public static int pxToDp(@NotNull SceneView view, int androidPx) {
        return Coordinates.pxToDp(view.getSurface(), androidPx);
    }

    public static int dpToPx(@NotNull DesignSurface surface, float androidDp) {
        return Math.round(androidDp * surface.getSceneScalingFactor());
    }

    public static int pxToDp(@NotNull DesignSurface surface, int androidPx) {
        return Math.round((float)androidPx / surface.getSceneScalingFactor());
    }

    public static int getSwingXDip(@NotNull SceneView view, int androidDpX) {
        return Coordinates.getSwingX(view, Coordinates.dpToPx(view.getSurface(), (float)androidDpX));
    }

    public static float getSwingXDip(@NotNull SceneView view, float androidDpX) {
        return Coordinates.getSwingX(view, view.getSceneScalingFactor() * androidDpX);
    }

    public static int getSwingYDip(@NotNull SceneView view, int androidDpY) {
        return Coordinates.getSwingY(view, Coordinates.dpToPx(view.getSurface(), (float)androidDpY));
    }

    public static float getSwingYDip(@NotNull SceneView view, float androidDpX) {
        return Coordinates.getSwingY(view, view.getSceneScalingFactor() * androidDpX);
    }

    public static int getSwingDimensionDip(@NotNull SceneView view, int androidDpDimension) {
        return Coordinates.getSwingDimension(view, Coordinates.dpToPx(view.getSurface(), (float)androidDpDimension));
    }

    public static float getSwingDimensionDip(@NotNull SceneView view, float androidDpDimension) {
        return Coordinates.getSwingDimension(view, view.getSceneScalingFactor() * androidDpDimension);
    }

    public static Rectangle getSwingRectDip(@NotNull SceneView view, @NotNull Rectangle rect) {
        return new Rectangle(Coordinates.getSwingXDip(view, rect.x), Coordinates.getSwingYDip(view, rect.y), Coordinates.getSwingDimensionDip(view, rect.width), Coordinates.getSwingDimensionDip(view, rect.height));
    }

    public static Rectangle2D.Float getSwingRectDip(@NotNull SceneView view, @NotNull Rectangle2D.Float rect) {
        return new Rectangle2D.Float(Coordinates.getSwingXDip(view, rect.x), Coordinates.getSwingYDip(view, rect.y), Coordinates.getSwingDimensionDip(view, rect.width), Coordinates.getSwingDimensionDip(view, rect.height));
    }

    public static Rectangle2D.Float getSwingRectDip(@NotNull SceneContext context, @NotNull Rectangle2D.Float rect) {
        return new Rectangle2D.Float(context.getSwingXDip(rect.x), context.getSwingYDip(rect.y), context.getSwingDimensionDip(rect.width), context.getSwingDimensionDip(rect.height));
    }

    public static Rectangle getSwingRect(@NotNull SceneView view, @NotNull Rectangle rect) {
        return new Rectangle(Coordinates.getSwingX(view, rect.x), Coordinates.getSwingY(view, rect.y), Coordinates.getSwingDimension(view, rect.width), Coordinates.getSwingDimension(view, rect.height));
    }

    public static Rectangle getSwingRect(@NotNull SceneContext context, @NotNull Rectangle rect) {
        return new Rectangle(context.getSwingX(rect.x), context.getSwingY(rect.y), Coordinates.getSwingDimension(context, rect.width), Coordinates.getSwingDimension(context, rect.height));
    }

    public static int getAndroidX(@NotNull SceneView view, int swingX) {
        return (int)Math.round((double)(swingX - view.getX() - view.getContentTranslationX()) / view.getScale());
    }

    public static int getAndroidXDip(@NotNull SceneView view, int swingX) {
        return Coordinates.pxToDp(view, Coordinates.getAndroidX(view, swingX));
    }

    public static int getAndroidY(@NotNull SceneView view, int swingY) {
        return (int)Math.round((double)(swingY - view.getY() - view.getContentTranslationY()) / view.getScale());
    }

    public static int getAndroidYDip(@NotNull SceneView view, int swingY) {
        return Coordinates.pxToDp(view, Coordinates.getAndroidY(view, swingY));
    }

    @NotNull
    public static Point getAndroidCoordinate(@NotNull SceneView view, @NotNull Point coord) {
        return new Point(Coordinates.getAndroidX(view, coord.x), Coordinates.getAndroidY(view, coord.y));
    }

    public static int getAndroidDimension(@NotNull SceneView view, int swingDimension) {
        return (int)Math.round((double)swingDimension / view.getScale());
    }

    public static int getAndroidDimension(@NotNull DesignSurface surface, int swingDimension) {
        return (int)Math.round((double)swingDimension / surface.getScale());
    }

    public static int getAndroidDimensionDip(@NotNull SceneView view, int swingDimension) {
        return Coordinates.pxToDp(view, Coordinates.getAndroidDimension(view, swingDimension));
    }

    public static int getAndroidDimensionDip(@NotNull DesignSurface surface, int swingDimension) {
        return Coordinates.pxToDp(surface, Coordinates.getAndroidDimension(surface, swingDimension));
    }

    @Deprecated
    @Nullable
    public static NlComponent findComponent(@NotNull SceneView view, int swingX, int swingY) {
        SceneContext sceneContext = SceneContext.get(view);
        int x = Coordinates.getAndroidXDip(view, swingX);
        int y = Coordinates.getAndroidYDip(view, swingY);
        SceneComponent sceneComponent = view.getScene().findComponent(sceneContext, x, y);
        return sceneComponent != null ? sceneComponent.getNlComponent() : null;
    }

    public static void transformGraphics(@NotNull SceneView view, @NotNull Graphics2D gc) {
        gc.translate(view.getX(), view.getY());
        gc.scale(view.getScale(), view.getScale());
    }
}

