/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.model;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.DnDTransferComponent;
import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.model.NlComponentBackend;
import com.android.tools.idea.common.model.NlComponentBackendXml;
import com.android.tools.idea.common.model.NlComponentDelegate;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.rendering.parsers.AttributeSnapshot;
import com.android.tools.idea.rendering.parsers.TagSnapshot;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.uibuilder.model.AttributesHelperKt;
import com.android.tools.idea.uibuilder.model.QualifiedName;
import com.android.tools.idea.util.ListenerCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlComponent
implements NlAttributesHolder {
    @Nullable
    private XmlModelComponentMixin myMixin;
    private final List<NlComponent> children = Lists.newArrayList();
    @Nullable
    private List<NlComponent> cachedChildrenCopy = null;
    private NlComponent myParent;
    @NotNull
    private final NlModel myModel;
    @Nullable
    private TagSnapshot mySnapshot;
    @NotNull
    private NlComponentBackend myBackend;
    private final HashMap<Object, Object> myClientProperties = new HashMap();
    private final ListenerCollection<ChangeListener> myListeners = ListenerCollection.createWithDirectExecutor();
    private final ChangeEvent myChangeEvent = new ChangeEvent(this);
    private NlComponentDelegate myDelegate;
    @Nullable
    AttributesTransaction myCurrentTransaction;

    public NlComponent(@NotNull NlModel model2, @NotNull XmlTag tag) {
        this.myModel = model2;
        this.myBackend = new NlComponentBackendXml(model2.getProject(), tag);
    }

    public NlComponent(@NotNull NlModel model2, @NotNull XmlTag tag, @NotNull SmartPsiElementPointer<XmlTag> tagPointer) {
        this.myModel = model2;
        this.myBackend = new NlComponentBackendXml(model2.getProject(), tag, tagPointer);
    }

    @Nullable
    public NlComponentDelegate getDelegate() {
        return this.myDelegate;
    }

    public void setDelegate(@Nullable NlComponentDelegate delegate) {
        this.myDelegate = delegate;
    }

    public void setMixin(@NotNull XmlModelComponentMixin mixin) {
        assert (this.myMixin == null);
        this.myMixin = mixin;
    }

    @Nullable
    public XmlModelComponentMixin getMixin() {
        return this.myMixin;
    }

    @Nullable
    public XmlTag getTag() {
        return this.myBackend.getTag();
    }

    @Deprecated
    @NotNull
    public XmlTag getTagDeprecated() {
        return this.myBackend.getTagDeprecated();
    }

    @Deprecated
    @NotNull
    public SmartPsiElementPointer<XmlTag> getTagPointer() {
        return this.myBackend.getTagPointer();
    }

    @NotNull
    public NlModel getModel() {
        return this.myModel;
    }

    public void setTag(@NotNull XmlTag tag) {
        this.myBackend.setTagElement(tag);
    }

    @Deprecated
    @Nullable
    public TagSnapshot getSnapshot() {
        return this.mySnapshot;
    }

    public void setSnapshot(@Nullable TagSnapshot snapshot) {
        this.mySnapshot = snapshot;
    }

    public void addChild(@NotNull NlComponent component) {
        this.addChild(component, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(@NotNull NlComponent component, @Nullable NlComponent before) {
        if (component == this) {
            throw new IllegalArgumentException();
        }
        List<NlComponent> list = this.children;
        synchronized (list) {
            int index;
            this.cachedChildrenCopy = null;
            int n = index = before != null ? this.children.indexOf(before) : -1;
            if (index != -1) {
                this.children.add(index, component);
            } else {
                this.children.add(component);
            }
        }
        component.setParent(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChild(@NotNull NlComponent component) {
        if (component == this) {
            throw new IllegalArgumentException();
        }
        if (this.myDelegate != null) {
            this.myDelegate.willRemoveChild(component);
        }
        List<NlComponent> list = this.children;
        synchronized (list) {
            this.cachedChildrenCopy = null;
            this.children.remove(component);
        }
        component.setParent(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChildren(@Nullable List<NlComponent> components) {
        List<NlComponent> list = this.children;
        synchronized (list) {
            this.cachedChildrenCopy = null;
            this.children.clear();
            if (components == null) {
                return;
            }
            this.children.addAll(components);
        }
        for (NlComponent component : components) {
            if (component == this) {
                throw new IllegalArgumentException();
            }
            component.setParent(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<NlComponent> getChildren() {
        ImmutableList childrenCopy = this.cachedChildrenCopy;
        if (childrenCopy == null) {
            List<NlComponent> list = this.children;
            synchronized (list) {
                this.cachedChildrenCopy = childrenCopy = ImmutableList.copyOf(this.children);
            }
        }
        return childrenCopy;
    }

    public int getChildCount() {
        return this.getChildren().size();
    }

    @Nullable
    public NlComponent getChild(int index) {
        List<NlComponent> children = this.getChildren();
        return index >= 0 && index < children.size() ? children.get(index) : null;
    }

    @NotNull
    public Stream<NlComponent> flatten() {
        return Stream.concat(Stream.of(this), this.getChildren().stream().flatMap(NlComponent::flatten));
    }

    @Nullable
    public NlComponent getNextSibling() {
        if (this.myParent == null) {
            return null;
        }
        for (int index = 0; index < this.myParent.getChildCount(); ++index) {
            if (this.myParent.getChild(index) != this) continue;
            return this.myParent.getChild(index + 1);
        }
        return null;
    }

    @Nullable
    public NlComponent findViewByTag(@NotNull XmlTag tag) {
        if (this.getTagDeprecated() == tag) {
            return this;
        }
        for (NlComponent child : this.getChildren()) {
            NlComponent result2 = child.findViewByTag(tag);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    private void findViewsByTag(@NotNull XmlTag tag, @NotNull ImmutableList.Builder<NlComponent> builder) {
        for (NlComponent child : this.getChildren()) {
            child.findViewsByTag(tag, builder);
        }
        if (this.getTagDeprecated() == tag) {
            builder.add((Object)this);
        }
    }

    @NotNull
    public ImmutableList<NlComponent> findViewsByTag(@NotNull XmlTag tag) {
        ImmutableList.Builder builder = ImmutableList.builder();
        this.findViewsByTag(tag, (ImmutableList.Builder<NlComponent>)builder);
        return builder.build();
    }

    public boolean isRoot() {
        return !(this.getTagDeprecated().getParent() instanceof XmlTag);
    }

    public NlComponent getRoot() {
        NlComponent component;
        for (component = this; component != null && !component.isRoot(); component = component.getParent()) {
        }
        return component;
    }

    @Nullable
    public String getId() {
        String id = this.myCurrentTransaction != null ? this.myCurrentTransaction.getAndroidAttribute("id") : this.resolveAttribute("http://schemas.android.com/apk/res/android", "id");
        return NlComponent.stripId(id);
    }

    public void clearTransaction() {
        if (this.myCurrentTransaction != null) {
            this.myCurrentTransaction.finishTransaction();
        }
    }

    @Nullable
    public static String stripId(@Nullable String id) {
        if (id != null) {
            if (id.startsWith("@+id/")) {
                return id.substring("@+id/".length());
            }
            if (id.startsWith("@id/")) {
                return id.substring("@id/".length());
            }
        }
        return null;
    }

    @Nullable
    public NlComponent getParent() {
        return this.myParent;
    }

    private void setParent(@Nullable NlComponent parent) {
        this.myParent = parent;
    }

    @NotNull
    public String getTagName() {
        return this.myBackend.getTagName();
    }

    @NotNull
    public NlComponentBackend getBackend() {
        return this.myBackend;
    }

    public String toString() {
        if (this.getMixin() != null) {
            return this.getMixin().toString();
        }
        return String.format("<%s>", this.myBackend.getTagName());
    }

    @Override
    public void setAttribute(@Nullable String namespace, @NotNull String attribute, @Nullable String value2) {
        String previous;
        if (this.myDelegate != null && this.myDelegate.handlesAttribute(this, namespace, attribute)) {
            this.myDelegate.setAttribute(this, namespace, attribute, value2);
            return;
        }
        XmlTag tag = this.getTagDeprecated();
        if (!tag.isValid()) {
            return;
        }
        String prefix = null;
        if (namespace != null) {
            this.transferNamespaces(this);
            prefix = AndroidResourceUtil.ensureNamespaceImported((XmlFile)tag.getContainingFile(), namespace, null);
        }
        if (Objects.equals(previous = this.getAttribute(namespace, attribute), value2)) {
            return;
        }
        this.myBackend.setAttribute(attribute, namespace, value2);
        if (this.mySnapshot != null) {
            this.mySnapshot.setAttribute(attribute, namespace, prefix, value2);
        }
    }

    @NotNull
    public AttributesTransaction startAttributeTransaction() {
        if (this.myCurrentTransaction == null) {
            this.myCurrentTransaction = new AttributesTransaction(this);
        }
        return this.myCurrentTransaction;
    }

    @Nullable
    public String getLiveAttribute(@Nullable String namespace, @NotNull String attribute) {
        if (this.myCurrentTransaction != null) {
            return this.myCurrentTransaction.getAttribute(namespace, attribute);
        }
        if (this.myDelegate != null && this.myDelegate.handlesAttribute(this, namespace, attribute)) {
            return this.myDelegate.getAttribute(this, namespace, attribute);
        }
        return this.getAttribute(namespace, attribute);
    }

    @Override
    @Nullable
    public String getAttribute(@Nullable String namespace, @NotNull String attribute) {
        if (this.myDelegate != null && this.myDelegate.handlesAttribute(this, namespace, attribute)) {
            return this.myDelegate.getAttribute(this, namespace, attribute);
        }
        return this.getAttributeImpl(namespace, attribute);
    }

    @Nullable
    public String getAttributeImpl(@Nullable String namespace, @NotNull String attribute) {
        if (this.mySnapshot != null) {
            return this.mySnapshot.getAttribute(attribute, namespace);
        }
        return this.myBackend.getAttribute(attribute, namespace);
    }

    @Nullable
    public String resolveAttribute(@Nullable String namespace, @NotNull String attribute) {
        String value2 = this.getAttribute(namespace, attribute);
        if (value2 != null) {
            return value2;
        }
        if (this.getMixin() != null) {
            return this.getMixin().getAttribute(namespace, attribute);
        }
        return null;
    }

    @NotNull
    public List<AttributeSnapshot> getAttributes() {
        if (this.myDelegate != null && this.myDelegate.handlesAttributes(this)) {
            List<AttributeSnapshot> attributes = this.myDelegate.getAttributes(this);
            if (attributes != null) {
                return attributes;
            }
            return Collections.emptyList();
        }
        return this.getAttributesImpl();
    }

    @NotNull
    public List<AttributeSnapshot> getAttributesImpl() {
        if (this.mySnapshot != null) {
            return this.mySnapshot.attributes;
        }
        XmlTag tag = this.getTagDeprecated();
        if (tag.isValid()) {
            Application application = ApplicationManager.getApplication();
            if (!application.isReadAccessAllowed()) {
                return (List)application.runReadAction(() -> AttributeSnapshot.createAttributesForTag(tag));
            }
            return AttributeSnapshot.createAttributesForTag(tag);
        }
        return Collections.emptyList();
    }

    @Nullable
    public String ensureNamespace(@NotNull String suggestedPrefix, @NotNull String namespace) {
        XmlTag tag = this.getBackend().getTag();
        if (tag == null) {
            return null;
        }
        this.transferNamespaces(this);
        return AndroidResourceUtil.ensureNamespaceImported((XmlFile)tag.getContainingFile(), namespace, suggestedPrefix);
    }

    public boolean isShowing() {
        return this.mySnapshot != null;
    }

    @Nullable
    public static String extractId(@Nullable String str) {
        if (str == null) {
            return null;
        }
        int index = str.lastIndexOf("@id/");
        if (index != -1) {
            return str.substring(index + 4);
        }
        index = str.lastIndexOf("@+id/");
        if (index != -1) {
            return str.substring(index + 5);
        }
        return null;
    }

    public void removeObsoleteAttributes() {
        Set<QualifiedName> obsoleteAttributes = AttributesHelperKt.getObsoleteAttributes(this);
        AttributesTransaction transaction = this.startAttributeTransaction();
        obsoleteAttributes.forEach(qualifiedName -> transaction.removeAttribute(qualifiedName.getNamespace(), qualifiedName.getName()));
        transaction.commit();
    }

    public final void putClientProperty(Object key, Object value2) {
        this.myClientProperties.put(key, value2);
    }

    public final Object getClientProperty(Object key) {
        return this.myClientProperties.get(key);
    }

    public final Object removeClientProperty(Object key) {
        return this.myClientProperties.remove(key);
    }

    public void addLiveChangeListener(ChangeListener listener2) {
        this.myListeners.add(listener2);
    }

    public void removeLiveChangeListener(ChangeListener listener2) {
        this.myListeners.remove(listener2);
    }

    public void fireLiveChangeEvent() {
        this.myListeners.forEach(listener2 -> listener2.stateChanged(this.myChangeEvent));
    }

    @NotNull
    public String assignId() {
        return this.assignId(this.getTagName());
    }

    public String ensureId() {
        if (this.getId() != null) {
            return this.getId();
        }
        return this.assignId();
    }

    @NotNull
    public String assignId(@NotNull String baseName) {
        return this.assignId(baseName, this.getModel().getIds());
    }

    @NotNull
    private String assignId(@NotNull Set<String> ids) {
        return this.assignId(this.getTagName(), ids);
    }

    @NotNull
    private String assignId(@NotNull String baseName, @NotNull Set<String> ids) {
        String newId = NlComponent.generateId(baseName, ids, ResourceFolderType.LAYOUT, this.getModel().getModule());
        NlAttributesHolder attributes = this.myCurrentTransaction == null ? this : this.myCurrentTransaction;
        attributes.setAttribute("http://schemas.android.com/apk/res/android", "id", "@+id/" + newId);
        this.getModel().getPendingIds().add(newId);
        return newId;
    }

    public void incrementId(@NotNull Set<String> ids) {
        String id = this.getId();
        if (id == null || id.isEmpty()) {
            ids.add(this.assignId(ids));
        } else {
            String baseName = id.replaceAll("[0-9]*$", "");
            if (baseName != null && !baseName.isEmpty()) {
                ids.add(this.assignId(baseName, ids));
            }
        }
    }

    @NotNull
    public static String generateId(@NotNull String baseName, @NotNull Set<String> ids, ResourceFolderType type, Module module) {
        String idValue = StringUtil.decapitalize((String)baseName.substring(baseName.lastIndexOf(46) + 1));
        Project project = module.getProject();
        String nextIdValue = idValue = ResourceHelper.prependResourcePrefix(module, idValue, type);
        int index = 0;
        NamesValidator validator = (NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage((Language)JavaLanguage.INSTANCE);
        while (ids.contains(nextIdValue) || validator != null && validator.isKeyword(nextIdValue, project)) {
            if (!(++index != 1 || validator != null && validator.isKeyword(nextIdValue, project))) {
                nextIdValue = idValue;
                continue;
            }
            nextIdValue = idValue + index;
        }
        return idValue + (index == 0 ? "" : Integer.valueOf(index));
    }

    @Nullable
    public String getTooltipText() {
        XmlModelComponentMixin mixin = this.getMixin();
        if (mixin != null) {
            return mixin.getTooltipText();
        }
        return null;
    }

    public boolean canAddTo(NlComponent receiver) {
        XmlModelComponentMixin mixin = this.getMixin();
        if (mixin != null) {
            return mixin.canAddTo(receiver);
        }
        return true;
    }

    public void moveTo(@NotNull NlComponent receiver, @Nullable NlComponent before, @NotNull InsertType type, @NotNull Set<String> ids, @Nullable DesignSurface surface) {
        XmlModelComponentMixin mixin = this.getMixin();
        if (mixin != null) {
            mixin.beforeMove(type, receiver, ids);
        }
        NlComponent oldParent = this.getParent();
        this.addTags(receiver, before, type);
        if (mixin != null) {
            mixin.afterMove(type, oldParent, receiver, surface);
        }
    }

    public void addTags(@NotNull NlComponent receiver, @Nullable NlComponent before, @NotNull InsertType type) {
        XmlTag beforeTag;
        NlComponent parent = this.getParent();
        if (parent != null) {
            parent.removeChild(this);
        }
        XmlTag tag = this.getBackend().getTag();
        XmlTag receiverTag = receiver.getBackend().getTag();
        XmlTag xmlTag = beforeTag = before != null ? before.getBackend().getTag() : null;
        if (receiverTag == null || tag == null) {
            return;
        }
        if (receiverTag == tag) {
            return;
        }
        receiver.addChild(this, before);
        this.transferNamespaces(receiver);
        if (beforeTag != null) {
            this.setTag((XmlTag)receiverTag.addBefore((PsiElement)tag, (PsiElement)beforeTag));
        } else {
            this.setTag(receiverTag.addSubTag(tag, false));
        }
        if (type.isMove()) {
            tag.delete();
        }
    }

    public void postCreateFromTransferrable(@NotNull DnDTransferComponent dndComponent) {
        XmlModelComponentMixin mixin = this.getMixin();
        if (mixin != null) {
            mixin.postCreateFromTransferrable(dndComponent);
        }
    }

    public boolean postCreate(@Nullable DesignSurface surface, @NotNull InsertType insertType) {
        XmlModelComponentMixin mixin = this.getMixin();
        if (mixin != null) {
            return mixin.postCreate(surface, insertType);
        }
        return true;
    }

    private void transferNamespaces(@NotNull NlComponent receiver) {
        NlComponent root = receiver.getRoot();
        while (receiver != null && receiver != root) {
            XmlTag tag = receiver.getTag();
            if (tag != null && !tag.getLocalNamespaceDeclarations().isEmpty()) {
                receiver.transferLocalNamespaces(root);
            }
            receiver = receiver.getParent();
        }
        if (receiver != this) {
            this.transferLocalNamespaces(root);
        }
    }

    private void transferLocalNamespaces(@NotNull NlComponent root) {
        XmlTag rootTag = root.getTag();
        XmlTag tag = this.getTag();
        if (tag == null || rootTag == null || rootTag == tag) {
            return;
        }
        Map prefixToNamespace = rootTag.getLocalNamespaceDeclarations();
        HashMap namespaceToPrefix = Maps.newHashMap();
        for (Map.Entry entry : prefixToNamespace.entrySet()) {
            namespaceToPrefix.put(entry.getValue(), entry.getKey());
        }
        HashMap oldPrefixToPrefix = Maps.newHashMap();
        for (Map.Entry entry : tag.getLocalNamespaceDeclarations().entrySet()) {
            String namespace = (String)entry.getValue();
            String prefix = (String)entry.getKey();
            String currentPrefix = (String)namespaceToPrefix.get(namespace);
            if (currentPrefix == null) {
                XmlFile file = this.getModel().getFile();
                String newPrefix = AndroidResourceUtil.ensureNamespaceImported(file, namespace, prefix);
                if (prefix.equals(newPrefix)) continue;
                oldPrefixToPrefix.put(prefix, newPrefix);
                namespaceToPrefix.put(namespace, newPrefix);
                continue;
            }
            if (prefix.equals(currentPrefix)) continue;
            oldPrefixToPrefix.put(prefix, currentPrefix);
        }
        if (!oldPrefixToPrefix.isEmpty()) {
            NlComponent.updatePrefixes(tag, oldPrefixToPrefix);
        }
        this.removeNamespaceAttributes();
    }

    private static void updatePrefixes(@NotNull XmlTag tag, @NotNull Map<String, String> oldPrefixToPrefix) {
        for (XmlAttribute xmlAttribute : tag.getAttributes()) {
            String newPrefix;
            String prefix = xmlAttribute.getNamespacePrefix();
            if (prefix.isEmpty()) continue;
            if (prefix.equals("xmlns")) {
                newPrefix = oldPrefixToPrefix.get(xmlAttribute.getLocalName());
                if (newPrefix == null) continue;
                xmlAttribute.setName("xmlns:" + newPrefix);
                continue;
            }
            newPrefix = oldPrefixToPrefix.get(prefix);
            if (newPrefix == null) continue;
            xmlAttribute.setName(newPrefix + ':' + xmlAttribute.getLocalName());
        }
        for (XmlAttribute xmlAttribute : tag.getSubTags()) {
            NlComponent.updatePrefixes((XmlTag)xmlAttribute, oldPrefixToPrefix);
        }
    }

    private void removeNamespaceAttributes() {
        XmlTag tag = this.getTag();
        if (tag != null) {
            for (XmlAttribute attribute : tag.getAttributes()) {
                if (!attribute.getName().startsWith("xmlns:")) continue;
                attribute.delete();
            }
        }
    }

    public Set<String> getDependencies() {
        XmlModelComponentMixin mixin = this.getMixin();
        if (mixin != null) {
            return mixin.getDependencies();
        }
        return ImmutableSet.of();
    }

    public static abstract class XmlModelComponentMixin {
        private final NlComponent myComponent;

        public XmlModelComponentMixin(@NotNull NlComponent component) {
            this.myComponent = component;
        }

        @NotNull
        protected NlComponent getComponent() {
            return this.myComponent;
        }

        @Nullable
        public String getAttribute(@Nullable String namespace, @NotNull String attribute) {
            return null;
        }

        public String toString() {
            return String.format("<%s>", this.myComponent.getTagName());
        }

        @Nullable
        public String getTooltipText() {
            return null;
        }

        public boolean canAddTo(@NotNull NlComponent receiver) {
            return true;
        }

        public Set<String> getDependencies() {
            return ImmutableSet.of();
        }

        public void beforeMove(@NotNull InsertType insertType, @NotNull NlComponent receiver, @NotNull Set<String> ids) {
        }

        public void afterMove(@NotNull InsertType insertType, @Nullable NlComponent previousParent, @NotNull NlComponent receiver, @Nullable DesignSurface surface) {
        }

        public boolean postCreate(@Nullable DesignSurface surface, @NotNull InsertType insertType) {
            return true;
        }

        public void postCreateFromTransferrable(DnDTransferComponent dndComponent) {
        }

        public abstract boolean maybeHandleDeletion(@NotNull Collection<NlComponent> var1);
    }
}

