/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.model;

import com.android.annotations.concurrency.Slow;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.common.api.DragType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.lint.LintAnnotationsModel;
import com.android.tools.idea.common.model.DnDTransferComponent;
import com.android.tools.idea.common.model.DnDTransferItem;
import com.android.tools.idea.common.model.ModelListener;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlComponentUtil;
import com.android.tools.idea.common.model.NlDependencyManager;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.type.DesignerEditorFileType;
import com.android.tools.idea.common.type.DesignerEditorFileTypeKt;
import com.android.tools.idea.common.util.XmlTagUtil;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.rendering.RefreshRenderAction;
import com.android.tools.idea.rendering.parsers.TagSnapshot;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.res.ResourceNotificationManager;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.util.ListenerCollection;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Alarm;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlModel
implements Disposable,
ResourceNotificationManager.ResourceChangeListener,
ModificationTracker {
    private static final boolean CHECK_MODEL_INTEGRITY = false;
    private final Set<String> myPendingIds = Sets.newHashSet();
    @NotNull
    private final AndroidFacet myFacet;
    private final VirtualFile myFile;
    private final Configuration myConfiguration;
    private final ListenerCollection<ModelListener> myListeners = ListenerCollection.createWithDirectExecutor();
    private NlComponent myRootComponent;
    private LintAnnotationsModel myLintAnnotationsModel;
    private final long myId;
    private final Set<Object> myActivations = Collections.newSetFromMap(new WeakHashMap());
    private final ModelVersion myModelVersion = new ModelVersion();
    private final DesignerEditorFileType myType;
    private long myConfigurationModificationCount;
    private final MergingUpdateQueue myUpdateQueue;
    private ChangeType myModificationTrigger;
    @NotNull
    private final Consumer<NlComponent> myComponentRegistrar;

    @Slow
    @NotNull
    public static NlModel create(@Nullable Disposable parent, @NotNull AndroidFacet facet, @NotNull VirtualFile file, @NotNull ConfigurationManager configurationManager, @NotNull Consumer<NlComponent> componentRegistrar) {
        return new NlModel(parent, facet, file, configurationManager.getConfiguration(file), componentRegistrar);
    }

    @Slow
    @NotNull
    public static NlModel create(@Nullable Disposable parent, @NotNull AndroidFacet facet, @NotNull VirtualFile file, @NotNull Consumer<NlComponent> componentRegistrar) {
        return NlModel.create(parent, facet, file, ConfigurationManager.getOrCreateInstance(facet), componentRegistrar);
    }

    @VisibleForTesting
    protected NlModel(@Nullable Disposable parent, @NotNull AndroidFacet facet, @NotNull VirtualFile file, @NotNull Configuration configuration, @NotNull Consumer<NlComponent> componentRegistrar) {
        this.myFacet = facet;
        this.myFile = file;
        this.myConfiguration = configuration;
        this.myComponentRegistrar = componentRegistrar;
        this.myConfigurationModificationCount = this.myConfiguration.getModificationCount();
        this.myId = System.nanoTime() ^ (long)file.getName().hashCode();
        if (parent != null) {
            Disposer.register((Disposable)parent, (Disposable)this);
        }
        this.myType = DesignerEditorFileTypeKt.typeOf((PsiFile)this.getFile());
        this.myUpdateQueue = new MergingUpdateQueue("android.layout.preview.edit", 250, true, null, null, null, Alarm.ThreadToUse.SWING_THREAD);
        this.myUpdateQueue.setRestartTimerOnAdd(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate(@NotNull Object source) {
        boolean wasActive;
        Set<Object> set = this.myActivations;
        synchronized (set) {
            wasActive = !this.myActivations.isEmpty();
            this.myActivations.add(source);
        }
        if (!wasActive) {
            if (this.myConfiguration.getModificationCount() != this.myConfigurationModificationCount) {
                this.updateTheme();
            }
            ResourceNotificationManager manager = ResourceNotificationManager.getInstance(this.getProject());
            manager.addListener(this, this.myFacet, this.myFile, this.myConfiguration);
            this.myListeners.forEach(listener2 -> listener2.modelActivated(this));
        }
    }

    public void updateTheme() {
        ResourceResolver resolver;
        ResourceUrl themeUrl = ResourceUrl.parse((String)this.myConfiguration.getTheme());
        if (themeUrl != null && themeUrl.type == ResourceType.STYLE && ((resolver = this.myConfiguration.getResourceResolver()) == null || resolver.getTheme(themeUrl.name, themeUrl.isFramework()) == null)) {
            this.myConfiguration.setTheme(this.myConfiguration.getConfigurationManager().computePreferredTheme(this.myConfiguration));
        }
    }

    private void deactivate() {
        this.myListeners.forEach(listener2 -> listener2.modelDeactivated(this));
        ResourceNotificationManager manager = ResourceNotificationManager.getInstance(this.getProject());
        manager.removeListener(this, this.myFacet, this.myFile, this.myConfiguration);
        this.myConfigurationModificationCount = this.myConfiguration.getModificationCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate(@NotNull Object source) {
        boolean shouldDeactivate;
        Set<Object> set = this.myActivations;
        synchronized (set) {
            boolean removed = this.myActivations.remove(source);
            shouldDeactivate = removed && this.myActivations.isEmpty();
        }
        if (shouldDeactivate) {
            this.deactivate();
        }
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        return this.myFile;
    }

    @NotNull
    public XmlFile getFile() {
        XmlFile file = (XmlFile)AndroidPsiUtils.getPsiFileSafely(this.getProject(), this.myFile);
        assert (file != null);
        return file;
    }

    @NotNull
    public DesignerEditorFileType getType() {
        return this.myType;
    }

    @Nullable
    public LintAnnotationsModel getLintAnnotationsModel() {
        return this.myLintAnnotationsModel;
    }

    public void setLintAnnotationsModel(@Nullable LintAnnotationsModel model2) {
        this.myLintAnnotationsModel = model2;
    }

    @NotNull
    public Set<String> getPendingIds() {
        return this.myPendingIds;
    }

    public void syncWithPsi(@NotNull XmlTag newRoot, @NotNull List<TagSnapshotTreeNode> roots) {
        new ModelUpdater(this).update(newRoot, roots);
    }

    public void checkStructure() {
    }

    private void checkUnique(NlComponent component, Set<NlComponent> unique) {
    }

    private void checkUnique(XmlTag tag, Set<XmlTag> unique) {
    }

    private void checkStructure(NlComponent component) {
    }

    public void addListener(@NotNull ModelListener listener2) {
        this.myListeners.add(listener2);
    }

    public void removeListener(@NotNull ModelListener listener2) {
        this.myListeners.remove(listener2);
    }

    public void notifyListenersModelUpdateComplete() {
        this.myListeners.forEach(listener2 -> listener2.modelDerivedDataChanged(this));
    }

    public void notifyListenersModelLayoutComplete(boolean animate) {
        this.myListeners.forEach(listener2 -> listener2.modelChangedOnLayout(this, animate));
    }

    @NotNull
    public AndroidFacet getFacet() {
        return this.myFacet;
    }

    @NotNull
    public Module getModule() {
        return this.myFacet.getModule();
    }

    @NotNull
    public Project getProject() {
        return this.getModule().getProject();
    }

    @NotNull
    public Configuration getConfiguration() {
        return this.myConfiguration;
    }

    @NotNull
    public ImmutableList<NlComponent> getComponents() {
        return this.myRootComponent != null ? ImmutableList.of((Object)this.myRootComponent) : ImmutableList.of();
    }

    @NotNull
    public Stream<NlComponent> flattenComponents() {
        return this.myRootComponent != null ? Stream.of(this.myRootComponent).flatMap(NlComponent::flatten) : Stream.empty();
    }

    public void notifyLiveUpdate(boolean animate) {
        this.myListeners.forEach(listener2 -> listener2.modelLiveUpdate(this, animate));
    }

    @NotNull
    public ImmutableList<NlComponent> findByOffset(int offset) {
        XmlTag tag = (XmlTag)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)this.getFile(), (int)offset, XmlTag.class, (boolean)false);
        return tag != null ? this.findViewsByTag(tag) : ImmutableList.of();
    }

    @Nullable
    public NlComponent findViewByTag(@NotNull XmlTag tag) {
        return this.myRootComponent != null ? this.myRootComponent.findViewByTag(tag) : null;
    }

    @Nullable
    public NlComponent find(@NotNull String id) {
        return this.flattenComponents().filter(c -> id.equals(c.getId())).findFirst().orElse(null);
    }

    @Nullable
    public NlComponent find(@NotNull Predicate<NlComponent> condition) {
        return this.flattenComponents().filter(condition).findFirst().orElse(null);
    }

    @NotNull
    private ImmutableList<NlComponent> findViewsByTag(@NotNull XmlTag tag) {
        if (this.myRootComponent == null) {
            return ImmutableList.of();
        }
        return this.myRootComponent.findViewsByTag(tag);
    }

    @Nullable
    public NlComponent findViewByPsi(@Nullable PsiElement element) {
        assert (ApplicationManager.getApplication().isReadAccessAllowed());
        while (element != null) {
            if (element instanceof XmlTag) {
                return this.findViewByTag((XmlTag)element);
            }
            element = element.getParent();
        }
        return null;
    }

    @Nullable
    public ResourceReference findAttributeByPsi(@NotNull PsiElement element) {
        assert (ApplicationManager.getApplication().isReadAccessAllowed());
        while (element != null) {
            if (element instanceof XmlAttribute) {
                XmlAttribute attribute = (XmlAttribute)element;
                ResourceNamespace namespace = ResourceHelper.resolveResourceNamespace((XmlElement)attribute, attribute.getNamespacePrefix());
                if (namespace == null) {
                    return null;
                }
                return ResourceReference.attr((ResourceNamespace)namespace, (String)attribute.getLocalName());
            }
            element = element.getParent();
        }
        return null;
    }

    public void delete(Collection<NlComponent> components) {
        WriteCommandAction.runWriteCommandAction((Project)this.getProject(), (String)"Delete Component", null, () -> NlModel.handleDeletion(components), (PsiFile[])new PsiFile[]{this.getFile()});
        this.notifyModified(ChangeType.DELETE);
    }

    private static void handleDeletion(@NotNull Collection<NlComponent> components) {
        Multimap<NlComponent, NlComponent> siblingLists = NlComponentUtil.groupSiblings(components);
        for (NlComponent parent : siblingLists.keySet()) {
            if (parent == null) continue;
            Collection children = siblingLists.get((Object)parent);
            if (parent.getMixin().maybeHandleDeletion(children)) continue;
            for (NlComponent component : children) {
                XmlTag tag;
                NlComponent p = component.getParent();
                if (p != null) {
                    p.removeChild(component);
                }
                if (!(tag = component.getTagDeprecated()).isValid()) continue;
                PsiElement parentTag = tag.getParent();
                tag.delete();
                if (!(parentTag instanceof XmlTag)) continue;
                ((XmlTag)parentTag).collapseIfEmpty();
            }
        }
    }

    @Nullable
    public NlComponent createComponent(@Nullable DesignSurface surface, @NotNull XmlTag tag, @Nullable NlComponent parent, @Nullable NlComponent before, @NotNull InsertType insertType) {
        XmlTag addedTag = tag;
        if (parent != null) {
            XmlTag parentTag = parent.getTagDeprecated();
            addedTag = (XmlTag)WriteAction.compute(() -> {
                if (before != null) {
                    return (XmlTag)parentTag.addBefore((PsiElement)tag, (PsiElement)before.getTagDeprecated());
                }
                return parentTag.addSubTag(tag, false);
            });
        }
        NlComponent child = this.createComponent(addedTag);
        if (parent != null) {
            parent.addChild(child, before);
        }
        if (child.postCreate(surface, insertType)) {
            return child;
        }
        return null;
    }

    @NotNull
    public NlComponent createComponent(@NotNull XmlTag tag) {
        NlComponent component = new NlComponent(this, tag);
        this.myComponentRegistrar.accept(component);
        return component;
    }

    @NotNull
    public List<NlComponent> createComponents(@NotNull DnDTransferItem item, @NotNull InsertType insertType, @NotNull DesignSurface surface) {
        ArrayList<NlComponent> components = new ArrayList<NlComponent>(item.getComponents().size());
        for (DnDTransferComponent dndComponent : item.getComponents()) {
            XmlTag tag = XmlTagUtil.createTag(this.getProject(), dndComponent.getRepresentation());
            NlComponent component = this.createComponent(surface, tag, null, null, insertType);
            if (component == null) {
                return Collections.emptyList();
            }
            component.postCreateFromTransferrable(dndComponent);
            components.add(component);
        }
        return components;
    }

    public boolean canAddComponents(@NotNull List<NlComponent> toAdd, @NotNull NlComponent receiver, @Nullable NlComponent before) {
        return this.canAddComponents(toAdd, receiver, before, false);
    }

    public boolean canAddComponents(@NotNull List<NlComponent> toAdd, @NotNull NlComponent receiver, @Nullable NlComponent before, boolean ignoreMissingDependencies) {
        if (before != null && before.getParent() != receiver) {
            return false;
        }
        if (toAdd.isEmpty()) {
            return false;
        }
        if (toAdd.stream().anyMatch(c -> !c.canAddTo(receiver))) {
            return false;
        }
        if (NlComponentUtil.isDescendant(receiver, toAdd)) {
            return false;
        }
        return ignoreMissingDependencies || this.checkIfUserWantsToAddDependencies(toAdd);
    }

    private boolean checkIfUserWantsToAddDependencies(List<NlComponent> toAdd) {
        return NlDependencyManager.getInstance().checkIfUserWantsToAddDependencies(toAdd, this.getFacet());
    }

    public void addComponents(@NotNull List<NlComponent> toAdd, @NotNull NlComponent receiver, @Nullable NlComponent before, @NotNull InsertType insertType, @Nullable DesignSurface surface) {
        this.addComponents(toAdd, receiver, before, insertType, surface, null);
    }

    public void addComponents(@NotNull List<NlComponent> componentToAdd, @NotNull NlComponent receiver, @Nullable NlComponent before, @NotNull InsertType insertType, @Nullable DesignSurface surface, @Nullable Runnable attributeUpdatingTask) {
        ImmutableList toAdd = ImmutableList.copyOf(componentToAdd);
        if (!this.canAddComponents((List<NlComponent>)toAdd, receiver, before)) {
            return;
        }
        Runnable callback2 = () -> this.addComponentInWriteCommand((List<NlComponent>)toAdd, receiver, before, insertType, surface, attributeUpdatingTask);
        NlDependencyManager.getInstance().addDependenciesAsync((Iterable<? extends NlComponent>)toAdd, this.getFacet(), "Adding Components...", callback2);
    }

    private void addComponentInWriteCommand(@NotNull List<NlComponent> toAdd, @NotNull NlComponent receiver, @Nullable NlComponent before, @NotNull InsertType insertType, @Nullable DesignSurface surface, @Nullable Runnable attributeUpdatingTask) {
        DumbService.getInstance((Project)this.getProject()).runWhenSmart(() -> {
            NlWriteCommandActionUtil.run(toAdd, NlModel.generateAddComponentsDescription(toAdd, insertType), () -> {
                if (attributeUpdatingTask != null) {
                    attributeUpdatingTask.run();
                }
                this.handleAddition(toAdd, receiver, before, insertType, surface);
            });
            this.notifyModified(ChangeType.ADD_COMPONENTS);
        });
    }

    @NotNull
    private static String generateAddComponentsDescription(@NotNull List<NlComponent> toAdd, @NotNull InsertType insertType) {
        DragType dragType = insertType.getDragType();
        String componentType = "";
        if (toAdd.size() == 1) {
            String tagName = toAdd.get(0).getTagName();
            componentType = tagName.substring(tagName.lastIndexOf(46) + 1);
        }
        return dragType.getDescription(componentType);
    }

    public void addTags(@NotNull List<NlComponent> added, @NotNull NlComponent receiver, @Nullable NlComponent before, @NotNull InsertType insertType) {
        NlWriteCommandActionUtil.run(added, NlModel.generateAddComponentsDescription(added, insertType), () -> {
            for (NlComponent component : added) {
                component.addTags(receiver, before, insertType);
            }
        });
        this.notifyModified(ChangeType.ADD_COMPONENTS);
    }

    @NotNull
    public Set<String> getIds() {
        LocalResourceRepository resources = ResourceRepositoryManager.getAppResources(this.getFacet());
        HashSet<String> ids = new HashSet<String>(resources.getResources(ResourceNamespace.TODO(), ResourceType.ID).keySet());
        Set<String> pendingIds = this.getPendingIds();
        if (!pendingIds.isEmpty()) {
            HashSet<String> all = new HashSet<String>(pendingIds.size() + ids.size());
            all.addAll(ids);
            all.addAll(pendingIds);
            ids = all;
        }
        return ids;
    }

    private void handleAddition(@NotNull List<NlComponent> added, @NotNull NlComponent receiver, @Nullable NlComponent before, @NotNull InsertType insertType, @Nullable DesignSurface surface) {
        Set<String> ids = this.getIds();
        for (NlComponent component : added) {
            component.moveTo(receiver, before, insertType, ids, surface);
        }
    }

    @NotNull
    public InsertType determineInsertType(@NotNull DragType dragType, @Nullable DnDTransferItem item, boolean asPreview) {
        if (item != null && item.isFromPalette()) {
            return asPreview ? InsertType.CREATE_PREVIEW : InsertType.CREATE;
        }
        switch (dragType) {
            case CREATE: {
                return asPreview ? InsertType.CREATE_PREVIEW : InsertType.CREATE;
            }
            case MOVE: {
                return item != null && this.myId != item.getModelId() ? InsertType.COPY : InsertType.MOVE_INTO;
            }
            case COPY: {
                return InsertType.COPY;
            }
        }
        return InsertType.PASTE;
    }

    public long getId() {
        return this.myId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        boolean shouldDeactivate;
        Set<Object> set = this.myActivations;
        synchronized (set) {
            shouldDeactivate = !this.myActivations.isEmpty();
            this.myActivations.clear();
        }
        if (shouldDeactivate) {
            this.deactivate();
        }
        this.myListeners.clear();
    }

    @NotNull
    public String toString() {
        return NlModel.class.getSimpleName() + " for " + this.myFile;
    }

    @Override
    public void resourcesChanged(@NotNull Set<ResourceNotificationManager.Reason> reason) {
        for (ResourceNotificationManager.Reason r : reason) {
            switch (r) {
                case RESOURCE_EDIT: {
                    this.notifyModifiedViaUpdateQueue(ChangeType.RESOURCE_EDIT);
                    break;
                }
                case EDIT: {
                    this.notifyModifiedViaUpdateQueue(ChangeType.EDIT);
                    break;
                }
                case IMAGE_RESOURCE_CHANGED: {
                    RefreshRenderAction.clearCache(this.getConfiguration());
                    this.notifyModified(ChangeType.RESOURCE_CHANGED);
                    break;
                }
                case GRADLE_SYNC: 
                case PROJECT_BUILD: 
                case VARIANT_CHANGED: 
                case SDK_CHANGED: {
                    this.notifyModified(ChangeType.BUILD);
                    break;
                }
                case CONFIGURATION_CHANGED: {
                    this.notifyModified(ChangeType.CONFIGURATION_CHANGE);
                }
            }
        }
    }

    public long getModificationCount() {
        return this.myModelVersion.getVersion();
    }

    public long getConfigurationModificationCount() {
        return this.myConfigurationModificationCount;
    }

    public void notifyModified(@NotNull ChangeType reason) {
        this.myModelVersion.increase(reason);
        this.updateTheme();
        this.myModificationTrigger = reason;
        this.myListeners.forEach(listener2 -> listener2.modelChanged(this));
    }

    public void notifyModifiedViaUpdateQueue(final @NotNull ChangeType reason) {
        this.myUpdateQueue.queue(new Update("edit"){

            public void run() {
                NlModel.this.notifyModified(reason);
            }

            public boolean canEat(Update update2) {
                return true;
            }
        });
    }

    @Nullable
    public ChangeType getLastChangeType() {
        return this.myModificationTrigger;
    }

    public void resetLastChange() {
        this.myModificationTrigger = null;
    }

    private /* synthetic */ void lambda$checkStructure$2() {
        Set unique = Sets.newIdentityHashSet();
        Set uniqueTags = Sets.newIdentityHashSet();
        this.checkUnique(this.getFile().getRootTag(), uniqueTags);
        uniqueTags.clear();
        if (this.myRootComponent != null) {
            this.checkUnique(this.myRootComponent.getTagDeprecated(), uniqueTags);
            this.checkUnique(this.myRootComponent, unique);
            this.checkStructure(this.myRootComponent);
        }
    }

    static class ModelVersion {
        private final AtomicLong myVersion = new AtomicLong();
        ChangeType mLastReason;

        ModelVersion() {
        }

        public void increase(ChangeType reason) {
            this.myVersion.incrementAndGet();
            this.mLastReason = reason;
        }

        public long getVersion() {
            return this.myVersion.get();
        }
    }

    public static enum ChangeType {
        RESOURCE_EDIT,
        EDIT,
        RESOURCE_CHANGED,
        ADD_COMPONENTS,
        DELETE,
        DND_COMMIT,
        DND_END,
        DROP,
        RESIZE_END,
        RESIZE_COMMIT,
        UPDATE_HIERARCHY,
        BUILD,
        CONFIGURATION_CHANGE;

    }

    private static class ModelUpdater {
        private final NlModel myModel;
        private final Map<XmlTag, NlComponent> myTagToComponentMap = Maps.newIdentityHashMap();
        private final Map<NlComponent, XmlTag> myComponentToTagMap = Maps.newIdentityHashMap();
        protected final Map<TagSnapshot, NlComponent> mySnapshotToComponent = Maps.newIdentityHashMap();
        private final Map<XmlTag, TagSnapshot> myTagToSnapshot = Maps.newHashMap();

        public ModelUpdater(@NotNull NlModel model2) {
            this.myModel = model2;
        }

        private void recordComponentMapping(@NotNull XmlTag tag, @NotNull NlComponent component) {
            XmlTag prevTag = this.myComponentToTagMap.get(component);
            if (prevTag != null) {
                this.myTagToComponentMap.remove(prevTag);
            }
            this.myComponentToTagMap.put(component, tag);
            this.myTagToComponentMap.put(tag, component);
        }

        @VisibleForTesting
        public void update(@Nullable XmlTag newRoot, @NotNull List<TagSnapshotTreeNode> roots) {
            if (newRoot == null) {
                this.myModel.myRootComponent = null;
                return;
            }
            this.myModel.myRootComponent = (NlComponent)ApplicationManager.getApplication().runReadAction(() -> {
                if (!newRoot.isValid()) {
                    return null;
                }
                for (TagSnapshotTreeNode tagSnapshotTreeNode : roots) {
                    ModelUpdater.gatherTagsAndSnapshots(tagSnapshotTreeNode, this.myTagToSnapshot);
                }
                this.mapOldToNew(newRoot);
                for (Map.Entry entry : this.myTagToComponentMap.entrySet()) {
                    XmlTag tag = (XmlTag)entry.getKey();
                    NlComponent component = (NlComponent)entry.getValue();
                    if (component.getTagName().equals(tag.getName())) continue;
                    this.myTagToComponentMap.clear();
                    this.myComponentToTagMap.clear();
                    break;
                }
                return this.createTree(newRoot);
            });
            for (NlComponent component : this.myTagToComponentMap.values()) {
                component.setSnapshot(null);
            }
            for (TagSnapshotTreeNode root : roots) {
                this.updateHierarchy(root);
            }
        }

        private void mapOldToNew(@NotNull XmlTag newRootTag) {
            XmlTag oldTag;
            TagSnapshot snapshot;
            NlComponent component;
            ApplicationManager.getApplication().assertReadAccessAllowed();
            for (NlComponent component2 : this.myModel.getComponents()) {
                this.gatherTagsAndSnapshots(component2);
            }
            ArrayList missing = Lists.newArrayList();
            Set remaining = Sets.newIdentityHashSet();
            remaining.addAll(this.myTagToComponentMap.keySet());
            ModelUpdater.checkMissing(newRootTag, remaining, missing);
            if (missing.isEmpty()) {
                return;
            }
            if (remaining.isEmpty()) {
                return;
            }
            HashMap oldIds = Maps.newHashMap();
            for (Map.Entry<TagSnapshot, NlComponent> entry : this.mySnapshotToComponent.entrySet()) {
                String id;
                TagSnapshot snapshot2 = entry.getKey();
                if (snapshot2 == null || (id = snapshot2.getAttribute("id", "http://schemas.android.com/apk/res/android")) == null) continue;
                oldIds.put(id, entry.getValue());
            }
            ListIterator missingIterator = missing.listIterator();
            while (missingIterator.hasNext()) {
                XmlTag tag = (XmlTag)missingIterator.next();
                String id = tag.getAttributeValue("id", "http://schemas.android.com/apk/res/android");
                if (id == null || (component = (NlComponent)oldIds.get(id)) == null) continue;
                this.recordComponentMapping(tag, component);
                remaining.remove(component.getTagDeprecated());
                missingIterator.remove();
            }
            if (missing.isEmpty() || remaining.isEmpty()) {
                return;
            }
            ArrayListMultimap snapshotIds = ArrayListMultimap.create();
            for (XmlTag old : remaining) {
                NlComponent component3 = this.myTagToComponentMap.get(old);
                if (component3 == null || (snapshot = component3.getSnapshot()) == null) continue;
                snapshotIds.put((Object)snapshot.getSignature(), (Object)snapshot);
            }
            missingIterator = missing.listIterator();
            while (missingIterator.hasNext()) {
                TagSnapshot first;
                NlComponent component4;
                long signature;
                Collection snapshots;
                XmlTag tag = (XmlTag)missingIterator.next();
                TagSnapshot snapshot3 = this.myTagToSnapshot.get(tag);
                if (snapshot3 == null || (snapshots = snapshotIds.get((Object)(signature = snapshot3.getSignature()))).isEmpty() || (component4 = this.mySnapshotToComponent.get(first = (TagSnapshot)snapshots.iterator().next())) == null) continue;
                this.recordComponentMapping(tag, component4);
                remaining.remove(component4.getTagDeprecated());
                missingIterator.remove();
            }
            if (missing.size() == 1 && remaining.size() == 1 && (component = this.myTagToComponentMap.get(oldTag = (XmlTag)remaining.iterator().next())) != null) {
                XmlTag newTag = (XmlTag)missing.get(0);
                snapshot = component.getSnapshot();
                if (snapshot != null && snapshot.tagName.equals(newTag.getName())) {
                    this.recordComponentMapping(newTag, component);
                }
            }
        }

        private static void checkMissing(XmlTag tag, Set<XmlTag> remaining, List<XmlTag> missing) {
            boolean found = remaining.remove(tag);
            if (!found) {
                missing.add(tag);
            }
            for (XmlTag child : tag.getSubTags()) {
                ModelUpdater.checkMissing(child, remaining, missing);
            }
        }

        private void gatherTagsAndSnapshots(@NotNull NlComponent component) {
            XmlTag tag = component.getTagDeprecated();
            this.recordComponentMapping(tag, component);
            this.mySnapshotToComponent.put(component.getSnapshot(), component);
            for (NlComponent child : component.getChildren()) {
                this.gatherTagsAndSnapshots(child);
            }
        }

        private static void gatherTagsAndSnapshots(@NotNull TagSnapshotTreeNode node, @NotNull Map<XmlTag, TagSnapshot> map2) {
            TagSnapshot snapshot = node.getTagSnapshot();
            if (snapshot != null) {
                map2.put(snapshot.tag, snapshot);
            }
            for (TagSnapshotTreeNode child : node.getChildren()) {
                ModelUpdater.gatherTagsAndSnapshots(child, map2);
            }
        }

        @NotNull
        private NlComponent createTree(@NotNull XmlTag tag) {
            XmlTag[] subTags;
            NlComponent component = this.myTagToComponentMap.get(tag);
            if (component == null) {
                component = this.myModel.createComponent(tag);
                this.recordComponentMapping(tag, component);
            }
            if ((subTags = tag.getSubTags()).length > 0) {
                ArrayList<NlComponent> children = new ArrayList<NlComponent>(subTags.length);
                for (XmlTag subtag : subTags) {
                    NlComponent child = this.createTree(subtag);
                    children.add(child);
                }
                component.setChildren(children);
            } else {
                component.setChildren(null);
            }
            return component;
        }

        private void updateHierarchy(@NotNull TagSnapshotTreeNode node) {
            TagSnapshot snapshot = node.getTagSnapshot();
            if (snapshot != null) {
                NlComponent component = this.mySnapshotToComponent.get(snapshot);
                if (component == null) {
                    component = this.myTagToComponentMap.get(snapshot.tag);
                }
                if (component != null) {
                    component.setSnapshot(snapshot);
                    assert (snapshot.tag != null);
                    component.setTag(snapshot.tag);
                }
            }
            for (TagSnapshotTreeNode child : node.getChildren()) {
                this.updateHierarchy(child);
            }
        }
    }

    public static interface TagSnapshotTreeNode {
        @Nullable
        public TagSnapshot getTagSnapshot();

        @NotNull
        public List<TagSnapshotTreeNode> getChildren();
    }
}

