/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.model;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.SelectionListener;
import com.android.tools.idea.util.ListenerCollection;
import com.android.utils.ImmutableCollectors;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectionModel {
    @NotNull
    private ImmutableList<NlComponent> mySelection = ImmutableList.of();
    private NlComponent myPrimary;
    private final ListenerCollection<SelectionListener> myListeners = ListenerCollection.createWithDirectExecutor();
    @Nullable
    Object mySecondarySelection;

    @NotNull
    public ImmutableList<NlComponent> getSelection() {
        return this.mySelection;
    }

    @Nullable
    public NlComponent getPrimary() {
        return this.myPrimary;
    }

    public void setSelection(@NotNull List<NlComponent> components) {
        this.setSelection((List<NlComponent>)ImmutableList.copyOf(components), components.isEmpty() ? null : components.iterator().next());
    }

    public void setSelection(@NotNull List<NlComponent> components, @Nullable NlComponent primary) {
        if (components.equals(this.mySelection)) {
            return;
        }
        this.mySelection = ImmutableList.copyOf(components);
        this.mySecondarySelection = null;
        this.myPrimary = primary;
        this.notifySelectionChanged();
    }

    public void clear() {
        if (this.mySelection.isEmpty()) {
            return;
        }
        this.mySelection = ImmutableList.of();
        this.myPrimary = null;
        this.mySecondarySelection = null;
        this.notifySelectionChanged();
    }

    public void clearSecondary() {
        if (this.mySecondarySelection == null) {
            return;
        }
        this.mySecondarySelection = null;
        this.notifySelectionChanged();
    }

    public void toggle(@NotNull NlComponent component) {
        NlComponent newPrimary;
        ImmutableList newSelection;
        int size = this.mySelection.size();
        if (size == 0) {
            newSelection = ImmutableList.of((Object)component);
            newPrimary = component;
        } else if (this.mySelection.contains((Object)component)) {
            if (size == 1) {
                newSelection = ImmutableList.of();
                newPrimary = null;
            } else {
                newSelection = (ImmutableList)this.mySelection.stream().filter(selection -> !selection.equals(component)).collect(ImmutableCollectors.toImmutableList());
                newPrimary = this.myPrimary == component ? null : this.myPrimary;
            }
        } else {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll(this.mySelection);
            builder.add((Object)component);
            newSelection = builder.build();
            newPrimary = this.myPrimary;
        }
        this.mySecondarySelection = null;
        this.setSelection((List<NlComponent>)newSelection, newPrimary);
    }

    private void notifySelectionChanged() {
        this.myListeners.forEach(l -> l.selectionChanged(this, (List<NlComponent>)this.mySelection));
    }

    public void addListener(@NotNull SelectionListener listener2) {
        this.myListeners.add(listener2);
    }

    public void removeListener(@Nullable SelectionListener listener2) {
        this.myListeners.remove(listener2);
    }

    public boolean isEmpty() {
        return this.mySelection.isEmpty();
    }

    public boolean isSelected(@NotNull NlComponent component) {
        return this.mySelection.contains((Object)component);
    }

    public void setSecondarySelection(NlComponent component, Object secondary) {
        if (component == null) {
            this.mySelection = ImmutableList.of();
            this.myPrimary = null;
            this.mySecondarySelection = null;
        } else {
            this.mySecondarySelection = secondary;
            this.mySelection = ImmutableList.of((Object)component);
            this.myPrimary = component;
        }
        this.notifySelectionChanged();
    }

    public Object getSecondarySelection() {
        return this.mySecondarySelection;
    }

    public boolean isSecondarySelected(Object object) {
        if (this.mySecondarySelection == object) {
            return true;
        }
        return this.mySecondarySelection != null && this.mySecondarySelection.equals(object);
    }
}

