/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.property;

import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.tools.adtui.workbench.ToolContent;
import com.android.tools.adtui.workbench.ToolWindowCallback;
import com.android.tools.idea.common.model.ModelListener;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.common.property.PropertiesPanel;
import com.android.tools.idea.common.property.editors.PropertyEditors;
import com.android.tools.idea.common.property.inspector.InspectorProviders;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.DesignSurfaceListener;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.uibuilder.analytics.NlUsageTracker;
import com.android.tools.idea.uibuilder.property.NlProperties;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Table;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Divider;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.Alarm;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PropertiesManager<Self extends PropertiesManager<Self>>
implements ToolContent<DesignSurface>,
DesignSurfaceListener,
ModelListener,
Disposable {
    public static final int UPDATE_DELAY_MSECS = 250;
    private static final int START_DELAY_MSECS = 20;
    public static final int MINIMUM_WIDTH = 250;
    private final Project myProject;
    private final AndroidFacet myFacet;
    private final PropertyEditors myEditors;
    protected boolean myLoading;
    private JBLoadingPanel myLoadingPanel;
    private PropertiesPanel<Self> myPropertiesPanel;
    @Nullable
    private DesignSurface mySurface;
    @Nullable
    protected SceneView mySceneView;
    private MergingUpdateQueue myUpdateQueue;
    private boolean myFirstLoad = true;
    private int myUpdateCount;
    private JBSplitter mySplitter;
    private ToolWindowCallback myToolWindow;

    public PropertiesManager(@NotNull AndroidFacet facet, @Nullable DesignSurface designSurface, @NotNull PropertyEditors editors, @NotNull Disposable parentDisposable) {
        this.myProject = facet.getModule().getProject();
        this.myFacet = facet;
        this.mySurface = designSurface;
        this.myEditors = editors;
        this.setToolContextWithoutCheck(designSurface);
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    public void setToolContext(@Nullable DesignSurface designSurface) {
        if (designSurface == this.mySurface) {
            return;
        }
        this.setToolContextWithoutCheck(designSurface);
    }

    public void registerCallbacks(@NotNull ToolWindowCallback toolWindow) {
        this.myToolWindow = toolWindow;
    }

    @NotNull
    private JBLoadingPanel getLoadingPanel() {
        if (this.myLoadingPanel == null) {
            this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this, 20);
            this.myLoadingPanel.setMinimumSize(new Dimension(JBUI.scale((int)250), 0));
            this.myLoadingPanel.add((Component)this.getContentPanel());
        }
        return this.myLoadingPanel;
    }

    @NotNull
    protected PropertiesPanel<Self> getPropertiesPanel() {
        if (this.myPropertiesPanel == null) {
            this.myPropertiesPanel = this.createPropertiesPanel();
        }
        return this.myPropertiesPanel;
    }

    @NotNull
    protected abstract PropertiesPanel<Self> createPropertiesPanel();

    @NotNull
    protected JBSplitter getContentPanel() {
        if (this.mySplitter == null) {
            this.mySplitter = new JBSplitter(true, 0.8f){
                {
                    this.setDividerWidth(9);
                }

                protected Divider createDivider() {
                    Splitter.DividerImpl divider = new Splitter.DividerImpl((Splitter)this);
                    divider.setBorder(IdeBorderFactory.createBorder((int)10));
                    return divider;
                }
            };
            this.mySplitter.setFirstComponent(this.getPropertiesPanel());
        }
        return this.mySplitter;
    }

    private void setToolContextWithoutCheck(@Nullable DesignSurface designSurface) {
        if (this.mySurface != null) {
            this.mySurface.removeListener(this);
        }
        this.mySurface = designSurface;
        if (this.mySurface == null) {
            this.setSceneView(null);
        } else {
            this.mySurface.addListener(this);
            SceneView sceneView = this.mySurface.getCurrentSceneView();
            this.setSceneView(sceneView);
            List<NlComponent> selection = sceneView != null ? sceneView.getSelectionModel().getSelection() : Collections.emptyList();
            this.componentSelectionChanged(this.mySurface, selection);
        }
    }

    @NotNull
    public JComponent getComponent() {
        return this.getLoadingPanel();
    }

    @NotNull
    public JComponent getFocusedComponent() {
        return this.getContentPanel();
    }

    @NotNull
    public List<AnAction> getGearActions() {
        return ImmutableList.of();
    }

    @NotNull
    public List<AnAction> getAdditionalActions() {
        return ImmutableList.of();
    }

    public boolean supportsFiltering() {
        return false;
    }

    @Nullable
    public DesignSurface getDesignSurface() {
        return this.mySurface;
    }

    protected void setSceneView(@Nullable SceneView sceneView) {
        if (sceneView == this.mySceneView) {
            return;
        }
        if (this.mySceneView != null) {
            this.mySceneView.getModel().removeListener(this);
        }
        this.mySceneView = sceneView;
        if (this.mySceneView != null) {
            this.mySceneView.getModel().addListener(this);
        }
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public AndroidFacet getFacet() {
        return this.myFacet;
    }

    @NotNull
    public PropertyEditors getPropertyEditors() {
        return this.myEditors;
    }

    @NotNull
    private MergingUpdateQueue getUpdateQueue() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myUpdateQueue == null) {
            this.myUpdateQueue = new MergingUpdateQueue("android.layout.propertysheet", 250, true, null, (Disposable)this.mySurface, null, Alarm.ThreadToUse.SWING_THREAD);
        }
        return this.myUpdateQueue;
    }

    private void setSelectedComponents(@NotNull List<NlComponent> components, @Nullable Runnable postUpdateRunnable) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            Table<String, String, NlPropertyItem> properties = NlProperties.getInstance().getProperties(this.myFacet, this, components);
            UIUtil.invokeLaterIfNeeded(() -> {
                if (Disposer.isDisposed((Disposable)this) || this.myProject.isDisposed()) {
                    return;
                }
                this.getPropertiesPanel().setItems(components, properties);
                if (postUpdateRunnable != null) {
                    this.myLoading = false;
                    postUpdateRunnable.run();
                }
            });
        });
    }

    public boolean isLoading() {
        return this.myLoading;
    }

    @NotNull
    public Map<ResourceReference, ResourceValue> getDefaultProperties(@NotNull List<NlComponent> components) {
        if (components.isEmpty()) {
            return Collections.emptyMap();
        }
        if (this.mySurface == null) {
            return Collections.emptyMap();
        }
        SceneView view = this.mySurface.getCurrentSceneView();
        if (view == null) {
            return Collections.emptyMap();
        }
        Map<Object, Map<ResourceReference, ResourceValue>> map2 = view.getSceneManager().getDefaultProperties();
        ArrayList<Map<ResourceReference, ResourceValue>> propertiesMaps = new ArrayList<Map<ResourceReference, ResourceValue>>(components.size());
        for (NlComponent component : components) {
            Map<ResourceReference, ResourceValue> propertiesMap = map2.get(component.getSnapshot());
            if (propertiesMap == null) {
                return Collections.emptyMap();
            }
            propertiesMaps.add(propertiesMap);
        }
        Map first = (Map)propertiesMaps.get(0);
        if (propertiesMaps.size() == 1) {
            return first;
        }
        HashMap<ResourceReference, ResourceValue> commonProperties = new HashMap<ResourceReference, ResourceValue>(first);
        for (int index = 1; index < propertiesMaps.size(); ++index) {
            Map other = (Map)propertiesMaps.get(index);
            Iterator it = commonProperties.keySet().iterator();
            while (it.hasNext()) {
                ResourceReference reference2 = (ResourceReference)it.next();
                ResourceValue value2 = (ResourceValue)other.get(reference2);
                if (value2 != null && value2.equals(commonProperties.get(reference2))) continue;
                it.remove();
            }
        }
        return commonProperties;
    }

    @Nullable
    public String getDefaultStyle(@NotNull List<NlComponent> components) {
        if (components.isEmpty()) {
            return null;
        }
        if (this.mySurface == null) {
            return null;
        }
        SceneView view = this.mySurface.getCurrentSceneView();
        if (view == null) {
            return null;
        }
        Map<Object, String> styleMap = view.getSceneManager().getDefaultStyles();
        String style = styleMap.get(components.get(0).getSnapshot());
        if (style == null) {
            return null;
        }
        for (NlComponent component : components) {
            String other = styleMap.get(component.getSnapshot());
            if (style.equals(other)) continue;
            return null;
        }
        return style;
    }

    @NotNull
    public abstract InspectorProviders<Self> getInspectorProviders(@NotNull Disposable var1);

    public void setValue(@NotNull NlProperty property2, @Nullable String value2) {
        property2.setValue(value2);
    }

    public void updateSelection() {
        if (this.mySurface == null || this.mySceneView == null) {
            return;
        }
        ImmutableList<NlComponent> selection = this.mySceneView.getSelectionModel().getSelection();
        this.componentSelectionChanged(this.mySurface, (List<NlComponent>)selection);
        ++this.myUpdateCount;
    }

    public int getUpdateCount() {
        return this.myUpdateCount;
    }

    public void propertyChanged(@NotNull NlProperty property2, @Nullable String oldValue, @Nullable String newValue) {
    }

    public void starStateChanged() {
        this.updateSelection();
    }

    public void resourceChanged(@NotNull ResourceItem item, @Nullable String oldValue, @Nullable String newValue) {
    }

    public abstract void logPropertyChange(@NotNull NlProperty var1);

    public void logFavoritesChange(@NotNull String added, @NotNull String removed, @NotNull List<String> favorites) {
        if (this.mySceneView == null) {
            return;
        }
        NlUsageTracker.getInstance(this.mySurface).logFavoritesChange(added, removed, favorites, this.mySceneView.getModel().getFacet());
    }

    @Override
    public void componentSelectionChanged(@NotNull DesignSurface surface, final @NotNull List<NlComponent> newSelection) {
        if (surface != this.mySurface) {
            return;
        }
        if (!newSelection.isEmpty() && this.myFirstLoad) {
            this.myFirstLoad = false;
            this.getLoadingPanel().startLoading();
        }
        this.myLoading = true;
        MergingUpdateQueue queue = this.getUpdateQueue();
        queue.queue(new Update("updateProperties"){

            public void run() {
                PropertiesManager.this.setSelectedComponents(newSelection, () -> ((JBLoadingPanel)PropertiesManager.this.getLoadingPanel()).stopLoading());
            }

            public boolean canEat(Update update2) {
                return true;
            }
        });
    }

    @Override
    public void modelChangedOnLayout(@NotNull NlModel model2, boolean animate) {
    }

    @Override
    public boolean activatePreferredEditor(@NotNull DesignSurface surface, @NotNull NlComponent component) {
        return false;
    }

    @Override
    public void modelChanged(@NotNull NlModel model2) {
        this.getPropertiesPanel().modelRendered();
    }

    public void dispose() {
        this.setToolContext(null);
    }
}

