/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.property.inspector;

import com.android.tools.adtui.common.AdtSecondaryPanel;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.common.property.PropertiesManager;
import com.android.tools.idea.common.property.editors.NlComponentEditor;
import com.android.tools.idea.common.property.inspector.InspectorComponent;
import com.android.tools.idea.common.property.inspector.InspectorProviders;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import com.google.common.html.HtmlEscapers;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.ui.AbstractExpandableItemsHandler;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InspectorPanel<PropMgr extends PropertiesManager<PropMgr>>
extends AdtSecondaryPanel
implements KeyEventDispatcher {
    private static final int MAX_LABEL_WIDTH = JBUI.scale((int)200);
    private static final int HORIZONTAL_SPACING = 6;
    private static final int COLUMN_COUNT = 2;
    @Nullable
    private final JComponent myBottomLink;
    private final Font myBoldLabelFont = UIUtil.getLabelFont().deriveFont(1);
    private final GridInspectorPanel myInspector;
    private final SpeedSearchComparator myComparator;
    private final Map<Component, ExpandableGroup> mySource2GroupMap = new IdentityHashMap<Component, ExpandableGroup>(4);
    private final Map<JLabel, ExpandableGroup> myLabel2GroupMap = new IdentityHashMap<JLabel, ExpandableGroup>(4);
    private final Multimap<JLabel, Component> myLabel2ComponentMap = HashMultimap.create();
    private final JLabel myDefaultLabel = new JLabel();
    private final InspectorExpandableItemsHandler myExpandableItemsHandler;
    private final Disposable myParentDisposable;
    private InspectorProviders<PropMgr> myInspectorProviders;
    private List<InspectorComponent<PropMgr>> myInspectors = Collections.emptyList();
    private ExpandableGroup myGroup;
    private GridConstraints myConstraints = new GridConstraints();
    private int myRow;
    private boolean myActivateEditorAfterLoad;
    private String myPropertyNameForActivation;
    private String myFilter;

    public InspectorPanel(@NotNull Disposable parentDisposable, @Nullable JComponent bottomLink) {
        super((LayoutManager)new BorderLayout());
        this.myBottomLink = bottomLink;
        if (this.myBottomLink != null) {
            this.myBottomLink.setBorder(BorderFactory.createEmptyBorder(5, 0, 10, 0));
        }
        this.myParentDisposable = parentDisposable;
        this.myInspector = new GridInspectorPanel();
        this.myInspector.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 6));
        this.myComparator = new SpeedSearchComparator(false);
        this.myExpandableItemsHandler = new InspectorExpandableItemsHandler(this);
        this.myFilter = "";
        this.add((Component)((Object)this.myInspector), "Center");
    }

    public void requestFocus() {
        List<NlComponentEditor> editors;
        if (!this.myInspectors.isEmpty() && !(editors = this.myInspectors.get(0).getEditors()).isEmpty()) {
            editors.get(0).requestFocus();
        }
    }

    public void addNotify() {
        super.addNotify();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
        this.myExpandableItemsHandler.install(this.myParentDisposable);
    }

    public void removeNotify() {
        super.removeNotify();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
        this.myExpandableItemsHandler.remove();
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent event) {
        Component source;
        ExpandableGroup group;
        if (event.getKeyCode() == 9 && event.getModifiers() == 0 && event.getID() == 401 && event.getSource() instanceof Component && (group = this.mySource2GroupMap.get(source = (Component)event.getSource())) != null && !group.isExpanded()) {
            group.setExpanded(true, true);
            ApplicationManager.getApplication().invokeLater(source::transferFocus);
            return true;
        }
        return false;
    }

    public void setFilter(@NotNull String filter2) {
        this.myFilter = filter2;
        ApplicationManager.getApplication().invokeLater(this::updateAfterFilterChange);
    }

    @NotNull
    public String getFilter() {
        return this.myFilter;
    }

    public void enterInFilter(@NotNull KeyEvent event) {
        if (this.myFilter.isEmpty()) {
            return;
        }
        Set visibleLabels = this.myLabel2ComponentMap.keySet().stream().filter(Component::isVisible).collect(Collectors.toSet());
        if (visibleLabels.size() != 1) {
            return;
        }
        Collection components = this.myLabel2ComponentMap.get(visibleLabels.iterator().next());
        if (components.size() != 1) {
            return;
        }
        Component editor2 = (Component)components.iterator().next();
        editor2.transferFocus();
        event.consume();
    }

    public void expandGroup(@NotNull JLabel label) {
        ExpandableGroup group = this.myLabel2GroupMap.get(label);
        if (group != null) {
            group.setExpanded(true, true);
        }
    }

    private void updateAfterFilterChange() {
        if (this.myFilter.isEmpty()) {
            this.restoreGroups();
        } else {
            this.applyFilter();
        }
        this.myInspector.invalidate();
        this.myInspector.repaint();
    }

    private void applyFilter() {
        for (JLabel label : this.myLabel2ComponentMap.keySet()) {
            boolean display2 = this.isMatch(label);
            label.setVisible(display2);
            this.myLabel2ComponentMap.get((Object)label).forEach(component -> component.setVisible(display2));
            ExpandableGroup group = this.myLabel2GroupMap.get(label);
            if (group == null) continue;
            label.setIcon(null);
        }
    }

    private void restoreGroups() {
        HashSet<Component> toShow = new HashSet<Component>(Arrays.asList(this.myInspector.getComponents()));
        for (ExpandableGroup group : this.myLabel2GroupMap.values()) {
            toShow.removeAll(group.myComponents);
            group.setExpanded(group.isExpanded(), false);
        }
        toShow.forEach(component -> component.setVisible(true));
        this.myInspectors.forEach(InspectorComponent::updateVisibility);
    }

    private boolean isMatch(@NotNull JLabel label) {
        if (this.myFilter.isEmpty()) {
            return true;
        }
        String text = StringUtil.removeHtmlTags((String)label.getText());
        if (StringUtil.isEmpty((String)text) || label.getFont() == this.myBoldLabelFont) {
            return false;
        }
        return this.myComparator.matchingFragments(this.myFilter, text) != null;
    }

    @NotNull
    private static GridLayoutManager createLayoutManager(int rows) {
        JBInsets margin = new JBInsets(0, 0, 0, 0);
        return new GridLayoutManager(rows, 2, (Insets)margin, 0, 0);
    }

    public void setComponent(@NotNull List<NlComponent> components, @NotNull Table<String, String, ? extends NlProperty> properties, @NotNull PropMgr propertiesManager) {
        this.myInspector.setLayout(null);
        this.myInspector.removeAll();
        this.mySource2GroupMap.clear();
        this.myLabel2GroupMap.clear();
        this.myLabel2ComponentMap.clear();
        this.myRow = 0;
        if (!components.isEmpty()) {
            HashMap propertiesByName = Maps.newHashMapWithExpectedSize((int)properties.size());
            for (NlProperty property2 : properties.row((Object)"http://schemas.android.com/apk/res/android").values()) {
                propertiesByName.put(property2.getName(), property2);
            }
            for (NlProperty property2 : properties.row((Object)"http://schemas.android.com/apk/res-auto").values()) {
                propertiesByName.put(property2.getName(), property2);
            }
            for (NlProperty property2 : properties.row((Object)"").values()) {
                propertiesByName.put(property2.getName(), property2);
            }
            this.collectExtraProperties(components, propertiesManager, propertiesByName);
            if (this.myInspectorProviders != null) {
                Disposer.dispose(this.myInspectorProviders);
            }
            this.myInspectorProviders = ((PropertiesManager)propertiesManager).getInspectorProviders(this.myParentDisposable);
            this.myInspectors = this.myInspectorProviders.createInspectorComponents(components, propertiesByName, propertiesManager);
            int rows = 0;
            for (InspectorComponent<PropMgr> inspector : this.myInspectors) {
                rows += inspector.getMaxNumberOfRows();
            }
            rows += this.myInspectors.size();
            ++rows;
            if (this.myBottomLink != null) {
                ++rows;
            }
            this.myInspector.setLayout((LayoutManager)InspectorPanel.createLayoutManager(rows));
            for (InspectorComponent<PropMgr> inspector : this.myInspectors) {
                this.addSeparator();
                inspector.attachToInspector(this);
            }
            this.endGroup();
            this.addSeparator();
            this.myInspector.add((Component)new Spacer(), new GridConstraints(this.myRow++, 0, 1, 2, 0, 1, 2, 6, null, null, null, 0, false));
            if (this.myBottomLink != null) {
                this.addLineComponent(this.myBottomLink, this.myRow++);
            }
        }
        this.myInspector.updateGridConstraints();
        ApplicationManager.getApplication().invokeLater(() -> {
            if (!this.myFilter.isEmpty()) {
                this.applyFilter();
            }
            if (this.myActivateEditorAfterLoad) {
                this.activatePreferredEditor(this.myPropertyNameForActivation);
            }
            this.repaint();
        });
    }

    protected void collectExtraProperties(@NotNull List<NlComponent> components, @NotNull PropMgr propertiesManager, Map<String, NlProperty> propertiesByName) {
    }

    public void refresh() {
        ApplicationManager.getApplication().invokeLater(() -> this.myInspectors.forEach(InspectorComponent::refresh));
    }

    public void activatePreferredEditor(@NotNull String propertyName, boolean activateAfterLoading) {
        if (activateAfterLoading) {
            this.myActivateEditorAfterLoad = true;
            this.myPropertyNameForActivation = propertyName;
        } else {
            this.activatePreferredEditor(propertyName);
        }
    }

    private void activatePreferredEditor(@NotNull String propertyName) {
        this.myActivateEditorAfterLoad = false;
        this.myPropertyNameForActivation = null;
        boolean designPropertyRequired = propertyName.startsWith("tools:");
        propertyName = StringUtil.trimStart((String)propertyName, (String)"tools:");
        for (InspectorComponent<PropMgr> component : this.myInspectors) {
            for (NlComponentEditor editor2 : component.getEditors()) {
                NlProperty property2 = editor2.getProperty();
                if (!propertyName.equals(property2.getName()) || designPropertyRequired && !"http://schemas.android.com/tools".equals(property2.getNamespace())) continue;
                editor2.requestFocus();
                return;
            }
        }
    }

    public JLabel addTitle(@NotNull String title) {
        return this.addTitle(title, null);
    }

    public JLabel addTitle(@NotNull String title, @Nullable Component rightComponent) {
        JLabel label = InspectorPanel.createLabel(title, null, null);
        label.setFont(this.myBoldLabelFont);
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.setOpaque(false);
        panel2.add((Component)label, "West");
        if (rightComponent != null) {
            panel2.add(rightComponent, "East");
        }
        this.addLineComponent(panel2, this.myRow++);
        this.myLabel2ComponentMap.put((Object)this.myDefaultLabel, (Object)panel2);
        this.startGroup(label, true, null);
        this.myLabel2GroupMap.put(label, this.myGroup);
        return label;
    }

    public void addSeparator() {
        this.endGroup();
        if (this.myRow > 0) {
            JSeparator component = new JSeparator();
            this.addLineComponent(component, this.myRow++);
            this.myLabel2ComponentMap.put((Object)this.myDefaultLabel, (Object)component);
        }
    }

    public JLabel addExpandableComponent(@NotNull String labelText, @Nullable String tooltip, @NotNull Component component, @NotNull Component keySource) {
        JLabel label = InspectorPanel.createLabel(labelText, tooltip, component);
        this.addLabelComponent(label, this.myRow);
        this.addValueComponent(component, this.myRow++);
        this.startGroup(label, false, keySource);
        this.myLabel2GroupMap.put(label, this.myGroup);
        this.myLabel2ComponentMap.put((Object)label, (Object)component);
        return label;
    }

    public JLabel addComponent(@NotNull String labelText, @Nullable String tooltip, @NotNull Component component) {
        JLabel label = InspectorPanel.createLabel(labelText, tooltip, component);
        this.addLabelComponent(label, this.myRow);
        this.addValueComponent(component, this.myRow++);
        this.myLabel2ComponentMap.put((Object)label, (Object)component);
        return label;
    }

    public void addPanel(@NotNull JComponent panel2) {
        this.addLineComponent(panel2, this.myRow++);
        this.myLabel2ComponentMap.put((Object)this.myDefaultLabel, (Object)panel2);
    }

    private static JLabel createLabel(@NotNull String labelText, @Nullable String tooltip, @Nullable Component component) {
        JBLabel label = new JBLabel("<html><nobr>" + HtmlEscapers.htmlEscaper().escape(labelText) + "</nobr></html>");
        label.setLabelFor(component);
        label.setToolTipText(tooltip);
        label.setSize(label.getPreferredSize());
        return label;
    }

    private void addLineComponent(@NotNull Component component, int row) {
        this.addComponent(component, row, 0, 2, 8, 1);
    }

    private void addLabelComponent(@NotNull Component component, int row) {
        this.addComponent(component, row, 0, 1, 8, 1);
    }

    private void addValueComponent(@NotNull Component component, int row) {
        this.addComponent(component, row, 1, 1, 4, 1);
    }

    private void addComponent(@NotNull Component component, int row, int column, int columnSpan, int anchor, int fill2) {
        this.addToGridPanel((JPanel)((Object)this.myInspector), component, row, column, columnSpan, anchor, fill2);
        if (this.myGroup != null) {
            this.myGroup.addComponent(component);
        }
    }

    private void addToGridPanel(@NotNull JPanel panel2, @NotNull Component component, int row, int column, int columnSpan, int anchor, int fill2) {
        this.myConstraints.setRow(row);
        this.myConstraints.setColumn(column);
        this.myConstraints.setColSpan(columnSpan);
        this.myConstraints.setAnchor(anchor);
        this.myConstraints.setFill(fill2);
        panel2.add(component, this.myConstraints);
    }

    private void startGroup(@NotNull JLabel label, boolean initiallyExpanded, @Nullable Component keySource) {
        this.myGroup = new ExpandableGroup(label, this.myGroup, initiallyExpanded);
        if (keySource != null) {
            this.mySource2GroupMap.put(keySource, this.myGroup);
        }
    }

    private void endGroup() {
        this.myGroup = null;
    }

    private static class InspectorExpandableItemsHandler
    extends AbstractExpandableItemsHandler<JLabel, JPanel> {
        private final MousePreprocessor myMousePreprocessor = new MousePreprocessor();
        private final JLabel myRenderer = new JLabel();

        protected InspectorExpandableItemsHandler(@NotNull InspectorPanel component) {
            super((JComponent)((Object)component.myInspector));
        }

        private void install(@NotNull Disposable parent) {
            IdeGlassPane glassPane = IdeGlassPaneUtil.find((Component)this.myComponent);
            glassPane.addMouseMotionPreprocessor((MouseMotionListener)this.myMousePreprocessor, parent);
        }

        private void remove() {
            IdeGlassPane glassPane = IdeGlassPaneUtil.find((Component)this.myComponent);
            glassPane.removeMouseMotionPreprocessor((MouseMotionListener)this.myMousePreprocessor);
        }

        @Nullable
        protected Pair<Component, Rectangle> getCellRendererAndBounds(@NotNull JLabel key) {
            this.myRenderer.setText(key.getText());
            this.myRenderer.setFont(key.getFont());
            this.myRenderer.setForeground(key.getForeground());
            this.myRenderer.setBackground(key.getBackground());
            Rectangle bounds = new Rectangle(key.getLocation(), key.getPreferredSize());
            return Pair.create((Object)this.myRenderer, (Object)bounds);
        }

        @NotNull
        protected Rectangle getVisibleRect(@NotNull JLabel key) {
            return SwingUtilities.convertRectangle(key, key.getVisibleRect(), this.myComponent);
        }

        @Nullable
        protected JLabel getCellKeyForPoint(@NotNull Point point) {
            return null;
        }

        private class MousePreprocessor
        extends MouseMotionAdapter {
            private MousePreprocessor() {
            }

            @Override
            public void mouseMoved(@NotNull MouseEvent event) {
                Component component;
                Point point = SwingUtilities.convertPoint(event.getComponent(), event.getPoint(), InspectorExpandableItemsHandler.this.myComponent);
                if (((JPanel)InspectorExpandableItemsHandler.this.myComponent).contains(point) && (component = ((JPanel)InspectorExpandableItemsHandler.this.myComponent).getComponentAt(point.x, point.y)) instanceof JLabel) {
                    InspectorExpandableItemsHandler.this.handleSelectionChange((JLabel)component, true);
                }
            }
        }
    }

    private static class GridInspectorPanel
    extends AdtSecondaryPanel {
        private int myWidth;

        private GridInspectorPanel() {
        }

        public void setLayout(LayoutManager layoutManager) {
            this.myWidth = -1;
            super.setLayout(layoutManager);
        }

        public void invalidate() {
            this.myWidth = -1;
            super.invalidate();
        }

        public void doLayout() {
            this.updateGridConstraints();
            super.doLayout();
        }

        private void updateGridConstraints() {
            LayoutManager layoutManager = this.getLayout();
            if (layoutManager instanceof GridLayoutManager) {
                GridLayoutManager gridLayoutManager = (GridLayoutManager)layoutManager;
                if (this.getWidth() != this.myWidth) {
                    this.myWidth = this.getWidth();
                    int labelWidth = Math.min((int)((double)(this.myWidth - 12) * 0.4), MAX_LABEL_WIDTH);
                    int editorWidth = this.myWidth - 12 - labelWidth;
                    for (Component component : this.getComponents()) {
                        GridConstraints constraints = gridLayoutManager.getConstraintsForComponent(component);
                        if (constraints == null) continue;
                        GridInspectorPanel.updateMinimumSize(constraints, labelWidth, editorWidth);
                    }
                }
            }
        }

        private static void updateMinimumSize(@NotNull GridConstraints constraints, int labelWidth, int editorWidth) {
            if (constraints.getColSpan() == 1) {
                if (constraints.getColumn() == 0) {
                    constraints.myMinimumSize.setSize(labelWidth, -1);
                } else if (constraints.getColumn() == 1) {
                    constraints.myMinimumSize.setSize(editorWidth, -1);
                }
            }
        }
    }

    private static class ExpandableGroup {
        private static final String KEY_PREFIX = "inspector.open.";
        private static final Icon EXPANDED_ICON = (Icon)UIManager.get("Tree.expandedIcon");
        private static final Icon COLLAPSED_ICON = (Icon)UIManager.get("Tree.collapsedIcon");
        private final JLabel myLabel;
        private final ExpandableGroup myParent;
        private final List<Component> myComponents;
        private final List<ExpandableGroup> myChildren;
        private boolean myExpanded;

        public ExpandableGroup(final @NotNull JLabel label, @Nullable ExpandableGroup parent, boolean defaultValue) {
            this.myLabel = label;
            this.myParent = parent;
            this.myComponents = new ArrayList<Component>(4);
            this.myChildren = new ArrayList<ExpandableGroup>();
            this.myExpanded = PropertiesComponent.getInstance().getBoolean(KEY_PREFIX + StringUtil.removeHtmlTags((String)label.getText()), defaultValue);
            label.setIcon(this.myExpanded ? EXPANDED_ICON : COLLAPSED_ICON);
            label.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent event) {
                    if (label.getIcon() != null) {
                        this.setExpanded(!this.isExpanded(), true);
                    }
                }
            });
            if (parent != null) {
                parent.myChildren.add(this);
            }
        }

        public void addComponent(@NotNull Component component) {
            if (this.myParent != null) {
                this.myParent.addComponent(component);
            }
            this.myComponents.add(component);
            if (!this.myExpanded) {
                component.setVisible(false);
            }
        }

        public boolean isExpanded() {
            return this.myExpanded;
        }

        public void setExpanded(boolean expanded, boolean updateProperties) {
            this.myExpanded = expanded;
            this.myLabel.setIcon(expanded ? EXPANDED_ICON : COLLAPSED_ICON);
            this.myComponents.forEach(component -> component.setVisible(expanded));
            if (expanded) {
                for (ExpandableGroup group : this.myChildren) {
                    group.setExpanded(group.isExpanded(), false);
                }
            }
            if (updateProperties) {
                PropertiesComponent.getInstance().setValue(KEY_PREFIX + StringUtil.removeHtmlTags((String)this.myLabel.getText()), expanded);
            }
        }
    }
}

