/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.property.inspector;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.common.property.PropertiesManager;
import com.android.tools.idea.common.property.inspector.InspectorComponent;
import com.android.tools.idea.common.property.inspector.InspectorProvider;
import com.google.common.collect.ImmutableList;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class InspectorProviders<PropMgr extends PropertiesManager<PropMgr>>
implements LafManagerListener,
Disposable {
    protected final PropMgr myPropertiesManager;

    public InspectorProviders(PropMgr propertiesManager, Disposable parentDisposable) {
        this.myPropertiesManager = propertiesManager;
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        LafManager.getInstance().addLafManagerListener((LafManagerListener)this);
    }

    @NotNull
    public List<InspectorComponent<PropMgr>> createInspectorComponents(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull PropMgr propertiesManager) {
        List<InspectorProvider<PropMgr>> providers = this.getProviders();
        ArrayList<InspectorComponent<PropMgr>> inspectors = new ArrayList<InspectorComponent<PropMgr>>(providers.size());
        if (components.isEmpty()) {
            return ImmutableList.of(this.getNullProvider().createCustomInspector(components, properties, propertiesManager));
        }
        for (InspectorProvider<PropMgr> provider : providers) {
            if (!provider.isApplicable(components, properties, propertiesManager)) continue;
            inspectors.add(provider.createCustomInspector(components, properties, propertiesManager));
        }
        return inspectors;
    }

    public void lookAndFeelChanged(@NotNull LafManager source) {
        this.resetCache();
        ((PropertiesManager)this.myPropertiesManager).updateSelection();
    }

    public void resetCache() {
        this.getProviders().forEach(InspectorProvider::resetCache);
    }

    public void dispose() {
        LafManager.getInstance().removeLafManagerListener((LafManagerListener)this);
    }

    protected abstract List<InspectorProvider<PropMgr>> getProviders();

    protected abstract InspectorProvider<PropMgr> getNullProvider();
}

