/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene;

import com.android.ide.common.rendering.api.ViewInfo;
import com.android.ide.common.resources.configuration.LayoutDirectionQualifier;
import com.android.resources.LayoutDirection;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionListener;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.Placeholder;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.SceneHitListener;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.target.AnchorTarget;
import com.android.tools.idea.common.scene.target.LassoTarget;
import com.android.tools.idea.common.scene.target.MultiComponentTarget;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderSettings;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.constraint.SecondarySelector;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.decorator.DecoratorUtilities;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ui.JBUI;
import java.awt.Cursor;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Scene
implements SelectionListener,
Disposable {
    private static final int DRAG_THRESHOLD = JBUI.scale((int)10);
    private final DesignSurface myDesignSurface;
    private final SceneManager mySceneManager;
    private static final boolean DEBUG = false;
    private final HashMap<NlComponent, SceneComponent> mySceneComponents = new HashMap();
    private SceneComponent myRoot;
    private boolean myIsAnimated = true;
    public static final int NO_LAYOUT = 0;
    public static final int IMMEDIATE_LAYOUT = 1;
    public static final int ANIMATED_LAYOUT = 2;
    private long myDisplayListVersion = 1L;
    private Target myOverTarget;
    private Target mySnapTarget;
    private SceneComponent myCurrentComponent;
    NlComponent myLastHoverConstraintComponent = null;
    private int mNeedsLayout = 0;
    protected int myPressedMouseX;
    protected int myPressedMouseY;
    private int myLastMouseX;
    private int myLastMouseY;
    @NotNull
    private final SceneHitListener myHoverListener;
    @NotNull
    private final SceneHitListener myHitListener;
    @NotNull
    private final SceneHitListener myFindListener;
    @NotNull
    private final SceneHitListener mySnapListener;
    @Nullable
    private Target myHitTarget = null;
    private Cursor myMouseCursor;
    private SceneComponent myHitComponent;
    List<SceneComponent> myNewSelectedComponentsOnRelease = new ArrayList<SceneComponent>();
    List<SceneComponent> myNewSelectedComponentsOnDown = new ArrayList<SceneComponent>();
    Set<SceneComponent> myHoveredComponents = new HashSet<SceneComponent>();
    private boolean myIsCtrlMetaDown;
    private boolean myIsShiftDown;
    private boolean myIsAltDown;
    private boolean myIsLiveRenderingEnabled;
    @NotNull
    private FilterType myFilterType = FilterType.NONE;

    public Scene(@NotNull SceneManager sceneManager, @NotNull DesignSurface surface, @NotNull RenderSettings renderSettings) {
        this.myDesignSurface = surface;
        this.mySceneManager = sceneManager;
        SelectionModel selectionModel = this.myDesignSurface.getSelectionModel();
        this.myHoverListener = new SceneHitListener(selectionModel);
        this.myHitListener = new SceneHitListener(selectionModel);
        this.myFindListener = new SceneHitListener(selectionModel);
        this.mySnapListener = new SceneHitListener(selectionModel);
        selectionModel.addListener(this);
        this.myHoverListener.setTargetFilter(target -> {
            if (target instanceof AnchorTarget) {
                AnchorTarget anchorTarget = (AnchorTarget)target;
                if (this.myHitTarget == null) {
                    return !anchorTarget.isEdge();
                }
                if (this.myHitTarget instanceof AnchorTarget) {
                    return ((AnchorTarget)this.myHitTarget).isConnectible(anchorTarget);
                }
            }
            return true;
        });
        this.myIsLiveRenderingEnabled = renderSettings.getUseLiveRendering();
        Disposer.register((Disposable)sceneManager, (Disposable)this);
    }

    public void dispose() {
        this.myDesignSurface.getSelectionModel().removeListener(this);
    }

    @NotNull
    public SceneManager getSceneManager() {
        return this.mySceneManager;
    }

    public boolean supportsRTL() {
        return true;
    }

    public boolean isInRTL() {
        Configuration configuration = this.myDesignSurface.getConfiguration();
        if (configuration == null) {
            return false;
        }
        LayoutDirectionQualifier qualifier = configuration.getFullConfig().getLayoutDirectionQualifier();
        if (qualifier == null) {
            return false;
        }
        return qualifier.getValue() == LayoutDirection.RTL;
    }

    public int getRenderedApiLevel() {
        IAndroidTarget target;
        Configuration configuration = this.myDesignSurface.getConfiguration();
        if (configuration != null && (target = configuration.getTarget()) != null) {
            return target.getVersion().getApiLevel();
        }
        return 1;
    }

    public boolean isAnimated() {
        return this.myIsAnimated;
    }

    public void setAnimated(boolean animated) {
        this.myIsAnimated = animated;
    }

    @Nullable
    public SceneComponent getSceneComponent(@Nullable NlComponent component) {
        if (component == null) {
            return null;
        }
        return this.mySceneComponents.get(component);
    }

    @NotNull
    public DesignSurface getDesignSurface() {
        return this.myDesignSurface;
    }

    @Nullable
    public SceneComponent getSceneComponent(@NotNull String componentId) {
        if (this.myRoot == null) {
            return null;
        }
        return this.myRoot.getSceneComponent(componentId);
    }

    public List<NlComponent> getSelection() {
        return this.myDesignSurface.getSelectionModel().getSelection();
    }

    @Nullable
    public Object getSecondarySelection() {
        return this.myDesignSurface.getSelectionModel().getSecondarySelection();
    }

    @Nullable
    public SceneComponent getRoot() {
        return this.myRoot;
    }

    public Cursor getMouseCursor() {
        return this.myMouseCursor;
    }

    public void updateModifiers(int modifiers) {
        int ctrlMetaDownMask = AdtUiUtils.getActionMask();
        int ctrlMetaMask = SystemInfo.isMac ? 4 : 2;
        this.myIsCtrlMetaDown = (modifiers & ctrlMetaDownMask) != 0 || (modifiers & ctrlMetaMask) != 0;
        this.myIsShiftDown = (modifiers & 0x40) != 0 || (modifiers & 1) != 0;
        this.myIsAltDown = (modifiers & 0x200) != 0 || (modifiers & 8) != 0;
    }

    public boolean isCtrlMetaDown() {
        return this.myIsCtrlMetaDown;
    }

    public boolean isShiftDown() {
        return this.myIsShiftDown;
    }

    public boolean isAltDown() {
        return this.myIsAltDown;
    }

    public void clearAllConstraints() {
        if (this.myRoot != null) {
            Stream.of(this.myRoot).flatMap(c -> c.getChildren().stream()).forEach(c -> c.clearAttributes());
        }
        this.select(Collections.emptyList());
    }

    public void addComponent(@NotNull SceneComponent component) {
        this.mySceneComponents.put(component.getNlComponent(), component);
        this.needsRebuildList();
    }

    public void removeComponent(@NotNull SceneComponent component) {
        component.removeFromParent();
        this.mySceneComponents.remove(component.getNlComponent(), component);
        this.needsRebuildList();
    }

    void removeAllComponents() {
        Iterator<Map.Entry<NlComponent, SceneComponent>> it = this.mySceneComponents.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<NlComponent, SceneComponent> entry = it.next();
            entry.getValue().removeFromParent();
            it.remove();
        }
    }

    @Override
    public void selectionChanged(@NotNull SelectionModel model2, @NotNull List<NlComponent> selection) {
        if (this.myRoot != null) {
            Scene.markSelection(this.myRoot, model2);
        }
    }

    private static void markSelection(SceneComponent component, SelectionModel model2) {
        component.setSelected(model2.isSelected(component.getNlComponent()));
        for (SceneComponent child : component.getChildren()) {
            Scene.markSelection(child, model2);
        }
    }

    public void buildDisplayList(@NotNull DisplayList displayList, long time2, SceneView sceneView) {
        this.buildDisplayList(displayList, time2, SceneContext.get(sceneView));
    }

    public void buildDisplayList(@NotNull DisplayList displayList, long time2) {
        this.layout(time2, SceneContext.get());
        this.buildDisplayList(displayList, time2, SceneContext.get());
    }

    public void repaint() {
        this.myDesignSurface.repaint();
    }

    public void buildDisplayList(@NotNull DisplayList displayList, long time2, SceneContext sceneContext) {
        if (this.myRoot != null) {
            sceneContext.getScenePicker().foreachObject(o -> {
                if (o instanceof SecondarySelector) {
                    ((SecondarySelector)o).release();
                }
            });
            sceneContext.getScenePicker().reset();
            this.myRoot.buildDisplayList(time2, displayList, sceneContext);
        }
    }

    public boolean layout(long time2, SceneContext sceneContext) {
        boolean needsToRebuildDisplayList = false;
        if (this.myRoot != null && (needsToRebuildDisplayList = this.myRoot.layout(sceneContext, time2))) {
            this.needsRebuildList();
        }
        return needsToRebuildDisplayList;
    }

    public void select(List<SceneComponent> components) {
        if (this.myDesignSurface != null) {
            ArrayList<NlComponent> nlComponents = new ArrayList<NlComponent>();
            if (this.myIsShiftDown || this.myIsCtrlMetaDown) {
                ImmutableList<NlComponent> selection = this.myDesignSurface.getSelectionModel().getSelection();
                nlComponents.addAll((Collection<NlComponent>)selection);
            }
            for (SceneComponent sceneComponent : components) {
                NlComponent nlComponent = sceneComponent.getNlComponent();
                if ((this.myIsShiftDown || this.myIsCtrlMetaDown) && nlComponents.contains(nlComponent)) {
                    nlComponents.remove(nlComponent);
                    continue;
                }
                nlComponents.add(nlComponent);
            }
            this.myDesignSurface.getSelectionModel().setSelection(nlComponents);
        }
    }

    public void mouseHover(@NotNull SceneContext transform2, int x, int y) {
        Object obj;
        this.myLastMouseX = x;
        this.myLastMouseY = y;
        if (this.myLastHoverConstraintComponent != null) {
            this.myLastHoverConstraintComponent.putClientProperty("CONSTRAINT_HOVER", null);
            this.myLastHoverConstraintComponent = null;
            this.needsRebuildList();
        }
        if (this.myRoot != null) {
            this.myHoverListener.find(transform2, this.myRoot, x, y);
            this.mySnapListener.find(transform2, this.myRoot, x, y);
        }
        this.repaint();
        Target closestTarget = this.myHoverListener.getClosestTarget();
        String tooltip = null;
        if (this.myOverTarget != closestTarget) {
            if (this.myOverTarget != null) {
                this.myOverTarget.setMouseHovered(false);
                this.myOverTarget = null;
                this.needsRebuildList();
            }
            if (closestTarget != null) {
                closestTarget.setMouseHovered(true);
                this.myOverTarget = closestTarget;
                this.needsRebuildList();
            }
        }
        if (closestTarget != null) {
            tooltip = closestTarget.getToolTipText();
            Target snapTarget = this.myHoverListener.getFilteredTarget(closestTarget);
            if (snapTarget != this.mySnapTarget) {
                if (this.mySnapTarget != null) {
                    this.mySnapTarget.setMouseHovered(false);
                    this.mySnapTarget = null;
                    this.needsRebuildList();
                }
                if (snapTarget != null) {
                    snapTarget.setMouseHovered(true);
                    this.mySnapTarget = closestTarget;
                    this.needsRebuildList();
                }
            }
        }
        this.updateHoveredComponentsDrawState();
        SceneComponent closestComponent = this.myHoverListener.getClosestComponent();
        if (closestComponent != null && tooltip == null) {
            tooltip = closestComponent.getNlComponent().getTooltipText();
        }
        if (this.myCurrentComponent != closestComponent) {
            if (this.myCurrentComponent != null) {
                this.myCurrentComponent.setDrawState(SceneComponent.DrawState.NORMAL);
                this.myCurrentComponent = null;
            }
            if (closestComponent != null) {
                closestComponent.setDrawState(SceneComponent.DrawState.HOVER);
                this.myCurrentComponent = closestComponent;
            }
            this.needsRebuildList();
        }
        if ((closestComponent == null || closestComponent.getNlComponent().isRoot() && this.myOverTarget == null) && (obj = transform2.findClickedGraphics(transform2.getSwingXDip(x), transform2.getSwingYDip(y))) != null && obj instanceof SecondarySelector) {
            SecondarySelector ss = (SecondarySelector)obj;
            NlComponent component = ss.getComponent();
            this.myLastHoverConstraintComponent = ss.getComponent();
            tooltip = this.getConstraintToolTip(ss);
            component.putClientProperty("CONSTRAINT_HOVER", (Object)ss.getConstraint());
            this.needsRebuildList();
        }
        transform2.setToolTip(tooltip);
        this.setCursor(transform2, x, y);
    }

    @NotNull
    private String getConstraintToolTip(@NotNull SecondarySelector ss) {
        String tooltip;
        NlComponent component = ss.getComponent();
        String connect = "";
        String target = "";
        SecondarySelector.Constraint connection = ss.getConstraint();
        if (this.isInRTL()) {
            if (connection == SecondarySelector.Constraint.LEFT) {
                connection = SecondarySelector.Constraint.RIGHT;
            } else if (connection == SecondarySelector.Constraint.RIGHT) {
                connection = SecondarySelector.Constraint.LEFT;
            }
        }
        switch (connection) {
            case LEFT: {
                connect = "layout_constraintStart_toStartOf";
                target = component.getAttribute("http://schemas.android.com/apk/res-auto", connect);
                if (target != null || (target = component.getAttribute("http://schemas.android.com/apk/res-auto", connect = "layout_constraintStart_toEndOf")) == null) break;
                break;
            }
            case RIGHT: {
                connect = "layout_constraintEnd_toStartOf";
                target = component.getAttribute("http://schemas.android.com/apk/res-auto", connect);
                if (target != null || (target = component.getAttribute("http://schemas.android.com/apk/res-auto", connect = "layout_constraintEnd_toEndOf")) == null) break;
                break;
            }
            case TOP: {
                connect = "layout_constraintTop_toTopOf";
                target = component.getAttribute("http://schemas.android.com/apk/res-auto", connect);
                if (target != null || (target = component.getAttribute("http://schemas.android.com/apk/res-auto", connect = "layout_constraintTop_toBottomOf")) == null) break;
                break;
            }
            case BOTTOM: {
                connect = "layout_constraintBottom_toTopOf";
                target = component.getAttribute("http://schemas.android.com/apk/res-auto", connect);
                if (target != null || (target = component.getAttribute("http://schemas.android.com/apk/res-auto", connect = "layout_constraintBottom_toBottomOf")) == null) break;
                break;
            }
            case BASELINE: {
                connect = "layout_constraintBaseline_toBaselineOf";
                target = component.getAttribute("http://schemas.android.com/apk/res-auto", connect);
            }
        }
        try {
            connect = connect.substring("layout_constraint".length(), connect.length() - 2).replace("_to", " to ").toLowerCase();
            target = target.substring(target.indexOf("/") + 1);
            tooltip = component.getTooltipText() + " " + connect + " of " + target;
        }
        catch (Exception ex) {
            tooltip = "";
        }
        return tooltip;
    }

    private void updateHoveredComponentsDrawState() {
        ArrayList<SceneComponent> hitComponents = this.myHoverListener.getHitComponents();
        for (SceneComponent component : hitComponents) {
            if (component != this.myCurrentComponent) {
                NlComponent nlComponent = component.getAuthoritativeNlComponent();
                if (DecoratorUtilities.getTryingToConnectState(nlComponent) != null) {
                    component.setDrawState(SceneComponent.DrawState.HOVER);
                } else {
                    component.setDrawState(SceneComponent.DrawState.NORMAL);
                }
            }
            this.myHoveredComponents.remove(component);
        }
        Iterator<SceneComponent> iterator = this.myHoveredComponents.iterator();
        while (iterator.hasNext()) {
            SceneComponent component;
            component = iterator.next();
            component.setDrawState(SceneComponent.DrawState.NORMAL);
            iterator.remove();
        }
        this.myHoveredComponents.addAll(hitComponents);
    }

    private void setCursor(@NotNull SceneContext transform2, int x, int y) {
        this.myMouseCursor = Cursor.getDefaultCursor();
        if (this.myCurrentComponent != null && this.myCurrentComponent.isDragging()) {
            this.myMouseCursor = Cursor.getPredefinedCursor(13);
            return;
        }
        if (this.myOverTarget != null) {
            this.myMouseCursor = this.myOverTarget.getMouseCursor();
            return;
        }
        SceneComponent component = this.findComponent(transform2, x, y);
        if (component != null && component.getParent() != null) {
            this.myMouseCursor = Cursor.getPredefinedCursor(12);
        }
    }

    private void delegateMouseDownToSelection(int x, int y, SceneComponent currentComponent) {
        List<NlComponent> selection = this.getSelection();
        if (selection.size() > 1) {
            for (NlComponent nlComponent : selection) {
                SceneComponent c;
                if (nlComponent == currentComponent.getNlComponent() || (c = currentComponent.getScene().getSceneComponent(nlComponent)) == null || c == currentComponent) continue;
                for (Target target : c.getTargets()) {
                    if (!(target instanceof MultiComponentTarget)) continue;
                    target.mouseDown(x, y);
                }
            }
        }
    }

    private void delegateMouseDragToSelection(int x, int y, @Nullable Target closestTarget, @NotNull SceneComponent currentComponent) {
        List<NlComponent> selection = this.getSelection();
        if (selection.size() > 1) {
            for (NlComponent nlComponent : selection) {
                SceneComponent c;
                if (nlComponent == currentComponent.getNlComponent() || (c = currentComponent.getScene().getSceneComponent(nlComponent)) == null || c == currentComponent) continue;
                for (Target target : c.getTargets()) {
                    if (!(target instanceof MultiComponentTarget)) continue;
                    ArrayList<Target> list = new ArrayList<Target>();
                    list.add(closestTarget);
                    target.mouseDrag(x, y, list);
                }
            }
        }
    }

    private void delegateMouseReleaseToSelection(int x, int y, @Nullable Target closestTarget, @NotNull SceneComponent currentComponent) {
        List<NlComponent> selection = this.getSelection();
        if (selection.size() > 1) {
            int count = selection.size();
            for (int i2 = 0; i2 < count; ++i2) {
                SceneComponent c;
                NlComponent nlComponent = selection.get(i2);
                if (nlComponent == currentComponent.getNlComponent() || (c = currentComponent.getScene().getSceneComponent(nlComponent)) == null) continue;
                for (Target target : c.getTargets()) {
                    if (!(target instanceof MultiComponentTarget)) continue;
                    target.mouseRelease(x, y, Collections.singletonList(closestTarget));
                }
            }
        }
    }

    private void delegateMouseCancelToSelection(@NotNull SceneComponent currentComponent) {
        NlComponent currentNlComponent = currentComponent.getNlComponent();
        Scene scene = currentComponent.getScene();
        List otherComponents = this.getSelection().stream().filter(it -> it != currentNlComponent).map(it -> scene.getSceneComponent((NlComponent)it)).filter(it -> it != null).collect(Collectors.toList());
        for (SceneComponent c : otherComponents) {
            ImmutableList<Target> targets = c.getTargets();
            for (Target t : targets) {
                if (!(t instanceof MultiComponentTarget)) continue;
                t.mouseCancel();
            }
        }
    }

    public void mouseDown(@NotNull SceneContext transform2, int x, int y) {
        this.myPressedMouseX = x;
        this.myPressedMouseY = y;
        this.mNeedsLayout = 0;
        this.myLastMouseX = x;
        this.myLastMouseY = y;
        this.myFilterType = FilterType.NONE;
        if (this.myRoot == null) {
            return;
        }
        this.myNewSelectedComponentsOnDown.clear();
        this.myHitListener.setTargetFilter(it -> {
            if (it instanceof AnchorTarget) {
                return !((AnchorTarget)it).isEdge();
            }
            return true;
        });
        SecondarySelector secondarySelector = this.getSelector(transform2, x, y);
        this.myHitListener.find(transform2, this.myRoot, x, y);
        this.myHitTarget = this.myHitListener.getClosestTarget();
        this.myHitComponent = this.myHitListener.getClosestComponent();
        if (this.myHitTarget != null) {
            this.myHitTarget.mouseDown(x, y);
            if (this.myHitTarget instanceof MultiComponentTarget) {
                this.delegateMouseDownToSelection(x, y, this.myHitTarget.getComponent());
            }
        } else if (this.myHitComponent != null && !this.inCurrentSelection(this.myHitComponent)) {
            this.myNewSelectedComponentsOnDown.add(this.myHitComponent);
            this.select(this.myNewSelectedComponentsOnDown);
        } else if (this.findSelectionOfCurve(secondarySelector)) {
            return;
        }
        this.myHitListener.setTargetFilter(null);
    }

    private SecondarySelector getSelector(@NotNull SceneContext transform2, int x, int y) {
        Object obj = transform2.findClickedGraphics(transform2.getSwingXDip(x), transform2.getSwingYDip(y));
        if (obj != null && obj instanceof SecondarySelector) {
            return (SecondarySelector)obj;
        }
        return null;
    }

    public void mouseDrag(@NotNull SceneContext transform2, int x, int y) {
        if (this.myLastMouseX == x && this.myLastMouseY == y) {
            return;
        }
        this.myLastMouseX = x;
        this.myLastMouseY = y;
        if (this.myHitTarget != null) {
            if (!this.myHitTarget.getComponent().isDragging() && !this.myDesignSurface.getSelectionModel().isSelected(this.myHitTarget.getComponent().getNlComponent()) && Scene.isWithinThreshold(this.myPressedMouseX, x, transform2) && Scene.isWithinThreshold(this.myPressedMouseY, y, transform2)) {
                return;
            }
            LassoTarget lassoTarget = null;
            if (this.myHitTarget instanceof LassoTarget && (lassoTarget = (LassoTarget)this.myHitTarget).getSelectWhileDragging() && lassoTarget.getHasChanged()) {
                this.myNewSelectedComponentsOnRelease.clear();
                this.myNewSelectedComponentsOnRelease.addAll(lassoTarget.getIntersectingComponents());
                this.select(this.myNewSelectedComponentsOnRelease);
                lassoTarget.clearHasChanged();
            }
            this.myHitListener.setTargetFilter(target -> this.myHitTarget != target);
            this.myHitListener.find(transform2, this.myRoot, x, y);
            SceneComponent targetComponent = this.myHitTarget.getComponent();
            if ((lassoTarget == null || lassoTarget.getIntersectingComponents().isEmpty()) && targetComponent != null && !this.inCurrentSelection(targetComponent)) {
                this.myNewSelectedComponentsOnRelease.clear();
                this.myNewSelectedComponentsOnRelease.add(targetComponent);
                this.select(this.myNewSelectedComponentsOnRelease);
            }
            this.myHitTarget.mouseDrag(x, y, this.myHitListener.myHitTargets);
            if (this.myHitTarget instanceof MultiComponentTarget) {
                this.delegateMouseDragToSelection(x, y, this.myHitListener.getClosestTarget(), this.myHitTarget.getComponent());
            }
            this.myHitListener.setTargetFilter(null);
        }
        this.mouseHover(transform2, x, y);
        this.checkRequestLayoutStatus();
    }

    private static boolean isWithinThreshold(int pos1, int pos2, SceneContext transform2) {
        int pos4;
        int pos3 = transform2.getSwingDimensionDip(pos1);
        return Math.abs(pos3 - (pos4 = transform2.getSwingDimensionDip(pos2))) < DRAG_THRESHOLD;
    }

    public void checkRequestLayoutStatus() {
        if (this.mNeedsLayout != 0) {
            SceneManager manager = this.myDesignSurface.getSceneManager();
            if (manager == null) {
                return;
            }
            if (this.myIsLiveRenderingEnabled) {
                manager.requestLayoutAndRender(this.mNeedsLayout == 2);
            } else {
                manager.layout(this.mNeedsLayout == 2);
            }
        }
    }

    private boolean findSelectionOfCurve(SecondarySelector ss) {
        if (ss == null) {
            return false;
        }
        NlComponent comp = ss.getComponent();
        SecondarySelector.Constraint sub = ss.getConstraint();
        this.myDesignSurface.getSelectionModel().setSecondarySelection(comp, (Object)sub);
        return true;
    }

    public void mouseRelease(@NotNull SceneContext transform2, int x, int y) {
        List<SceneComponent> changed;
        this.myLastMouseX = x;
        this.myLastMouseY = y;
        SceneComponent closestComponent = this.myHitListener.getClosestComponent();
        if (this.myHitTarget != null) {
            this.myHitListener.find(transform2, this.myRoot, x, y);
            Target closest = this.myHitListener.getFilteredTarget(this.myHitTarget);
            this.myHitTarget.mouseRelease(x, y, closest != null ? Collections.singletonList(closest) : Collections.emptyList());
            this.myHitTarget.getComponent().setDragging(false);
            if (this.myHitTarget instanceof MultiComponentTarget) {
                this.delegateMouseReleaseToSelection(x, y, this.myHitListener.getClosestTarget(), this.myHitTarget.getComponent());
            }
        }
        this.myFilterType = FilterType.NONE;
        this.myNewSelectedComponentsOnRelease.clear();
        if (this.myHitComponent != null && closestComponent == this.myHitComponent) {
            this.myNewSelectedComponentsOnRelease.add(this.myHitComponent);
        }
        if (this.myHitTarget != null && (changed = this.myHitTarget.newSelection()) != null) {
            this.myNewSelectedComponentsOnRelease.clear();
            this.myNewSelectedComponentsOnRelease.addAll(changed);
        }
        SecondarySelector secondarySelector = this.getSelector(transform2, x, y);
        boolean same = this.sameSelection();
        if (secondarySelector == null && !same && (this.myHitTarget == null || this.myHitTarget.canChangeSelection())) {
            this.select(this.myNewSelectedComponentsOnRelease);
        } else {
            this.myDesignSurface.getSelectionModel().clearSecondary();
            this.findSelectionOfCurve(secondarySelector);
        }
        this.myHitTarget = null;
        this.checkRequestLayoutStatus();
    }

    public void mouseCancel() {
        if (this.myHitTarget != null) {
            this.myHitTarget.mouseCancel();
            this.myHitTarget.getComponent().setDragging(false);
            if (this.myHitTarget instanceof MultiComponentTarget) {
                this.delegateMouseCancelToSelection(this.myHitTarget.getComponent());
            }
        }
        this.myFilterType = FilterType.NONE;
        this.myNewSelectedComponentsOnRelease.clear();
        this.myHitTarget = null;
        this.checkRequestLayoutStatus();
    }

    private boolean inCurrentSelection(@NotNull SceneComponent component) {
        ImmutableList<NlComponent> currentSelection = this.myDesignSurface.getSelectionModel().getSelection();
        return currentSelection.contains(component.getNlComponent());
    }

    private boolean sameSelection() {
        if (!this.myNewSelectedComponentsOnRelease.isEmpty() && this.myNewSelectedComponentsOnRelease.size() == this.myNewSelectedComponentsOnDown.size() && this.myNewSelectedComponentsOnRelease.containsAll(this.myNewSelectedComponentsOnDown)) {
            return true;
        }
        ImmutableList<NlComponent> currentSelection = this.myDesignSurface.getSelectionModel().getSelection();
        if (this.myNewSelectedComponentsOnRelease.size() == currentSelection.size()) {
            int count = currentSelection.size();
            for (int i2 = 0; i2 < count; ++i2) {
                NlComponent component = (NlComponent)currentSelection.get(i2);
                SceneComponent sceneComponent = this.getSceneComponent(component);
                if (this.myNewSelectedComponentsOnRelease.contains(sceneComponent)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void needsLayout(int type) {
        this.mNeedsLayout = type;
    }

    public long getDisplayListVersion() {
        return this.myDisplayListVersion;
    }

    public void needsRebuildList() {
        ++this.myDisplayListVersion;
    }

    public List<SceneComponent> findWithin(int x, int y, int width, int height) {
        ArrayList within = Lists.newArrayList();
        if (this.getRoot() != null) {
            Scene.addWithin(within, this.getRoot(), x, y, width, height);
        }
        return within;
    }

    private static boolean addWithin(@NotNull List<SceneComponent> result2, @NotNull SceneComponent component, int x, int y, int width, int height) {
        if (component.getDrawX() + component.getDrawWidth() <= x || x + width <= component.getDrawX() || component.getDrawY() + component.getDrawHeight() <= y || y + height <= component.getDrawY()) {
            return false;
        }
        boolean found = false;
        for (SceneComponent child : component.getChildren()) {
            found |= Scene.addWithin(result2, child, x, y, width, height);
        }
        if (!found) {
            result2.add(component);
        }
        return true;
    }

    @Nullable
    public SceneComponent findComponent(@NotNull SceneContext transform2, int x, int y) {
        if (this.myRoot == null) {
            return null;
        }
        this.myFindListener.find(transform2, this.myRoot, x, y);
        return this.myFindListener.getClosestComponent();
    }

    @Nullable
    public Target findTarget(@NotNull SceneContext transform2, int x, int y) {
        if (this.myRoot == null) {
            return null;
        }
        this.myFindListener.find(transform2, this.myRoot, x, y);
        return this.myFindListener.getClosestTarget();
    }

    public Collection<SceneComponent> getSceneComponents() {
        return this.mySceneComponents.values();
    }

    public void setRoot(SceneComponent root) {
        this.myRoot = root;
    }

    @NotNull
    public FilterType getFilterType() {
        return this.myFilterType;
    }

    public void setFilterType(@NotNull FilterType filterType) {
        this.myFilterType = filterType;
    }

    @Nullable
    public Target getInteractingTarget() {
        return this.myHitTarget;
    }

    @Nullable
    public Dimension measureWrapSize(@NotNull SceneComponent component) {
        return this.measure(component, (n, namespace, localName) -> {
            if ("layout_width".equals(localName) && "http://schemas.android.com/apk/res/android".equals(namespace)) {
                return "wrap_content";
            }
            if ("layout_height".equals(localName) && "http://schemas.android.com/apk/res/android".equals(namespace)) {
                return "wrap_content";
            }
            return null;
        });
    }

    @Nullable
    private Dimension measure(@NotNull SceneComponent component, @Nullable RenderTask.AttributeFilter filter2) {
        NlComponent neleComponent = component.getNlComponent();
        if (!neleComponent.getBackend().isValid()) {
            return null;
        }
        NlModel model2 = neleComponent.getModel();
        XmlFile xmlFile = model2.getFile();
        Module module = model2.getModule();
        RenderService renderService = RenderService.getInstance(module.getProject());
        AndroidFacet facet = model2.getFacet();
        RenderLogger logger = renderService.createLogger(facet);
        RenderTask task = renderService.taskBuilder(facet, model2.getConfiguration()).withLogger(logger).withPsiFile((PsiFile)xmlFile).buildSynchronously();
        if (task == null) {
            return null;
        }
        XmlTag tag = neleComponent.getTagDeprecated();
        ViewInfo viewInfo = task.measureChild(tag, filter2);
        if (viewInfo == null) {
            return null;
        }
        viewInfo = RenderService.getSafeBounds(viewInfo);
        return new Dimension(Coordinates.pxToDp(this.getDesignSurface(), viewInfo.getRight() - viewInfo.getLeft()), Coordinates.pxToDp(this.getDesignSurface(), viewInfo.getBottom() - viewInfo.getTop()));
    }

    public List<Placeholder> getPlaceholders(@Nullable SceneComponent requester) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        Scene.doGetPlaceholders((ImmutableList.Builder<Placeholder>)builder, this.myRoot, requester);
        return builder.build();
    }

    public boolean isLiveRenderingEnabled() {
        return this.myIsLiveRenderingEnabled;
    }

    public void setLiveRenderingEnabled(boolean enabled) {
        this.myIsLiveRenderingEnabled = enabled;
    }

    private static void doGetPlaceholders(@NotNull ImmutableList.Builder<Placeholder> builder, @NotNull SceneComponent component, @Nullable SceneComponent requester) {
        if (component == requester) {
            return;
        }
        NlComponent nlComponent = component.getNlComponent();
        ViewHandler handler = NlComponentHelperKt.getViewHandler(nlComponent);
        if (handler != null) {
            builder.addAll(handler.getPlaceholders(component));
        }
        for (SceneComponent child : component.getChildren()) {
            Scene.doGetPlaceholders(builder, child, requester);
        }
    }

    public void setHitTarget(@Nullable Target hitTarget) {
        this.myHitTarget = hitTarget;
    }

    public static enum FilterType {
        ALL,
        ANCHOR,
        VERTICAL_ANCHOR,
        HORIZONTAL_ANCHOR,
        BASELINE_ANCHOR,
        NONE,
        RESIZE;

    }
}

