/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene;

import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.ComponentProvider;
import com.android.tools.idea.common.scene.HitProvider;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.scene.ScenePicker;
import com.android.tools.idea.common.scene.TargetProvider;
import com.android.tools.idea.common.scene.TemporarySceneComponent;
import com.android.tools.idea.common.scene.decorator.SceneDecorator;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.target.CommonDragTarget;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.decorator.DecoratorUtilities;
import com.android.tools.idea.uibuilder.scene.target.Notch;
import com.android.tools.idea.uibuilder.scene.target.ResizeBaseTarget;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SceneComponent {
    public static final int ANIMATION_DURATION = 350;
    public HashMap<String, Object> myCache = new HashMap();
    public SceneDecorator myDecorator;
    private TargetProvider myTargetProvider;
    private ComponentProvider myComponentProvider;
    private HitProvider myHitProvider;
    private final Scene myScene;
    private final NlComponent myNlComponent;
    private CopyOnWriteArrayList<SceneComponent> myChildren = new CopyOnWriteArrayList();
    private SceneComponent myParent = null;
    private boolean myIsToolLocked = false;
    private boolean myIsSelected = false;
    protected boolean myDragging = false;
    private AnimatedValue myAnimatedDrawX = new AnimatedValue();
    private AnimatedValue myAnimatedDrawY = new AnimatedValue();
    private AnimatedValue myAnimatedDrawWidth = new AnimatedValue();
    private AnimatedValue myAnimatedDrawHeight = new AnimatedValue();
    private DrawState myDrawState = DrawState.NORMAL;
    @GuardedBy(value="myTargets")
    private final ArrayList<Target> myTargets = new ArrayList();
    @GuardedBy(value="myTargets")
    @Nullable
    private ImmutableList<Target> myCachedTargetList;
    private int myCurrentLeft = 0;
    private int myCurrentTop = 0;
    private int myCurrentRight = 0;
    private int myCurrentBottom = 0;
    private boolean myShowBaseline = false;
    @Nullable
    private Notch.Provider myNotchProvider = null;

    public int getCenterX() {
        return this.myCurrentLeft + (this.myCurrentRight - this.myCurrentLeft) / 2;
    }

    public int getCenterY() {
        return this.myCurrentTop + (this.myCurrentBottom - this.myCurrentTop) / 2;
    }

    public SceneComponent(@NotNull Scene scene, @NotNull NlComponent component, @NotNull HitProvider hitProvider) {
        this.myScene = scene;
        this.myNlComponent = component;
        this.myScene.addComponent(this);
        SceneManager manager = scene.getSceneManager();
        this.myDecorator = manager.getSceneDecoratorFactory().get(component);
        this.myHitProvider = hitProvider;
        this.setSelected(this.myScene.getDesignSurface().getSelectionModel().isSelected(component));
    }

    public String toString() {
        return this.getNlComponent().toString() + " [ " + this.myCurrentLeft + ", " + this.myCurrentTop + " - " + this.myCurrentRight + ", " + this.myCurrentBottom + "]";
    }

    @Nullable
    public SceneComponent getParent() {
        return this.myParent;
    }

    private void setParent(@NotNull SceneComponent parent) {
        this.myParent = parent;
    }

    public int getDepth() {
        int depth = 0;
        SceneComponent current = this.myParent;
        while (current != null) {
            current = current.myParent;
            ++depth;
        }
        return depth;
    }

    private TargetProvider getTargetProvider() {
        return this.myTargetProvider;
    }

    public boolean useRtlAttributes() {
        return this.myScene.supportsRTL();
    }

    public int findTarget(Class aClass) {
        ImmutableList<Target> targets = this.getTargets();
        int count = targets.size();
        for (int i2 = 0; i2 < count; ++i2) {
            if (!aClass.isInstance(targets.get(i2))) continue;
            return i2;
        }
        return -1;
    }

    boolean hasAncestor(SceneComponent candidate) {
        for (SceneComponent parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (parent != candidate) continue;
            return true;
        }
        return false;
    }

    public boolean isSelected() {
        return this.myIsSelected;
    }

    public boolean canShowBaseline() {
        return this.myShowBaseline;
    }

    public void setShowBaseline(boolean value2) {
        this.myShowBaseline = value2;
    }

    public boolean hasNoDimension() {
        return this.myAnimatedDrawWidth.value == 0 && this.myAnimatedDrawHeight.value == 0 && this.myAnimatedDrawX.value == this.myAnimatedDrawX.target && this.myAnimatedDrawY.value == this.myAnimatedDrawY.target;
    }

    public int getDrawX() {
        return this.myAnimatedDrawX.getValue(0L);
    }

    public int getDrawY() {
        return this.myAnimatedDrawY.getValue(0L);
    }

    public int getDrawWidth() {
        return this.myAnimatedDrawWidth.getValue(0L);
    }

    public int getDrawHeight() {
        return this.myAnimatedDrawHeight.getValue(0L);
    }

    public int getDrawX(long time2) {
        return this.myAnimatedDrawX.getValue(time2);
    }

    public int getDrawY(long time2) {
        return this.myAnimatedDrawY.getValue(time2);
    }

    public int getDrawWidth(long time2) {
        return this.myAnimatedDrawWidth.getValue(time2);
    }

    public int getDrawHeight(long time2) {
        return this.myAnimatedDrawHeight.getValue(time2);
    }

    public void setPosition(int dx, int dy) {
        this.myAnimatedDrawX.setValue(dx);
        this.myAnimatedDrawY.setValue(dy);
        if (NlComponentHelperKt.getHasNlComponentInfo(this.myNlComponent)) {
            NlComponentHelperKt.setX(this.myNlComponent, Coordinates.dpToPx(this.myScene.getDesignSurface(), (float)dx));
            NlComponentHelperKt.setY(this.myNlComponent, Coordinates.dpToPx(this.myScene.getDesignSurface(), (float)dy));
        }
        this.myScene.needsRebuildList();
    }

    public void setPositionTarget(int dx, int dy, long time2) {
        this.myAnimatedDrawX.setTarget(dx, time2);
        this.myAnimatedDrawY.setTarget(dy, time2);
        if (NlComponentHelperKt.getHasNlComponentInfo(this.myNlComponent)) {
            NlComponentHelperKt.setX(this.myNlComponent, Coordinates.dpToPx(this.myScene.getDesignSurface(), (float)dx));
            NlComponentHelperKt.setY(this.myNlComponent, Coordinates.dpToPx(this.myScene.getDesignSurface(), (float)dy));
        } else {
            this.myScene.needsRebuildList();
        }
    }

    public void setSize(int width, int height) {
        this.myAnimatedDrawWidth.setValue(width);
        this.myAnimatedDrawHeight.setValue(height);
        if (NlComponentHelperKt.getHasNlComponentInfo(this.myNlComponent)) {
            NlComponentHelperKt.setW(this.myNlComponent, Coordinates.dpToPx(this.myScene.getDesignSurface(), (float)width));
            NlComponentHelperKt.setH(this.myNlComponent, Coordinates.dpToPx(this.myScene.getDesignSurface(), (float)height));
        }
        this.myScene.needsRebuildList();
    }

    public void setSizeTarget(int width, int height, long time2) {
        this.myAnimatedDrawWidth.setTarget(width, time2);
        this.myAnimatedDrawHeight.setTarget(height, time2);
        if (NlComponentHelperKt.getHasNlComponentInfo(this.myNlComponent)) {
            NlComponentHelperKt.setW(this.myNlComponent, Coordinates.dpToPx(this.myScene.getDesignSurface(), (float)width));
            NlComponentHelperKt.setH(this.myNlComponent, Coordinates.dpToPx(this.myScene.getDesignSurface(), (float)height));
        }
    }

    @NotNull
    public NlComponent getAuthoritativeNlComponent() {
        ComponentProvider provider = this.myComponentProvider;
        if (provider != null) {
            return provider.getComponent(this);
        }
        return this.myNlComponent;
    }

    @NotNull
    public NlComponent getNlComponent() {
        return this.myNlComponent;
    }

    @NotNull
    public Scene getScene() {
        return this.myScene;
    }

    public List<SceneComponent> getChildren() {
        return this.myChildren;
    }

    public int getChildCount() {
        return this.myChildren.size();
    }

    public SceneComponent getChild(int i2) {
        return this.myChildren.get(i2);
    }

    public void setToolLocked(boolean locked) {
        this.myIsToolLocked = locked;
    }

    public boolean isToolLocked() {
        return this.myIsToolLocked;
    }

    public void setDrawState(@NotNull DrawState drawState) {
        DrawState oldState = this.myDrawState;
        this.myDrawState = drawState;
        if (this.myIsSelected) {
            this.myDrawState = DrawState.SELECTED;
        }
        if (oldState != this.myDrawState) {
            DecoratorUtilities.setTimeChange(this.myNlComponent, "view", DecoratorUtilities.mapState(drawState));
        }
    }

    public int getBaseline() {
        return Coordinates.pxToDp(this.getScene().getDesignSurface(), NlComponentHelperKt.getBaseline(this.myNlComponent));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelected(boolean selected) {
        if (!selected || !this.myIsSelected) {
            this.myShowBaseline = false;
        }
        this.myIsSelected = selected;
        if (this.myIsSelected) {
            this.setDrawState(DrawState.SELECTED);
        } else {
            this.setDrawState(DrawState.NORMAL);
        }
        ArrayList<Target> arrayList = this.myTargets;
        synchronized (arrayList) {
            this.myTargets.forEach(it -> it.componentSelectionChanged(selected));
        }
    }

    public void setDragging(boolean dragging) {
        if (!this.getNlComponent().isRoot()) {
            this.myDragging = dragging;
        }
    }

    public boolean isDragging() {
        return this.myDragging;
    }

    public DrawState getDrawState() {
        return this.myDrawState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableList<Target> getTargets() {
        assert (ApplicationManager.getApplication().isDispatchThread());
        ArrayList<Target> arrayList = this.myTargets;
        synchronized (arrayList) {
            if (this.myCachedTargetList == null) {
                this.myCachedTargetList = ImmutableList.copyOf(this.myTargets);
            }
            return this.myCachedTargetList;
        }
    }

    public SceneDecorator getDecorator() {
        return this.myDecorator;
    }

    @Nullable
    public Notch.Provider getNotchProvider() {
        return this.myNotchProvider;
    }

    public void setNotchProvider(@Nullable Notch.Provider notchProvider) {
        this.myNotchProvider = notchProvider;
    }

    ResizeBaseTarget getResizeTarget(ResizeBaseTarget.Type type) {
        ImmutableList<Target> targets = this.getTargets();
        int count = targets.size();
        for (int i2 = 0; i2 < count; ++i2) {
            ResizeBaseTarget target;
            if (!(targets.get(i2) instanceof ResizeBaseTarget) || (target = (ResizeBaseTarget)targets.get(i2)).getType() != type) continue;
            return target;
        }
        return null;
    }

    @Nullable
    public SceneComponent getSceneComponent(@NotNull String componentId) {
        if (componentId.equalsIgnoreCase(this.myNlComponent.getId())) {
            return this;
        }
        int count = this.myChildren.size();
        for (int i2 = 0; i2 < count; ++i2) {
            SceneComponent child = this.myChildren.get(i2);
            SceneComponent found = child.getSceneComponent(componentId);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    @Nullable
    public SceneComponent getSceneComponent(@NotNull NlComponent nlComponent) {
        if (nlComponent == this.myNlComponent) {
            return this;
        }
        for (SceneComponent child : this.getChildren()) {
            SceneComponent found = child.getSceneComponent(nlComponent);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public boolean intersects(Rectangle rectangle) {
        return rectangle.intersects(this.fillRect(null));
    }

    void clearAttributes() {
        ViewGroupHandler parentHandler;
        NlComponent component = this.getAuthoritativeNlComponent();
        NlComponent parent = component.getParent();
        if (parent != null && (parentHandler = NlComponentHelperKt.getViewGroupHandler(parent)) != null) {
            parentHandler.clearAttributes(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTarget(@NotNull Target target) {
        target.setComponent(this);
        ArrayList<Target> arrayList = this.myTargets;
        synchronized (arrayList) {
            this.myCachedTargetList = null;
            this.myTargets.add(target);
        }
    }

    public void addChild(@NotNull SceneComponent child) {
        child.removeFromParent();
        child.setParent(this);
        this.myChildren.add(child);
    }

    public void removeFromParent() {
        SceneComponent parent = this.myParent;
        if (parent != null) {
            parent.remove(this);
        }
    }

    private void remove(@NotNull SceneComponent component) {
        if (this.myChildren.remove(component)) {
            component.myParent = null;
        }
    }

    public boolean layout(@NotNull SceneContext sceneTransform, long time2) {
        boolean needsRebuildDisplayList = false;
        int left2 = this.myAnimatedDrawX.getValue(time2);
        int top = this.myAnimatedDrawY.getValue(time2);
        int right2 = left2 + this.myAnimatedDrawWidth.getValue(time2);
        int bottom2 = top + this.myAnimatedDrawHeight.getValue(time2);
        needsRebuildDisplayList |= this.myCurrentLeft != left2;
        needsRebuildDisplayList |= this.myCurrentTop != top;
        needsRebuildDisplayList |= this.myCurrentRight != right2;
        needsRebuildDisplayList |= this.myCurrentBottom != bottom2;
        this.myCurrentLeft = left2;
        this.myCurrentTop = top;
        this.myCurrentRight = right2;
        this.myCurrentBottom = bottom2;
        needsRebuildDisplayList |= this.isAnimating();
        ImmutableList<Target> targets = this.getTargets();
        int num = targets.size();
        for (int i2 = 0; i2 < num; ++i2) {
            Target target = (Target)targets.get(i2);
            needsRebuildDisplayList |= target.layout(sceneTransform, this.myCurrentLeft, this.myCurrentTop, this.myCurrentRight, this.myCurrentBottom);
        }
        int childCount = this.myChildren.size();
        for (int i3 = 0; i3 < childCount; ++i3) {
            SceneComponent child = this.myChildren.get(i3);
            needsRebuildDisplayList |= child.layout(sceneTransform, time2);
        }
        return needsRebuildDisplayList;
    }

    public boolean isAnimating() {
        return this.myAnimatedDrawX.isAnimating() || this.myAnimatedDrawY.isAnimating() || this.myAnimatedDrawWidth.isAnimating() || this.myAnimatedDrawHeight.isAnimating();
    }

    public Rectangle fillRect(@Nullable Rectangle rectangle) {
        if (rectangle == null) {
            rectangle = new Rectangle();
        }
        rectangle.x = this.myCurrentLeft;
        rectangle.y = this.myCurrentTop;
        rectangle.width = this.myCurrentRight - this.myCurrentLeft;
        rectangle.height = this.myCurrentBottom - this.myCurrentTop;
        return rectangle;
    }

    public void addHit(@NotNull SceneContext sceneTransform, @NotNull ScenePicker picker) {
        if (this.myIsToolLocked) {
            return;
        }
        this.myHitProvider.addHit(this, sceneTransform, picker);
        ImmutableList<Target> targets = this.getTargets();
        int num = targets.size();
        for (int i2 = 0; i2 < num; ++i2) {
            Target target = (Target)targets.get(i2);
            target.addHit(sceneTransform, picker);
        }
        int childCount = this.myChildren.size();
        for (int i3 = 0; i3 < childCount; ++i3) {
            SceneComponent child = this.myChildren.get(i3);
            if (child instanceof TemporarySceneComponent) continue;
            child.addHit(sceneTransform, picker);
        }
    }

    public void buildDisplayList(long time2, @NotNull DisplayList list, SceneContext sceneContext) {
        this.myDecorator.buildList(list, time2, sceneContext, this);
    }

    @NotNull
    public Rectangle fillDrawRect(long time2, @Nullable Rectangle rec) {
        if (rec == null) {
            rec = new Rectangle();
        }
        rec.x = this.getDrawX(time2);
        rec.y = this.getDrawY(time2);
        rec.width = this.getDrawWidth(time2);
        rec.height = this.getDrawHeight(time2);
        return rec;
    }

    @NotNull
    public Rectangle2D.Float fillDrawRect2D(long time2, @Nullable Rectangle2D.Float rec) {
        if (rec == null) {
            rec = new Rectangle2D.Float();
        }
        rec.x = this.getDrawX(time2);
        rec.y = this.getDrawY(time2);
        rec.width = this.getDrawWidth(time2);
        rec.height = this.getDrawHeight(time2);
        return rec;
    }

    @Nullable
    public String getId() {
        return this.myNlComponent.getId();
    }

    public boolean containsX(int xDp) {
        return this.getDrawX() <= xDp && xDp <= this.getDrawX() + this.getDrawWidth();
    }

    public boolean containsY(int yDp) {
        return this.getDrawY() <= yDp && yDp <= this.getDrawY() + this.getDrawHeight();
    }

    public void setTargetProvider(@Nullable TargetProvider targetProvider) {
        if (this.myTargetProvider == targetProvider) {
            return;
        }
        this.myTargetProvider = targetProvider;
    }

    public void setComponentProvider(@NotNull ComponentProvider provider) {
        this.myComponentProvider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTargets() {
        TargetProvider provider;
        ArrayList<Target> arrayList = this.myTargets;
        synchronized (arrayList) {
            this.myCachedTargetList = null;
            this.myTargets.clear();
        }
        SceneComponent parent = this.myParent;
        if (parent != null && (provider = parent.getTargetProvider()) != null) {
            provider.createChildTargets(parent, this).forEach(this::addTarget);
        }
        if ((provider = this.myTargetProvider) != null) {
            provider.createTargets(this).forEach(this::addTarget);
        }
        for (SceneComponent child : this.getChildren()) {
            child.updateTargets();
        }
        if (((Boolean)StudioFlags.NELE_DRAG_PLACEHOLDER.get()).booleanValue()) {
            boolean hasDragTarget;
            ArrayList<Target> arrayList2 = this.myTargets;
            synchronized (arrayList2) {
                hasDragTarget = this.myTargets.removeIf(CommonDragTarget::isSupported);
            }
            if (hasDragTarget && this.myScene.getRoot() != this) {
                this.addTarget(new CommonDragTarget(this));
            }
        }
    }

    static class AnimatedValue {
        int value;
        int target;
        long startTime;
        int duration = 350;

        AnimatedValue() {
        }

        public void setValue(int v) {
            this.value = v;
            this.target = v;
            this.startTime = 0L;
        }

        public void setTarget(int v, long time2) {
            if (this.target == v) {
                return;
            }
            this.startTime = time2;
            this.target = v;
        }

        public int getValue(long time2) {
            if (this.startTime == 0L) {
                this.target = this.value;
                return this.value;
            }
            float progress = (float)(time2 - this.startTime) / (float)this.duration;
            if (progress >= 1.0f) {
                this.value = this.target;
                return this.value;
            }
            if (progress <= 0.0f) {
                return this.value;
            }
            return (int)(0.5 + this.EaseInOutInterpolator(progress, this.value, this.target));
        }

        public boolean isAnimating() {
            return this.value != this.target;
        }

        double EaseInOutInterpolator(double progress, double begin, double end) {
            double change = (end - begin) / 2.0;
            if ((progress *= 2.0) < 1.0) {
                return change * progress * progress + begin;
            }
            return -change * ((progress -= 1.0) * (progress - 2.0) - 1.0) + begin;
        }
    }

    public static enum DrawState {
        SUBDUED,
        NORMAL,
        HOVER,
        SELECTED,
        DRAG;

    }
}

