/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.ScenePicker;
import com.android.tools.idea.common.scene.target.Target;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SceneHitListener {
    @NotNull
    private SelectionModel mySelectionModel;
    private ScenePicker myPicker = new ScenePicker();
    double myClosestComponentDistance = Double.MAX_VALUE;
    double myClosestTargetDistance = Double.MAX_VALUE;
    ArrayList<SceneComponent> myHitComponents = new ArrayList();
    @NotNull
    final ArrayList<Target> myHitTargets = new ArrayList();
    private Predicate<Target> myTargertFilter = it -> true;

    public SceneHitListener(@NotNull SelectionModel selectionModel) {
        this.mySelectionModel = selectionModel;
        this.myPicker.setSelectListener((a, b) -> this.over(a, b));
    }

    public void setTargetFilter(@Nullable Predicate<Target> filter2) {
        this.myTargertFilter = filter2 != null ? filter2 : it -> true;
    }

    public void find(@NotNull SceneContext transform2, @NotNull SceneComponent root, int x, int y) {
        this.myHitComponents.clear();
        this.myHitTargets.clear();
        this.myClosestComponentDistance = Double.MAX_VALUE;
        this.myClosestTargetDistance = Double.MAX_VALUE;
        this.myPicker.reset();
        root.addHit(transform2, this.myPicker);
        this.myPicker.find(transform2.getSwingXDip(x), transform2.getSwingYDip(y));
    }

    public void over(Object over, double dist) {
        if (over instanceof Target) {
            if (!this.myTargertFilter.test((Target)over)) {
                return;
            }
            Target target = (Target)over;
            if (dist < this.myClosestTargetDistance) {
                this.myHitTargets.clear();
                this.myHitTargets.add(target);
                this.myClosestTargetDistance = dist;
            } else if (dist == this.myClosestTargetDistance) {
                this.myHitTargets.add(target);
            }
        } else if (over instanceof SceneComponent) {
            SceneComponent component = (SceneComponent)over;
            if (dist < this.myClosestComponentDistance) {
                this.myHitComponents.clear();
                this.myHitComponents.add(component);
                this.myClosestComponentDistance = dist;
            } else if (dist == this.myClosestComponentDistance) {
                this.myHitComponents.add(component);
            }
        }
    }

    public Target getClosestTarget() {
        int count = this.myHitTargets.size();
        if (count == 0) {
            return null;
        }
        ImmutableList<NlComponent> selection = this.mySelectionModel.getSelection();
        Target candidate = this.myHitTargets.get(count - 1);
        boolean inSelection = SceneHitListener.parentInSelection(candidate.getComponent(), selection);
        for (int i2 = count - 2; i2 >= 0; --i2) {
            Target target = this.myHitTargets.get(i2);
            boolean targetParentInSelection = SceneHitListener.parentInSelection(target.getComponent(), selection);
            if (inSelection && !targetParentInSelection || (inSelection || !targetParentInSelection) && target.getPreferenceLevel() <= candidate.getPreferenceLevel() && (target.getPreferenceLevel() != candidate.getPreferenceLevel() || target.getComponent().getDepth() <= candidate.getComponent().getDepth())) continue;
            candidate = target;
            inSelection = targetParentInSelection;
        }
        return candidate;
    }

    @Nullable
    public Target getFilteredTarget(Target filteredTarget) {
        Target hit = null;
        boolean found = false;
        for (Target target : this.myHitTargets) {
            if (target == filteredTarget) {
                found = true;
                continue;
            }
            if (!filteredTarget.getClass().isAssignableFrom(target.getClass())) continue;
            hit = target;
        }
        if (hit == null && found) {
            hit = filteredTarget;
        }
        return hit;
    }

    public SceneComponent getClosestComponent() {
        int count = this.myHitComponents.size();
        if (count == 0) {
            return null;
        }
        if (count == 1) {
            return this.myHitComponents.get(0);
        }
        ImmutableList<NlComponent> selection = this.mySelectionModel.getSelection();
        if (selection.isEmpty()) {
            return this.myHitComponents.get(count - 1);
        }
        SceneComponent candidate = this.myHitComponents.get(count - 1);
        boolean inSelection = selection.contains(candidate.getNlComponent());
        if (inSelection) {
            return candidate;
        }
        for (int i2 = count - 1; i2 >= 0; --i2) {
            SceneComponent target = this.myHitComponents.get(i2);
            if (!SceneHitListener.parentInSelection(target, selection)) continue;
            return target;
        }
        return candidate;
    }

    public ArrayList<SceneComponent> getHitComponents() {
        return this.myHitComponents;
    }

    private static boolean parentInSelection(@NotNull SceneComponent component, @NotNull List<NlComponent> selection) {
        if (selection.isEmpty()) {
            return false;
        }
        while (component != null) {
            if (selection.contains(component.getNlComponent())) {
                return true;
            }
            component = component.getParent();
        }
        return false;
    }
}

