/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene;

import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.common.surface.SceneView;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;

public class SceneInteraction
extends Interaction {
    protected SceneView mySceneView;

    public SceneInteraction(@NotNull SceneView sceneView) {
        this.mySceneView = sceneView;
    }

    @Override
    public void begin(int x, int y, @JdkConstants.InputEventMask int startMask) {
        super.begin(x, y, startMask);
        int androidX = Coordinates.getAndroidX(this.mySceneView, this.myStartX);
        int androidY = Coordinates.getAndroidY(this.mySceneView, this.myStartY);
        int dpX = Coordinates.pxToDp(this.mySceneView, androidX);
        int dpY = Coordinates.pxToDp(this.mySceneView, androidY);
        Scene scene = this.mySceneView.getScene();
        scene.updateModifiers(startMask);
        scene.mouseDown(SceneContext.get(this.mySceneView), dpX, dpY);
    }

    @Override
    public void update(int x, int y, @JdkConstants.InputEventMask int modifiers) {
        super.update(x, y, modifiers);
        int androidX = Coordinates.getAndroidX(this.mySceneView, x);
        int androidY = Coordinates.getAndroidY(this.mySceneView, y);
        int dpX = Coordinates.pxToDp(this.mySceneView, androidX);
        int dpY = Coordinates.pxToDp(this.mySceneView, androidY);
        Scene scene = this.mySceneView.getScene();
        scene.updateModifiers(modifiers);
        scene.mouseDrag(SceneContext.get(this.mySceneView), dpX, dpY);
        this.mySceneView.getSurface().repaint();
    }

    @Override
    public void end(int x, int y, @JdkConstants.InputEventMask int modifiers, boolean canceled) {
        super.end(x, y, modifiers, canceled);
        int androidX = Coordinates.getAndroidX(this.mySceneView, x);
        int androidY = Coordinates.getAndroidY(this.mySceneView, y);
        int dpX = Coordinates.pxToDp(this.mySceneView, androidX);
        int dpY = Coordinates.pxToDp(this.mySceneView, androidY);
        Scene scene = this.mySceneView.getScene();
        scene.updateModifiers(modifiers);
        if (canceled) {
            scene.mouseCancel();
        } else {
            scene.mouseRelease(SceneContext.get(this.mySceneView), dpX, dpY);
        }
        this.mySceneView.getSurface().repaint();
    }
}

