/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene;

import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.DefaultHitProvider;
import com.android.tools.idea.common.scene.HitProvider;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.TemporarySceneComponent;
import com.android.tools.idea.common.scene.decorator.SceneDecoratorFactory;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.rendering.RenderSettings;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;

public abstract class SceneManager
implements Disposable {
    public static final boolean SUPPORTS_LOCKING = false;
    @NotNull
    private final NlModel myModel;
    @NotNull
    private final DesignSurface myDesignSurface;
    @NotNull
    private final Scene myScene;
    @NotNull
    private SceneView mySceneView;
    @NotNull
    private final HitProvider myHitProvider = new DefaultHitProvider();

    public SceneManager(@NotNull NlModel model2, @NotNull DesignSurface surface, @NotNull RenderSettings renderSettings) {
        this.myModel = model2;
        this.myDesignSurface = surface;
        Disposer.register((Disposable)model2, (Disposable)this);
        this.myScene = new Scene(this, this.myDesignSurface, renderSettings);
    }

    protected void createSceneView() {
        this.mySceneView = this.doCreateSceneView();
        this.myDesignSurface.addLayers(this.getLayers());
    }

    @NotNull
    protected abstract SceneView doCreateSceneView();

    public void updateSceneView() {
        this.myDesignSurface.removeLayers(this.getLayers());
        this.getLayers().forEach(Layer::dispose);
        this.createSceneView();
    }

    @NotNull
    public SceneView getSceneView() {
        return this.mySceneView;
    }

    @NotNull
    public ImmutableList<Layer> getLayers() {
        return this.mySceneView.getLayers();
    }

    public void dispose() {
        this.getLayers().forEach(Disposer::dispose);
    }

    public void update() {
        List<SceneComponent> hierarchy;
        ImmutableList<NlComponent> components = this.getModel().getComponents();
        Scene scene = this.getScene();
        if (components.isEmpty()) {
            scene.removeAllComponents();
            scene.setRoot(null);
            return;
        }
        HashSet<SceneComponent> usedComponents = new HashSet<SceneComponent>();
        HashSet<SceneComponent> oldComponents = new HashSet<SceneComponent>(scene.getSceneComponents());
        NlComponent rootComponent = this.getRoot();
        if (this.myScene.getRoot() != null && rootComponent != this.myScene.getRoot().getNlComponent()) {
            scene.removeAllComponents();
            scene.setRoot(null);
        }
        SceneComponent root = (hierarchy = this.createHierarchy(rootComponent)).isEmpty() ? null : hierarchy.get(0);
        scene.setRoot(root);
        if (root != null) {
            this.updateFromComponent(root, usedComponents);
        }
        oldComponents.removeAll(usedComponents);
        oldComponents.removeIf(component -> component instanceof TemporarySceneComponent);
        oldComponents.forEach(scene::removeComponent);
        scene.needsRebuildList();
    }

    @NotNull
    protected NlComponent getRoot() {
        return ((NlComponent)this.getModel().getComponents().get(0)).getRoot();
    }

    public static boolean isComponentLocked(@NotNull NlComponent component) {
        return false;
    }

    @NotNull
    protected List<SceneComponent> createHierarchy(@NotNull NlComponent component) {
        SceneComponent sceneComponent = this.getScene().getSceneComponent(component);
        if (sceneComponent == null) {
            sceneComponent = new SceneComponent(this.getScene(), component, this.getHitProvider(component));
        }
        sceneComponent.setToolLocked(SceneManager.isComponentLocked(component));
        HashSet<SceneComponent> oldChildren = new HashSet<SceneComponent>(sceneComponent.getChildren());
        for (NlComponent nlChild : component.getChildren()) {
            List<SceneComponent> children = this.createHierarchy(nlChild);
            oldChildren.removeAll(children);
            for (SceneComponent child : children) {
                child.removeFromParent();
                sceneComponent.addChild(child);
            }
        }
        for (SceneComponent child : oldChildren) {
            if (child instanceof TemporarySceneComponent && child.getParent() == sceneComponent || child.getParent() != sceneComponent) continue;
            child.removeFromParent();
        }
        return ImmutableList.of((Object)sceneComponent);
    }

    protected final void updateFromComponent(@NotNull SceneComponent component, @NotNull Set<SceneComponent> seenComponents) {
        seenComponents.add(component);
        this.updateFromComponent(component);
        for (SceneComponent child : component.getChildren()) {
            this.updateFromComponent(child, seenComponents);
        }
        this.postUpdateFromComponent(component);
    }

    protected void postUpdateFromComponent(@NotNull SceneComponent component) {
    }

    @NotNull
    public abstract TemporarySceneComponent createTemporaryComponent(@NotNull NlComponent var1);

    protected void updateFromComponent(SceneComponent sceneComponent) {
        sceneComponent.setToolLocked(false);
    }

    @NotNull
    protected DesignSurface getDesignSurface() {
        return this.myDesignSurface;
    }

    @NotNull
    public NlModel getModel() {
        return this.myModel;
    }

    @NotNull
    public Scene getScene() {
        return this.myScene;
    }

    @NotNull
    public abstract CompletableFuture<Void> requestRender();

    public void requestLayoutAndRender(boolean animate) {
    }

    public abstract void layout(boolean var1);

    @NotNull
    public abstract SceneDecoratorFactory getSceneDecoratorFactory();

    public abstract Map<Object, Map<ResourceReference, ResourceValue>> getDefaultProperties();

    public abstract Map<Object, String> getDefaultStyles();

    @NotNull
    protected HitProvider getHitProvider(@NotNull NlComponent component) {
        return this.myHitProvider;
    }
}

