/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene.draw;

import com.android.tools.idea.common.scene.LerpFloat;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DrawCommandBase;
import com.android.tools.idea.common.scene.draw.DrawCommandBaseKt;
import com.android.tools.idea.common.scene.draw.DrawCommandSerializationHelperKt;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\b\u0012\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0007B-\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\t\u0010\u0013\u001a\u00020\tH\u00c2\u0003J\t\u0010\u0014\u001a\u00020\u000bH\u00c2\u0003J\t\u0010\u0015\u001a\u00020\rH\u00c2\u0003J\t\u0010\u0016\u001a\u00020\u000fH\u00c2\u0003J\t\u0010\u0017\u001a\u00020\u0011H\u00c2\u0003J;\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\b\u0010\u001d\u001a\u00020\tH\u0016J\t\u0010\u001e\u001a\u00020\tH\u00d6\u0001J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0014J\b\u0010%\u001a\u00020\u0004H\u0016J\t\u0010&\u001a\u00020\u0004H\u00d6\u0001R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/android/tools/idea/common/scene/draw/DrawCircle;", "Lcom/android/tools/idea/common/scene/draw/DrawCommandBase;", "sp", "", "", "([Ljava/lang/String;)V", "s", "(Ljava/lang/String;)V", "myLevel", "", "myCenter", "Ljava/awt/geom/Point2D$Float;", "myColor", "Ljava/awt/Color;", "myStroke", "Ljava/awt/BasicStroke;", "myRadius", "Lcom/android/tools/idea/common/scene/LerpFloat;", "(ILjava/awt/geom/Point2D$Float;Ljava/awt/Color;Ljava/awt/BasicStroke;Lcom/android/tools/idea/common/scene/LerpFloat;)V", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "getLevel", "hashCode", "onPaint", "", "g", "Ljava/awt/Graphics2D;", "sceneContext", "Lcom/android/tools/idea/common/scene/SceneContext;", "serialize", "toString", "intellij.android.designer"})
public final class DrawCircle
extends DrawCommandBase {
    private final int myLevel;
    private final Point2D.Float myCenter;
    private final Color myColor;
    private final BasicStroke myStroke;
    private final LerpFloat myRadius;

    @Override
    public int getLevel() {
        return this.myLevel;
    }

    @Override
    @NotNull
    public String serialize() {
        return DrawCommandSerializationHelperKt.buildString(this.getClass().getSimpleName(), this.myLevel, DrawCommandSerializationHelperKt.point2DToString(this.myCenter), DrawCommandSerializationHelperKt.colorToString(this.myColor), (int)this.myStroke.getLineWidth(), DrawCommandSerializationHelperKt.lerpToString(this.myRadius));
    }

    @Override
    protected void onPaint(@NotNull Graphics2D g, @NotNull SceneContext sceneContext) {
        float r = ((Number)this.myRadius.getValue(sceneContext.getTime())).floatValue();
        g.setColor(this.myColor);
        g.setStroke(this.myStroke);
        g.setRenderingHints((Map)DrawCommandBaseKt.getHQ_RENDERING_HINTS());
        Ellipse2D.Float circle = new Ellipse2D.Float(this.myCenter.x - r, this.myCenter.y - r, (float)2 * r, (float)2 * r);
        g.draw(circle);
        g.dispose();
        if (!this.myRadius.isComplete(sceneContext.getTime())) {
            sceneContext.repaint();
        }
    }

    public DrawCircle(int myLevel, @NotNull Point2D.Float myCenter, @NotNull Color myColor, @NotNull BasicStroke myStroke, @NotNull LerpFloat myRadius) {
        this.myLevel = myLevel;
        this.myCenter = myCenter;
        this.myColor = myColor;
        this.myStroke = myStroke;
        this.myRadius = myRadius;
    }

    private DrawCircle(String[] sp) {
        float f;
        String string = sp[0];
        DrawCircle drawCircle = this;
        boolean bl = false;
        int n = Integer.parseInt(string);
        string = sp[3];
        Color color = DrawCommandSerializationHelperKt.stringToColor(sp[2]);
        Point2D.Float float_ = DrawCommandSerializationHelperKt.stringToPoint2D(sp[1]);
        bl = false;
        float f2 = f = Float.parseFloat(string);
        drawCircle(n, float_, color, new BasicStroke(f2), DrawCommandSerializationHelperKt.stringToLerp(sp[4]));
    }

    public DrawCircle(@NotNull String s) {
        this(DrawCommandSerializationHelperKt.parse(s, 5));
    }

    private final int component1() {
        return this.myLevel;
    }

    private final Point2D.Float component2() {
        return this.myCenter;
    }

    private final Color component3() {
        return this.myColor;
    }

    private final BasicStroke component4() {
        return this.myStroke;
    }

    private final LerpFloat component5() {
        return this.myRadius;
    }

    @NotNull
    public final DrawCircle copy(int myLevel, @NotNull Point2D.Float myCenter, @NotNull Color myColor, @NotNull BasicStroke myStroke, @NotNull LerpFloat myRadius) {
        return new DrawCircle(myLevel, myCenter, myColor, myStroke, myRadius);
    }

    @NotNull
    public static /* synthetic */ DrawCircle copy$default(DrawCircle drawCircle, int n, Point2D.Float float_, Color color, BasicStroke basicStroke, LerpFloat lerpFloat, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = drawCircle.myLevel;
        }
        if ((n2 & 2) != 0) {
            float_ = drawCircle.myCenter;
        }
        if ((n2 & 4) != 0) {
            color = drawCircle.myColor;
        }
        if ((n2 & 8) != 0) {
            basicStroke = drawCircle.myStroke;
        }
        if ((n2 & 0x10) != 0) {
            lerpFloat = drawCircle.myRadius;
        }
        return drawCircle.copy(n, float_, color, basicStroke, lerpFloat);
    }

    @NotNull
    public String toString() {
        return "DrawCircle(myLevel=" + this.myLevel + ", myCenter=" + this.myCenter + ", myColor=" + this.myColor + ", myStroke=" + this.myStroke + ", myRadius=" + this.myRadius + ")";
    }

    public int hashCode() {
        Point2D.Float float_ = this.myCenter;
        Color color = this.myColor;
        BasicStroke basicStroke = this.myStroke;
        LerpFloat lerpFloat = this.myRadius;
        return (((Integer.hashCode(this.myLevel) * 31 + (float_ != null ? ((Object)float_).hashCode() : 0)) * 31 + (color != null ? ((Object)color).hashCode() : 0)) * 31 + (basicStroke != null ? ((Object)basicStroke).hashCode() : 0)) * 31 + (lerpFloat != null ? lerpFloat.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof DrawCircle)) break block3;
                DrawCircle drawCircle = (DrawCircle)object;
                if (!(this.myLevel == drawCircle.myLevel) || !Intrinsics.areEqual((Object)this.myCenter, (Object)drawCircle.myCenter) || !Intrinsics.areEqual((Object)this.myColor, (Object)drawCircle.myColor) || !Intrinsics.areEqual((Object)this.myStroke, (Object)drawCircle.myStroke) || !Intrinsics.areEqual((Object)this.myRadius, (Object)drawCircle.myRadius)) break block3;
            }
            return true;
        }
        return false;
    }
}

