/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene.draw;

import com.android.tools.idea.common.scene.LerpFloat;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DrawCommandBase;
import com.android.tools.idea.common.scene.draw.DrawCommandSerializationHelperKt;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB\u0015\b\u0012\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\u0010\u000eB\u000f\b\u0016\u0012\u0006\u0010\u000f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0010B%\u0012\u0006\u0010\u0011\u001a\u00020\u0003\u0012\u0006\u0010\u0012\u001a\u00020\u0005\u0012\u0006\u0010\u0013\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J\t\u0010\u0016\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c2\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00c2\u0003J\t\u0010\u0019\u001a\u00020\u0014H\u00c2\u0003J1\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0011\u001a\u00020\u00032\b\b\u0002\u0010\u0012\u001a\u00020\u00052\b\b\u0002\u0010\u0013\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0014H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u00d6\u0003J\b\u0010\u001f\u001a\u00020\u0003H\u0016J\t\u0010 \u001a\u00020\u0003H\u00d6\u0001J\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0014J\b\u0010'\u001a\u00020\rH\u0016J\t\u0010(\u001a\u00020\rH\u00d6\u0001R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/android/tools/idea/common/scene/draw/DrawFilledCircle;", "Lcom/android/tools/idea/common/scene/draw/DrawCommandBase;", "myLevel", "", "myCenter", "Ljava/awt/geom/Point2D$Float;", "myColor", "Ljava/awt/Color;", "radius", "", "(ILjava/awt/geom/Point2D$Float;Ljava/awt/Color;F)V", "sp", "", "", "([Ljava/lang/String;)V", "s", "(Ljava/lang/String;)V", "level", "center", "color", "Lcom/android/tools/idea/common/scene/LerpFloat;", "(ILjava/awt/geom/Point2D$Float;Ljava/awt/Color;Lcom/android/tools/idea/common/scene/LerpFloat;)V", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "getLevel", "hashCode", "onPaint", "", "g", "Ljava/awt/Graphics2D;", "sceneContext", "Lcom/android/tools/idea/common/scene/SceneContext;", "serialize", "toString", "intellij.android.designer"})
public final class DrawFilledCircle
extends DrawCommandBase {
    private final int level;
    private final Point2D.Float center;
    private final Color color;
    private final LerpFloat radius;

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    @NotNull
    public String serialize() {
        return DrawCommandSerializationHelperKt.buildString(this.getClass().getSimpleName(), this.level, DrawCommandSerializationHelperKt.point2DToString(this.center), DrawCommandSerializationHelperKt.colorToString(this.color), DrawCommandSerializationHelperKt.lerpToString(this.radius));
    }

    @Override
    protected void onPaint(@NotNull Graphics2D g, @NotNull SceneContext sceneContext) {
        float r = ((Number)this.radius.getValue(sceneContext.getTime())).floatValue();
        g.setColor(this.color);
        Ellipse2D.Float circle = new Ellipse2D.Float(this.center.x - r, this.center.y - r, (float)2 * r, (float)2 * r);
        g.fill(circle);
        if (!this.radius.isComplete(sceneContext.getTime())) {
            sceneContext.repaint();
        }
    }

    public DrawFilledCircle(int level, @NotNull Point2D.Float center, @NotNull Color color, @NotNull LerpFloat radius) {
        this.level = level;
        this.center = center;
        this.color = color;
        this.radius = radius;
    }

    public DrawFilledCircle(int myLevel, @NotNull Point2D.Float myCenter, @NotNull Color myColor, float radius) {
        this(myLevel, myCenter, myColor, new LerpFloat(radius));
    }

    private DrawFilledCircle(String[] sp) {
        String string = sp[0];
        DrawFilledCircle drawFilledCircle = this;
        boolean bl = false;
        int n = Integer.parseInt(string);
        drawFilledCircle(n, DrawCommandSerializationHelperKt.stringToPoint2D(sp[1]), DrawCommandSerializationHelperKt.stringToColor(sp[2]), DrawCommandSerializationHelperKt.stringToLerp(sp[3]));
    }

    public DrawFilledCircle(@NotNull String s) {
        this(DrawCommandSerializationHelperKt.parse(s, 4));
    }

    private final int component1() {
        return this.level;
    }

    private final Point2D.Float component2() {
        return this.center;
    }

    private final Color component3() {
        return this.color;
    }

    private final LerpFloat component4() {
        return this.radius;
    }

    @NotNull
    public final DrawFilledCircle copy(int level, @NotNull Point2D.Float center, @NotNull Color color, @NotNull LerpFloat radius) {
        return new DrawFilledCircle(level, center, color, radius);
    }

    @NotNull
    public static /* synthetic */ DrawFilledCircle copy$default(DrawFilledCircle drawFilledCircle, int n, Point2D.Float float_, Color color, LerpFloat lerpFloat, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = drawFilledCircle.level;
        }
        if ((n2 & 2) != 0) {
            float_ = drawFilledCircle.center;
        }
        if ((n2 & 4) != 0) {
            color = drawFilledCircle.color;
        }
        if ((n2 & 8) != 0) {
            lerpFloat = drawFilledCircle.radius;
        }
        return drawFilledCircle.copy(n, float_, color, lerpFloat);
    }

    @NotNull
    public String toString() {
        return "DrawFilledCircle(level=" + this.level + ", center=" + this.center + ", color=" + this.color + ", radius=" + this.radius + ")";
    }

    public int hashCode() {
        Point2D.Float float_ = this.center;
        Color color = this.color;
        LerpFloat lerpFloat = this.radius;
        return ((Integer.hashCode(this.level) * 31 + (float_ != null ? ((Object)float_).hashCode() : 0)) * 31 + (color != null ? ((Object)color).hashCode() : 0)) * 31 + (lerpFloat != null ? lerpFloat.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof DrawFilledCircle)) break block3;
                DrawFilledCircle drawFilledCircle = (DrawFilledCircle)object;
                if (!(this.level == drawFilledCircle.level) || !Intrinsics.areEqual((Object)this.center, (Object)drawFilledCircle.center) || !Intrinsics.areEqual((Object)this.color, (Object)drawFilledCircle.color) || !Intrinsics.areEqual((Object)this.radius, (Object)drawFilledCircle.radius)) break block3;
            }
            return true;
        }
        return false;
    }
}

