/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene.target;

import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.ScenePicker;
import com.android.tools.idea.common.scene.target.Target;
import java.awt.Cursor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseTarget
implements Target {
    protected SceneComponent myComponent;
    protected float myLeft = 0.0f;
    protected float myTop = 0.0f;
    protected float myRight = 0.0f;
    protected float myBottom = 0.0f;
    protected boolean mIsOver = false;

    @Override
    public void setComponent(@NotNull SceneComponent component) {
        this.myComponent = component;
    }

    @Override
    public SceneComponent getComponent() {
        return this.myComponent;
    }

    @Override
    public void setMouseHovered(boolean over) {
        if (over != this.mIsOver && this.myComponent != null) {
            this.myComponent.getScene().repaint();
        }
        this.mIsOver = over;
    }

    @Override
    public boolean isMouseHovered() {
        return this.mIsOver;
    }

    @Override
    public float getCenterX() {
        return this.myLeft + (this.myRight - this.myLeft) / 2.0f;
    }

    @Override
    public float getCenterY() {
        return this.myTop + (this.myBottom - this.myTop) / 2.0f;
    }

    @Override
    public Cursor getMouseCursor() {
        return Cursor.getDefaultCursor();
    }

    @Override
    public void addHit(@NotNull SceneContext transform2, @NotNull ScenePicker picker) {
        if (this.isHittable()) {
            picker.addRect(this, 0, transform2.getSwingXDip(this.myLeft), transform2.getSwingYDip(this.myTop), transform2.getSwingXDip(this.myRight), transform2.getSwingYDip(this.myBottom));
        }
    }

    protected boolean isHittable() {
        return this.getComponent().getScene().getFilterType() == Scene.FilterType.ALL;
    }

    @Override
    @Nullable
    public String getToolTipText() {
        return null;
    }
}

